/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import loci.common.AbstractNIOHandle;
import loci.common.NIOByteBufferProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOFileHandle
extends AbstractNIOHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(NIOFileHandle.class);
    protected static int defaultBufferSize = 0x100000;
    protected static int defaultRWBufferSize = 8192;
    protected RandomAccessFile raf;
    protected FileChannel channel;
    protected long position = 0L;
    protected long bufferStartPosition = 0L;
    protected int bufferSize;
    protected ByteBuffer buffer;
    protected boolean isReadWrite = false;
    protected FileChannel.MapMode mapMode = FileChannel.MapMode.READ_ONLY;
    protected ByteOrder order;
    protected NIOByteBufferProvider byteBufferProvider;
    private Long defaultLength;

    public NIOFileHandle(File file2, String mode, int bufferSize) throws IOException {
        this.bufferSize = bufferSize;
        this.validateMode(mode);
        if (mode.equals("rw")) {
            this.isReadWrite = true;
            this.mapMode = FileChannel.MapMode.READ_WRITE;
        }
        this.raf = new RandomAccessFile(file2, mode);
        this.channel = this.raf.getChannel();
        this.byteBufferProvider = new NIOByteBufferProvider(this.channel, this.mapMode);
        this.buffer(this.position, 0);
        if (mode.equals("r")) {
            this.defaultLength = this.raf.length();
        }
    }

    public NIOFileHandle(File file2, String mode) throws IOException {
        this(file2, mode, mode.equals("rw") ? defaultRWBufferSize : defaultBufferSize);
    }

    public NIOFileHandle(String name, String mode) throws IOException {
        this(new File(name), mode);
    }

    public static void setDefaultBufferSize(int size) {
        defaultBufferSize = size;
    }

    public static void setDefaultReadWriteBufferSize(int size) {
        defaultRWBufferSize = size;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public FileChannel getFileChannel() {
        try {
            this.channel.position(this.position);
        }
        catch (IOException e) {
            LOGGER.warn("FileChannel.position failed", e);
        }
        return this.channel;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setLength(long length) throws IOException {
        if (this.raf.length() < length) {
            this.raf.setLength(length);
            if (this.raf.length() != length) {
                byte[] b = new byte[defaultRWBufferSize];
                while (this.raf.length() < length) {
                    this.raf.seek(this.raf.length());
                    int len = (int)Math.min((long)b.length, length - this.raf.length());
                    this.raf.write(b, 0, len);
                }
            }
        }
        this.raf.seek(length - 1L);
        this.buffer = null;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public long getFilePointer() {
        return this.position;
    }

    @Override
    public long length() throws IOException {
        if (this.defaultLength != null) {
            return this.defaultLength;
        }
        return this.raf.length();
    }

    @Override
    public ByteOrder getOrder() {
        return this.buffer == null ? this.order : this.buffer.order();
    }

    @Override
    public void setOrder(ByteOrder order) {
        this.order = order;
        if (this.buffer != null) {
            this.buffer.order(order);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(ByteBuffer.wrap(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b), off, len);
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        return this.read(buf, 0, buf.capacity());
    }

    @Override
    public int read(ByteBuffer buf, int off, int len) throws IOException {
        buf.position(off);
        int realLength = (int)Math.min((long)len, this.length() - this.position);
        if (realLength < 0) {
            return -1;
        }
        buf.limit(off + realLength);
        this.buffer(this.position, realLength);
        this.position += (long)realLength;
        while (buf.hasRemaining()) {
            try {
                buf.put(this.buffer.get());
            }
            catch (BufferUnderflowException e) {
                EOFException eof = new EOFException("Attempting to read beyond end of file.");
                eof.initCause(e);
                throw eof;
            }
        }
        return realLength;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.mapMode == FileChannel.MapMode.READ_WRITE && pos > this.length()) {
            this.setLength(pos);
        }
        this.buffer(pos, 0);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        this.buffer(this.position, 1);
        ++this.position;
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public char readChar() throws IOException {
        this.buffer(this.position, 2);
        this.position += 2L;
        try {
            return this.buffer.getChar();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public double readDouble() throws IOException {
        this.buffer(this.position, 8);
        this.position += 8L;
        try {
            return this.buffer.getDouble();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public float readFloat() throws IOException {
        this.buffer(this.position, 4);
        this.position += 4L;
        try {
            return this.buffer.getFloat();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.read(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.read(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        this.buffer(this.position, 4);
        this.position += 4L;
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public String readLine() throws IOException {
        this.raf.seek(this.position);
        String line = this.raf.readLine();
        this.buffer(this.raf.getFilePointer(), 0);
        return line;
    }

    @Override
    public long readLong() throws IOException {
        this.buffer(this.position, 8);
        this.position += 8L;
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public short readShort() throws IOException {
        this.buffer(this.position, 2);
        this.position += 2L;
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        this.raf.seek(this.position);
        String utf8 = this.raf.readUTF();
        this.buffer(this.raf.getFilePointer(), 0);
        return utf8;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skipBytes((long)n);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        long oldPosition = this.position;
        long newPosition = oldPosition + Math.min(n, this.length());
        this.buffer(newPosition, 0);
        return this.position - oldPosition;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(ByteBuffer.wrap(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(b), off, len);
    }

    @Override
    public void write(ByteBuffer buf) throws IOException {
        this.write(buf, 0, buf.capacity());
    }

    @Override
    public void write(ByteBuffer buf, int off, int len) throws IOException {
        buf.limit(off + len);
        buf.position(off);
        this.position += (long)this.channel.write(buf, this.position);
        this.raf.seek(this.position);
        this.buffer = null;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.writeSetup(1);
        this.buffer.put((byte)v);
        this.doWrite(1);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes("UTF-8"));
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeSetup(2);
        this.buffer.putChar((char)v);
        this.doWrite(2);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.write(s.getBytes("UTF-16BE"));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeSetup(8);
        this.buffer.putDouble(v);
        this.doWrite(8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeSetup(4);
        this.buffer.putFloat(v);
        this.doWrite(4);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeSetup(4);
        this.buffer.putInt(v);
        this.doWrite(4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeSetup(8);
        this.buffer.putLong(v);
        this.doWrite(8);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeSetup(2);
        this.buffer.putShort((short)v);
        this.doWrite(2);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int strlen = str.getBytes("UTF-8").length + 2;
        this.writeSetup(strlen);
        this.raf.seek(this.position);
        this.raf.writeUTF(str);
        this.position += (long)strlen;
        this.buffer = null;
    }

    private void buffer(long offset, int size) throws IOException {
        this.position = offset;
        long newPosition = offset + (long)size;
        if (newPosition < this.bufferStartPosition || newPosition > this.bufferStartPosition + (long)this.bufferSize || this.buffer == null) {
            long newSize;
            this.bufferStartPosition = offset;
            if (this.length() > 0L && this.length() - 1L < this.bufferStartPosition) {
                this.bufferStartPosition = this.length() - 1L;
            }
            if ((newSize = Math.min(this.length() - this.bufferStartPosition, (long)this.bufferSize)) < (long)size && newSize == (long)this.bufferSize) {
                newSize = size;
            }
            if (newSize + this.bufferStartPosition > this.length()) {
                newSize = this.length() - this.bufferStartPosition;
            }
            offset = this.bufferStartPosition;
            ByteOrder byteOrder = this.buffer == null ? this.order : this.getOrder();
            this.buffer = this.byteBufferProvider.allocate(this.bufferStartPosition, (int)newSize);
            if (byteOrder != null) {
                this.setOrder(byteOrder);
            }
        }
        this.buffer.position((int)(offset - this.bufferStartPosition));
        if (this.buffer.position() + size > this.buffer.limit() && this.mapMode == FileChannel.MapMode.READ_WRITE) {
            this.buffer.limit(this.buffer.position() + size);
        }
    }

    private void writeSetup(int length) throws IOException {
        this.validateLength(length);
        this.buffer(this.position, length);
    }

    private void doWrite(int length) throws IOException {
        this.buffer.position(this.buffer.position() - length);
        this.channel.write(this.buffer, this.position);
        this.position += (long)length;
    }
}

