/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.io.File;
import java.io.FileFilter;

public class ExtensionFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
Comparable {
    private String[] exts;
    private String desc;

    public ExtensionFileFilter(String extension, String description) {
        this(new String[]{extension}, description);
    }

    public ExtensionFileFilter(String[] extensions, String description) {
        this.exts = new String[extensions.length];
        System.arraycopy(extensions, 0, this.exts, 0, extensions.length);
        StringBuilder sb = new StringBuilder(description);
        boolean first = true;
        for (int i = 0; i < this.exts.length; ++i) {
            if (this.exts[i] == null) {
                this.exts[i] = "";
            }
            if (this.exts[i].equals("")) continue;
            if (first) {
                sb.append(" (");
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("*.");
            sb.append(this.exts[i]);
        }
        if (!first) {
            sb.append(")");
        }
        this.desc = sb.toString();
    }

    public String getExtension() {
        return this.exts[0];
    }

    public String[] getExtensions() {
        return this.exts;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName().toLowerCase();
        for (int i = 0; i < this.exts.length; ++i) {
            if (!name.endsWith(this.exts[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        return "ExtensionFileFilter: " + this.desc;
    }

    public int compareTo(Object o) {
        return this.desc.compareToIgnoreCase(((javax.swing.filechooser.FileFilter)o).getDescription());
    }
}

