/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class HitachiReader
extends FormatReader {
    private static final String MAGIC = "[SemImageFile]";
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private ImageReader helperReader;

    public HitachiReader() {
        super("Hitachi", "txt");
        this.suffixSufficient = false;
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .txt file plus one similarly-named .tif, .bmp, or .jpg file";
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        String base = name;
        if (base.indexOf(46) >= 0) {
            base = base.substring(0, base.lastIndexOf("."));
        }
        if (HitachiReader.checkSuffix(name, "txt")) {
            Location bmp = new Location(base + ".bmp");
            Location jpg = new Location(base + ".jpg");
            Location tif = new Location(base + ".tif");
            if (!(bmp.exists() || jpg.exists() || tif.exists())) {
                return false;
            }
            return super.isThisType(name, open);
        }
        String textFile = base + ".txt";
        return new Location(textFile).exists() && this.isThisType(textFile, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = MAGIC.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).indexOf(MAGIC) >= 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.helperReader.openBytes(no, buf, x, y, w, h);
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.helperReader.getCurrentFile()};
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.helperReader != null) {
                this.helperReader.close();
            }
            this.helperReader = null;
        }
    }

    @Override
    public void reopenFile() throws IOException {
        super.reopenFile();
        this.helperReader.reopenFile();
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!HitachiReader.checkSuffix(id, "txt")) {
            String base = id;
            if (base.indexOf(46) >= 0) {
                base = base.substring(0, base.lastIndexOf("."));
            }
            id = base + ".txt";
            this.initFile(id);
            return;
        }
        super.initFile(id);
        String data = DataTools.readFile(id);
        IniParser parser = new IniParser();
        parser.setBackslashContinuesLine(false);
        IniList ini = parser.parseINI(new BufferedReader(new StringReader(data)));
        IniTable image = ini.getTable("SemImageFile");
        if (image == null) {
            throw new FormatException("Could not find 'SemImageFile' table.");
        }
        for (String key : image.keySet()) {
            this.addGlobalMeta(key, image.get(key));
        }
        String imageName = (String)image.get("SampleName");
        String pixelsFile = (String)image.get("ImageName");
        String date = (String)image.get("Date");
        String time = (String)image.get("Time");
        Location parent = new Location(id).getAbsoluteFile().getParentFile();
        pixelsFile = new Location(parent, pixelsFile).getAbsolutePath();
        ClassList<IFormatReader> classes = ImageReader.getDefaultReaderClasses();
        Class<IFormatReader>[] classArray = classes.getClasses();
        ClassList<IFormatReader> newClasses = new ClassList<IFormatReader>(IFormatReader.class);
        for (Class<IFormatReader> c : classArray) {
            if (c.equals(HitachiReader.class)) continue;
            newClasses.addClass(c);
        }
        this.helperReader = new ImageReader(newClasses);
        this.helperReader.setId(pixelsFile);
        this.core = new ArrayList<CoreMetadata>(this.helperReader.getCoreMetadataList());
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM);
        store.setImageName(imageName, 0);
        date = DateTools.formatDate(date + " " + time, DATE_FORMAT);
        if (date != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        this.populateOMEMetadata(image, store);
    }

    private void populateOMEMetadata(IniTable image, MetadataStore store) {
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        String modelNumber = (String)image.get("InstructName");
        String serialNumber = (String)image.get("SerialNumber");
        Double pixelSize = new Double((String)image.get("PixelSize"));
        String workingDistance = (String)image.get("WorkingDistance");
        Double stagePosXn = Double.valueOf((String)image.get("StagePositionX"));
        Double stagePosYn = Double.valueOf((String)image.get("StagePositionY"));
        Double stagePosZn = Double.valueOf((String)image.get("StagePositionZ"));
        Length stagePosXl = new Length(stagePosXn, UNITS.REFERENCEFRAME);
        Length stagePosYl = new Length(stagePosYn, UNITS.REFERENCEFRAME);
        Length stagePosZl = new Length(stagePosZn, UNITS.REFERENCEFRAME);
        Length sizeX = FormatTools.getPhysicalSizeX(pixelSize);
        Length sizeY = FormatTools.getPhysicalSizeY(pixelSize);
        if (sizeX != null) {
            store.setPixelsPhysicalSizeX(sizeX, 0);
        }
        if (sizeY != null) {
            store.setPixelsPhysicalSizeY(sizeY, 0);
        }
        store.setPlanePositionX(stagePosXl, 0, 0);
        store.setPlanePositionY(stagePosYl, 0, 0);
        store.setPlanePositionZ(stagePosZl, 0, 0);
        String instrument = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrument, 0);
        store.setImageInstrumentRef(instrument, 0);
        if (modelNumber != null) {
            store.setMicroscopeModel(modelNumber, 0);
        }
        if (serialNumber != null) {
            store.setMicroscopeSerialNumber(serialNumber, 0);
        }
        if (workingDistance != null) {
            int end = workingDistance.indexOf(32);
            if (end < 0) {
                end = workingDistance.length();
            }
            workingDistance = workingDistance.substring(0, end);
            String objective = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objective, 0, 0);
            store.setObjectiveSettingsID(objective, 0);
            store.setObjectiveWorkingDistance(new Length(new Double(workingDistance), UNITS.MICROMETER), 0, 0);
        }
    }
}

