/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.gui.GenericDialog;
import java.awt.Choice;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.WindowTools;

public class SwapDialog
extends ImporterDialog
implements ItemListener {
    private Choice zChoice;
    private Choice cChoice;
    private Choice tChoice;

    public SwapDialog(ImportProcess process) {
        super(process);
    }

    @Override
    protected boolean needPrompt() {
        return !this.process.isWindowless() && this.options.isSwapDimensions();
    }

    @Override
    protected GenericDialog constructDialog() {
        ImageProcessorReader reader = this.process.getReader();
        int seriesCount = this.process.getSeriesCount();
        GenericDialog gd = new GenericDialog("Dimension swapping options");
        String[] labels = new String[]{"Z", "C", "T"};
        for (int s = 0; s < seriesCount; ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            reader.setSeries(s);
            String[] sizes = new String[]{String.valueOf(reader.getSizeZ()), String.valueOf(reader.getSizeC()), String.valueOf(reader.getSizeT())};
            gd.addMessage("Series " + (s + 1) + ":\n");
            for (int i = 0; i < labels.length; ++i) {
                gd.addChoice(labels[i] + "_" + (s + 1), sizes, sizes[i]);
            }
        }
        List<Choice> choices = WindowTools.getChoices(gd);
        this.zChoice = choices.get(0);
        this.cChoice = choices.get(1);
        this.tChoice = choices.get(2);
        this.zChoice.addItemListener(this);
        this.cChoice.addItemListener(this);
        this.tChoice.addItemListener(this);
        WindowTools.addScrollBars((Container)gd);
        return gd;
    }

    @Override
    protected boolean harvestResults(GenericDialog gd) {
        ImageProcessorReader reader = this.process.getReader();
        int seriesCount = this.process.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            reader.setSeries(s);
            int z = Integer.parseInt(gd.getNextChoice());
            int c = Integer.parseInt(gd.getNextChoice());
            int t = Integer.parseInt(gd.getNextChoice());
            int originalZ = reader.getSizeZ();
            int originalC = reader.getSizeC();
            int originalT = reader.getSizeT();
            String originalOrder = reader.getDimensionOrder();
            StringBuffer sb = new StringBuffer();
            sb.append("XY");
            for (int i = 2; i < originalOrder.length(); ++i) {
                int originalValue = 0;
                switch (originalOrder.charAt(i)) {
                    case 'Z': {
                        originalValue = originalZ;
                        break;
                    }
                    case 'C': {
                        originalValue = originalC;
                        break;
                    }
                    case 'T': {
                        originalValue = originalT;
                    }
                }
                if (originalValue == z && sb.indexOf("Z") < 0) {
                    sb.append("Z");
                    continue;
                }
                if (originalValue == c && sb.indexOf("C") < 0) {
                    sb.append("C");
                    continue;
                }
                if (originalValue != t || sb.indexOf("T") >= 0) continue;
                sb.append("T");
            }
            this.options.setInputOrder(s, sb.toString());
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        int zIndex = this.zChoice.getSelectedIndex();
        int cIndex = this.cChoice.getSelectedIndex();
        int tIndex = this.tChoice.getSelectedIndex();
        if (src == this.zChoice) {
            if (zIndex == cIndex) {
                this.cChoice.select(this.firstAvailable(zIndex, tIndex));
            } else if (zIndex == tIndex) {
                this.tChoice.select(this.firstAvailable(zIndex, cIndex));
            }
        } else if (src == this.cChoice) {
            if (cIndex == zIndex) {
                this.zChoice.select(this.firstAvailable(cIndex, tIndex));
            } else if (cIndex == tIndex) {
                this.tChoice.select(this.firstAvailable(zIndex, cIndex));
            }
        } else if (src == this.tChoice) {
            if (tIndex == zIndex) {
                this.zChoice.select(this.firstAvailable(cIndex, tIndex));
            } else if (tIndex == cIndex) {
                this.cChoice.select(this.firstAvailable(zIndex, tIndex));
            }
        }
    }

    private int firstAvailable(int ... index) {
        boolean minValue = false;
        int maxValue = 2;
        for (int v = 0; v <= 2; ++v) {
            boolean taken = false;
            for (int i : index) {
                if (v != i) continue;
                taken = true;
                break;
            }
            if (taken) continue;
            return v;
        }
        return -1;
    }
}

