/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class InterfaceEndRecord
extends Record {
    public static final short sid = 226;

    public InterfaceEndRecord() {
    }

    public InterfaceEndRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 226) {
            throw new RecordFormatException("NOT A INTERFACEEND RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[INTERFACEEND]\n");
        buffer.append("[/INTERFACEEND]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)226);
        LittleEndian.putShort(data, 2 + offset, (short)0);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 4;
    }

    @Override
    public short getSid() {
        return 226;
    }
}

