/*
 * Decompiled with CFR 0.152.
 */
package ome.units.quantity;

import ome.units.quantity.Quantity;
import ome.units.unit.Unit;

public class Length
extends Quantity
implements Comparable<Length> {
    private static final int SEED1 = 45;
    private static final int SEED2 = 56;
    Number value;
    Unit<Length> unit;
    private int hashCodeValue;

    public Length(Number inValue, Unit<Length> inUnit) {
        if (inValue == null) {
            throw new NullPointerException("Length: Length cannot be constructed with a null value.");
        }
        this.value = inValue;
        this.unit = inUnit;
        this.hashCodeValue = 45;
        this.hashCodeValue = 56 * this.hashCodeValue + Float.floatToIntBits(this.value.floatValue());
        this.hashCodeValue = 56 * this.hashCodeValue + this.unit.getSymbol().hashCode();
    }

    @Override
    public Number value() {
        return this.value;
    }

    public Number value(Unit<Length> inUnit) {
        if (this.unit.equals(inUnit)) {
            return this.value;
        }
        if (this.unit.isConvertible(inUnit).booleanValue()) {
            return this.unit.convertValue(this.value, inUnit);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Length otherLength = (Length)other;
        if (this.unit.equals(otherLength.unit)) {
            return this.value.equals(otherLength.value);
        }
        if (this.unit.isConvertible(otherLength.unit).booleanValue()) {
            return this.unit.convertValue(this.value, otherLength.unit).equals(otherLength.value);
        }
        return false;
    }

    @Override
    public int compareTo(Length other) {
        if (this == other) {
            return 0;
        }
        return Double.compare(this.value.doubleValue(), other.value(this.unit).doubleValue());
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName());
        result.append(": ");
        result.append("value[");
        result.append(this.value);
        result.append("], unit[");
        result.append(this.unit.getSymbol());
        result.append("] stored as ");
        result.append(this.value.getClass().getName());
        return result.toString();
    }

    public Unit<Length> unit() {
        return this.unit;
    }
}

