/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarTimeZone;
import ucar.nc2.units.DateFormatter;

@ThreadSafe
public class CalendarDateFormatter {
    private static DateTimeFormatter isof = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZoneUTC();
    private static DateTimeFormatter isof_with_millis_of_second = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();
    private static DateTimeFormatter dtf = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss'Z'").withZoneUTC();
    private static DateTimeFormatter dtf_with_millis_of_second = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS'Z'").withZoneUTC();
    private static DateTimeFormatter df = DateTimeFormat.forPattern("yyyy-MM-dd").withZoneUTC();
    public static final String isodatePatternString = "([\\+\\-\\d]+)([ t]([\\.\\:\\d]*)([ \\+\\-]\\S*)?z?)?$";
    private static final Pattern isodatePattern = Pattern.compile("([\\+\\-\\d]+)([ t]([\\.\\:\\d]*)([ \\+\\-]\\S*)?z?)?$");
    private final DateTimeFormatter dflocal;

    public static String toDateTimeStringISO(CalendarDate cd) {
        if (cd.getDateTime().getMillisOfSecond() == 0) {
            return isof.print(cd.getDateTime());
        }
        return isof_with_millis_of_second.print(cd.getDateTime());
    }

    public static String toDateTimeStringISO(Date d) {
        return CalendarDateFormatter.toDateTimeStringISO(CalendarDate.of(d));
    }

    public static String toDateTimeString(CalendarDate cd) {
        if (cd.getDateTime().getMillisOfSecond() == 0) {
            return dtf.print(cd.getDateTime());
        }
        return dtf_with_millis_of_second.print(cd.getDateTime());
    }

    public static String toDateTimeString(Date date) {
        return CalendarDateFormatter.toDateTimeString(CalendarDate.of(date));
    }

    public static String toDateTimeStringPresent() {
        return dtf.print(new DateTime());
    }

    public static String toDateString(CalendarDate cd) {
        return df.print(cd.getDateTime());
    }

    public static String toDateStringPresent() {
        return df.print(new DateTime());
    }

    @Deprecated
    public static Date parseISODate(String iso) {
        DateFormatter df = new DateFormatter();
        return df.getISODate(iso);
    }

    public static CalendarDate isoStringToCalendarDate(Calendar calt, String iso) throws IllegalArgumentException {
        DateTime dt = CalendarDateFormatter.parseIsoTimeString(calt, iso);
        return new CalendarDate(calt, dt);
    }

    public static Date isoStringToDate(String iso) throws IllegalArgumentException {
        CalendarDate dt = CalendarDateFormatter.isoStringToCalendarDate(null, iso);
        return dt.toDate();
    }

    private static DateTime parseIsoTimeString(Calendar calt, String iso) {
        iso = iso.trim();
        Matcher m = isodatePattern.matcher(iso = iso.toLowerCase());
        if (!m.matches()) {
            throw new IllegalArgumentException(iso + " does not match " + isodatePatternString);
        }
        String dateString = m.group(1);
        String timeString = m.group(3);
        String zoneString = m.group(4);
        int year = 0;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        double second = 0.0;
        try {
            boolean isMinus = false;
            if (dateString.startsWith("-")) {
                isMinus = true;
                dateString = dateString.substring(1);
            } else if (dateString.startsWith("+")) {
                dateString = dateString.substring(1);
            }
            StringTokenizer dateTokenizer = new StringTokenizer(dateString, "-");
            if (dateTokenizer.hasMoreTokens()) {
                year = Integer.parseInt(dateTokenizer.nextToken());
            }
            if (dateTokenizer.hasMoreTokens()) {
                month = Integer.parseInt(dateTokenizer.nextToken());
            }
            if (dateTokenizer.hasMoreTokens()) {
                day = Integer.parseInt(dateTokenizer.nextToken());
            }
            if (timeString != null && timeString.length() > 0) {
                StringTokenizer timeTokenizer = new StringTokenizer(timeString, ":");
                if (timeTokenizer.hasMoreTokens()) {
                    hour = Integer.parseInt(timeTokenizer.nextToken());
                }
                if (timeTokenizer.hasMoreTokens()) {
                    minute = Integer.parseInt(timeTokenizer.nextToken());
                }
                if (timeTokenizer.hasMoreTokens()) {
                    second = Double.parseDouble(timeTokenizer.nextToken());
                }
            }
            if (isMinus) {
                year = -year;
            }
            Chronology cron = Calendar.getChronology(calt);
            cron = cron.withUTC();
            DateTime dt = new DateTime(year, month, day, hour, minute, 0, 0, cron);
            dt = dt.plus((long)(1000.0 * second));
            if (!(zoneString == null || (zoneString = zoneString.trim()).length() <= 0 || zoneString.equalsIgnoreCase("Z") || zoneString.equalsIgnoreCase("UTC") || zoneString.equalsIgnoreCase("GMT"))) {
                String hourS;
                isMinus = false;
                if (zoneString.startsWith("-")) {
                    isMinus = true;
                    zoneString = zoneString.substring(1);
                } else if (zoneString.startsWith("+")) {
                    zoneString = zoneString.substring(1);
                }
                int hourOffset = 0;
                int minuteOffset = 0;
                int posColon = zoneString.indexOf(58);
                if (posColon > 0) {
                    hourS = zoneString.substring(0, posColon);
                    String minS = zoneString.substring(posColon + 1);
                    hourOffset = Integer.parseInt(hourS);
                    minuteOffset = Integer.parseInt(minS);
                } else if (zoneString.length() > 2) {
                    hourS = zoneString.substring(0, 2);
                    String minS = zoneString.substring(2);
                    hourOffset = Integer.parseInt(hourS);
                    minuteOffset = Integer.parseInt(minS);
                } else {
                    hourOffset = Integer.parseInt(zoneString);
                }
                if (isMinus) {
                    hourOffset = -hourOffset;
                }
                DateTimeZone dtz = DateTimeZone.forOffsetHoursMinutes(hourOffset, minuteOffset);
                dt = dt.withZoneRetainFields(dtz);
                dt = dt.withZone(DateTimeZone.UTC);
            }
            return dt;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal base time specification: '" + dateString + "' " + e.getMessage());
        }
    }

    public CalendarDateFormatter(String pattern) {
        this.dflocal = DateTimeFormat.forPattern(pattern).withZoneUTC();
    }

    public CalendarDateFormatter(String pattern, CalendarTimeZone tz, Calendar cal) {
        Chronology chron = Calendar.getChronology(cal);
        this.dflocal = DateTimeFormat.forPattern(pattern).withChronology(chron).withZone(tz.getJodaTimeZone());
    }

    public CalendarDateFormatter(String pattern, CalendarTimeZone tz) {
        this.dflocal = DateTimeFormat.forPattern(pattern).withZone(tz.getJodaTimeZone());
    }

    public String toString(CalendarDate cd) {
        return this.dflocal.print(cd.getDateTime());
    }

    public CalendarDate parse(String timeString) {
        DateTime dt = this.dflocal.parseDateTime(timeString);
        Calendar cal = Calendar.get(dt.getChronology().toString());
        return new CalendarDate(cal, dt);
    }

    public static void main(String[] arg) {
        CalendarDate cd = CalendarDate.present();
        System.out.printf("%s%n", cd);
        System.out.printf("%s%n", CalendarDateFormatter.toDateTimeStringISO(cd));
        System.out.printf("%s%n", CalendarDateFormatter.toDateTimeString(cd));
        System.out.printf("%s%n", CalendarDateFormatter.toDateString(cd));
        Date d = new Date();
        System.out.printf("%s%n", CalendarDateFormatter.toDateTimeString(d));
        DateFormatter df = new DateFormatter();
        System.out.printf("%s%n", df.toDateTimeString(d));
        System.out.printf("%s%n", df.toDateOnlyString(d));
    }
}

