/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.CpuInfo;
import edu.stanford.facs.swing.Html;
import edu.stanford.facs.swing.ImageIconColorer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class Basics {
    public static Float widthFactor;
    public static Float heightFactor;
    public static Float toolBarFactor;
    static final String UTF8 = "UTF-8";
    private static final String[] entities;
    private static char[] symbols;

    public static String getHomeNoDriveLetter() {
        String string = System.getProperty("user.home").indexOf(":") == 1 ? System.getProperty("user.home").substring(2) : System.getProperty("user.home");
        return string;
    }

    public Set getDupSet(Collection<String> collection, Map<String, List> map, String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        if (collection.size() >= 0) {
            Iterator<String> iterator = collection.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                List list = map.get(string2);
                if (list == null) {
                    treeSet.add(string2);
                    continue;
                }
                if (list.size() == 0) {
                    treeSet.add(string2);
                    continue;
                }
                if (string == null || !list.contains(string)) {
                    int n = list.size();
                    String string3 = string2 + " #" + (n + 1);
                    while (map.containsKey(string3)) {
                        n = n++;
                        string3 = string2 + " #" + (n + 1);
                    }
                    arrayList.add(string2);
                    arrayList2.add(string3);
                    treeSet2.add(string2);
                    continue;
                }
                treeSet.add(string2);
            }
        }
        return treeSet;
    }

    public static void savePng(ImageIcon imageIcon, String string, String string2) throws IOException {
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
    }

    public static JTextField GetTextField(JComboBox<Object> jComboBox, int n) {
        jComboBox.setSelectedIndex(-1);
        jComboBox.setEditable(true);
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        jTextField.setFocusable(true);
        jTextField.setText("");
        jTextField.setColumns(n);
        String string = new String(new char[n]).replace("\u0000", "F");
        jComboBox.setPrototypeDisplayValue(string);
        jTextField.setFocusable(true);
        jTextField.setText("");
        return jTextField;
    }

    public static int Scale(int n) {
        if ((double)toolBarFactor.floatValue() < 1.1) {
            return n;
        }
        return (int)((float)n * toolBarFactor.floatValue());
    }

    public static Object GetResizedImg(File file, float f, File file2) {
        String string = file.getAbsolutePath();
        if ((double)f > 0.0 && f != 1.0f && file.exists()) {
            File file3;
            String string2 = file.getName();
            int n = string2.lastIndexOf(".");
            if (n >= 0) {
                string2 = string2.substring(0, n) + "_" + f + ".png";
            }
            if (!(file3 = new File(file2, string2)).exists()) {
                ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
                int n2 = (int)((float)imageIcon.getIconWidth() * f);
                int n3 = (int)((float)imageIcon.getIconHeight() * f);
                Image image = Basics.Resize(imageIcon, n2, n3).getImage();
                BufferedImage bufferedImage = ImageIconColorer.ImageToBufferedImage(image, n2, n3);
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", file3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }
            string = file3.getAbsolutePath();
        }
        return string;
    }

    public static void HearEnterKey(final JList jList, final JButton jButton) {
        jList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray.length > 1) {
                    return;
                }
                if (keyEvent.getKeyCode() == 10) {
                    System.out.println("Sending ACTION_PERFORMED to ActionListener");
                    jButton.doClick();
                    keyEvent.consume();
                }
            }
        });
    }

    public static ImageIcon Resize(ImageIcon imageIcon, float f) {
        if (imageIcon == null) {
            return null;
        }
        int n = (int)((float)imageIcon.getIconWidth() * f);
        int n2 = (int)((float)imageIcon.getIconHeight() * f);
        return Basics.Resize(imageIcon, n, n2, 4);
    }

    public static ImageIcon Resize(ImageIcon imageIcon, int n, int n2) {
        return Basics.Resize(imageIcon, n, n2, 4);
    }

    public static ImageIcon Resize(ImageIcon imageIcon, int n, int n2, int n3) {
        return Basics.Resize(imageIcon.getImage(), n, n2, n3);
    }

    public static ImageIcon Resize(Image image, int n, int n2, int n3) {
        Image image2 = image.getScaledInstance(n, n2, n3);
        return new ImageIcon(image2);
    }

    public static void setResizingFactors(float f, float f2, float f3) {
        widthFactor = Float.valueOf(f);
        heightFactor = Float.valueOf(f2);
        toolBarFactor = Float.valueOf(f3);
    }

    public static ImageIcon ResizeIfNeeded(ImageIcon imageIcon) {
        if (toolBarFactor == null) {
            Basics.setResizing(2000, 2000, 12);
        }
        if (toolBarFactor.floatValue() != 1.0f) {
            return Basics.Resize(imageIcon, toolBarFactor.floatValue());
        }
        return imageIcon;
    }

    public static void setResizing(int n, int n2, int n3) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        widthFactor = Float.valueOf(1.0f);
        heightFactor = Float.valueOf(1.0f);
        toolBarFactor = Float.valueOf(1.0f);
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            if (rectangle == null || rectangle.height <= n && rectangle.width <= n2) continue;
            toolBarFactor = Float.valueOf((float)UIManager.getFont("Label.font").getSize() / (float)n3);
            heightFactor = Float.valueOf((float)rectangle.height / (float)n);
            widthFactor = Float.valueOf((float)rectangle.width / (float)n2);
        }
    }

    public static void setFontFace(String string) {
        String[] stringArray = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Font font = (Font)UIManager.get(string2);
            UIManager.put(string2, new Font(string, font.getStyle(), font.getSize()));
        }
    }

    public static synchronized ArrayList<Double> readMatrix(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(string)), UTF8));
            return Basics.readMatrix(bufferedReader, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ArrayList<Double> readMatrix(BufferedReader bufferedReader, boolean bl) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (bufferedReader != null) {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (bl) {
                        System.out.println("***" + string);
                    }
                    String[] stringArray = string.split(", *");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Double d = 0.0;
                        try {
                            d = Double.parseDouble(stringArray[i]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        arrayList.add(d);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                CpuInfo.closeWithoutThrowingUp(bufferedReader);
            }
        }
        return arrayList;
    }

    public static double[][] reshape2D(Collection<Double> collection) {
        int n = (int)Math.sqrt(collection.size());
        return Basics.reshape2D(collection, n, n);
    }

    public static double[][] reshape2D(Collection<Double> collection, int n, int n2) {
        double[][] dArrayArray = new double[n][];
        Iterator<Double> iterator = collection.iterator();
        int n3 = 0;
        int n4 = 0;
        double[] dArray = new double[n2];
        while (iterator.hasNext()) {
            dArray[n4] = iterator.next();
            if (++n4 != 256) continue;
            n4 = 0;
            dArray = new double[n2];
            dArrayArray[n3] = dArray;
            ++n3;
        }
        return dArrayArray;
    }

    public static double[] reshape1D(Collection<Double> collection) {
        double[] dArray = new double[collection.size()];
        Iterator<Double> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            dArray[n] = iterator.next();
            ++n;
        }
        return dArray;
    }

    public static int[] reshape1DInt(Collection<Double> collection) {
        int[] nArray = new int[collection.size()];
        Iterator<Double> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            double d = iterator.next();
            nArray[n] = (int)d;
            ++n;
        }
        return nArray;
    }

    public static int[] toInt(Collection collection) {
        int[] nArray = new int[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n2 = 0;
            if (e instanceof Number) {
                n2 = ((Number)e).intValue();
            } else {
                try {
                    n2 = (int)Double.parseDouble(e.toString());
                }
                catch (Exception exception) {
                    System.out.println("Can't convert " + e);
                }
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public String ToFile() {
        return null;
    }

    public static Object EncodeFileUrl(String string) {
        return URLEncoder.encode(string).replaceAll("\\+", "%20");
    }

    public static Object EncodeFileUrl2(String string, String string2) {
        return URLEncoder.encode(new File(string, string2).getAbsolutePath()).replaceAll("\\+", "%20");
    }

    public static String firstWord(String string) {
        int n = string.indexOf(32);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String RemoveXml(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        int n = cArray.length;
        int n2 = entities.length;
        boolean bl = false;
        block5: for (int i = 0; i < n; ++i) {
            if (bl) {
                if (cArray[i] != '>') continue;
                bl = false;
                continue;
            }
            switch (cArray[i]) {
                case '<': {
                    bl = true;
                }
                case '*': 
                case '[': 
                case ']': 
                case '^': {
                    continue block5;
                }
                case '&': {
                    int n3;
                    for (n3 = i + 1; n3 < n && cArray[n3] != ';'; ++n3) {
                    }
                    if (n3 < n) {
                        int n4;
                        String string2 = string.substring(i, n3);
                        for (n4 = 0; n4 < n2; ++n4) {
                            if (!string2.equals(entities[n4])) continue;
                            stringBuilder.append(symbols[n4]);
                            break;
                        }
                        if (n4 == n2) {
                            stringBuilder.append(string2);
                            stringBuilder.append(';');
                        }
                    }
                    i = n3;
                    continue block5;
                }
                default: {
                    stringBuilder.append(cArray[i]);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object2 != null) {
            return object2.equals(object);
        }
        return object.equals(object2);
    }

    public static String getFileNameNoExtension(String string) {
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static Object Pluralize(String string, int n) {
        if (n > 1 || n == 0) {
            return string + "s";
        }
        return string;
    }

    public static Object Pluralize(String string, int n, String string2) {
        if (n > 1 || n == 0) {
            return string2;
        }
        return string;
    }

    public static Object Pluralize2(String string, int n) {
        if (n > 1 || n == 0) {
            return n + " " + string + "s";
        }
        return n + " " + string;
    }

    public static Object Pluralize2(String string, int n, String string2) {
        if (n > 1 || n == 0) {
            return n + " " + string2;
        }
        return n + " " + string;
    }

    public static void main(String[] stringArray) {
        Test.go(stringArray);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static List<String> tabToCsv(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(string.replaceAll(",", "").replaceAll("\t", ","));
        }
        return arrayList;
    }

    public static Object tabToCsv(String string) {
        return string.replaceAll(",", " ").replaceAll("\t", ",");
    }

    public static List<Integer> indexesOf(String string, String string2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = string.indexOf(string2);
        while (n >= 0) {
            arrayList.add(n);
            n = string.indexOf(string2, n + string2.length());
        }
        return arrayList;
    }

    static {
        entities = new String[]{"&nbsp", "&amp", "&lt", "&gt", "&cent", "&pound", "&yen", "&euro", "&copy", "&reg"};
        symbols = new char[]{' ', '&', '<', '>', '\u00a2', '\u00a3', '\u00a5', '\u20ac', '\u00a9', '\u00ae'};
    }

    private static class Test {
        private Test() {
        }

        static void go(String[] stringArray) {
            Object object = (String)Basics.GetResizedImg(new File("/Users/swmeehan/Documents/eclipse/CytoGate/matlabsrc/tree.png"), 32.0f, new File("/Users/swmeehan/.autoGate"));
            object = Basics.GetResizedImg(new File("/Users/swmeehan/Documents/eclipse/AutooGate/matlabsrc/tree.png"), 32.0f, new File("/Users/swmeehan/.autoGate"));
            Object object2 = Basics.EncodeFileUrl("/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate/76.png");
            object2 = Basics.EncodeFileUrl2("/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", "76.png");
            object2 = Basics.EncodeFileUrl2("/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", "76.png");
            object2 = Html.ImgSized2("76.png", "/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", 1.0, 200, false);
            object2 = Html.ImgSized2("76.png", "/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", 1.0, 200, true);
            object2 = Html.ImgSized2("76.png", "/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", 0.5, 200, false);
            object2 = Html.ImgSized2("76.png", "/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", 0.75, 200, true);
            String string = Basics.RemoveXml("HI how are you");
            String string2 = Basics.RemoveXml("<html>I am good and &gt; you at making &cent; and &euro;nd &stuff; like that!!&aMp");
            String string3 = "/Users/swmeehan/Documents/workspace/CytoGate/matlabsrc/pointers.txt";
            if (stringArray.length > 0) {
                string3 = stringArray[0];
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("123.44");
            arrayList.add(45.2);
            arrayList.add(2);
            arrayList.add(Character.valueOf('h'));
            int[] nArray = Basics.toInt(arrayList);
            ArrayList<Double> arrayList2 = Basics.readMatrix(string3);
            double[][] dArray = Basics.reshape2D(arrayList2);
            double[] dArray2 = Basics.reshape1D(arrayList2);
            System.out.println(arrayList2);
        }
    }

    public static class Dups {
        final Set<String> unused = new TreeSet<String>();
        final Set<String> used = new TreeSet<String>();
        final List<String> dups = new ArrayList<String>();
        final List<String> dupAlts = new ArrayList<String>();
    }
}

