function import_bardensr_results(batches, codebook_name,codebookopt_name)
    if ~exist('codebook_name','var')
        codebook_name='codebook.mat';
    end

    

    % import geneseq results
    [folders,~]=get_folders();
    S=load(codebook_name);
    codebook=S.codebook;
    %load(codebook_name,'codebook');
    id2={};
    lroi={};
    %for i=55
    for i=1:numel(folders)    
        cd(folders{i})
        cd aligned
        try
            m=dlmread('bardensrresult.csv',',',1,0);
            lroi{i}=m(:,[3 2])+1;
            id2{i}=m(:,4)+1;
        catch
            warning('%s has no geneseq rolonies\n',folders{i});
            lroi{i}=[];
            id2{i}=[];
        end
    
        
        cd ../..
    end


    % import opt cycle
    if exist('codebookopt_name','var')
        [folders,~]=get_folders();
        S_opt=load(codebookopt_name);
        codebook_opt=S_opt.codebook;
        %load(codebookopt_name,'codebook');

        id3={};
        lroi3={};

        for i=1:numel(folders)
            cd(folders{i})
            cd aligned
            try
                m=dlmread('bardensrresult_optseq.csv',',',1,0);
                lroi3{i}=m(:,[3 2])+1;
                id3{i}=m(:,4)+1+size(codebook,1);
            catch
                warning('%s has no optseq rolonies\n',folders{i});
                lroi3{i}=[];
                id3{i}=[];
            end
            cd ../..
        end


    end




    % manually check false positive rate, reiterate basecalling if necessary (keep fpr <5%)
    unusedidx=find(contains(codebook(:,1),caseInsensitivePattern('unused')));
    %sum(ismember(cell2mat(id2'),unusedidx))
    %numel(cell2mat(id2'))
    fpr=sum(ismember(cell2mat(id2'),unusedidx))/numel(cell2mat(id2'))/numel(unusedidx)*sum(~contains(codebook(:,1),'unused'));
    fprintf('Finished importing geneseq bardensr results.\n Overall FPR is %.3u\n',fpr);
    
    if exist('codebookopt_name','var')
        % manually check false positive rate, reiterate basecalling if necessary (keep fpr <5%)

        unusedidx=find(contains(codebook_opt(:,1),caseInsensitivePattern('unused')))+size(codebook,1);
        %sum(ismember(cell2mat(id2'),unusedidx))
        %numel(cell2mat(id2'))
        fpr_opt=sum(ismember(cell2mat(id3'),unusedidx))/numel(cell2mat(id3'))/numel(unusedidx)*sum(~contains(codebook_opt(:,1),caseInsensitivePattern('unused')));
        fprintf('Finished importing optseq bardensr results.\n Overall FPR is %.3u\n',fpr_opt);

        id2=cellfun(@(x,y)[x;y],id2,id3, ...
            'UniformOutput',false);
        lroi=cellfun(@(x,y)[x;y],lroi,lroi3, ...
            'UniformOutput',false);
        
    end





    
    save('basecalls.mat','lroi','id2','-v7.3')
    


    % if exist('batches','var')
    %     uniq_batches=unique(batches);
    %     num_batches=numel(uniq_batches);
    %     for i=1:num_batches
    %         fpr=sum(ismember(cell2mat(id2(batches==uniq_batches(i))'),unusedidx))/numel(cell2mat(id2(batches==uniq_batches(i))'))/numel(unusedidx)*sum(~contains(codebook(:,1),'unused'));
    %         fprintf('Batch %u, FPR is %.3u\n',uniq_batches(i),fpr);
    %     end
    % end
    % 
    
            



end