
function cmdout=run_bardensr(use_predefined_thresh,cycle_name,codebook_name,codebookbin_name,scriptname)
    %This needs to be changed on new systems
    if ~exist('use_predefined_thresh','var')
        use_predefined_thresh=0;
    end

    if ~exist('cycle_name','var')
        cycle_name='geneseq';
    end

    if ~exist('codebook_name','var')
        codebook_name='codebook.mat';
    end

    if ~exist('codebookbin_name','var')
        codebookbin_name='codebookforbardensr.mat';
    end

    if ~exist('scriptname','var')
        scriptname='bardensrbasecall.py';
    end


        % is the script provided? If not, using default script
    if ~isfile(scriptname)
        if exist(scriptname,'file')

            fprintf('No custom bardensr script provided. Using default %s for processing.\n', scriptname);
            scriptname=['"',which(scriptname),'"'];

        else
            error([scriptname,' does not exist.']);
        end
    else
        warning('%s is provided in the current folder, overriding default %s.\n',scriptname,scriptname);
    end


    py_root_n2v = fileparts("C:\barseq_envs\bardensr\python.exe");
    ENV = getenv('PATH');
    oldpath=ENV;
    ENV = strsplit(ENV, ';');
    items_to_add_to_path = {
        char(fullfile(py_root_n2v, 'Library', 'mingw64', 'bin'))
        char(fullfile(py_root_n2v, 'Library', 'usr', 'bin'))
        char(fullfile(py_root_n2v, 'Library', 'bin'))
        char(fullfile(py_root_n2v, 'Scripts'))
        char(py_root_n2v)
        };
    ENV = [items_to_add_to_path(:); ENV(:)];
    ENV = unique(ENV, 'stable');
    ENV = strjoin(ENV, ';');
    
    fprintf('Starting bardensr in python for %s ...\n',cycle_name)
    cd ..
    setenv('PATH', ENV);
    % if use_predefined_thresh  % fixed bardensrbasecall.py to run both
    % cases
    %     [status,cmdout]=system([ ...
    %         'python bardensrbasecall_predefinedthresh.py ', ...
    %         cycle_name,' ', ...
    %         codebook_name,' ', ...
    %         codebookbin_name,' ', ...
    %         num2str(use_predefined_thresh)], ...
    %         '-echo');
    % else
        [status,cmdout]=system([ ...
            'python ', ...
             scriptname,' ', ...
             cycle_name,' ', ...
             codebook_name,' ', ...
             codebookbin_name,' ', ...
             num2str(use_predefined_thresh)], ...
             '-echo');
    % end
    setenv('PATH',oldpath);
    cd processed
    if status==0
        fprintf('bardensr finished successfully.\n')
    else
        warning('bardensr has a warning. Please check cmdout.\n')
    end

end