%reduce filt_neurons file size

function cleanup_filt_neurons(filename,fields_to_reduce,fields_to_delete)
% filename = 'filt_neurons_709413_CCFv2'; %change this for each experiment
% 
% fields_to_reduce = {'clustid','subclass','CCFname','CCFparentname'};
% %example fields to reduce
% 
% fields_to_delete = {'depth','angle'}; %example fields to delete

F = load(filename);
old_filt_neurons = F.filt_neurons;
clear F

%% 

fields = fieldnames(old_filt_neurons);
to_change = ismember(fields,fields_to_reduce);
to_delete = ismember(fields,fields_to_delete);

for i = 1:length(fields)
    if to_change(i) == 1 %change these fields
        code_name = append(fields{i},'_code');
        uniq_vars = unique(old_filt_neurons.(fields{i}));

        filt_neurons.(code_name) = uniq_vars;
        new_field = zeros(length(old_filt_neurons.(fields{i})),1);

        for j = 1:length(uniq_vars)
            match = ismember(old_filt_neurons.(fields{i}),uniq_vars{j});
            new_field(match) = j;
        end

        filt_neurons.(fields{i}) = new_field;
    elseif to_delete(i) == 0
        %copy directly
        filt_neurons.(fields{i}) = old_filt_neurons.(fields{i});
    end
end
%% 

new_file_name = append(filename,'_small.mat');
save(new_file_name,'filt_neurons','-v7.3');

end