/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import com.google.api.client.util.Key;
import io.minio.DateFormat;
import io.minio.messages.Owner;
import io.minio.messages.XmlEntity;
import java.util.Date;
import org.xmlpull.v1.XmlPullParserException;

public class Item
extends XmlEntity {
    @Key(value="Key")
    private String objectName;
    @Key(value="LastModified")
    private String lastModified;
    @Key(value="ETag")
    private String etag;
    @Key(value="Size")
    private long size;
    @Key(value="StorageClass")
    private String storageClass;
    @Key(value="Owner")
    private Owner owner;
    private boolean isDir = false;

    public Item() throws XmlPullParserException {
        this(null, false);
    }

    public Item(String objectName, boolean isDir) throws XmlPullParserException {
        this.name = "Item";
        this.objectName = objectName;
        this.isDir = isDir;
    }

    public String objectName() {
        return this.objectName;
    }

    public Date lastModified() {
        return DateFormat.RESPONSE_DATE_FORMAT.parseDateTime(this.lastModified).toDate();
    }

    public String etag() {
        return this.etag;
    }

    public long objectSize() {
        return this.size;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public Owner owner() {
        return this.owner;
    }

    public boolean isDir() {
        return this.isDir;
    }
}

