/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ReaderWrapper;
import loci.formats.gui.AWTImageTools;

public class BufferedImageReader
extends ReaderWrapper {
    public static BufferedImageReader makeBufferedImageReader(IFormatReader r) {
        if (r instanceof BufferedImageReader) {
            return (BufferedImageReader)r;
        }
        return new BufferedImageReader(r);
    }

    public BufferedImageReader() {
    }

    public BufferedImageReader(IFormatReader r) {
        super(r);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return this.openImage(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public BufferedImage openImage(int no, int x, int y, int w, int h) throws FormatException, IOException {
        Class<?> dataType = this.getNativeDataType();
        if (BufferedImage.class.isAssignableFrom(dataType)) {
            return (BufferedImage)this.openPlane(no, x, y, w, h);
        }
        return AWTImageTools.openImage(this.openBytes(no, x, y, w, h), this, w, h);
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        Class<?> dataType = this.getNativeDataType();
        if (BufferedImage.class.isAssignableFrom(dataType)) {
            BufferedImage img = AWTImageTools.makeUnsigned(this.openImage(no));
            return AWTImageTools.scale(img, this.getThumbSizeX(), this.getThumbSizeY(), false);
        }
        byte[] thumbBytes = this.openThumbBytes(no);
        return AWTImageTools.openImage(thumbBytes, this, this.getThumbSizeX(), this.getThumbSizeY());
    }
}

