/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.PackbitsCodec;
import loci.formats.codec.WrappedCodec;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class DicomReader
extends FormatReader {
    public static final String DICOM_MAGIC_STRING = "DICM";
    private static final String[] DICOM_SUFFIXES = new String[]{"dic", "dcm", "dicom", "j2ki", "j2kr"};
    private static final ImmutableMap<Integer, String> TYPES = DicomReader.buildTypes();
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int PIXEL_SIGN = 2625601;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int SLICE_SPACING = 0x180088;
    private static final int SAMPLES_PER_PIXEL = 0x280002;
    private static final int PHOTOMETRIC_INTERPRETATION = 2621444;
    private static final int PLANAR_CONFIGURATION = 2621446;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int WINDOW_CENTER = 2625616;
    private static final int WINDOW_WIDTH = 2625617;
    private static final int RESCALE_INTERCEPT = 2625618;
    private static final int RESCALE_SLOPE = 2625619;
    private static final int ICON_IMAGE_SEQUENCE = 0x880200;
    private static final int ITEM = -73728;
    private static final int ITEM_DELIMINATION = -73715;
    private static final int SEQUENCE_DELIMINATION = -73507;
    private static final int PIXEL_DATA = 2145386512;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static final int IMPLICIT_VR = 11565;
    private int bitsPerPixel;
    private int location;
    private int elementLength;
    private int vr;
    private boolean oddLocations;
    private boolean inSequence;
    private boolean bigEndianTransferSyntax;
    private byte[][] lut;
    private short[][] shortLut;
    private long[] offsets;
    private int maxPixelRange;
    private int centerPixelValue;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private boolean isJP2K = false;
    private boolean isJPEG = false;
    private boolean isRLE = false;
    private boolean isDeflate = false;
    private boolean inverted;
    private String date;
    private String time;
    private String imageType;
    private String pixelSizeX;
    private String pixelSizeY;
    private Double pixelSizeZ;
    private List<Double> positionX = new ArrayList<Double>();
    private List<Double> positionY = new ArrayList<Double>();
    private List<Double> positionZ = new ArrayList<Double>();
    private Map<Integer, List<String>> fileList;
    private int imagesPerFile;
    private String originalDate;
    private String originalTime;
    private String originalInstance;
    private int originalSeries;
    private int originalX;
    private int originalY;
    private DicomReader helper;
    private List<String> companionFiles = new ArrayList<String>();

    public DicomReader() {
        super("DICOM", new String[]{"dic", "dcm", "dicom", "jp2", "j2ki", "j2kr", "raw", "ima"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = new String[]{"Medical Imaging"};
        this.datasetDescription = "One or more .dcm or .dicom files";
        this.hasCompanionFiles = true;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (DicomReader.checkSuffix(name, DICOM_SUFFIXES)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 1024;
        if (!FormatTools.validStream(stream, 1024, true)) {
            return false;
        }
        stream.seek(128L);
        if (stream.readString(4).equals(DICOM_MAGIC_STRING)) {
            return true;
        }
        stream.seek(0L);
        try {
            int tag = this.getNextTag(stream, false);
            return TYPES.containsKey(tag);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        for (String file2 : files) {
            if (!file2.endsWith("DICOMDIR")) continue;
            return 1;
        }
        return super.getRequiredDirectories(files);
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 0 && this.getPixelType() != 1) {
            return null;
        }
        return this.lut;
    }

    @Override
    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 2 && this.getPixelType() != 3) {
            return null;
        }
        return this.shortLut;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels || this.fileList == null) {
            return null;
        }
        Object[] keys = this.fileList.keySet().toArray(new Integer[0]);
        Arrays.sort(keys);
        List<String> files = this.fileList.get(keys[this.getSeries()]);
        if (files == null) {
            return null;
        }
        ArrayList<String> uniqueFiles = new ArrayList<String>();
        for (String f : files) {
            if (uniqueFiles.contains(f)) continue;
            uniqueFiles.add(f);
        }
        for (String f : this.companionFiles) {
            if (uniqueFiles.contains(f)) continue;
            uniqueFiles.add(f);
        }
        return uniqueFiles.toArray(new String[uniqueFiles.size()]);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 1;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        block29: {
            int bpp;
            block30: {
                FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
                Object[] keys = this.fileList.keySet().toArray(new Integer[0]);
                Arrays.sort(keys);
                if (this.fileList.size() > 1 || this.fileList.get(keys[this.getSeries()]).size() > 1) {
                    int fileNumber = 0;
                    if (this.fileList.get(keys[this.getSeries()]).size() > 1) {
                        fileNumber = no / this.imagesPerFile;
                        no %= this.imagesPerFile;
                    }
                    String file2 = this.fileList.get(keys[this.getSeries()]).get(fileNumber);
                    this.helper.setId(file2);
                    return this.helper.openBytes(no, buf, x, y, w, h);
                }
                int ec = this.isIndexed() ? 1 : this.getSizeC();
                bpp = FormatTools.getBytesPerPixel(this.getPixelType());
                int bytes = this.getSizeX() * this.getSizeY() * bpp * ec;
                if (this.in == null) {
                    this.in = new RandomAccessInputStream(this.currentId);
                }
                this.in.seek(this.offsets[no]);
                if (this.isRLE) {
                    CodecOptions options = new CodecOptions();
                    options.maxBytes = this.getSizeX() * this.getSizeY();
                    block0: for (int c = 0; c < ec; ++c) {
                        PackbitsCodec codec = new PackbitsCodec();
                        byte[] t = null;
                        if (bpp > 1) {
                            int i;
                            int plane = bytes / (bpp * ec);
                            byte[][] tmp = new byte[bpp][];
                            long start = this.in.getFilePointer();
                            for (i = 0; i < bpp; ++i) {
                                tmp[i] = codec.decompress(this.in, options);
                                if (i > 0 && tmp[i].length > options.maxBytes) {
                                    this.in.seek(start);
                                    tmp[i] = codec.decompress(this.in, options);
                                }
                                if (no >= this.imagesPerFile - 1 && i >= bpp - 1) continue;
                                start = this.in.getFilePointer();
                                while (this.in.read() == 0) {
                                }
                                long end = this.in.getFilePointer();
                                this.in.seek(end - 1L);
                            }
                            t = new byte[bytes / ec];
                            for (i = 0; i < plane; ++i) {
                                for (int j = 0; j < bpp; ++j) {
                                    int byteIndex;
                                    int n = byteIndex = this.isLittleEndian() ? bpp - j - 1 : j;
                                    if (i >= tmp[byteIndex].length) continue;
                                    t[i * bpp + j] = tmp[byteIndex][i];
                                }
                            }
                        } else {
                            t = codec.decompress(this.in, options);
                            if (t.length < bytes / ec) {
                                byte[] tmp = t;
                                t = new byte[bytes / ec];
                                System.arraycopy(tmp, 0, t, 0, tmp.length);
                            }
                            if (no < this.imagesPerFile - 1 || c < ec - 1) {
                                while (this.in.read() == 0) {
                                }
                                this.in.seek(this.in.getFilePointer() - 1L);
                            }
                        }
                        int rowLen = w * bpp;
                        int srcRowLen = this.getSizeX() * bpp;
                        for (int row = 0; row < h; ++row) {
                            int src = (row + y) * srcRowLen + x * bpp;
                            int dest = (h * c + row) * rowLen;
                            int len = Math.min(rowLen, t.length - src - 1);
                            if (len < 0) continue block0;
                            System.arraycopy(t, src, buf, dest, len);
                        }
                    }
                } else if (this.isJPEG || this.isJP2K) {
                    int pt;
                    long end = no < this.offsets.length - 1 ? this.offsets[no + 1] : this.in.length();
                    byte[] b = new byte[(int)(end - this.in.getFilePointer())];
                    this.in.read(b);
                    if (b[2] != -1) {
                        byte[] tmp = new byte[b.length + 1];
                        tmp[0] = b[0];
                        tmp[1] = b[1];
                        tmp[2] = -1;
                        System.arraycopy(b, 2, tmp, 3, b.length - 2);
                        b = tmp;
                    }
                    if ((b[3] & 0xFF) >= 240) {
                        b[3] = (byte)(b[3] - 48);
                    }
                    for (pt = b.length - 2; pt >= 0 && b[pt] != -1 || b[pt + 1] != -39; --pt) {
                    }
                    if (pt < b.length - 2) {
                        byte[] tmp = b;
                        b = new byte[pt + 2];
                        System.arraycopy(tmp, 0, b, 0, b.length);
                    }
                    WrappedCodec codec = null;
                    CodecOptions options = new CodecOptions();
                    options.littleEndian = this.isLittleEndian();
                    options.interleaved = this.isInterleaved();
                    codec = this.isJPEG ? new JPEGCodec() : new JPEG2000Codec();
                    b = codec.decompress(b, options);
                    int rowLen = w * bpp;
                    int srcRowLen = this.getSizeX() * bpp;
                    int srcPlane = this.getSizeY() * srcRowLen;
                    for (int c = 0; c < ec; ++c) {
                        for (int row = 0; row < h; ++row) {
                            System.arraycopy(b, c * srcPlane + (row + y) * srcRowLen + x * bpp, buf, h * rowLen * c + row * rowLen, rowLen);
                        }
                    }
                } else {
                    if (this.isDeflate) {
                        throw new UnsupportedCompressionException("Deflate data is not supported.");
                    }
                    this.readPlane(this.in, x, y, w, h, buf);
                }
                if (!this.inverted) break block29;
                if (bpp != 1) break block30;
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = (byte)(255 - buf[i]);
                }
                break block29;
            }
            if (bpp != 2) break block29;
            long maxPixelValue = this.maxPixelRange + this.centerPixelValue / 2;
            if (this.maxPixelRange == -1 || this.centerPixelValue < this.maxPixelRange / 2) {
                maxPixelValue = FormatTools.defaultMinMax(this.getPixelType())[1];
            }
            boolean little = this.isLittleEndian();
            for (int i = 0; i < buf.length; i += 2) {
                short s = DataTools.bytesToShort(buf, i, 2, little);
                DataTools.unpackBytes(maxPixelValue - (long)s, buf, i, 2, little);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.helper != null) {
            this.helper.close(fileOnly);
        }
        if (!fileOnly) {
            this.vr = 0;
            this.elementLength = 0;
            this.location = 0;
            this.bitsPerPixel = 0;
            this.bigEndianTransferSyntax = false;
            this.inSequence = false;
            this.oddLocations = false;
            this.isDeflate = false;
            this.isRLE = false;
            this.isJP2K = false;
            this.isJPEG = false;
            this.lut = null;
            this.offsets = null;
            this.shortLut = null;
            this.maxPixelRange = 0;
            this.centerPixelValue = 0;
            this.rescaleSlope = 1.0;
            this.rescaleIntercept = 0.0;
            this.pixelSizeY = null;
            this.pixelSizeX = null;
            this.pixelSizeZ = null;
            this.imagesPerFile = 0;
            this.fileList = null;
            this.inverted = false;
            this.imageType = null;
            this.time = null;
            this.date = null;
            this.originalInstance = null;
            this.originalTime = null;
            this.originalDate = null;
            this.originalSeries = 0;
            this.originalX = 0;
            this.originalY = 0;
            this.helper = null;
            this.companionFiles.clear();
            this.positionX.clear();
            this.positionY.clear();
            this.positionZ.clear();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        this.attachCompanionFiles();
        this.helper = new DicomReader();
        this.helper.setGroupFiles(false);
        m.littleEndian = true;
        this.location = 0;
        this.isJPEG = false;
        this.isRLE = false;
        this.bigEndianTransferSyntax = false;
        this.oddLocations = false;
        this.inSequence = false;
        this.bitsPerPixel = 0;
        this.elementLength = 0;
        this.vr = 0;
        this.lut = null;
        this.offsets = null;
        this.inverted = false;
        LOGGER.info("Verifying DICOM format");
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        this.in.seek(128L);
        if (this.in.readString(4).equals(DICOM_MAGIC_STRING)) {
            if (level != MetadataLevel.MINIMUM) {
                this.in.seek(0L);
                this.addSeriesMeta("Header information", this.in.readString(128));
                this.in.skipBytes(4);
            }
            this.location = 128;
        } else {
            this.in.seek(0L);
        }
        LOGGER.info("Reading tags");
        long baseOffset = 0L;
        boolean decodingTags = true;
        boolean signed = false;
        String currentType = "";
        while (decodingTags && this.in.getFilePointer() + 4L < this.in.length()) {
            LOGGER.debug("Reading tag from {}", (Object)this.in.getFilePointer());
            int tag = this.getNextTag(this.in);
            if (this.elementLength <= 0) continue;
            this.oddLocations = (this.location & 1) != 0;
            LOGGER.debug("  tag={} len={} fp=", tag, this.elementLength, this.in.getFilePointer());
            String s = null;
            switch (tag) {
                case 131088: {
                    s = this.in.readString(this.elementLength);
                    this.addInfo(tag, s);
                    if (s.startsWith("1.2.840.10008.1.2.4.9")) {
                        this.isJP2K = true;
                    } else if (s.startsWith("1.2.840.10008.1.2.4")) {
                        this.isJPEG = true;
                    } else if (s.startsWith("1.2.840.10008.1.2.5")) {
                        this.isRLE = true;
                    } else if (s.equals("1.2.8.10008.1.2.1.99")) {
                        this.isDeflate = true;
                    } else if (s.indexOf("1.2.4") > -1 || s.indexOf("1.2.5") > -1) {
                        throw new UnsupportedCompressionException("Sorry, compression type " + s + " not supported");
                    }
                    if (s.indexOf("1.2.840.10008.1.2.2") < 0) break;
                    this.bigEndianTransferSyntax = true;
                    break;
                }
                case 0x280008: {
                    s = this.in.readString(this.elementLength);
                    this.addInfo(tag, s);
                    double frames = Double.parseDouble(s);
                    if (!(frames > 1.0)) break;
                    this.imagesPerFile = (int)frames;
                    break;
                }
                case 0x280002: {
                    this.addInfo(tag, this.in.readShort());
                    break;
                }
                case 2621446: {
                    short config = this.in.readShort();
                    m.interleaved = config == 0;
                    this.addInfo(tag, config);
                    break;
                }
                case 2621456: {
                    short y = this.in.readShort();
                    if (y > this.getSizeY()) {
                        m.sizeY = y;
                        this.originalY = y;
                    }
                    this.addInfo(tag, this.getSizeY());
                    break;
                }
                case 2621457: {
                    short x = this.in.readShort();
                    if (x > this.getSizeX()) {
                        m.sizeX = x;
                        this.originalX = x;
                    }
                    this.addInfo(tag, this.getSizeX());
                    break;
                }
                case 0x180088: 
                case 2621444: 
                case 2621488: 
                case 2625616: 
                case 2625618: {
                    String winCenter = this.in.readString(this.elementLength);
                    if (winCenter.trim().length() == 0) {
                        this.centerPixelValue = -1;
                    } else {
                        try {
                            this.centerPixelValue = new Double(winCenter).intValue();
                        }
                        catch (NumberFormatException e) {
                            this.centerPixelValue = -1;
                        }
                    }
                    this.addInfo(tag, winCenter);
                    break;
                }
                case 2625619: {
                    this.addInfo(tag, this.in.readString(this.elementLength));
                    break;
                }
                case 2621696: {
                    if (this.bitsPerPixel == 0) {
                        this.bitsPerPixel = this.in.readShort();
                    } else {
                        this.in.skipBytes(2);
                    }
                    this.addInfo(tag, this.bitsPerPixel);
                    break;
                }
                case 2621699: 
                case 2625601: {
                    short ss = this.in.readShort();
                    signed = ss == 1;
                    this.addInfo(tag, ss);
                    break;
                }
                case 2625617: 
                case 537262910: {
                    String t = this.in.readString(this.elementLength);
                    if (t.trim().length() == 0) {
                        this.maxPixelRange = -1;
                    } else {
                        try {
                            this.maxPixelRange = new Double(t.trim()).intValue();
                        }
                        catch (NumberFormatException e) {
                            this.maxPixelRange = -1;
                        }
                    }
                    this.addInfo(tag, t);
                    break;
                }
                case -73728: 
                case 0xFFEE000: 
                case 2145386512: {
                    if (this.elementLength != 0) {
                        baseOffset = this.in.getFilePointer();
                        this.addInfo(tag, this.location);
                        decodingTags = false;
                        break;
                    }
                    this.addInfo(tag, null);
                    break;
                }
                case 2139619344: {
                    if (this.elementLength == 0) break;
                    baseOffset = this.location + 4;
                    decodingTags = false;
                    break;
                }
                case 2145386496: {
                    this.in.skipBytes(this.elementLength);
                    break;
                }
                case 0: {
                    this.in.seek(this.in.getFilePointer() - 4L);
                    break;
                }
                case 267312: {
                    currentType = this.getHeaderInfo(tag, s).trim();
                    break;
                }
                case 267520: {
                    if (currentType.equals("IMAGE")) {
                        int seriesIndex;
                        if (this.fileList == null) {
                            this.fileList = new HashMap<Integer, List<String>>();
                        }
                        if (this.fileList.get(seriesIndex = this.originalSeries) == null) {
                            this.fileList.put(seriesIndex, new ArrayList());
                        }
                        this.fileList.get(seriesIndex).add(this.getHeaderInfo(tag, s).trim());
                    } else {
                        this.companionFiles.add(this.getHeaderInfo(tag, s).trim());
                    }
                    currentType = "";
                    break;
                }
                default: {
                    long oldfp = this.in.getFilePointer();
                    this.addInfo(tag, s);
                    this.in.seek(oldfp + (long)this.elementLength);
                }
            }
            if (this.in.getFilePointer() < this.in.length() - 4L) continue;
            decodingTags = false;
        }
        if (this.imagesPerFile == 0) {
            this.imagesPerFile = 1;
        }
        if (id.endsWith("DICOMDIR")) {
            String parent = new Location(this.currentId).getAbsoluteFile().getParent();
            Object[] fileKeys = this.fileList.keySet().toArray(new Integer[0]);
            Arrays.sort(fileKeys);
            for (int q = 0; q < this.fileList.size(); ++q) {
                for (int i2 = 0; i2 < this.fileList.get(fileKeys[q]).size(); ++i2) {
                    String file2 = this.fileList.get(fileKeys[q]).get(i2);
                    file2 = file2.replace('\\', File.separatorChar);
                    file2 = file2.replaceAll("/", File.separator);
                    this.fileList.get(fileKeys[q]).set(i2, parent + File.separator + file2);
                }
            }
            for (int i3 = 0; i3 < this.companionFiles.size(); ++i3) {
                String file3 = this.companionFiles.get(i3);
                file3 = file3.replace('\\', File.separatorChar);
                file3 = file3.replaceAll("/", File.separator);
                this.companionFiles.set(i3, parent + File.separator + file3);
            }
            this.companionFiles.add(new Location(this.currentId).getAbsolutePath());
            this.initFile(this.fileList.get(fileKeys[0]).get(0));
            return;
        }
        m.bitsPerPixel = this.bitsPerPixel;
        while (this.bitsPerPixel % 8 != 0) {
            ++this.bitsPerPixel;
        }
        if (this.bitsPerPixel == 24 || this.bitsPerPixel == 48) {
            this.bitsPerPixel /= 3;
            m.bitsPerPixel /= 3;
        }
        m.pixelType = FormatTools.pixelTypeFromBytes(this.bitsPerPixel / 8, signed, false);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int plane = this.getSizeX() * this.getSizeY() * (this.lut == null ? this.getSizeC() : 1) * bpp;
        LOGGER.info("Calculating image offsets");
        this.in.seek(baseOffset - 12L);
        int len = this.in.readInt();
        if (len >= 0 && (long)len + this.in.getFilePointer() < this.in.length()) {
            this.in.skipBytes(len);
            int check = this.in.readShort() & 0xFFFF;
            if (check == 65534) {
                baseOffset = this.in.getFilePointer() + 2L;
            }
        }
        this.offsets = new long[this.imagesPerFile];
        for (int i4 = 0; i4 < this.imagesPerFile; ++i4) {
            if (this.isRLE) {
                if (i4 == 0) {
                    this.in.seek(baseOffset);
                } else {
                    this.in.seek(this.offsets[i4 - 1]);
                    CodecOptions options = new CodecOptions();
                    options.maxBytes = plane / bpp;
                    for (int q = 0; q < bpp; ++q) {
                        new PackbitsCodec().decompress(this.in, options);
                        while (this.in.read() == 0) {
                        }
                        this.in.seek(this.in.getFilePointer() - 1L);
                    }
                }
                this.in.skipBytes(i4 == 0 ? 64 : 53);
                while (this.in.read() == 0) {
                }
                this.offsets[i4] = this.in.getFilePointer() - 1L;
                continue;
            }
            if (this.isJPEG || this.isJP2K) {
                this.offsets[i4] = i4 == 0 ? baseOffset : this.offsets[i4 - 1] + 3L;
                byte secondCheck = this.isJPEG ? (byte)-40 : 79;
                this.in.seek(this.offsets[i4]);
                byte[] buf = new byte[8192];
                int n = this.in.read(buf);
                boolean found = false;
                while (!found) {
                    int q;
                    for (q = 0; q < n - 2; ++q) {
                        if (buf[q] != -1 || buf[q + 1] != secondCheck || buf[q + 2] != -1 || !this.isJPEG && (!this.isJP2K || buf[q + 3] != 81)) continue;
                        found = true;
                        this.offsets[i4] = this.in.getFilePointer() + (long)q - (long)n;
                        break;
                    }
                    if (found) continue;
                    for (q = 0; q < 4; ++q) {
                        buf[q] = buf[buf.length + q - 4];
                    }
                    n = this.in.read(buf, 4, buf.length - 4) + 4;
                }
                continue;
            }
            this.offsets[i4] = baseOffset + (long)(plane * i4);
        }
        this.makeFileList();
        LOGGER.info("Populating metadata");
        int seriesCount = this.fileList.size();
        Object[] keys = this.fileList.keySet().toArray(new Integer[0]);
        Arrays.sort(keys);
        if (seriesCount > 1) {
            this.core.clear();
        }
        for (int i5 = 0; i5 < seriesCount; ++i5) {
            CoreMetadata ms;
            if (seriesCount == 1) {
                ms = (CoreMetadata)this.core.get(i5);
                ms.sizeZ = this.imagesPerFile * this.fileList.get(keys[i5]).size();
                if (ms.sizeC == 0) {
                    ms.sizeC = 1;
                }
                ms.rgb = ms.sizeC > 1;
                ms.sizeT = 1;
                ms.dimensionOrder = "XYCZT";
                ms.metadataComplete = true;
                ms.falseColor = false;
                if (this.isRLE) {
                    ((CoreMetadata)this.core.get((int)i5)).interleaved = false;
                }
                ms.imageCount = ms.sizeZ;
                continue;
            }
            this.helper.close();
            this.helper.setId(this.fileList.get(keys[i5]).get(0));
            ms = this.helper.getCoreMetadataList().get(0);
            ms.sizeZ *= this.fileList.get(keys[i5]).size();
            ms.imageCount = ms.sizeZ;
            this.core.add(ms);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String stamp = null;
        if (this.date != null && this.time != null) {
            stamp = this.date + " " + this.time;
            stamp = DateTools.formatDate(stamp, "yyyy.MM.dd HH:mm:ss", ".");
        }
        if (stamp == null || stamp.trim().equals("")) {
            stamp = null;
        }
        for (i = 0; i < this.core.size(); ++i) {
            if (stamp != null) {
                store.setImageAcquisitionDate(new Timestamp(stamp), i);
            }
            store.setImageName("Series " + i, i);
        }
        if (level != MetadataLevel.MINIMUM) {
            for (i = 0; i < this.core.size(); ++i) {
                Length z;
                Length y;
                Length x;
                store.setImageDescription(this.imageType, i);
                if (this.pixelSizeX != null && (x = FormatTools.getPhysicalSizeX(new Double(this.pixelSizeX), UNITS.MILLIMETER)) != null) {
                    store.setPixelsPhysicalSizeX(x, i);
                }
                if (this.pixelSizeY != null && (y = FormatTools.getPhysicalSizeY(new Double(this.pixelSizeY), UNITS.MILLIMETER)) != null) {
                    store.setPixelsPhysicalSizeY(y, i);
                }
                if (this.pixelSizeZ != null && (z = FormatTools.getPhysicalSizeZ(new Double(this.pixelSizeZ), UNITS.MILLIMETER)) != null) {
                    store.setPixelsPhysicalSizeZ(z, i);
                }
                for (int p = 0; p < this.getImageCount(); ++p) {
                    Length z2;
                    Length y2;
                    Length x2;
                    if (p < this.positionX.size() && this.positionX.get(p) != null && (x2 = new Length(this.positionX.get(p), UNITS.MILLIMETER)) != null) {
                        store.setPlanePositionX(x2, 0, p);
                    }
                    if (p < this.positionY.size() && this.positionY.get(p) != null && (y2 = new Length(this.positionY.get(p), UNITS.MILLIMETER)) != null) {
                        store.setPlanePositionY(y2, 0, p);
                    }
                    if (p >= this.positionZ.size() || this.positionZ.get(p) == null || (z2 = new Length(this.positionZ.get(p), UNITS.MILLIMETER)) == null) continue;
                    store.setPlanePositionZ(z2, 0, p);
                }
            }
        }
    }

    private void addInfo(int tag, String value) throws IOException {
        String oldValue = value;
        String info = this.getHeaderInfo(tag, value);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        if (info != null && tag != -73728) {
            String key;
            if ((info = info.trim()).equals("")) {
                String string = info = oldValue == null ? "" : oldValue.trim();
            }
            if ((key = TYPES.get(tag)) == null) {
                key = this.formatTag(tag);
            }
            if (key.equals("Samples per pixel")) {
                m.sizeC = Integer.parseInt(info);
                if (this.getSizeC() > 1) {
                    m.rgb = true;
                }
            } else if (key.equals("Photometric Interpretation")) {
                if (info.equals("PALETTE COLOR")) {
                    m.indexed = true;
                    m.sizeC = 1;
                    m.rgb = false;
                    this.lut = new byte[3][];
                    this.shortLut = new short[3][];
                } else if (info.startsWith("MONOCHROME")) {
                    this.inverted = info.endsWith("1");
                }
            } else if (key.equals("Acquisition Date")) {
                this.originalDate = info;
            } else if (key.equals("Acquisition Time")) {
                this.originalTime = info;
            } else if (key.equals("Instance Number")) {
                if (info.trim().length() > 0) {
                    this.originalInstance = info;
                }
            } else if (key.equals("Series Number")) {
                try {
                    this.originalSeries = Integer.parseInt(info);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (key.indexOf("Palette Color LUT Data") != -1) {
                String color = key.substring(0, key.indexOf(32)).trim();
                int ndx = color.equals("Red") ? 0 : (color.equals("Green") ? 1 : 2);
                long fp = this.in.getFilePointer();
                this.in.seek(this.in.getFilePointer() - (long)this.elementLength + 1L);
                this.shortLut[ndx] = new short[this.elementLength / 2];
                this.lut[ndx] = new byte[this.elementLength / 2];
                for (int i = 0; i < this.lut[ndx].length; ++i) {
                    this.shortLut[ndx][i] = this.in.readShort();
                    this.lut[ndx][i] = (byte)(this.shortLut[ndx][i] & 0xFF);
                }
                this.in.seek(fp);
            } else if (key.equals("Content Time")) {
                this.time = info;
            } else if (key.equals("Content Date")) {
                this.date = info;
            } else if (key.equals("Image Type")) {
                this.imageType = info;
            } else if (key.equals("Rescale Intercept")) {
                this.rescaleIntercept = Double.parseDouble(info);
            } else if (key.equals("Rescale Slope")) {
                this.rescaleSlope = Double.parseDouble(info);
            } else if (key.equals("Pixel Spacing")) {
                this.pixelSizeY = info.substring(0, info.indexOf("\\"));
                this.pixelSizeX = info.substring(info.lastIndexOf("\\") + 1);
            } else if (key.equals("Spacing Between Slices")) {
                this.pixelSizeZ = new Double(info);
            } else if (tag == 0x200032) {
                String[] positions = info.replace('\\', '_').split("_");
                if (positions.length > 0) {
                    try {
                        this.positionX.add(Double.valueOf(positions[0]));
                    }
                    catch (NumberFormatException e) {
                        this.positionX.add(null);
                    }
                } else {
                    this.positionX.add(null);
                    this.positionY.add(null);
                    this.positionZ.add(null);
                }
                if (positions.length > 1) {
                    try {
                        this.positionY.add(Double.valueOf(positions[1]));
                    }
                    catch (NumberFormatException e) {
                        this.positionY.add(null);
                    }
                } else {
                    this.positionY.add(null);
                    this.positionZ.add(null);
                }
                if (positions.length > 2) {
                    try {
                        this.positionZ.add(Double.valueOf(positions[2]));
                    }
                    catch (NumberFormatException e) {
                        this.positionZ.add(null);
                    }
                } else {
                    this.positionZ.add(null);
                }
            }
            if ((tag & 0xFFFF0000) >> 16 != 32736) {
                key = this.formatTag(tag) + " " + key;
                if (this.metadata.containsKey(key)) {
                    Object v = this.getMetadataValue(key);
                    this.metadata.remove(key);
                    this.addSeriesMetaList(key, v);
                    this.addSeriesMetaList(key, info);
                } else {
                    this.addSeriesMetaList(key, info);
                }
            }
        }
    }

    private void addInfo(int tag, int value) throws IOException {
        this.addInfo(tag, Integer.toString(value));
    }

    private String getHeaderInfo(int tag, String value) throws IOException {
        String id;
        if (tag == -73715 || tag == -73507) {
            this.inSequence = false;
        }
        if ((id = TYPES.get(tag)) != null) {
            if (this.vr == 11565 && id != null) {
                this.vr = (id.charAt(0) << 8) + id.charAt(1);
            }
            if (id.length() > 2) {
                id = id.substring(2);
            }
        }
        if (tag == -73728) {
            return id != null ? id : null;
        }
        if (value != null) {
            return value;
        }
        boolean skip = false;
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                value = this.in.readString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    value = Integer.toString(this.in.readShort());
                    break;
                }
                StringBuilder sb = new StringBuilder();
                int n = this.elementLength / 2;
                for (int i = 0; i < n; ++i) {
                    sb.append(this.in.readShort());
                    sb.append(" ");
                }
                value = sb.toString();
                break;
            }
            case 11565: {
                value = this.in.readString(this.elementLength);
                if (this.elementLength > 4 && this.elementLength <= 44) break;
                value = null;
                break;
            }
            case 21329: {
                boolean privateTag;
                value = "";
                boolean bl = privateTag = (tag >> 16 & 1) != 0;
                if (tag != 0x880200 && !privateTag) break;
                skip = true;
                break;
            }
            default: {
                skip = true;
            }
        }
        if (skip) {
            long skipCount = this.elementLength;
            if (this.in.getFilePointer() + skipCount <= this.in.length()) {
                this.in.skipBytes((int)skipCount);
            }
            this.location += this.elementLength;
            value = "";
        }
        if (value != null && id == null && !value.equals("")) {
            return value;
        }
        if (id == null) {
            return null;
        }
        return value;
    }

    private int getLength(RandomAccessInputStream stream, int tag) throws IOException {
        byte[] b = new byte[4];
        stream.read(b);
        this.vr = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (b[2] == 0 || b[3] == 0) {
                    return stream.readInt();
                }
                this.vr = 11565;
                return DataTools.bytesToInt(b, stream.isLittleEndian());
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                if (tag == 2633734) {
                    return DataTools.bytesToInt(b, 2, 2, stream.isLittleEndian());
                }
                int n1 = DataTools.bytesToShort(b, 2, 2, stream.isLittleEndian());
                int n2 = DataTools.bytesToShort(b, 2, 2, !stream.isLittleEndian());
                n2 &= 0xFFFF;
                if ((n1 &= 0xFFFF) < 0 || (long)n1 + stream.getFilePointer() > stream.length()) {
                    return n2;
                }
                if (n2 < 0 || (long)n2 + stream.getFilePointer() > stream.length()) {
                    return n1;
                }
                return n1;
            }
            case 65535: {
                this.vr = 11565;
                return 8;
            }
        }
        this.vr = 11565;
        int len = DataTools.bytesToInt(b, stream.isLittleEndian());
        if ((long)len + stream.getFilePointer() > stream.length() || len < 0) {
            len = DataTools.bytesToInt(b, 2, 2, stream.isLittleEndian());
            len &= 0xFFFF;
        }
        return len;
    }

    private int getNextTag(RandomAccessInputStream stream) throws FormatException, IOException {
        return this.getNextTag(stream, true);
    }

    private int getNextTag(RandomAccessInputStream stream, boolean setMetadata) throws FormatException, IOException {
        long fp = stream.getFilePointer();
        if (fp >= stream.length() - 2L) {
            return 0;
        }
        int groupWord = stream.readShort() & 0xFFFF;
        if (groupWord == 2048 && this.bigEndianTransferSyntax) {
            if (setMetadata) {
                ((CoreMetadata)this.core.get((int)0)).littleEndian = false;
            }
            groupWord = 8;
            stream.order(false);
        } else if (groupWord == 65279 || groupWord == 65534) {
            stream.skipBytes(6);
            return this.getNextTag(stream, setMetadata);
        }
        short elementWord = stream.readShort();
        int tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
        this.elementLength = this.getLength(stream, tag);
        if ((long)this.elementLength > stream.length()) {
            stream.seek(fp);
            stream.order(!((CoreMetadata)this.core.get((int)0)).littleEndian);
            if (setMetadata) {
                ((CoreMetadata)this.core.get((int)0)).littleEndian = !((CoreMetadata)this.core.get((int)0)).littleEndian;
            }
            groupWord = stream.readShort() & 0xFFFF;
            elementWord = stream.readShort();
            tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
            this.elementLength = this.getLength(stream, tag);
            if ((long)this.elementLength > stream.length()) {
                throw new FormatException("Invalid tag length " + this.elementLength);
            }
            return tag;
        }
        if (this.elementLength < 0 && groupWord == 32736) {
            stream.skipBytes(12);
            this.elementLength = stream.readInt();
            if (this.elementLength < 0) {
                this.elementLength = stream.readInt();
            }
        }
        if (this.elementLength == 0 && (groupWord == 32736 || tag == 2691092)) {
            this.elementLength = this.getLength(stream, tag);
        } else if (this.elementLength == 0) {
            stream.seek(stream.getFilePointer() - 4L);
            String v = stream.readString(2);
            if (v.equals("UT")) {
                stream.skipBytes(2);
                this.elementLength = stream.readInt();
            } else {
                stream.skipBytes(2);
            }
        }
        if (!this.oddLocations && this.elementLength % 2 == 1) {
            ++this.elementLength;
        }
        if (this.elementLength == -1 || tag != 1572896 && TYPES.containsKey(tag) && TYPES.get(tag).endsWith("Sequence")) {
            this.elementLength = 0;
            this.inSequence = true;
        }
        return tag;
    }

    private void makeFileList() throws FormatException, IOException {
        LOGGER.info("Building file list");
        if (this.fileList == null && this.originalInstance != null && this.originalDate != null && this.originalTime != null && this.isGroupFiles()) {
            this.currentId = new Location(this.currentId).getAbsolutePath();
            this.fileList = new HashMap<Integer, List<String>>();
            Integer s = this.originalSeries;
            this.fileList.put(s, new ArrayList());
            int instanceNumber = Integer.parseInt(this.originalInstance) - 1;
            if (instanceNumber == 0) {
                this.fileList.get(s).add(this.currentId);
            } else {
                while (instanceNumber > this.fileList.get(s).size()) {
                    this.fileList.get(s).add(null);
                }
                this.fileList.get(s).add(this.currentId);
            }
            Location currentFile = new Location(this.currentId).getAbsoluteFile();
            Location directory = currentFile.getParentFile();
            directory = directory.getParentFile();
            String[] subdirs = directory.list(true);
            if (subdirs != null) {
                for (String subdir : subdirs) {
                    Location f = new Location(directory, subdir).getAbsoluteFile();
                    if (!f.isDirectory()) continue;
                    this.scanDirectory(f, true);
                }
            }
            for (List list : this.fileList.values()) {
                Iterator fileIterator = list.iterator();
                while (fileIterator.hasNext()) {
                    if (fileIterator.next() != null) continue;
                    fileIterator.remove();
                }
            }
        } else if (this.fileList == null || !this.isGroupFiles()) {
            this.fileList = new HashMap<Integer, List<String>>();
            this.fileList.put(0, new ArrayList());
            this.fileList.get(0).add(this.currentId);
        }
    }

    private void scanDirectory(Location dir, boolean checkSeries) throws FormatException, IOException {
        Location currentFile = new Location(this.currentId).getAbsoluteFile();
        FilePattern pattern = new FilePattern(currentFile.getName(), dir.getAbsolutePath());
        Object[] patternFiles = pattern.getFiles();
        if (patternFiles == null) {
            patternFiles = new String[]{};
        }
        Arrays.sort(patternFiles);
        for (int i = 0; i < patternFiles.length; ++i) {
            patternFiles[i] = new Location((String)patternFiles[i]).getAbsolutePath();
        }
        Object[] files = dir.list(true);
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (Object f : files) {
            String file2 = new Location(dir, (String)f).getAbsolutePath();
            LOGGER.debug("Checking file {}", (Object)file2);
            if (((String)f).equals(this.currentId) || file2.equals(this.currentId) || !this.isThisType(file2) || Arrays.binarySearch(patternFiles, file2) < 0) continue;
            this.addFileToList(file2, checkSeries);
        }
    }

    private void addFileToList(String file2, boolean checkSeries) throws FormatException, IOException {
        short currentX = 0;
        short currentY = 0;
        int fileSeries = -1;
        String date = null;
        String time = null;
        String instance = null;
        try (RandomAccessInputStream stream = new RandomAccessInputStream(file2);){
            long fp;
            if (!this.isThisType(stream)) {
                return;
            }
            stream.order(true);
            stream.seek(128L);
            if (!stream.readString(4).equals(DICOM_MAGIC_STRING)) {
                stream.seek(0L);
            }
            while ((date == null || time == null || instance == null || checkSeries && fileSeries < 0 || currentX == 0 || currentY == 0) && (fp = stream.getFilePointer()) + 4L < stream.length()) {
                if (fp < 0L) {
                    break;
                }
                int tag = this.getNextTag(stream);
                String key = TYPES.get(tag);
                if ("Instance Number".equals(key)) {
                    instance = stream.readString(this.elementLength).trim();
                    if (instance.length() != 0) continue;
                    instance = null;
                    continue;
                }
                if ("Acquisition Time".equals(key)) {
                    time = stream.readString(this.elementLength);
                    continue;
                }
                if ("Acquisition Date".equals(key)) {
                    date = stream.readString(this.elementLength);
                    continue;
                }
                if ("Series Number".equals(key)) {
                    fileSeries = Integer.parseInt(stream.readString(this.elementLength).trim());
                    continue;
                }
                if (tag == 2621456) {
                    short y = stream.readShort();
                    if (y <= currentY) continue;
                    currentY = y;
                    continue;
                }
                if (tag == 2621457) {
                    short x = stream.readShort();
                    if (x <= currentX) continue;
                    currentX = x;
                    continue;
                }
                stream.skipBytes(this.elementLength);
            }
        }
        LOGGER.trace("  date = {}, originalDate = {}", (Object)date, (Object)this.originalDate);
        LOGGER.trace("  time = {}, originalTime = {}", (Object)time, (Object)this.originalTime);
        LOGGER.trace("  instance = {}, originalInstance = {}", (Object)instance, (Object)this.originalInstance);
        LOGGER.trace("  checkSeries = {}", (Object)checkSeries);
        LOGGER.trace("  fileSeries = {}, originalSeries = {}", (Object)fileSeries, (Object)this.originalSeries);
        LOGGER.trace("  currentX = {}, originalX = {}", (Object)currentX, (Object)this.originalX);
        LOGGER.trace("  currentY = {}, originalY = {}", (Object)currentY, (Object)this.originalY);
        if (date == null || time == null || instance == null || checkSeries && fileSeries != this.originalSeries) {
            return;
        }
        if (currentX != this.originalX || currentY != this.originalY) {
            ++fileSeries;
        }
        int stamp = 0;
        try {
            stamp = Integer.parseInt(time);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int timestamp = 0;
        try {
            timestamp = Integer.parseInt(this.originalTime);
        }
        catch (NumberFormatException fp) {
            // empty catch block
        }
        LOGGER.trace("  stamp = {}", (Object)stamp);
        LOGGER.trace("  timestamp = {}", (Object)timestamp);
        if (date.equals(this.originalDate) && Math.abs(stamp - timestamp) < 150) {
            int position = Integer.parseInt(instance) - 1;
            if (position < 0) {
                position = 0;
            }
            if (this.fileList.get(fileSeries) == null) {
                this.fileList.put(fileSeries, new ArrayList());
            }
            if (position < this.fileList.get(fileSeries).size()) {
                while (position < this.fileList.get(fileSeries).size() && this.fileList.get(fileSeries).get(position) != null) {
                    ++position;
                }
                if (position < this.fileList.get(fileSeries).size()) {
                    this.fileList.get(fileSeries).set(position, file2);
                } else if (!this.fileList.get(fileSeries).contains(file2)) {
                    this.fileList.get(fileSeries).add(file2);
                }
            } else if (!this.fileList.get(fileSeries).contains(file2)) {
                while (position > this.fileList.get(fileSeries).size()) {
                    this.fileList.get(fileSeries).add(null);
                }
                this.fileList.get(fileSeries).add(file2);
            }
        }
    }

    private String formatTag(int tag) {
        String s = Integer.toHexString(tag);
        while (s.length() < 8) {
            s = "0" + s;
        }
        return s.substring(0, 4) + "," + s.substring(4);
    }

    private void attachCompanionFiles() throws IOException {
        Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
        Location grandparent = parent.getParentFile();
        if (new Location(grandparent, parent.getName() + ".mif").exists()) {
            String[] list;
            for (String f : list = grandparent.list(true)) {
                Location file2 = new Location(grandparent, f);
                if (file2.isDirectory()) continue;
                this.companionFiles.add(file2.getAbsolutePath());
            }
        }
    }

    private static ImmutableMap<Integer, String> buildTypes() {
        ImmutableMap.Builder<Integer, String> dict = ImmutableMap.builder();
        dict.put(new Integer(131074), "Media Storage SOP Class UID");
        dict.put(new Integer(131075), "Media Storage SOP Instance UID");
        dict.put(new Integer(131088), "Transfer Syntax UID");
        dict.put(new Integer(131090), "Implementation Class UID");
        dict.put(new Integer(131091), "Implementation Version Name");
        dict.put(new Integer(131094), "Source Application Entity Title");
        dict.put(new Integer(524293), "Specific Character Set");
        dict.put(new Integer(524296), "Image Type");
        dict.put(new Integer(524304), "Recognition Code");
        dict.put(new Integer(524306), "Instance Creation Date");
        dict.put(new Integer(524307), "Instance Creation Time");
        dict.put(new Integer(524308), "Instance Creator UID");
        dict.put(new Integer(524310), "SOP Class UID");
        dict.put(new Integer(524312), "SOP Instance UID");
        dict.put(new Integer(524314), "Related General SOP Class UID");
        dict.put(new Integer(524315), "Original Specialized SOP Class UID");
        dict.put(new Integer(524320), "Study Date");
        dict.put(new Integer(524321), "Series Date");
        dict.put(new Integer(524322), "Acquisition Date");
        dict.put(new Integer(524323), "Content Date");
        dict.put(new Integer(524324), "Overlay Date");
        dict.put(new Integer(524325), "Curve Date");
        dict.put(new Integer(524330), "Acquisition Date/Time");
        dict.put(new Integer(524336), "Study Time");
        dict.put(new Integer(524337), "Series Time");
        dict.put(new Integer(524338), "Acquisition Time");
        dict.put(new Integer(524339), "Content Time");
        dict.put(new Integer(524340), "Overlay Time");
        dict.put(new Integer(524341), "Curve Time");
        dict.put(new Integer(524353), "Data Set Subtype");
        dict.put(new Integer(524368), "Accession Number");
        dict.put(new Integer(524370), "Query/Retrieve Level");
        dict.put(new Integer(524372), "Retrieve AE Title");
        dict.put(new Integer(524374), "Instance Availability");
        dict.put(new Integer(524376), "Failed SOP Instance UID List");
        dict.put(new Integer(524384), "Modality");
        dict.put(new Integer(524385), "Modalities in Study");
        dict.put(new Integer(524386), "SOP Classes in Study");
        dict.put(new Integer(524388), "Conversion Type");
        dict.put(new Integer(524392), "Presentation Intent Type");
        dict.put(new Integer(524400), "Manufacturer");
        dict.put(new Integer(524416), "Institution Name");
        dict.put(new Integer(524417), "Institution Address");
        dict.put(new Integer(524418), "Institution Code Sequence");
        dict.put(new Integer(524432), "Referring Physician's Name");
        dict.put(new Integer(524434), "Referring Physician's Address");
        dict.put(new Integer(524436), "Referring Physician's Telephone");
        dict.put(new Integer(524438), "Referring Physician ID");
        dict.put(new Integer(524544), "Code Value");
        dict.put(new Integer(524546), "Coding Scheme Designator");
        dict.put(new Integer(524547), "Coding Scheme Version");
        dict.put(new Integer(524548), "Code Meaning");
        dict.put(new Integer(524549), "Mapping Resource");
        dict.put(new Integer(524550), "Context Group Version");
        dict.put(new Integer(524551), "Context Group Local Version");
        dict.put(new Integer(524555), "Context Group Extension Flag");
        dict.put(new Integer(524556), "Coding Scheme UID");
        dict.put(new Integer(524557), "Context Group Extension Creator UID");
        dict.put(new Integer(524559), "Context ID");
        dict.put(new Integer(524560), "Coding Scheme ID");
        dict.put(new Integer(524562), "Coding Scheme Registry");
        dict.put(new Integer(524564), "Coding Scheme External ID");
        dict.put(new Integer(524565), "Coding Scheme Name");
        dict.put(new Integer(524566), "Responsible Organization");
        dict.put(new Integer(524801), "Timezone Offset from UTC");
        dict.put(new Integer(528400), "Station Name");
        dict.put(new Integer(528432), "Study Description");
        dict.put(new Integer(528434), "Procedure Code Sequence");
        dict.put(new Integer(528446), "Series Description");
        dict.put(new Integer(528448), "Institutional Department Name");
        dict.put(new Integer(528456), "Physician(s) of Record");
        dict.put(new Integer(528457), "Physician(s) of Record ID");
        dict.put(new Integer(528464), "Performing Physician's Name");
        dict.put(new Integer(528466), "Performing Physican ID");
        dict.put(new Integer(528480), "Name of Physician(s) Reading Study");
        dict.put(new Integer(528482), "Physician(s) Reading Study ID");
        dict.put(new Integer(528496), "Operator's Name");
        dict.put(new Integer(528498), "Operator ID");
        dict.put(new Integer(528512), "Admitting Diagnoses Description");
        dict.put(new Integer(528516), "Admitting Diagnoses Code Sequence");
        dict.put(new Integer(528528), "Manufacturer's Model Name");
        dict.put(new Integer(528640), "Referenced Results Sequence");
        dict.put(new Integer(528656), "Referenced Study Sequence");
        dict.put(new Integer(528657), "Referenced Performed Procedure Step");
        dict.put(new Integer(528661), "Referenced Series Sequence");
        dict.put(new Integer(528672), "Referenced Patient Sequence");
        dict.put(new Integer(528677), "Referenced Visit Sequence");
        dict.put(new Integer(528688), "Referenced Overlay Sequence");
        dict.put(new Integer(528698), "Referenced Waveform Sequence");
        dict.put(new Integer(528704), "Referenced Image Sequence");
        dict.put(new Integer(528709), "Referenced Curve Sequence");
        dict.put(new Integer(528714), "Referenced Instance Sequence");
        dict.put(new Integer(528720), "Referenced SOP Class UID");
        dict.put(new Integer(528725), "Referenced SOP Instance UID");
        dict.put(new Integer(528730), "SOP Classes Supported");
        dict.put(new Integer(528736), "Referenced Frame Number");
        dict.put(new Integer(528789), "Transaction UID");
        dict.put(new Integer(528791), "Failure Reason");
        dict.put(new Integer(528792), "Failed SOP Sequence");
        dict.put(new Integer(528793), "Referenced SOP Sequence");
        dict.put(new Integer(528896), "Studies Containing Other Referenced Instances Sequence");
        dict.put(new Integer(528976), "Related Series Sequence");
        dict.put(new Integer(532753), "Derivation Description");
        dict.put(new Integer(532754), "Source Image Sequence");
        dict.put(new Integer(532768), "Stage Name");
        dict.put(new Integer(532770), "Stage Number");
        dict.put(new Integer(532772), "Number of Stages");
        dict.put(new Integer(532775), "View Name");
        dict.put(new Integer(532776), "View Number");
        dict.put(new Integer(532777), "Number of Event Timers");
        dict.put(new Integer(532778), "Number of Views in Stage");
        dict.put(new Integer(532784), "Event Elapsed Time(s)");
        dict.put(new Integer(532786), "Event Timer Name(s)");
        dict.put(new Integer(532802), "Start Trim");
        dict.put(new Integer(532803), "Stop Trim");
        dict.put(new Integer(532804), "Recommended Display Frame Rate");
        dict.put(new Integer(533016), "Anatomic Region Sequence");
        dict.put(new Integer(533024), "Anatomic Region Modifier Sequence");
        dict.put(new Integer(533032), "Primary Anatomic Structure Sequence");
        dict.put(new Integer(533033), "Anatomic Structure Sequence");
        dict.put(new Integer(533040), "Primary Anatomic Structure Modifier");
        dict.put(new Integer(533056), "Transducer Position Sequence");
        dict.put(new Integer(533058), "Transducer Position Modifier Sequence");
        dict.put(new Integer(533060), "Transducer Orientation Sequence");
        dict.put(new Integer(533062), "Transducer Orientation Modifier");
        dict.put(new Integer(536577), "Alternate Representation Sequence");
        dict.put(new Integer(561159), "Frame Type");
        dict.put(new Integer(561298), "Referenced Image Evidence Sequence");
        dict.put(new Integer(561441), "Referenced Raw Data Sequence");
        dict.put(new Integer(561443), "Creator-Version UID");
        dict.put(new Integer(561444), "Derivation Image Sequence");
        dict.put(new Integer(561492), "Source Image Evidence Sequence");
        dict.put(new Integer(561669), "Pixel Representation");
        dict.put(new Integer(561670), "Volumetric Properties");
        dict.put(new Integer(561671), "Volume Based Calculation Technique");
        dict.put(new Integer(561672), "Complex Image Component");
        dict.put(new Integer(561673), "Acquisition Contrast");
        dict.put(new Integer(561685), "Derivation Code Sequence");
        dict.put(new Integer(561719), "Reference Grayscale Presentation State");
        dict.put(new Integer(0x100010), "Patient's Name");
        dict.put(new Integer(0x100020), "Patient ID");
        dict.put(new Integer(0x100021), "Issuer of Patient ID");
        dict.put(new Integer(0x100030), "Patient's Birth Date");
        dict.put(new Integer(1048626), "Patient's Birth Time");
        dict.put(new Integer(0x100040), "Patient's Sex");
        dict.put(new Integer(0x100050), "Patient's Insurance Plane Code");
        dict.put(new Integer(0x100101), "Patient's Primary Language Code");
        dict.put(new Integer(0x100102), "Patient's Primary Language Modifier");
        dict.put(new Integer(0x101000), "Other Patient IDs");
        dict.put(new Integer(0x101001), "Other Patient Names");
        dict.put(new Integer(0x101005), "Patient's Birth Name");
        dict.put(new Integer(0x101010), "Patient's Age");
        dict.put(new Integer(0x101020), "Patient's Size");
        dict.put(new Integer(0x101030), "Patient's Weight");
        dict.put(new Integer(0x101040), "Patient's Address");
        dict.put(new Integer(0x101060), "Patient's Mother's Birth Name");
        dict.put(new Integer(0x101080), "Military Rank");
        dict.put(new Integer(0x101081), "Branch of Service");
        dict.put(new Integer(0x101090), "Medical Record Locator");
        dict.put(new Integer(0x102000), "Medical Alerts");
        dict.put(new Integer(0x102110), "Contrast Allergies");
        dict.put(new Integer(1057104), "Country of Residence");
        dict.put(new Integer(1057106), "Region of Residence");
        dict.put(new Integer(1057108), "Patient's Telephone Numbers");
        dict.put(new Integer(1057120), "Ethnic Group");
        dict.put(new Integer(1057152), "Occupation");
        dict.put(new Integer(1057184), "Smoking Status");
        dict.put(new Integer(1057200), "Additional Patient History");
        dict.put(new Integer(1057216), "Pregnancy Status");
        dict.put(new Integer(1057232), "Last Menstrual Date");
        dict.put(new Integer(1057264), "Patient's Religious Preference");
        dict.put(new Integer(0x104000), "Patient Comments");
        dict.put(new Integer(0x120010), "Clinical Trial Sponsor Name");
        dict.put(new Integer(0x120020), "Clinical Trial Protocol ID");
        dict.put(new Integer(0x120021), "Clinical Trial Protocol Name");
        dict.put(new Integer(1179696), "Clinical Trial Site ID");
        dict.put(new Integer(1179697), "Clinical Trial Site Name");
        dict.put(new Integer(1179712), "Clinical Trial Subject ID");
        dict.put(new Integer(1179714), "Clinical Trial Subject Reading ID");
        dict.put(new Integer(1179728), "Clinical Trial Time Point ID");
        dict.put(new Integer(1179729), "Clinical Trial Time Point Description");
        dict.put(new Integer(1179744), "Clinical Trial Coordinating Center");
        dict.put(new Integer(0x180010), "Contrast/Bolus Agent");
        dict.put(new Integer(1572882), "Contrast/Bolus Agent Sequence");
        dict.put(new Integer(1572884), "Contrast/Bolus Admin. Route Sequence");
        dict.put(new Integer(1572885), "Body Part Examined");
        dict.put(new Integer(1572896), "Scanning Sequence");
        dict.put(new Integer(1572897), "Sequence Variant");
        dict.put(new Integer(1572898), "Scan Options");
        dict.put(new Integer(1572899), "MR Acquisition Type");
        dict.put(new Integer(1572900), "Sequence Name");
        dict.put(new Integer(1572901), "Angio Flag");
        dict.put(new Integer(1572902), "Intervention Drug Information Sequence");
        dict.put(new Integer(1572903), "Intervention Drug Stop Time");
        dict.put(new Integer(1572904), "Intervention Drug Dose");
        dict.put(new Integer(1572905), "Intervention Drug Sequence");
        dict.put(new Integer(1572906), "Additional Drug Sequence");
        dict.put(new Integer(1572913), "Radiopharmaceutical");
        dict.put(new Integer(1572916), "Intervention Drug Name");
        dict.put(new Integer(1572917), "Intervention Drug Start Time");
        dict.put(new Integer(1572918), "Intervention Sequence");
        dict.put(new Integer(1572920), "Intervention Status");
        dict.put(new Integer(1572922), "Intervention Description");
        dict.put(new Integer(1572928), "Cine Rate");
        dict.put(new Integer(1572944), "Slice Thickness");
        dict.put(new Integer(1572960), "KVP");
        dict.put(new Integer(1572976), "Counts Accumulated");
        dict.put(new Integer(1572977), "Acquisition Termination Condition");
        dict.put(new Integer(1572978), "Effective Duration");
        dict.put(new Integer(1572979), "Acquisition Start Condition");
        dict.put(new Integer(1572980), "Acquisition Start Condition Data");
        dict.put(new Integer(1572981), "Acquisition Termination Condition Data");
        dict.put(new Integer(0x180080), "Repetition Time");
        dict.put(new Integer(0x180081), "Echo Time");
        dict.put(new Integer(1572994), "Inversion Time");
        dict.put(new Integer(1572995), "Number of Averages");
        dict.put(new Integer(1572996), "Imaging Frequency");
        dict.put(new Integer(1572997), "Imaged Nucleus");
        dict.put(new Integer(1572998), "Echo Number(s)");
        dict.put(new Integer(1572999), "Magnetic Field Strength");
        dict.put(new Integer(0x180088), "Spacing Between Slices");
        dict.put(new Integer(1573001), "Number of Phase Encoding Steps");
        dict.put(new Integer(1573008), "Data Collection Diameter");
        dict.put(new Integer(1573009), "Echo Train Length");
        dict.put(new Integer(1573011), "Percent Sampling");
        dict.put(new Integer(1573012), "Percent Phase Field of View");
        dict.put(new Integer(1573013), "Pixel Bandwidth");
        dict.put(new Integer(0x181000), "Device Serial Number");
        dict.put(new Integer(1576964), "Plate ID");
        dict.put(new Integer(0x181010), "Secondary Capture Device ID");
        dict.put(new Integer(0x181011), "Hardcopy Creation Device ID");
        dict.put(new Integer(1576978), "Date of Secondary Capture");
        dict.put(new Integer(1576980), "Time of Secondary Capture");
        dict.put(new Integer(1576982), "Secondary Capture Device Manufacturer");
        dict.put(new Integer(1576983), "Hardcopy Device Manufacturer");
        dict.put(new Integer(0x181018), "Secondary Capture Device Model Name");
        dict.put(new Integer(1576985), "Secondary Capture Device Software Version");
        dict.put(new Integer(1576986), "Hardcopy Device Software Version");
        dict.put(new Integer(1576987), "Hardcopy Device Model Name");
        dict.put(new Integer(1576992), "Software Version(s)");
        dict.put(new Integer(1576994), "Video Image Format Acquired");
        dict.put(new Integer(1576995), "Digital Image Format Acquired");
        dict.put(new Integer(1577008), "Protocol Name");
        dict.put(new Integer(1577024), "Contrast/Bolus Route");
        dict.put(new Integer(1577025), "Contrast/Bolus Volume");
        dict.put(new Integer(1577026), "Contrast/Bolus Start Time");
        dict.put(new Integer(1577027), "Contrast/Bolus Stop Time");
        dict.put(new Integer(1577028), "Contrast/Bolus Total Dose");
        dict.put(new Integer(1577029), "Syringe Counts");
        dict.put(new Integer(1577030), "Contrast Flow Rate");
        dict.put(new Integer(1577031), "Contrast Flow Duration");
        dict.put(new Integer(1577032), "Contrast/Bolus Ingredient");
        dict.put(new Integer(1577033), "Contrast Ingredient Concentration");
        dict.put(new Integer(1577040), "Spatial Resolution");
        dict.put(new Integer(1577056), "Trigger Time");
        dict.put(new Integer(1577057), "Trigger Source or Type");
        dict.put(new Integer(1577058), "Nominal Interval");
        dict.put(new Integer(1577059), "Frame Time");
        dict.put(new Integer(1577060), "Framing Type");
        dict.put(new Integer(1577061), "Frame Time Vector");
        dict.put(new Integer(1577062), "Frame Delay");
        dict.put(new Integer(1577063), "Image Trigger Delay");
        dict.put(new Integer(1577064), "Multiplex Group Time Offset");
        dict.put(new Integer(1577065), "Trigger Time Offset");
        dict.put(new Integer(1577066), "Synchronization Trigger");
        dict.put(new Integer(1577068), "Synchronization Channel");
        dict.put(new Integer(1577070), "Trigger Sample Position");
        dict.put(new Integer(1577072), "Radiopharmaceutical Route");
        dict.put(new Integer(1577073), "Radiopharmaceutical Volume");
        dict.put(new Integer(1577074), "Radiopharmaceutical Start Time");
        dict.put(new Integer(1577075), "Radiopharmaceutical Stop Time");
        dict.put(new Integer(1577076), "Radionuclide Total Dose");
        dict.put(new Integer(1577077), "Radionuclide Half Life");
        dict.put(new Integer(1577078), "Radionuclide Positron Fraction");
        dict.put(new Integer(1577079), "Radiopharmaceutical Specific Activity");
        dict.put(new Integer(0x181080), "Beat Rejection Flag");
        dict.put(new Integer(0x181081), "Low R-R Value");
        dict.put(new Integer(1577090), "High R-R Value");
        dict.put(new Integer(1577091), "Intervals Acquired");
        dict.put(new Integer(1577092), "Intervals Rejected");
        dict.put(new Integer(1577093), "PVC Rejection");
        dict.put(new Integer(1577094), "Skip Beats");
        dict.put(new Integer(0x181088), "Heart Rate");
        dict.put(new Integer(1577104), "Cardiac Number of Images");
        dict.put(new Integer(1577108), "Trigger Window");
        dict.put(new Integer(0x181100), "Reconstruction Diameter");
        dict.put(new Integer(0x181110), "Distance Source to Detector");
        dict.put(new Integer(0x181111), "Distance Source to Patient");
        dict.put(new Integer(0x181114), "Estimated Radiographic Mag. Factor");
        dict.put(new Integer(1577248), "Gantry/Detector Tilt");
        dict.put(new Integer(0x181121), "Gantry/Detector Skew");
        dict.put(new Integer(1577264), "Table Height");
        dict.put(new Integer(0x181131), "Table Traverse");
        dict.put(new Integer(1577268), "Table Motion");
        dict.put(new Integer(1577269), "Table Vertical Increment");
        dict.put(new Integer(1577270), "Table Lateral Increment");
        dict.put(new Integer(1577271), "Table Longitudinal Increment");
        dict.put(new Integer(0x181138), "Table Angle");
        dict.put(new Integer(1577274), "Table Type");
        dict.put(new Integer(1577280), "Rotation Direction");
        dict.put(new Integer(0x181141), "Angular Position");
        dict.put(new Integer(1577282), "Radial Position");
        dict.put(new Integer(1577283), "Scan Arc");
        dict.put(new Integer(0x181144), "Angular Step");
        dict.put(new Integer(1577285), "Center of Rotation Offset");
        dict.put(new Integer(1577287), "Field of View Shape");
        dict.put(new Integer(1577289), "Field of View Dimension(s)");
        dict.put(new Integer(1577296), "Exposure Time");
        dict.put(new Integer(0x181151), "X-ray Tube Current");
        dict.put(new Integer(1577298), "Exposure");
        dict.put(new Integer(1577299), "Exposure in uAs");
        dict.put(new Integer(1577300), "Average Pulse Width");
        dict.put(new Integer(0x181155), "Radiation Setting");
        dict.put(new Integer(1577302), "Rectification Type");
        dict.put(new Integer(1577306), "Radiation Mode");
        dict.put(new Integer(1577310), "Image Area Dose Product");
        dict.put(new Integer(1577312), "Filter Type");
        dict.put(new Integer(0x181161), "Type of Filters");
        dict.put(new Integer(1577314), "Intensifier Size");
        dict.put(new Integer(1577316), "Imager Pixel Spacing");
        dict.put(new Integer(0x181166), "Grid");
        dict.put(new Integer(1577328), "Generator Power");
        dict.put(new Integer(0x181180), "Collimator/Grid Name");
        dict.put(new Integer(0x181181), "Collimator Type");
        dict.put(new Integer(0x181182), "Focal Distance");
        dict.put(new Integer(0x181183), "X Focus Center");
        dict.put(new Integer(0x181184), "Y Focus Center");
        dict.put(new Integer(1577360), "Focal Spot(s)");
        dict.put(new Integer(0x181191), "Anode Target Material");
        dict.put(new Integer(1577376), "Body Part Thickness");
        dict.put(new Integer(1577378), "Compression Force");
        dict.put(new Integer(1577472), "Date of Last Calibration");
        dict.put(new Integer(1577473), "Time of Last Calibration");
        dict.put(new Integer(1577488), "Convolution Kernel");
        dict.put(new Integer(1577538), "Actual Frame Duration");
        dict.put(new Integer(1577539), "Count Rate");
        dict.put(new Integer(1577540), "Preferred Playback Sequencing");
        dict.put(new Integer(1577552), "Receive Coil Name");
        dict.put(new Integer(1577553), "Transmit Coil Name");
        dict.put(new Integer(1577568), "Plate Type");
        dict.put(new Integer(1577569), "Phosphor Type");
        dict.put(new Integer(1577728), "Scan Velocity");
        dict.put(new Integer(1577729), "Whole Body Technique");
        dict.put(new Integer(1577730), "Scan Length");
        dict.put(new Integer(1577744), "Acquisition Matrix");
        dict.put(new Integer(1577746), "In-plane Phase Encoding Direction");
        dict.put(new Integer(1577748), "Flip Angle");
        dict.put(new Integer(1577749), "Variable Flip Angle Flag");
        dict.put(new Integer(1577750), "SAR");
        dict.put(new Integer(0x181318), "dB/dt");
        dict.put(new Integer(1577984), "Acquisition Device Processing Descr.");
        dict.put(new Integer(1577985), "Acquisition Device Processing Code");
        dict.put(new Integer(1577986), "Cassette Orientation");
        dict.put(new Integer(1577987), "Cassette Size");
        dict.put(new Integer(1577988), "Exposures on Plate");
        dict.put(new Integer(1577989), "Relative X-ray Exposure");
        dict.put(new Integer(1578064), "Column Angulation");
        dict.put(new Integer(1578080), "Tomo Layer Height");
        dict.put(new Integer(1578096), "Tomo Angle");
        dict.put(new Integer(1578112), "Tomo Time");
        dict.put(new Integer(1578128), "Tomo Type");
        dict.put(new Integer(1578129), "Tomo Class");
        dict.put(new Integer(1578133), "Number of Tomosynthesis Source Images");
        dict.put(new Integer(1578240), "Positioner Motion");
        dict.put(new Integer(1578248), "Positioner Type");
        dict.put(new Integer(1578256), "Positioner Primary Angle");
        dict.put(new Integer(0x181511), "Positioner Secondary Angle");
        dict.put(new Integer(1578272), "Positioner Primary Angle Increment");
        dict.put(new Integer(1578273), "Positioner Secondary Angle Increment");
        dict.put(new Integer(1578288), "Detector Primary Angle");
        dict.put(new Integer(1578289), "Detector Secondary Angle");
        dict.put(new Integer(1578496), "Shutter Shape");
        dict.put(new Integer(1578498), "Shutter Left Vertical Edge");
        dict.put(new Integer(1578500), "Shutter Right Vertical Edge");
        dict.put(new Integer(1578502), "Shutter Upper Horizontal Edge");
        dict.put(new Integer(1578504), "Shutter Lower Horizontal Edge");
        dict.put(new Integer(1578512), "Center of Circular Shutter");
        dict.put(new Integer(1578514), "Radius of Circular Shutter");
        dict.put(new Integer(1578528), "Vertices of the Polygonal Shutter");
        dict.put(new Integer(1578530), "Shutter Presentation Value");
        dict.put(new Integer(1578531), "Shutter Overlay Group");
        dict.put(new Integer(1578752), "Collimator Shape");
        dict.put(new Integer(1578754), "Collimator Left Vertical Edge");
        dict.put(new Integer(1578756), "Collimator Right Vertical Edge");
        dict.put(new Integer(1578758), "Collimator Upper Horizontal Edge");
        dict.put(new Integer(1578760), "Collimator Lower Horizontal Edge");
        dict.put(new Integer(1578768), "Center of Circular Collimator");
        dict.put(new Integer(1578770), "Radius of Circular Collimator");
        dict.put(new Integer(1578784), "Vertices of the polygonal Collimator");
        dict.put(new Integer(0x181800), "Acquisition Time Synchronized");
        dict.put(new Integer(0x181801), "Time Source");
        dict.put(new Integer(1579010), "Time Distribution Protocol");
        dict.put(new Integer(1579011), "NTP Source Address");
        dict.put(new Integer(1581057), "Page Number Vector");
        dict.put(new Integer(1581058), "Frame Label Vector");
        dict.put(new Integer(1581059), "Frame Primary Angle Vector");
        dict.put(new Integer(1581060), "Frame Secondary Angle Vector");
        dict.put(new Integer(1581061), "Slice Location Vector");
        dict.put(new Integer(1581062), "Display Window Label Vector");
        dict.put(new Integer(1581072), "Nominal Scanned Pixel Spacing");
        dict.put(new Integer(1581088), "Digitizing Device Transport Direction");
        dict.put(new Integer(1581104), "Rotation of Scanned Film");
        dict.put(new Integer(1585408), "IVUS Acquisition");
        dict.put(new Integer(1585409), "IVUS Pullback Rate");
        dict.put(new Integer(1585410), "IVUS Gated Rate");
        dict.put(new Integer(1585411), "IVUS Pullback Start Frame Number");
        dict.put(new Integer(1585412), "IVUS Pullback Stop Frame Number");
        dict.put(new Integer(1585413), "Lesion Number");
        dict.put(new Integer(1593344), "Output Power");
        dict.put(new Integer(1593360), "Transducer Data");
        dict.put(new Integer(1593362), "Focus Depth");
        dict.put(new Integer(1593376), "Processing Function");
        dict.put(new Integer(1593377), "Postprocessing Fuction");
        dict.put(new Integer(1593378), "Mechanical Index");
        dict.put(new Integer(1593380), "Bone Thermal Index");
        dict.put(new Integer(1593382), "Cranial Thermal Index");
        dict.put(new Integer(1593383), "Soft Tissue Thermal Index");
        dict.put(new Integer(1593384), "Soft Tissue-focus Thermal Index");
        dict.put(new Integer(1593385), "Soft Tissue-surface Thermal Index");
        dict.put(new Integer(1593424), "Depth of scan field");
        dict.put(new Integer(1593600), "Patient Position");
        dict.put(new Integer(1593601), "View Position");
        dict.put(new Integer(1593604), "Projection Eponymous Name Code");
        dict.put(new Integer(1597440), "Sensitivity");
        dict.put(new Integer(1597457), "Sequence of Ultrasound Regions");
        dict.put(new Integer(1597458), "Region Spatial Format");
        dict.put(new Integer(1597460), "Region Data Type");
        dict.put(new Integer(1597462), "Region Flags");
        dict.put(new Integer(1597464), "Region Location Min X0");
        dict.put(new Integer(1597466), "Region Location Min Y0");
        dict.put(new Integer(1597468), "Region Location Max X1");
        dict.put(new Integer(1597470), "Region Location Max Y1");
        dict.put(new Integer(1597472), "Reference Pixel X0");
        dict.put(new Integer(1597474), "Reference Pixel Y0");
        dict.put(new Integer(1597476), "Physical Units X Direction");
        dict.put(new Integer(1597478), "Physical Units Y Direction");
        dict.put(new Integer(1597480), "Reference Pixel Physical Value X");
        dict.put(new Integer(1597482), "Reference Pixel Physical Value Y");
        dict.put(new Integer(1597484), "Physical Delta X");
        dict.put(new Integer(1597486), "Physical Delta Y");
        dict.put(new Integer(1597488), "Transducer Frequency");
        dict.put(new Integer(1597489), "Transducer Type");
        dict.put(new Integer(1597490), "Pulse Repetition Frequency");
        dict.put(new Integer(1597492), "Doppler Correction Angle");
        dict.put(new Integer(1597494), "Steering Angle");
        dict.put(new Integer(1597497), "Doppler Sample Volume X Position");
        dict.put(new Integer(1597499), "Doppler Sample Volume Y Position");
        dict.put(new Integer(1597501), "TM-Line Position X0");
        dict.put(new Integer(1597503), "TM-Line Position Y0");
        dict.put(new Integer(1597505), "TM-Line Position X1");
        dict.put(new Integer(1597507), "TM-Line Position Y1");
        dict.put(new Integer(1597508), "Pixel Component Organization");
        dict.put(new Integer(1597510), "Pixel Component Mask");
        dict.put(new Integer(1597512), "Pixel Component Range Start");
        dict.put(new Integer(1597514), "Pixel Component Range Stop");
        dict.put(new Integer(1597516), "Pixel Component Physical Units");
        dict.put(new Integer(1597518), "Pixel Component Data Type");
        dict.put(new Integer(1597520), "Number of Table Break Points");
        dict.put(new Integer(1597522), "Table of X Break Points");
        dict.put(new Integer(1597524), "Table of Y Break Points");
        dict.put(new Integer(1597526), "Number of Table Entries");
        dict.put(new Integer(1597528), "Table of Pixel Values");
        dict.put(new Integer(1597530), "Table of Parameter Values");
        dict.put(new Integer(1597536), "R Wave Time Vector");
        dict.put(new Integer(1601536), "Detector Conditions Nominal Flag");
        dict.put(new Integer(1601537), "Detector Temperature");
        dict.put(new Integer(1601540), "Detector Type");
        dict.put(new Integer(1601541), "Detector Configuration");
        dict.put(new Integer(1601542), "Detector Description");
        dict.put(new Integer(1601544), "Detector Mode");
        dict.put(new Integer(1601546), "Detector ID");
        dict.put(new Integer(1601548), "Date of Last Detector Calibration");
        dict.put(new Integer(1601550), "Time of Last Detector Calibration");
        dict.put(new Integer(1601554), "Detector Time Since Last Exposure");
        dict.put(new Integer(1601556), "Detector Active Time");
        dict.put(new Integer(1601558), "Detector Activation Offset");
        dict.put(new Integer(1601562), "Detector Binning");
        dict.put(new Integer(1601568), "Detector Element Physical Size");
        dict.put(new Integer(1601570), "Detector Element Spacing");
        dict.put(new Integer(1601572), "Detector Active Shape");
        dict.put(new Integer(1601574), "Detector Active Dimension(s)");
        dict.put(new Integer(1601576), "Detector Active Origin");
        dict.put(new Integer(1601578), "Detector Manufacturer Name");
        dict.put(new Integer(1601579), "Detector Model Name");
        dict.put(new Integer(1601584), "Field of View Origin");
        dict.put(new Integer(1601586), "Field of View Rotation");
        dict.put(new Integer(1601588), "Field of View Horizontal Flip");
        dict.put(new Integer(1601600), "Grid Absorbing Material");
        dict.put(new Integer(1601601), "Grid Spacing Material");
        dict.put(new Integer(1601602), "Grid Thickness");
        dict.put(new Integer(1601604), "Grid Pitch");
        dict.put(new Integer(1601606), "Grid Aspect Ratio");
        dict.put(new Integer(1601608), "Grid Period");
        dict.put(new Integer(1601612), "Grid Focal Distance");
        dict.put(new Integer(1601616), "Filter Material");
        dict.put(new Integer(1601618), "Filter Thickness Min");
        dict.put(new Integer(1601620), "Filter Thickness Max");
        dict.put(new Integer(1601632), "Exposure Control Mode");
        dict.put(new Integer(0x20000D), "Study Instance UID");
        dict.put(new Integer(0x20000E), "Series Instance UID");
        dict.put(new Integer(0x200011), "Series Number");
        dict.put(new Integer(0x200012), "Acquisition Number");
        dict.put(new Integer(2097171), "Instance Number");
        dict.put(new Integer(0x200020), "Patient Orientation");
        dict.put(new Integer(0x200030), "Image Position");
        dict.put(new Integer(0x200032), "Image Position (Patient)");
        dict.put(new Integer(2097207), "Image Orientation (Patient)");
        dict.put(new Integer(0x200050), "Location");
        dict.put(new Integer(0x200052), "Frame of Reference UID");
        dict.put(new Integer(0x200070), "Image Geometry Type");
        dict.put(new Integer(0x201001), "Acquisitions in Series");
        dict.put(new Integer(0x201020), "Reference");
        dict.put(new Integer(2101313), "Slice Location");
        dict.put(new Integer(0x280002), "Samples per pixel");
        dict.put(new Integer(2621443), "Samples per pixel used");
        dict.put(new Integer(2621444), "Photometric Interpretation");
        dict.put(new Integer(2621446), "Planar Configuration");
        dict.put(new Integer(0x280008), "Number of frames");
        dict.put(new Integer(2621449), "Frame Increment Pointer");
        dict.put(new Integer(2621450), "Frame Dimension Pointer");
        dict.put(new Integer(2621456), "Rows");
        dict.put(new Integer(2621457), "Columns");
        dict.put(new Integer(2621458), "Planes");
        dict.put(new Integer(2621460), "Ultrasound Color Data Present");
        dict.put(new Integer(2621488), "Pixel Spacing");
        dict.put(new Integer(2621489), "Zoom Factor");
        dict.put(new Integer(2621490), "Zoom Center");
        dict.put(new Integer(2621492), "Pixel Aspect Ratio");
        dict.put(new Integer(2621521), "Corrected Image");
        dict.put(new Integer(2621696), "Bits Allocated");
        dict.put(new Integer(2621697), "Bits Stored");
        dict.put(new Integer(2621698), "High Bit");
        dict.put(new Integer(2621699), "Pixel Representation");
        dict.put(new Integer(2621702), "Smallest Image Pixel Value");
        dict.put(new Integer(2621703), "Largest Image Pixel Value");
        dict.put(new Integer(2621704), "Smallest Pixel Value in Series");
        dict.put(new Integer(2621705), "Largest Pixel Value in Series");
        dict.put(new Integer(2621712), "Smallest Image Pixel Value in Plane");
        dict.put(new Integer(2621713), "Largest Image Pixel Value in Plane");
        dict.put(new Integer(2621728), "Pixel Padding Value");
        dict.put(new Integer(2622208), "Quality Control Image");
        dict.put(new Integer(2622209), "Burned in Annotation");
        dict.put(new Integer(2625600), "Pixel Intensity Relationship");
        dict.put(new Integer(2625601), "Pixel Intensity Relationship Sign");
        dict.put(new Integer(2625616), "Window Center");
        dict.put(new Integer(2625617), "Window Width");
        dict.put(new Integer(2625618), "Rescale Intercept");
        dict.put(new Integer(2625619), "Rescale Slope");
        dict.put(new Integer(2625620), "Rescale Type");
        dict.put(new Integer(2625621), "Window Center and Width Explanation");
        dict.put(new Integer(2625680), "Recommended Viewing Mode");
        dict.put(new Integer(2625793), "Red Palette Color LUT Descriptor");
        dict.put(new Integer(2625794), "Green Palette Color LUT Descriptor");
        dict.put(new Integer(2625795), "Blue Palette Color LUT Descriptor");
        dict.put(new Integer(2625945), "Palette Color LUT UID");
        dict.put(new Integer(2626049), "Red Palette Color LUT Data");
        dict.put(new Integer(2626050), "Green Palette Color LUT Data");
        dict.put(new Integer(2626051), "Blue Palette Color LUT Data");
        dict.put(new Integer(0x281221), "Segmented Red Palette Color LUT Data");
        dict.put(new Integer(0x281222), "Segmented Green Palette Color LUT Data");
        dict.put(new Integer(2626083), "Segmented Blue Palette Color LUT Data");
        dict.put(new Integer(2626304), "Implant Present");
        dict.put(new Integer(2626384), "Partial View");
        dict.put(new Integer(2626385), "Partial View Description");
        dict.put(new Integer(2629904), "Lossy Image Compression");
        dict.put(new Integer(0x282112), "Lossy Image Compression Ratio");
        dict.put(new Integer(2629908), "Lossy Image Compression Method");
        dict.put(new Integer(2633728), "Modality LUT Sequence");
        dict.put(new Integer(2633730), "LUT Descriptor");
        dict.put(new Integer(2633731), "LUT Explanation");
        dict.put(new Integer(2633732), "Modality LUT Type");
        dict.put(new Integer(2633734), "LUT Data");
        dict.put(new Integer(2633744), "VOI LUT Sequence");
        dict.put(new Integer(2634000), "Softcopy VOI LUT Sequence");
        dict.put(new Integer(2641920), "Bi-Plane Acquisition Sequence");
        dict.put(new Integer(2646032), "Representative Frame Number");
        dict.put(new Integer(2646048), "Frame Numbers of Interest (FOI)");
        dict.put(new Integer(2646050), "Frame(s) of Interest Description");
        dict.put(new Integer(2646051), "Frame of Interest Type");
        dict.put(new Integer(2646080), "R Wave Pointer");
        dict.put(new Integer(2646272), "Mask Subtraction Sequence");
        dict.put(new Integer(2646273), "Mask Operation");
        dict.put(new Integer(2646274), "Applicable Frame Range");
        dict.put(new Integer(2646288), "Mask Frame Numbers");
        dict.put(new Integer(2646290), "Contrast Frame Averaging");
        dict.put(new Integer(2646292), "Mask Sub-pixel Shift");
        dict.put(new Integer(2646304), "TID Offset");
        dict.put(new Integer(2646416), "Mask Operation Explanation");
        dict.put(new Integer(2658305), "Data Point Rows");
        dict.put(new Integer(2658306), "Data Point Columns");
        dict.put(new Integer(2658307), "Signal Domain Columns");
        dict.put(new Integer(2658568), "Data Representation");
        dict.put(new Integer(2658576), "Pixel Measures Sequence");
        dict.put(new Integer(2658610), "Frame VOI LUT Sequence");
        dict.put(new Integer(2658629), "Pixel Value Transformation Sequence");
        dict.put(new Integer(2658869), "Signal Domain Rows");
        dict.put(new Integer(5505041), "Number of Energy Windows");
        dict.put(new Integer(5505057), "Number of Detectors");
        dict.put(new Integer(5505105), "Number of Rotations");
        dict.put(new Integer(5505152), "Slice Vector");
        dict.put(new Integer(5505153), "Number of Slices");
        dict.put(new Integer(5505538), "Type of Detector Motion");
        dict.put(new Integer(0x540400), "Image ID");
        dict.put(new Integer(0x20100100), "Border Density");
        return dict.build();
    }
}

