/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;

public class JPKReader
extends BaseTiffReader {
    public JPKReader() {
        super("JPK Instruments", "jpk");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
        this.canSeparateSeries = false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        return JPKReader.checkSuffix(name, "jpk");
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int ifd;
        if (this.getSeriesCount() == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int n = ifd = this.getSeries() == 0 ? 0 : no + 1;
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        this.tiffParser.fillInIFD((IFD)this.ifds.get(ifd));
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, w, h);
        return buf;
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getMainIFDs();
        int seriesCount = this.ifds.size() > 1 ? 2 : 1;
        this.core.clear();
        for (int s = 0; s < seriesCount; ++s) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            IFD ifd = (IFD)this.ifds.get(s);
            this.tiffParser.fillInIFD(ifd);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            ms.rgb = samples > 1 || p == PhotoInterp.RGB;
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = 1;
            ms.sizeT = s == 0 ? 1 : this.ifds.size() - 1;
            ms.sizeC = ms.rgb ? samples : 1;
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            ms.imageCount = s == 0 ? 1 : this.ifds.size() - 1;
            ms.pixelType = ifd.getPixelType();
            ms.metadataComplete = true;
            ms.interleaved = false;
            ms.falseColor = false;
            ms.dimensionOrder = "XYCZT";
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            this.setSeries(s);
            for (Integer key : ((IFD)this.ifds.get(s)).keySet()) {
                if (key < 32848) continue;
                this.addSeriesMeta("Tag " + key, ((IFD)this.ifds.get(s)).get(key));
            }
        }
        this.setSeries(0);
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
        }
    }
}

