/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class LEOReader
extends BaseTiffReader {
    public static final int LEO_TAG = 34118;
    private double xSize;
    private String date;
    private double workingDistance;

    public LEOReader() {
        super("LEO", new String[]{"sxm", "tif", "tiff"});
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixSufficient = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setDoCaching(false);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(34118);
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        String tag = ((IFD)this.ifds.get(0)).getIFDTextValue(34118);
        String[] lines = tag.split("\n");
        this.date = "";
        double filament = 0.0;
        double eht = 0.0;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.xSize = Double.parseDouble(lines[3]) * 1000000.0;
            for (int line = 36; line < lines.length; ++line) {
                if (lines[line].equals("AP_IMAGE_PIXEL_SIZE")) {
                    this.xSize = Double.parseDouble(lines[++line].split("\\s+=\\s+")[1].replace(" nm", "e-03"));
                    continue;
                }
                if (lines[line].equals("AP_WD")) {
                    this.workingDistance = Double.parseDouble(lines[++line].split("\\s+=\\s+")[1].replace(" mm", "e+03"));
                    continue;
                }
                if (lines[line].equals("AP_ACTUALCURRENT")) {
                    filament = Double.parseDouble(lines[++line].split("\\s+=\\s+")[1].replace(" A", ""));
                    continue;
                }
                if (lines[line].equals("AP_ACTUALKV")) {
                    eht = Double.parseDouble(lines[++line].split("\\s+=\\s+")[1].replace(" kV", "e+03").replace(" V", ""));
                    continue;
                }
                if (lines[line].equals("AP_TIME")) {
                    this.date = this.date + lines[++line].split(" :")[1];
                    continue;
                }
                if (!lines[line].equals("AP_DATE")) continue;
                this.date = this.date + " " + lines[++line].split(" :")[1];
            }
            this.addGlobalMeta("EHT", eht);
            this.addGlobalMeta("Filament", filament);
            this.addGlobalMeta("Working Distance", this.workingDistance);
            this.addGlobalMeta("Physical pixel size", this.xSize + " um");
            this.addGlobalMeta("Acquisition date", this.date);
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        this.date = DateTools.formatDate(this.date, "HH:mm dd-MMM-yyyy");
        if (this.date != null) {
            store.setImageAcquisitionDate(new Timestamp(this.date), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length sizeX = FormatTools.getPhysicalSizeX(this.xSize);
            Length sizeY = FormatTools.getPhysicalSizeY(this.xSize);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            String instrument = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrument, 0);
            store.setImageInstrumentRef(instrument, 0);
            store.setObjectiveID(MetadataTools.createLSID("Objective", 0, 0), 0, 0);
            store.setObjectiveWorkingDistance(new Length(this.workingDistance, UNITS.MICROMETER), 0, 0);
            store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
            store.setObjectiveCorrection(MetadataTools.getCorrection("Other"), 0, 0);
        }
    }
}

