/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.DebugTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.DimensionSwapper;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.Memoizer;
import loci.formats.MetadataTools;
import loci.formats.MinMaxCalculator;
import loci.formats.MissingLibraryException;
import loci.formats.Modulo;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.BufferedImageReader;
import loci.formats.gui.ImageViewer;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import loci.formats.tools.AsciiImage;
import loci.formats.tools.CommandLineTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageInfo.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final ImmutableSet<String> HELP_ARGUMENTS = ImmutableSet.of("-h", "-help", "--help");
    private String id = null;
    private boolean printVersion = false;
    private boolean pixels = true;
    private boolean doCore = true;
    private boolean doMeta = true;
    private boolean filter = true;
    private boolean thumbs = false;
    private boolean minmax = false;
    private boolean merge = false;
    private boolean stitch = false;
    private boolean group = true;
    private boolean separate = false;
    private boolean expand = false;
    private boolean omexml = false;
    private boolean cache = false;
    private boolean originalMetadata = true;
    private boolean normalize = false;
    private boolean fastBlit = false;
    private boolean autoscale = false;
    private boolean preload = false;
    private boolean ascii = false;
    private boolean usedFiles = true;
    private boolean omexmlOnly = false;
    private boolean validate = true;
    private boolean flat = true;
    private String omexmlVersion = null;
    private int start = 0;
    private int end = Integer.MAX_VALUE;
    private int series = 0;
    private int resolution = 0;
    private int xCoordinate = 0;
    private int yCoordinate = 0;
    private int width = 0;
    private int height = 0;
    private String swapOrder = null;
    private String shuffleOrder = null;
    private String map = null;
    private String format = null;
    private String cachedir = null;
    private int xmlSpaces = 3;
    private DynamicMetadataOptions options = new DynamicMetadataOptions();
    private IFormatReader reader;
    private IFormatReader baseReader;
    private MinMaxCalculator minMaxCalc;
    private DimensionSwapper dimSwapper;
    private BufferedImageReader biReader;
    private Double[] preGlobalMin = null;
    private Double[] preGlobalMax = null;
    private Double[] preKnownMin = null;
    private Double[] preKnownMax = null;
    private Double[] prePlaneMin = null;
    private Double[] prePlaneMax = null;
    private boolean preIsMinMaxPop = false;

    public boolean parseArgs(String[] args) {
        this.id = null;
        this.printVersion = false;
        this.pixels = true;
        this.doCore = true;
        this.doMeta = true;
        this.filter = true;
        this.thumbs = false;
        this.minmax = false;
        this.merge = false;
        this.stitch = false;
        this.group = true;
        this.separate = false;
        this.expand = false;
        this.omexml = false;
        this.cache = false;
        this.originalMetadata = true;
        this.normalize = false;
        this.fastBlit = false;
        this.autoscale = false;
        this.preload = false;
        this.usedFiles = true;
        this.omexmlOnly = false;
        this.validate = true;
        this.flat = true;
        this.omexmlVersion = null;
        this.xmlSpaces = 3;
        this.start = 0;
        this.end = Integer.MAX_VALUE;
        this.series = 0;
        this.resolution = 0;
        this.xCoordinate = 0;
        this.yCoordinate = 0;
        this.width = 0;
        this.height = 0;
        this.swapOrder = null;
        this.shuffleOrder = null;
        this.map = null;
        this.cachedir = null;
        if (args == null) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-version")) {
                    this.printVersion = true;
                    return true;
                }
                if (args[i].equals("-nopix")) {
                    this.pixels = false;
                    continue;
                }
                if (args[i].equals("-nocore")) {
                    this.doCore = false;
                    continue;
                }
                if (args[i].equals("-nometa")) {
                    this.doMeta = false;
                    continue;
                }
                if (args[i].equals("-nofilter")) {
                    this.filter = false;
                    continue;
                }
                if (args[i].equals("-thumbs")) {
                    this.thumbs = true;
                    continue;
                }
                if (args[i].equals("-minmax")) {
                    this.minmax = true;
                    continue;
                }
                if (args[i].equals("-merge")) {
                    this.merge = true;
                    continue;
                }
                if (args[i].equals("-stitch")) {
                    this.stitch = true;
                    continue;
                }
                if (args[i].equals("-nogroup")) {
                    this.group = false;
                    continue;
                }
                if (args[i].equals("-separate")) {
                    this.separate = true;
                    continue;
                }
                if (args[i].equals("-expand")) {
                    this.expand = true;
                    continue;
                }
                if (args[i].equals("-cache")) {
                    this.cache = true;
                    continue;
                }
                if (args[i].equals("-omexml")) {
                    this.omexml = true;
                    continue;
                }
                if (args[i].equals("-no-sas")) {
                    this.originalMetadata = false;
                    continue;
                }
                if (args[i].equals("-normalize")) {
                    this.normalize = true;
                    continue;
                }
                if (args[i].equals("-fast")) {
                    this.fastBlit = true;
                    continue;
                }
                if (args[i].equals("-autoscale")) {
                    this.fastBlit = true;
                    this.autoscale = true;
                    continue;
                }
                if (args[i].equals("-novalid")) {
                    this.validate = false;
                    continue;
                }
                if (args[i].equals("-validate")) {
                    this.validate = true;
                    continue;
                }
                if (args[i].equals("-noflat")) {
                    this.flat = false;
                    continue;
                }
                if (args[i].equals("-debug")) {
                    DebugTools.setRootLevel("DEBUG");
                    continue;
                }
                if (args[i].equals("-trace")) {
                    DebugTools.setRootLevel("TRACE");
                    continue;
                }
                if (args[i].equals("-omexml-only")) {
                    this.omexmlOnly = true;
                    this.omexml = true;
                    DebugTools.setRootLevel("OFF");
                    continue;
                }
                if (args[i].equals("-preload")) {
                    this.preload = true;
                    continue;
                }
                if (args[i].equals("-ascii")) {
                    this.ascii = true;
                    continue;
                }
                if (args[i].equals("-nousedfiles")) {
                    this.usedFiles = false;
                    continue;
                }
                if (args[i].equals("-xmlversion")) {
                    this.omexmlVersion = args[++i];
                    continue;
                }
                if (args[i].equals("-xmlspaces")) {
                    this.xmlSpaces = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-crop")) {
                    StringTokenizer st = new StringTokenizer(args[++i], ",");
                    this.xCoordinate = Integer.parseInt(st.nextToken());
                    this.yCoordinate = Integer.parseInt(st.nextToken());
                    this.width = Integer.parseInt(st.nextToken());
                    this.height = Integer.parseInt(st.nextToken());
                    continue;
                }
                if (args[i].equals("-range")) {
                    try {
                        this.start = Integer.parseInt(args[++i]);
                        this.end = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-series")) {
                    try {
                        this.series = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-resolution")) {
                    try {
                        this.resolution = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-swap")) {
                    this.swapOrder = args[++i].toUpperCase();
                    continue;
                }
                if (args[i].equals("-shuffle")) {
                    this.shuffleOrder = args[++i].toUpperCase();
                    continue;
                }
                if (args[i].equals("-map")) {
                    this.map = args[++i];
                    continue;
                }
                if (args[i].equals("-format")) {
                    this.format = args[++i];
                    continue;
                }
                if (args[i].equals("-cache-dir")) {
                    this.cache = true;
                    this.cachedir = args[++i];
                    continue;
                }
                if (args[i].equals("-option")) {
                    this.options.set(args[++i], args[++i]);
                    continue;
                }
                if (args[i].equals("-no-upgrade")) continue;
                LOGGER.error("Found unknown command flag: {}; exiting.", (Object)args[i]);
                return false;
            }
            if (this.id == null) {
                this.id = args[i];
                continue;
            }
            LOGGER.error("Found unknown argument: {}; exiting.", (Object)args[i]);
            return false;
        }
        return true;
    }

    public void printUsage() {
        String fmt = this.reader instanceof ImageReader ? "any" : this.reader.getFormat();
        String[] s = new String[]{"To test read a file in " + fmt + " format, run:", "  showinf file [-nopix] [-nocore] [-nometa] [-thumbs] [-minmax] ", "    [-merge] [-nogroup] [-stitch] [-separate] [-expand] [-omexml]", "    [-normalize] [-fast] [-debug] [-range start end] [-series num]", "    [-resolution num] [-swap inputOrder] [-shuffle outputOrder]", "    [-map id] [-preload] [-crop x,y,w,h] [-autoscale] [-novalid]", "    [-omexml-only] [-no-sas] [-no-upgrade] [-noflat] [-format Format]", "    [-cache] [-cache-dir dir] [-option key value]", "", "    -version: print the library version and exit", "        file: the image file to read", "      -nopix: read metadata only, not pixels", "     -nocore: do not output core metadata", "     -nometa: do not parse format-specific metadata table", "   -nofilter: do not filter metadata fields", "     -thumbs: read thumbnails instead of normal pixels", "     -minmax: compute min/max statistics", "      -merge: combine separate channels into RGB image", "    -nogroup: force multi-file datasets to be read as individual files", "     -stitch: stitch files with similar names", "   -separate: split RGB image into separate channels", "     -expand: expand indexed color to RGB", "     -omexml: populate OME-XML metadata", "  -normalize: normalize floating point images (*)", "       -fast: paint RGB images as quickly as possible (*)", "      -debug: turn on debugging output", "      -range: specify range of planes to read (inclusive)", "     -series: specify which image series to read", "     -noflat: do not flatten subresolutions", " -resolution: used in combination with -noflat to specify which", "              subresolution to read (for images with subresolutions)", "       -swap: override the default input dimension order", "    -shuffle: override the default output dimension order", "        -map: specify file on disk to which name should be mapped", "    -preload: pre-read entire file into a buffer; significantly", "              reduces the time required to read the images, but", "              requires more memory", "       -crop: crop images before displaying; argument is 'x,y,w,h'", "  -autoscale: automatically adjust brightness and contrast (*)", "    -novalid: do not perform validation of OME-XML", "-omexml-only: only output the generated OME-XML", "     -no-sas: do not output OME-XML StructuredAnnotation elements", " -no-upgrade: do not perform the upgrade check", "     -format: read file with a particular reader (e.g., ZeissZVI)", "      -cache: cache the initialized reader", "  -cache-dir: use the specified directory to store the cached", "              initialized reader. If unspecified, the cached reader", "              will be stored under the same folder as the image file", "     -option: add the specified key/value pair to the reader's options list", "", "* = may result in loss of precision", ""};
        for (int i = 0; i < s.length; ++i) {
            System.out.println(s[i]);
        }
    }

    public void setReader(IFormatReader reader) {
        this.reader = reader;
    }

    public void createReader() {
        if (this.reader != null) {
            return;
        }
        if (this.format != null) {
            try {
                Class<?> c = Class.forName("loci.formats.in." + this.format + "Reader");
                this.reader = (IFormatReader)c.newInstance();
            }
            catch (ClassNotFoundException exc) {
                LOGGER.warn("Unknown reader: {}", (Object)this.format);
                LOGGER.debug("", exc);
            }
            catch (InstantiationException exc) {
                LOGGER.warn("Cannot instantiate reader: {}", (Object)this.format);
                LOGGER.debug("", exc);
            }
            catch (IllegalAccessException exc) {
                LOGGER.warn("Cannot access reader: {}", (Object)this.format);
                LOGGER.debug("", exc);
            }
        }
        if (this.reader == null) {
            this.reader = new ImageReader();
        }
        this.baseReader = this.reader;
    }

    public void mapLocation() throws IOException {
        if (this.map != null) {
            Location.mapId(this.id, this.map);
        } else if (this.preload) {
            int r;
            RandomAccessInputStream f = new RandomAccessInputStream(this.id);
            if (!(this.reader instanceof ImageReader)) {
                LOGGER.info("Checking {} format [{}]", (Object)this.reader.getFormat(), (Object)(this.reader.isThisType(f) ? "yes" : "no"));
                f.seek(0L);
            }
            int len = (int)f.length();
            LOGGER.info("Caching {} bytes:", (Object)len);
            byte[] b = new byte[len];
            int blockSize = 0x800000;
            int read = 0;
            for (int left = len; left > 0; left -= r) {
                r = f.read(b, read, blockSize < left ? blockSize : left);
                float ratio = (float)(read += r) / (float)len;
                int p = (int)(100.0f * ratio);
                LOGGER.info("\tRead {} bytes ({}% complete)", (Object)read, (Object)p);
            }
            f.close();
            ByteArrayHandle file2 = new ByteArrayHandle(b);
            Location.mapFile(this.id, file2);
        }
    }

    public void configureReaderPreInit() throws FormatException, IOException {
        if (this.omexml) {
            this.reader.setOriginalMetadataPopulated(this.originalMetadata);
            try {
                ServiceFactory factory = new ServiceFactory();
                OMEXMLService service = factory.getInstance(OMEXMLService.class);
                this.reader.setMetadataStore(service.createOMEXMLMetadata(null, this.omexmlVersion));
            }
            catch (DependencyException de) {
                throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, de);
            }
            catch (ServiceException se) {
                throw new FormatException(se);
            }
        }
        if (this.reader instanceof ImageReader) {
            ImageReader ir = (ImageReader)this.reader;
            if (new Location(this.id).exists()) {
                LOGGER.info("Checking file format [{}]", (Object)ir.getFormat(this.id));
            }
        } else {
            LOGGER.info("Checking {} format [{}]", (Object)this.reader.getFormat(), (Object)(this.reader.isThisType(this.id) ? "yes" : "no"));
        }
        LOGGER.info("Initializing reader");
        if (this.stitch) {
            this.reader = new FileStitcher(this.reader, true);
            Location f = new Location(this.id);
            String pat = null;
            if (!f.exists()) {
                ((FileStitcher)this.reader).setUsingPatternIds(true);
                pat = this.id;
            } else {
                pat = FilePattern.findPattern(f);
            }
            if (pat != null) {
                this.id = pat;
            }
        }
        if (this.expand) {
            this.reader = new ChannelFiller(this.reader);
        }
        if (this.separate) {
            this.reader = new ChannelSeparator(this.reader);
        }
        if (this.merge) {
            this.reader = new ChannelMerger(this.reader);
        }
        if (this.cache) {
            this.reader = this.cachedir != null ? new Memoizer(this.reader, 0L, new File(this.cachedir)) : new Memoizer(this.reader, 0L);
        }
        this.minMaxCalc = null;
        if (this.minmax || this.autoscale) {
            this.minMaxCalc = new MinMaxCalculator(this.reader);
            this.reader = this.minMaxCalc;
        }
        this.dimSwapper = null;
        if (this.swapOrder != null || this.shuffleOrder != null) {
            this.dimSwapper = new DimensionSwapper(this.reader);
            this.reader = this.dimSwapper;
        }
        this.biReader = new BufferedImageReader(this.reader);
        this.reader = this.biReader;
        this.reader.close();
        this.reader.setNormalized(this.normalize);
        this.reader.setMetadataFiltered(this.filter);
        this.reader.setGroupFiles(this.group);
        this.options.setMetadataLevel(this.doMeta ? MetadataLevel.ALL : MetadataLevel.MINIMUM);
        this.options.setValidate(this.validate);
        this.reader.setMetadataOptions(this.options);
        this.reader.setFlattenedResolutions(this.flat);
    }

    public void configureReaderPostInit() {
        if (this.swapOrder != null) {
            this.dimSwapper.swapDimensions(this.swapOrder);
        }
        if (this.shuffleOrder != null) {
            this.dimSwapper.setOutputOrder(this.shuffleOrder);
        }
    }

    public void checkWarnings() {
        if (!(this.normalize || this.reader.getPixelType() != 6 && this.reader.getPixelType() != 7)) {
            LOGGER.warn("");
            LOGGER.warn("Java does not support display of unnormalized floating point data.");
            LOGGER.warn("Please use the '-normalize' option to avoid receiving a cryptic exception.");
        }
        if (this.reader.isRGB() && this.reader.getRGBChannelCount() > 4) {
            LOGGER.warn("");
            LOGGER.warn("Java does not support merging more than 4 channels.");
            LOGGER.warn("Please use the '-separate' option to avoid losing channels beyond the 4th.");
        }
    }

    public void readCoreMetadata() throws FormatException, IOException {
        if (!this.doCore) {
            return;
        }
        LOGGER.info("");
        LOGGER.info("Reading core metadata");
        LOGGER.info("{} = {}", (Object)(this.stitch ? "File pattern" : "filename"), (Object)(this.stitch ? this.id : this.reader.getCurrentFile()));
        if (this.map != null) {
            LOGGER.info("Mapped filename = {}", (Object)this.map);
        }
        if (this.usedFiles) {
            int u;
            boolean usedValid;
            String[] used = this.reader.getUsedFiles();
            boolean bl = usedValid = used != null && used.length > 0;
            if (usedValid) {
                for (u = 0; u < used.length; ++u) {
                    if (used[u] != null) continue;
                    usedValid = false;
                    break;
                }
            }
            if (!usedValid) {
                LOGGER.warn("************ invalid used files list ************");
            }
            if (used == null) {
                LOGGER.info("Used files = null");
            } else if (used.length == 0) {
                LOGGER.info("Used files = []");
            } else if (used.length > 1) {
                LOGGER.info("Used files:");
                for (u = 0; u < used.length; ++u) {
                    LOGGER.info("\t{}", (Object)used[u]);
                }
            } else if (!this.id.equals(used[0])) {
                LOGGER.info("Used files = [{}]", (Object)used[0]);
            }
        }
        int seriesCount = this.reader.getSeriesCount();
        LOGGER.info("Series count = {}", (Object)seriesCount);
        MetadataStore ms = this.reader.getMetadataStore();
        MetadataRetrieve mr = ms instanceof MetadataRetrieve ? (MetadataRetrieve)((Object)ms) : null;
        for (int j = 0; j < seriesCount; ++j) {
            int[] indices;
            this.reader.setSeries(j);
            int imageCount = this.reader.getImageCount();
            int resolutions = this.reader.getResolutionCount();
            boolean rgb = this.reader.isRGB();
            int sizeX = this.reader.getSizeX();
            int sizeY = this.reader.getSizeY();
            int sizeZ = this.reader.getSizeZ();
            int sizeC = this.reader.getSizeC();
            int sizeT = this.reader.getSizeT();
            int pixelType = this.reader.getPixelType();
            int validBits = this.reader.getBitsPerPixel();
            int effSizeC = this.reader.getEffectiveSizeC();
            int rgbChanCount = this.reader.getRGBChannelCount();
            boolean indexed = this.reader.isIndexed();
            boolean falseColor = this.reader.isFalseColor();
            byte[][] table8 = this.reader.get8BitLookupTable();
            short[][] table16 = this.reader.get16BitLookupTable();
            Modulo moduloZ = this.reader.getModuloZ();
            Modulo moduloC = this.reader.getModuloC();
            Modulo moduloT = this.reader.getModuloT();
            int thumbSizeX = this.reader.getThumbSizeX();
            int thumbSizeY = this.reader.getThumbSizeY();
            int tileSizeX = this.reader.getOptimalTileWidth();
            int tileSizeY = this.reader.getOptimalTileHeight();
            boolean little = this.reader.isLittleEndian();
            String dimOrder = this.reader.getDimensionOrder();
            boolean orderCertain = this.reader.isOrderCertain();
            boolean thumbnail = this.reader.isThumbnailSeries();
            boolean interleaved = this.reader.isInterleaved();
            boolean metadataComplete = this.reader.isMetadataComplete();
            String seriesName = mr == null ? null : mr.getImageName(j);
            LOGGER.info("Series #{}{}{}:", j, seriesName == null ? " " : " -- ", seriesName == null ? "" : seriesName);
            if (!this.flat && resolutions > 1) {
                LOGGER.info("\tResolutions = {}", (Object)resolutions);
                for (int i = 0; i < resolutions; ++i) {
                    this.reader.setResolution(i);
                    LOGGER.info("\t\tsizeX[{}] = {}", (Object)i, (Object)this.reader.getSizeX());
                }
                this.reader.setResolution(0);
            }
            LOGGER.info("\tImage count = {}", (Object)imageCount);
            LOGGER.info("\tRGB = {} ({}) {}", rgb, rgbChanCount, this.merge ? "(merged)" : (this.separate ? "(separated)" : ""));
            if (rgb != (rgbChanCount != 1)) {
                LOGGER.warn("\t************ RGB mismatch ************");
            }
            LOGGER.info("\tInterleaved = {}", (Object)interleaved);
            StringBuilder sb = new StringBuilder();
            sb.append("\tIndexed = ");
            sb.append(indexed);
            sb.append(" (");
            sb.append(!falseColor);
            sb.append(" color");
            if (table8 != null) {
                sb.append(", 8-bit LUT: ");
                sb.append(table8.length);
                sb.append(" x ");
                sb.append(table8[0] == null ? "null" : "" + table8[0].length);
            }
            if (table16 != null) {
                sb.append(", 16-bit LUT: ");
                sb.append(table16.length);
                sb.append(" x ");
                sb.append(table16[0] == null ? "null" : "" + table16[0].length);
            }
            sb.append(")");
            LOGGER.info(sb.toString());
            if (table8 != null && table16 != null) {
                LOGGER.warn("\t************ multiple LUTs ************");
            }
            LOGGER.info("\tWidth = {}", (Object)sizeX);
            LOGGER.info("\tHeight = {}", (Object)sizeY);
            this.printDimension("SizeZ", sizeZ, sizeZ, moduloZ);
            this.printDimension("SizeT", sizeT, sizeT, moduloT);
            this.printDimension("SizeC", sizeC, effSizeC, moduloC);
            if (imageCount != sizeZ * effSizeC * sizeT) {
                LOGGER.info("\t************ ZCT mismatch ************");
            }
            LOGGER.info("\tTile size = {} x {}", (Object)tileSizeX, (Object)tileSizeY);
            LOGGER.info("\tThumbnail size = {} x {}", (Object)thumbSizeX, (Object)thumbSizeY);
            LOGGER.info("\tEndianness = {}", (Object)(little ? "intel (little)" : "motorola (big)"));
            LOGGER.info("\tDimension order = {} ({})", (Object)dimOrder, (Object)(orderCertain ? "certain" : "uncertain"));
            LOGGER.info("\tPixel type = {}", (Object)FormatTools.getPixelTypeString(pixelType));
            LOGGER.info("\tValid bits per pixel = {}", (Object)validBits);
            LOGGER.info("\tMetadata complete = {}", (Object)metadataComplete);
            LOGGER.info("\tThumbnail series = {}", (Object)thumbnail);
            if (!this.doMeta) continue;
            LOGGER.info("\t-----");
            if (imageCount > 6) {
                int q = imageCount / 2;
                indices = new int[]{0, q - 2, q - 1, q, q + 1, q + 2, imageCount - 1};
            } else {
                indices = imageCount > 2 ? new int[]{0, imageCount / 2, imageCount - 1} : (imageCount > 1 ? new int[]{0, 1} : new int[]{0});
            }
            int[][] zct = new int[indices.length][];
            int[] indices2 = new int[indices.length];
            sb.setLength(0);
            for (int i = 0; i < indices.length; ++i) {
                zct[i] = this.reader.getZCTCoords(indices[i]);
                indices2[i] = this.reader.getIndex(zct[i][0], zct[i][1], zct[i][2]);
                sb.append("\tPlane #");
                sb.append(indices[i]);
                sb.append(" <=> Z ");
                sb.append(zct[i][0]);
                sb.append(", C ");
                sb.append(zct[i][1]);
                sb.append(", T ");
                sb.append(zct[i][2]);
                if (indices[i] != indices2[i]) {
                    sb.append(" [mismatch: ");
                    sb.append(indices2[i]);
                    sb.append("]");
                    sb.append(NEWLINE);
                    continue;
                }
                sb.append(NEWLINE);
            }
            LOGGER.info(sb.toString());
        }
    }

    public void initPreMinMaxValues() throws FormatException, IOException {
        this.preGlobalMax = null;
        this.preGlobalMin = null;
        this.preKnownMax = null;
        this.preKnownMin = null;
        this.prePlaneMax = null;
        this.prePlaneMin = null;
        this.preIsMinMaxPop = false;
        if (this.minmax) {
            int sizeC = this.reader.getSizeC();
            this.preGlobalMin = new Double[sizeC];
            this.preGlobalMax = new Double[sizeC];
            this.preKnownMin = new Double[sizeC];
            this.preKnownMax = new Double[sizeC];
            for (int c = 0; c < sizeC; ++c) {
                this.preGlobalMin[c] = this.minMaxCalc.getChannelGlobalMinimum(c);
                this.preGlobalMax[c] = this.minMaxCalc.getChannelGlobalMaximum(c);
                this.preKnownMin[c] = this.minMaxCalc.getChannelKnownMinimum(c);
                this.preKnownMax[c] = this.minMaxCalc.getChannelKnownMaximum(c);
            }
            this.prePlaneMin = this.minMaxCalc.getPlaneMinimum(0);
            this.prePlaneMax = this.minMaxCalc.getPlaneMaximum(0);
            this.preIsMinMaxPop = this.minMaxCalc.isMinMaxPopulated();
        }
    }

    public void printMinMaxValues() throws FormatException, IOException {
        int subC;
        int sizeC = this.reader.getSizeC();
        Double[] globalMin = new Double[sizeC];
        Double[] globalMax = new Double[sizeC];
        Double[] knownMin = new Double[sizeC];
        Double[] knownMax = new Double[sizeC];
        for (int c = 0; c < sizeC; ++c) {
            globalMin[c] = this.minMaxCalc.getChannelGlobalMinimum(c);
            globalMax[c] = this.minMaxCalc.getChannelGlobalMaximum(c);
            knownMin[c] = this.minMaxCalc.getChannelKnownMinimum(c);
            knownMax[c] = this.minMaxCalc.getChannelKnownMaximum(c);
        }
        Double[] planeMin = this.minMaxCalc.getPlaneMinimum(0);
        Double[] planeMax = this.minMaxCalc.getPlaneMaximum(0);
        boolean isMinMaxPop = this.minMaxCalc.isMinMaxPopulated();
        LOGGER.info("");
        LOGGER.info("Min/max values:");
        for (int c = 0; c < sizeC; ++c) {
            LOGGER.info("\tChannel {}:", (Object)c);
            LOGGER.info("\t\tGlobal minimum = {} (initially {})", (Object)globalMin[c], (Object)this.preGlobalMin[c]);
            LOGGER.info("\t\tGlobal maximum = {} (initially {})", (Object)globalMax[c], (Object)this.preGlobalMax[c]);
            LOGGER.info("\t\tKnown minimum = {} (initially {})", (Object)knownMin[c], (Object)this.preKnownMin[c]);
            LOGGER.info("\t\tKnown maximum = {} (initially {})", (Object)knownMax[c], (Object)this.preKnownMax[c]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\tFirst plane minimum(s) =");
        if (planeMin == null) {
            sb.append(" none");
        } else {
            for (subC = 0; subC < planeMin.length; ++subC) {
                sb.append(" ");
                sb.append(planeMin[subC]);
            }
        }
        sb.append(" (initially");
        if (this.prePlaneMin == null) {
            sb.append(" none");
        } else {
            for (subC = 0; subC < this.prePlaneMin.length; ++subC) {
                sb.append(" ");
                sb.append(this.prePlaneMin[subC]);
            }
        }
        sb.append(")");
        LOGGER.info(sb.toString());
        sb.setLength(0);
        sb.append("\tFirst plane maximum(s) =");
        if (planeMax == null) {
            sb.append(" none");
        } else {
            for (subC = 0; subC < planeMax.length; ++subC) {
                sb.append(" ");
                sb.append(planeMax[subC]);
            }
        }
        sb.append(" (initially");
        if (this.prePlaneMax == null) {
            sb.append(" none");
        } else {
            for (subC = 0; subC < this.prePlaneMax.length; ++subC) {
                sb.append(" ");
                sb.append(this.prePlaneMax[subC]);
            }
        }
        sb.append(")");
        LOGGER.info(sb.toString());
        LOGGER.info("\tMin/max populated = {} (initially {})", (Object)isMinMaxPop, (Object)this.preIsMinMaxPop);
    }

    public void readPixels() throws FormatException, IOException {
        long s;
        String seriesLabel = this.reader.getSeriesCount() > 1 ? " series #" + this.series : "";
        LOGGER.info("");
        int num = this.reader.getImageCount();
        if (this.start < 0) {
            this.start = 0;
        }
        if (this.start >= num) {
            this.start = num - 1;
        }
        if (this.end < 0) {
            this.end = 0;
        }
        if (this.end >= num) {
            this.end = num - 1;
        }
        if (this.end < this.start) {
            this.end = this.start;
        }
        LOGGER.info("Reading{} pixel data ({}-{})", seriesLabel, this.start, this.end);
        int sizeX = this.reader.getSizeX();
        int sizeY = this.reader.getSizeY();
        if (this.width == 0) {
            this.width = sizeX;
        }
        if (this.height == 0) {
            this.height = sizeY;
        }
        int pixelType = this.reader.getPixelType();
        BufferedImage[] images = new BufferedImage[this.end - this.start + 1];
        long timeLastLogged = s = System.currentTimeMillis();
        for (int i = this.start; i <= this.end; ++i) {
            int pixType;
            if (!this.fastBlit) {
                images[i - this.start] = this.thumbs ? this.biReader.openThumbImage(i) : this.biReader.openImage(i, this.xCoordinate, this.yCoordinate, this.width, this.height);
            } else {
                byte[] b = this.thumbs ? this.reader.openThumbBytes(i) : this.reader.openBytes(i, this.xCoordinate, this.yCoordinate, this.width, this.height);
                Object pix = DataTools.makeDataArray(b, FormatTools.getBytesPerPixel(pixelType), FormatTools.isFloatingPoint(pixelType), this.reader.isLittleEndian());
                Double min = null;
                Double max = null;
                if (this.autoscale) {
                    Double[] planeMin = this.minMaxCalc.getPlaneMinimum(i);
                    Double[] planeMax = this.minMaxCalc.getPlaneMaximum(i);
                    if (planeMin != null && planeMax != null) {
                        min = planeMin[0];
                        max = planeMax[0];
                        for (int j = 1; j < planeMin.length; ++j) {
                            if (planeMin[j] < min) {
                                min = planeMin[j];
                            }
                            if (!(planeMax[j] > max)) continue;
                            max = planeMax[j];
                        }
                    }
                } else if (this.normalize) {
                    min = 0.0;
                    max = 1.0;
                }
                if (this.normalize) {
                    if (pix instanceof float[]) {
                        pix = DataTools.normalizeFloats((float[])pix);
                    } else if (pix instanceof double[]) {
                        pix = DataTools.normalizeDoubles((double[])pix);
                    }
                }
                images[i - this.start] = this.thumbs ? AWTImageTools.makeImage(ImageTools.make24Bits(pix, sizeX, sizeY, this.reader.isInterleaved(), false, min, max), sizeX, sizeY, FormatTools.isSigned(pixelType)) : AWTImageTools.makeImage(ImageTools.make24Bits(pix, this.width, this.height, this.reader.isInterleaved(), false, min, max), this.width, this.height, FormatTools.isSigned(pixelType));
            }
            if (images[i - this.start] == null) {
                LOGGER.warn("\t************ Failed to read plane #{} ************", (Object)i);
            }
            if (this.reader.isIndexed() && this.reader.get8BitLookupTable() == null && this.reader.get16BitLookupTable() == null) {
                LOGGER.warn("\t************ no LUT for plane #{} ************", (Object)i);
            }
            if ((pixType = AWTImageTools.getPixelType(images[i - this.start])) != pixelType && pixType != pixelType + 1 && !this.fastBlit) {
                LOGGER.info("\tPlane #{}: pixel type mismatch: {}/{}", i, FormatTools.getPixelTypeString(pixType), FormatTools.getPixelTypeString(pixelType));
                continue;
            }
            long t = System.currentTimeMillis();
            if (i != this.end && (t - timeLastLogged) / 1000L <= 0L) continue;
            int current = i - this.start + 1;
            int total = this.end - this.start + 1;
            int percent = 100 * current / total;
            LOGGER.info("\tRead {}/{} planes ({}%)", current, total, percent);
            timeLastLogged = t;
        }
        long e = System.currentTimeMillis();
        LOGGER.info("[done]");
        float sec = (float)(e - s) / 1000.0f;
        float avg = (float)(e - s) / (float)images.length;
        LOGGER.info("{}s elapsed ({}ms per plane)", (Object)Float.valueOf(sec), (Object)Float.valueOf(avg));
        if (this.minmax) {
            this.printMinMaxValues();
        }
        if (this.ascii) {
            for (int i = 0; i < images.length; ++i) {
                BufferedImage img = images[i];
                LOGGER.info("");
                LOGGER.info("Image #{}:", (Object)i);
                LOGGER.info(new AsciiImage(img).toString());
            }
        } else {
            LOGGER.info("");
            LOGGER.info("Launching image viewer");
            ImageViewer viewer = new ImageViewer(false);
            viewer.setImages(this.reader, images);
            viewer.setVisible(true);
        }
    }

    public void printGlobalMetadata() {
        String[] keys;
        LOGGER.info("");
        LOGGER.info("Reading global metadata");
        Hashtable<String, Object> meta = this.reader.getGlobalMetadata();
        for (String key : keys = MetadataTools.keys(meta)) {
            LOGGER.info("{}: {}", (Object)key, meta.get(key));
        }
    }

    public void printOriginalMetadata() {
        String seriesLabel = this.reader.getSeriesCount() > 1 ? " series #" + this.series : "";
        LOGGER.info("");
        LOGGER.info("Reading{} metadata", (Object)seriesLabel);
        Hashtable<String, Object> meta = this.reader.getSeriesMetadata();
        String[] keys = MetadataTools.keys(meta);
        for (int i = 0; i < keys.length; ++i) {
            LOGGER.info("{}: {}", (Object)keys[i], meta.get(keys[i]));
        }
    }

    public void printOMEXML() throws MissingLibraryException, ServiceException {
        OMEXMLService service;
        LOGGER.info("");
        MetadataStore ms = this.reader.getMetadataStore();
        if (this.baseReader instanceof ImageReader) {
            this.baseReader = ((ImageReader)this.baseReader).getReader();
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            service = factory.getInstance(OMEXMLService.class);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, de);
        }
        String version = service.getOMEXMLVersion(ms);
        if (version == null) {
            LOGGER.info("Generating OME-XML");
        } else {
            LOGGER.info("Generating OME-XML (schema version {})", (Object)version);
        }
        if (ms instanceof MetadataRetrieve) {
            if (this.omexmlOnly) {
                DebugTools.setRootLevel("INFO");
            }
            String xml = service.getOMEXML((MetadataRetrieve)((Object)ms));
            LOGGER.info("{}", (Object)XMLTools.indentXML(xml, this.xmlSpaces, true));
            if (this.omexmlOnly) {
                DebugTools.setRootLevel("OFF");
            }
        } else {
            LOGGER.info("The metadata could not be converted to OME-XML.");
            if (this.omexmlVersion == null) {
                LOGGER.info("The OME-XML Java library is probably not available.");
            } else {
                LOGGER.info("{} is probably not a legal schema version.", (Object)this.omexmlVersion);
            }
        }
    }

    public boolean testRead(String[] args) throws FormatException, ServiceException, IOException {
        for (String arg : args) {
            if (!HELP_ARGUMENTS.contains(arg)) continue;
            if (this.reader == null) {
                this.reader = new ImageReader();
            }
            this.printUsage();
            return false;
        }
        boolean validArgs = this.parseArgs(args);
        if (!validArgs) {
            return false;
        }
        if (this.printVersion) {
            CommandLineTools.printVersion();
            return true;
        }
        this.createReader();
        if (this.id == null) {
            this.printUsage();
            return false;
        }
        CommandLineTools.runUpgradeCheck(args);
        this.mapLocation();
        this.configureReaderPreInit();
        long s = System.currentTimeMillis();
        try {
            this.reader.setId(this.id);
        }
        catch (FormatException exc) {
            this.reader.close();
            LOGGER.error("Failure during the reader initialization");
            LOGGER.debug("", exc);
            return false;
        }
        long e = System.currentTimeMillis();
        float sec = (float)(e - s) / 1000.0f;
        LOGGER.info("Initialization took {}s", (Object)Float.valueOf(sec));
        this.configureReaderPostInit();
        this.checkWarnings();
        this.readCoreMetadata();
        this.reader.setSeries(this.series);
        if (!this.flat) {
            this.reader.setResolution(this.resolution);
        }
        this.initPreMinMaxValues();
        if (this.pixels) {
            this.readPixels();
        }
        if (this.doMeta) {
            this.printGlobalMetadata();
            this.printOriginalMetadata();
        }
        if (this.omexml) {
            this.printOMEXML();
        }
        if (!this.pixels) {
            this.reader.close();
        }
        return true;
    }

    private void printDimension(String dim, int size, int effectiveSize, Modulo modulo) {
        StringBuffer sb = new StringBuffer("\t");
        sb.append(dim);
        sb.append(" = ");
        sb.append(size);
        if (size != effectiveSize) {
            sb.append(" (effectively ");
            sb.append(effectiveSize);
            sb.append(")");
        }
        int product = 1;
        if (modulo.length() == 1) {
            product = size;
        } else {
            sb.append(" (");
            sb.append(size / modulo.length());
            sb.append(" ");
            sb.append(modulo.parentType);
            sb.append(" x ");
            sb.append(modulo.length());
            sb.append(" ");
            sb.append(modulo.type);
            sb.append(")");
            product = size / modulo.length() * modulo.length();
        }
        LOGGER.info(sb.toString());
        if (product != size) {
            LOGGER.warn("\t************ {} dimension mismatch ************", (Object)dim);
        }
    }

    public static void main(String[] args) throws Exception {
        DebugTools.enableLogging("INFO");
        if (!new ImageInfo().testRead(args)) {
            System.exit(1);
        }
    }
}

