/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.CellValueRecordInterface;
import loci.poi.hssf.record.NumberRecord;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.util.RKUtil;

public class RKRecord
extends Record
implements CellValueRecordInterface {
    public static final short sid = 638;
    public static final short RK_IEEE_NUMBER = 0;
    public static final short RK_IEEE_NUMBER_TIMES_100 = 1;
    public static final short RK_INTEGER = 2;
    public static final short RK_INTEGER_TIMES_100 = 3;
    private int field_1_row;
    private short field_2_col;
    private short field_3_xf_index;
    private int field_4_rk_number;

    public RKRecord() {
    }

    public RKRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 638) {
            throw new RecordFormatException("NOT A valid RK RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_col = in.readShort();
        this.field_3_xf_index = in.readShort();
        this.field_4_rk_number = in.readInt();
    }

    @Override
    public int getRow() {
        return this.field_1_row;
    }

    @Override
    public short getColumn() {
        return this.field_2_col;
    }

    @Override
    public short getXFIndex() {
        return this.field_3_xf_index;
    }

    public int getRKField() {
        return this.field_4_rk_number;
    }

    public short getRKType() {
        return (short)(this.field_4_rk_number & 3);
    }

    public double getRKNumber() {
        return RKUtil.decodeNumber(this.field_4_rk_number);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[RK]\n");
        buffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("    .col            = ").append(Integer.toHexString(this.getColumn())).append("\n");
        buffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        buffer.append("    .rknumber       = ").append(Integer.toHexString(this.getRKField())).append("\n");
        buffer.append("        .rktype     = ").append(Integer.toHexString(this.getRKType())).append("\n");
        buffer.append("        .rknumber   = ").append(this.getRKNumber()).append("\n");
        buffer.append("[/RK]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        NumberRecord rec = new NumberRecord();
        rec.setColumn(this.getColumn());
        rec.setRow(this.getRow());
        rec.setValue(this.getRKNumber());
        rec.setXFIndex(this.getXFIndex());
        return rec.serialize(offset, data);
    }

    public static void main(String[] ignored_args) {
        int[] values = new int[]{0x3FF00000, 1079951361, 49382714, 49382715, -52598374};
        double[] rvalues = new double[]{1.0, 1.23, 1.2345678E7, 123456.78, -1.3149594E7};
        for (int j = 0; j < values.length; ++j) {
            System.out.println("input = " + Integer.toHexString(values[j]) + " -> " + rvalues[j] + ": " + RKUtil.decodeNumber(values[j]));
        }
    }

    @Override
    public short getSid() {
        return 638;
    }

    @Override
    public boolean isBefore(CellValueRecordInterface i) {
        if (this.getRow() > i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() > i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    @Override
    public boolean isAfter(CellValueRecordInterface i) {
        if (this.getRow() < i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() < i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    @Override
    public boolean isEqual(CellValueRecordInterface i) {
        return this.getRow() == i.getRow() && this.getColumn() == i.getColumn();
    }

    @Override
    public boolean isInValueSection() {
        return true;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public void setColumn(short col) {
    }

    @Override
    public void setRow(int row) {
    }

    @Override
    public void setXFIndex(short xf) {
    }

    @Override
    public Object clone() {
        RKRecord rec = new RKRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_col = this.field_2_col;
        rec.field_3_xf_index = this.field_3_xf_index;
        rec.field_4_rk_number = this.field_4_rk_number;
        return rec;
    }
}

