/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import okio.Okio;
import okio.Sink;
import okio.Source;

public interface FileSystem {
    public static final FileSystem SYSTEM = new FileSystem(){

        @Override
        public Source source(File file2) throws FileNotFoundException {
            return Okio.source(file2);
        }

        @Override
        public Sink sink(File file2) throws FileNotFoundException {
            try {
                return Okio.sink(file2);
            }
            catch (FileNotFoundException e) {
                file2.getParentFile().mkdirs();
                return Okio.sink(file2);
            }
        }

        @Override
        public Sink appendingSink(File file2) throws FileNotFoundException {
            try {
                return Okio.appendingSink(file2);
            }
            catch (FileNotFoundException e) {
                file2.getParentFile().mkdirs();
                return Okio.appendingSink(file2);
            }
        }

        @Override
        public void delete(File file2) throws IOException {
            if (!file2.delete() && file2.exists()) {
                throw new IOException("failed to delete " + file2);
            }
        }

        @Override
        public boolean exists(File file2) {
            return file2.exists();
        }

        @Override
        public long size(File file2) {
            return file2.length();
        }

        @Override
        public void rename(File from, File to) throws IOException {
            this.delete(to);
            if (!from.renameTo(to)) {
                throw new IOException("failed to rename " + from + " to " + to);
            }
        }

        @Override
        public void deleteContents(File directory) throws IOException {
            File[] files = directory.listFiles();
            if (files == null) {
                throw new IOException("not a readable directory: " + directory);
            }
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    this.deleteContents(file2);
                }
                if (file2.delete()) continue;
                throw new IOException("failed to delete " + file2);
            }
        }
    };

    public Source source(File var1) throws FileNotFoundException;

    public Sink sink(File var1) throws FileNotFoundException;

    public Sink appendingSink(File var1) throws FileNotFoundException;

    public void delete(File var1) throws IOException;

    public boolean exists(File var1);

    public long size(File var1);

    public void rename(File var1, File var2) throws IOException;

    public void deleteContents(File var1) throws IOException;
}

