/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import ome.codecs.BaseCodec;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;
import ome.codecs.MissingLibraryException;
import ome.codecs.UnsupportedCompressionException;
import ome.codecs.services.LuraWaveService;

public class LuraWaveCodec
extends BaseCodec {
    private LuraWaveService service;

    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        throw new UnsupportedCompressionException("LuraWave compression not supported");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        byte[] buf = new byte[(int)in.length()];
        in.read(buf);
        return this.decompress(buf, options);
    }

    @Override
    public byte[] decompress(byte[] buf, CodecOptions options) throws CodecException {
        this.initialize();
        BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(buf), 4096);
        try {
            this.service.initialize(stream);
        }
        catch (DependencyException e) {
            throw new CodecException("No LuraWave license code was specified.\r\nPlease set one in the lurawave.license system property (e.g., with -Dlurawave.license=XXXX from the command line).", e);
        }
        catch (ServiceException e) {
            throw new CodecException("Invalid license code: ", e);
        }
        catch (IOException e) {
            throw new CodecException(e);
        }
        int w = this.service.getWidth();
        int h = this.service.getHeight();
        int nbits = 8 * (options.maxBytes / (w * h));
        if (nbits == 8) {
            byte[] image8 = new byte[w * h];
            try {
                this.service.decodeToMemoryGray8(image8, -1, 1024, 0);
            }
            catch (ServiceException e) {
                throw new CodecException("Invalid license code: ", e);
            }
            return image8;
        }
        if (nbits == 16) {
            short[] image16 = new short[w * h];
            try {
                this.service.decodeToMemoryGray16(image16, 0, -1, 1024, 0, 1, w, 0, 0, w, h);
            }
            catch (ServiceException e) {
                throw new CodecException("Invalid license code: ", e);
            }
            byte[] output = new byte[w * h * 2];
            for (int i = 0; i < image16.length; ++i) {
                DataTools.unpackBytes(image16[i], output, i * 2, 2, true);
            }
            return output;
        }
        throw new CodecException("Unsupported bits per pixel: " + nbits);
    }

    private void initialize() throws CodecException {
        if (this.service != null) {
            return;
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            this.service = factory.getInstance(LuraWaveService.class);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException("The LuraWave decoding library, lwf_jsdk2.6.jar, is required to decode this file.\r\nPlease make sure it is present in your classpath.", e);
        }
    }
}

