/*
 * Decompiled with CFR 0.152.
 */
package ome.units.quantity;

import ome.units.quantity.Quantity;
import ome.units.unit.Unit;

public class Temperature
extends Quantity
implements Comparable<Temperature> {
    private static final int SEED1 = 12;
    private static final int SEED2 = 23;
    Number value;
    Unit<Temperature> unit;
    private int hashCodeValue;

    public Temperature(Number inValue, Unit<Temperature> inUnit) {
        if (inValue == null) {
            throw new NullPointerException("Temperature: Temperature cannot be constructed with a null value.");
        }
        this.value = inValue;
        this.unit = inUnit;
        this.hashCodeValue = 12;
        this.hashCodeValue = 23 * this.hashCodeValue + Float.floatToIntBits(this.value.floatValue());
        this.hashCodeValue = 23 * this.hashCodeValue + this.unit.getSymbol().hashCode();
    }

    @Override
    public Number value() {
        return this.value;
    }

    public Number value(Unit<Temperature> inUnit) {
        if (this.unit.equals(inUnit)) {
            return this.value;
        }
        if (this.unit.isConvertible(inUnit).booleanValue()) {
            return this.unit.convertValue(this.value, inUnit);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Temperature otherTemperature = (Temperature)other;
        if (this.unit.equals(otherTemperature.unit)) {
            return this.value.equals(otherTemperature.value);
        }
        if (this.unit.isConvertible(otherTemperature.unit).booleanValue()) {
            return this.unit.convertValue(this.value, otherTemperature.unit).equals(otherTemperature.value);
        }
        return false;
    }

    @Override
    public int compareTo(Temperature other) {
        if (this == other) {
            return 0;
        }
        return Double.compare(this.value.doubleValue(), other.value(this.unit).doubleValue());
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName());
        result.append(": ");
        result.append("value[");
        result.append(this.value);
        result.append("], unit[");
        result.append(this.unit.getSymbol());
        result.append("] stored as ");
        result.append(this.value.getClass().getName());
        return result.toString();
    }

    public Unit<Temperature> unit() {
        return this.unit;
    }
}

