/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.Umap;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class UmapFloat {
    private final float[][] head_embedding;
    private final float[][] tail_embedding;
    private final int[] head;
    private final int[] tail;
    private final int n_epochs;
    private final int n_vertices;
    private final float[] epochs_per_sample;
    private final float a;
    private final float b;
    private final float initial_alpha;
    private final boolean move_other;
    private float alpha;
    private final float BG2S;
    private final float ABNEG2;
    private final float BNEG1;
    private Random r;
    private final int n_1_simplices;
    private final float[] epochs_per_negative_sample;
    private final float[] epoch_of_next_negative_sample;
    private final float[] epoch_of_next_sample;
    private float nTh;
    private int n_epoch;

    public void randomize() {
        this.r = new Random();
    }

    public float setReports(float f) {
        this.nTh = (float)this.n_epochs / f;
        return this.nTh;
    }

    public float getReports() {
        return this.nTh;
    }

    public UmapFloat(float[][] fArray, float[][] fArray2, int[] nArray, int[] nArray2, int n, int n2, float[] fArray3, float f, float f2, float f3, float f4, int n3) {
        this.head_embedding = fArray;
        this.tail_embedding = fArray2;
        this.head = nArray;
        this.tail = nArray2;
        this.n_epochs = n;
        this.n_vertices = n2;
        this.epochs_per_sample = fArray3;
        this.a = f;
        this.b = f2;
        this.initial_alpha = f4;
        this.move_other = fArray.length == fArray2.length;
        this.alpha = f4;
        this.BG2S = 2.0f * f3 * f2;
        this.ABNEG2 = -2.0f * f * f2;
        this.BNEG1 = f2 - 1.0f;
        this.r = new Random(503L);
        this.n_1_simplices = fArray3.length;
        this.epochs_per_negative_sample = new float[fArray3.length];
        for (int i = 0; i < this.n_1_simplices; ++i) {
            this.epochs_per_negative_sample[i] = fArray3[i] / (float)n3;
        }
        this.epoch_of_next_negative_sample = Arrays.copyOf(this.epochs_per_negative_sample, this.n_1_simplices);
        this.epoch_of_next_sample = Arrays.copyOf(fArray3, this.n_1_simplices);
        this.nTh = (float)n / (float)Umap.EPOCH_REPORTS();
        this.n_epoch = 1;
    }

    public int getEpochsDone() {
        return this.n_epoch;
    }

    public int getEpochsToDo() {
        return this.n_epochs;
    }

    public boolean nextEpochs() {
        return this.nextEpochs(null);
    }

    public boolean nextEpochs(List<Integer> list) {
        int n = 0;
        float[] fArray = new float[]{0.0f, 0.0f};
        float[] fArray2 = new float[]{0.0f, 0.0f};
        int n2 = 0;
        float[] fArray3 = new float[]{0.0f, 0.0f};
        float[] fArray4 = new float[]{0.0f, 0.0f};
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n3 = 0;
        int n4 = 0;
        for (int i = this.n_epoch; i <= this.n_epochs; ++i) {
            for (int j = 0; j < this.n_1_simplices; ++j) {
                if (this.epoch_of_next_sample[j] > (float)i) continue;
                n3 = this.head[j] - 1;
                n4 = this.tail[j] - 1;
                fArray[0] = this.head_embedding[n3][0];
                fArray[1] = this.head_embedding[n3][1];
                fArray2[0] = this.tail_embedding[n4][0];
                fArray2[1] = this.tail_embedding[n4][1];
                fArray4[0] = fArray[0] - fArray2[0];
                fArray4[1] = fArray[1] - fArray2[1];
                f2 = fArray4[0] * fArray4[0] + fArray4[1] * fArray4[1];
                if (f2 > 0.0f) {
                    f = this.ABNEG2 * (float)Math.pow(f2, this.BNEG1) / (this.a * (float)Math.pow(f2, this.b) + 1.0f);
                    f3 = f * fArray4[0];
                    fArray3[0] = (f3 > 4.0f ? 4.0f : (f3 < -4.0f ? -4.0f : f3)) * this.alpha;
                    f3 = f * fArray4[1];
                    fArray3[1] = (f3 > 4.0f ? 4.0f : (f3 < -4.0f ? -4.0f : f3)) * this.alpha;
                    fArray[0] = fArray[0] + fArray3[0];
                    fArray[1] = fArray[1] + fArray3[1];
                    if (this.move_other) {
                        fArray2[0] = fArray2[0] - fArray3[0];
                        fArray2[1] = fArray2[1] - fArray3[1];
                        this.tail_embedding[n4][0] = fArray2[0];
                        this.tail_embedding[n4][1] = fArray2[1];
                    }
                } else {
                    fArray3[0] = 0.0f;
                    fArray3[1] = 0.0f;
                }
                int n5 = j;
                this.epoch_of_next_sample[n5] = this.epoch_of_next_sample[n5] + this.epochs_per_sample[j];
                n2 = (int)Math.floor(((float)i - this.epoch_of_next_negative_sample[j]) / this.epochs_per_negative_sample[j]);
                for (int k = 0; k < n2; ++k) {
                    if (list == null) {
                        n4 = this.r.nextInt(this.n_vertices);
                    } else {
                        if (n >= list.size()) {
                            n = 0;
                        }
                        n4 = list.get(n++);
                    }
                    if (n3 == n4) continue;
                    fArray2[0] = this.tail_embedding[n4][0];
                    fArray2[1] = this.tail_embedding[n4][1];
                    fArray4[0] = fArray[0] - fArray2[0];
                    fArray4[1] = fArray[1] - fArray2[1];
                    f2 = fArray4[0] * fArray4[0] + fArray4[1] * fArray4[1];
                    if (f2 > 0.0f) {
                        f = this.BG2S / (0.001f + f2) / (this.a * (float)Math.pow(f2, this.b) + 1.0f);
                        f3 = f * fArray4[0];
                        fArray3[0] = (f3 > 4.0f ? 4.0f : (f3 < -4.0f ? -4.0f : f3)) * this.alpha;
                        f3 = f * fArray4[1];
                        fArray3[1] = (f3 > 4.0f ? 4.0f : (f3 < -4.0f ? -4.0f : f3)) * this.alpha;
                    } else {
                        fArray3[0] = 4.0f;
                        fArray3[1] = 4.0f;
                    }
                    fArray[0] = fArray[0] + fArray3[0];
                    fArray[1] = fArray[1] + fArray3[1];
                }
                this.head_embedding[n3][0] = fArray[0];
                this.head_embedding[n3][1] = fArray[1];
                int n6 = j;
                this.epoch_of_next_negative_sample[n6] = this.epoch_of_next_negative_sample[n6] + (float)n2 * this.epochs_per_negative_sample[j];
            }
            this.alpha = this.initial_alpha * (1.0f - (float)i / (float)this.n_epochs);
            if (Math.floor((float)i % this.nTh) != 0.0) continue;
            this.n_epoch = i + 1;
            return this.n_epoch >= this.n_epochs;
        }
        return true;
    }

    public float[][] getEmbedding() {
        return this.head_embedding;
    }

    public boolean isFinished() {
        return this.n_epoch >= this.n_epochs;
    }

    public static float[][] Copy(double[][] dArray) {
        int n = dArray.length;
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dArray[i].length;
            fArrayArray[i] = new float[n2];
            for (int j = 0; j < n2; ++j) {
                fArrayArray[i][j] = (float)dArray[i][j];
            }
        }
        return fArrayArray;
    }

    public static float[] Copy(double[] dArray) {
        int n = dArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }
}

