
function [cellid,bc,bc_count,bc_curation]=expand_bc(filt_neurons,cellid)
%given filt_neurons, concatenate all_bc
if ~exist('cellid','var')
    cellid=filt_neurons.id;
end
filt_neurons.total_bc_count=cellfun(@sum,filt_neurons.all_bc_count);

has_bc=filt_neurons.total_bc_count>0;

idx=ismember(filt_neurons.id,cellid);
bc=cell2mat(filt_neurons.all_bc(idx&has_bc));
if isfield(filt_neurons,'curation_filt_bc')
    filt_neurons.curation_filt_bc=cellfun(@(x) x>0,filt_neurons.curation_filt_bc,'UniformOutput',false);
    bc_curation=cell2mat(filt_neurons.curation_filt_bc(idx&has_bc));
else
    bc_curation=cell(numel(cellid),1);
end

try
    bc_count=cell2mat(filt_neurons.all_bc_count(idx&has_bc)')';
    
catch
    bc_count=cell2mat(filt_neurons.all_bc_count(idx&has_bc));
end
    
cellid=cellfun(@(x,y) repmat(x,numel(y),1), ...
     num2cell(filt_neurons.id(idx&has_bc)), ...
     filt_neurons.all_bc_count(idx&has_bc), ...
     'UniformOutput',0);
cellid=cell2mat(cellid);

end