/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class StochasticGradientDescent {
    public final int n_components;
    private final double[][] head_embedding;
    private final double[][] tail_embedding;
    private final int[] head;
    private final int[] tail;
    private final int n_epochs;
    private final int n_vertices;
    private final double[] epochs_per_sample;
    private final double a;
    private final double b;
    private final double initial_alpha;
    public boolean move_other;
    private double alpha;
    private final double BG2S;
    private final double ABNEG2;
    private final double BNEG1;
    private Random r;
    private final int n_1_simplices;
    private final double[] epochs_per_negative_sample;
    private final double[] epoch_of_next_negative_sample;
    private final double[] epoch_of_next_sample;
    private double nTh;
    private int n_epoch;
    static final boolean DEBUG_RANDI = false;
    static final boolean DEBUG_STATIC_AND_INSTANCE = false;

    public void randomize() {
        this.r = new Random();
    }

    public double setReports(double d) {
        this.nTh = (double)this.n_epochs / d;
        return this.nTh;
    }

    public double getReports() {
        return this.nTh;
    }

    public StochasticGradientDescent(double[][] dArray, double[][] dArray2, int[] nArray, int[] nArray2, int n, int n2, double[] dArray3, double d, double d2, double d3, double d4, int n3) {
        this.head_embedding = dArray;
        this.tail_embedding = dArray2;
        this.head = nArray;
        this.tail = nArray2;
        this.n_epochs = n;
        this.n_vertices = n2;
        this.epochs_per_sample = dArray3;
        this.a = d;
        this.b = d2;
        this.initial_alpha = d4;
        this.n_components = dArray.length > 0 ? dArray[0].length : 0;
        this.move_other = dArray.length == dArray2.length;
        this.alpha = d4;
        this.BG2S = 2.0 * d3 * d2;
        this.ABNEG2 = -2.0 * d * d2;
        this.BNEG1 = d2 - 1.0;
        this.r = new Random(503L);
        this.n_1_simplices = dArray3.length;
        this.epochs_per_negative_sample = new double[dArray3.length];
        for (int i = 0; i < this.n_1_simplices; ++i) {
            this.epochs_per_negative_sample[i] = dArray3[i] / (double)n3;
        }
        this.epoch_of_next_negative_sample = Arrays.copyOf(this.epochs_per_negative_sample, this.n_1_simplices);
        this.epoch_of_next_sample = Arrays.copyOf(dArray3, this.n_1_simplices);
        this.nTh = (double)n / (double)StochasticGradientDescent.EPOCH_REPORTS();
        this.n_epoch = 1;
    }

    public int getEpochsDone() {
        return this.n_epoch;
    }

    public int getEpochsToDo() {
        return this.n_epochs;
    }

    public boolean nextEpochs() {
        return this.nextEpochs(null);
    }

    public boolean nextEpochs(List<Integer> list) {
        int n = 0;
        double[] dArray = new double[this.n_components];
        double[] dArray2 = new double[this.n_components];
        int n2 = 0;
        double[] dArray3 = new double[this.n_components];
        double[] dArray4 = new double[this.n_components];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.alpha * 4.0;
        double d5 = this.alpha * -4.0;
        for (int i = this.n_epoch; i <= this.n_epochs; ++i) {
            for (int j = 0; j < this.n_1_simplices; ++j) {
                int n3;
                if (this.epoch_of_next_sample[j] > (double)i) continue;
                int n4 = this.head[j] - 1;
                int n5 = this.tail[j] - 1;
                for (n3 = 0; n3 < this.n_components; ++n3) {
                    dArray[n3] = this.head_embedding[n4][n3];
                    dArray2[n3] = this.tail_embedding[n5][n3];
                    dArray4[n3] = dArray[n3] - dArray2[n3];
                }
                d2 = 0.0;
                for (n3 = 0; n3 < this.n_components; ++n3) {
                    d2 += dArray4[n3] * dArray4[n3];
                }
                if (d2 > 0.0) {
                    d = this.ABNEG2 * Math.pow(d2, this.BNEG1) / (this.a * Math.pow(d2, this.b) + 1.0);
                    for (n3 = 0; n3 < this.n_components; ++n3) {
                        d3 = d * dArray4[n3];
                        dArray3[n3] = d3 >= 4.0 ? d4 : (d3 <= -4.0 ? d5 : d3 * this.alpha);
                        dArray[n3] = dArray[n3] + dArray3[n3];
                    }
                    if (this.move_other) {
                        for (n3 = 0; n3 < this.n_components; ++n3) {
                            dArray2[n3] = dArray2[n3] - dArray3[n3];
                            this.tail_embedding[n5][n3] = dArray2[n3];
                        }
                    }
                } else {
                    for (n3 = 0; n3 < this.n_components; ++n3) {
                        dArray3[n3] = 0.0;
                    }
                }
                int n6 = j;
                this.epoch_of_next_sample[n6] = this.epoch_of_next_sample[n6] + this.epochs_per_sample[j];
                n2 = (int)Math.floor(((double)i - this.epoch_of_next_negative_sample[j]) / this.epochs_per_negative_sample[j]);
                for (n3 = 0; n3 < n2; ++n3) {
                    int n7;
                    if (list == null) {
                        n5 = this.r.nextInt(this.n_vertices);
                    } else {
                        if (n >= list.size()) {
                            n = 0;
                        }
                        n5 = list.get(n++);
                    }
                    if (n4 == n5) continue;
                    d2 = 0.0;
                    for (n7 = 0; n7 < this.n_components; ++n7) {
                        dArray2[n7] = this.tail_embedding[n5][n7];
                        dArray4[n7] = dArray[n7] - dArray2[n7];
                        d2 += dArray4[n7] * dArray4[n7];
                    }
                    if (d2 > 0.0) {
                        d = this.BG2S / (0.001 + d2) / (this.a * Math.pow(d2, this.b) + 1.0);
                        for (n7 = 0; n7 < this.n_components; ++n7) {
                            d3 = d * dArray4[n7];
                            dArray3[n7] = d3 >= 4.0 ? d4 : (d3 <= -4.0 ? d5 : d3 * this.alpha);
                        }
                    } else {
                        for (n7 = 0; n7 < this.n_components; ++n7) {
                            dArray3[n7] = 4.0;
                        }
                    }
                    for (n7 = 0; n7 < this.n_components; ++n7) {
                        dArray[n7] = dArray[n7] + dArray3[n7];
                    }
                }
                for (n3 = 0; n3 < this.n_components; ++n3) {
                    this.head_embedding[n4][n3] = dArray[n3];
                }
                int n8 = j;
                this.epoch_of_next_negative_sample[n8] = this.epoch_of_next_negative_sample[n8] + (double)n2 * this.epochs_per_negative_sample[j];
            }
            this.alpha = this.initial_alpha * (1.0 - (double)i / (double)this.n_epochs);
            d4 = this.alpha * 4.0;
            d5 = this.alpha * -4.0;
            if (Math.floor((double)i % this.nTh) != 0.0) continue;
            this.n_epoch = i + 1;
            return this.n_epoch >= this.n_epochs;
        }
        return true;
    }

    public double[][] getEmbedding() {
        return this.head_embedding;
    }

    public boolean isFinished() {
        return this.n_epoch >= this.n_epochs;
    }

    public static final int EPOCH_REPORTS() {
        return 20;
    }

    public static double[][] Copy(double[][] dArray) {
        int n = dArray.length;
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < n; ++i) {
            int n2 = dArray[i].length;
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArrayArray[i][j] = dArray[i][j];
            }
        }
        return dArrayArray;
    }
}

