/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class Umap {
    private final double[][] head_embedding;
    private final double[][] tail_embedding;
    private final int[] head;
    private final int[] tail;
    private final int n_epochs;
    private final int n_vertices;
    private final double[] epochs_per_sample;
    private final double a;
    private final double b;
    private final double initial_alpha;
    public boolean move_other;
    private double alpha;
    private final double BG2S;
    private final double ABNEG2;
    private final double BNEG1;
    private Random r;
    private final int n_1_simplices;
    private final double[] epochs_per_negative_sample;
    private final double[] epoch_of_next_negative_sample;
    private final double[] epoch_of_next_sample;
    private double nTh;
    private int n_epoch;
    static final boolean DEBUG_RANDI = false;
    static final boolean DEBUG_STATIC_AND_INSTANCE = false;
    static boolean DEBUG_PRINT = true;

    public void randomize() {
        this.r = new Random();
    }

    public double setReports(double d) {
        this.nTh = (double)this.n_epochs / d;
        return this.nTh;
    }

    public double getReports() {
        return this.nTh;
    }

    public Umap(double[][] dArray, double[][] dArray2, int[] nArray, int[] nArray2, int n, int n2, double[] dArray3, double d, double d2, double d3, double d4, int n3) {
        this.head_embedding = dArray;
        this.tail_embedding = dArray2;
        this.head = nArray;
        this.tail = nArray2;
        this.n_epochs = n;
        this.n_vertices = n2;
        this.epochs_per_sample = dArray3;
        this.a = d;
        this.b = d2;
        this.initial_alpha = d4;
        this.move_other = dArray.length == dArray2.length;
        this.alpha = d4;
        this.BG2S = 2.0 * d3 * d2;
        this.ABNEG2 = -2.0 * d * d2;
        this.BNEG1 = d2 - 1.0;
        this.r = new Random(503L);
        this.n_1_simplices = dArray3.length;
        this.epochs_per_negative_sample = new double[dArray3.length];
        for (int i = 0; i < this.n_1_simplices; ++i) {
            this.epochs_per_negative_sample[i] = dArray3[i] / (double)n3;
        }
        this.epoch_of_next_negative_sample = Arrays.copyOf(this.epochs_per_negative_sample, this.n_1_simplices);
        this.epoch_of_next_sample = Arrays.copyOf(dArray3, this.n_1_simplices);
        this.nTh = (double)n / (double)Umap.EPOCH_REPORTS();
        this.n_epoch = 1;
    }

    public int getEpochsDone() {
        return this.n_epoch;
    }

    public int getEpochsToDo() {
        return this.n_epochs;
    }

    public boolean nextEpochs() {
        return this.nextEpochs(null);
    }

    public boolean nextEpochs(List<Integer> list) {
        int n = 0;
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0};
        int n2 = 0;
        double[] dArray3 = new double[]{0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0};
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = this.n_epoch; i <= this.n_epochs; ++i) {
            for (int j = 0; j < this.n_1_simplices; ++j) {
                if (this.epoch_of_next_sample[j] > (double)i) continue;
                int n3 = this.head[j] - 1;
                int n4 = this.tail[j] - 1;
                dArray[0] = this.head_embedding[n3][0];
                dArray[1] = this.head_embedding[n3][1];
                dArray2[0] = this.tail_embedding[n4][0];
                dArray2[1] = this.tail_embedding[n4][1];
                dArray4[0] = dArray[0] - dArray2[0];
                dArray4[1] = dArray[1] - dArray2[1];
                d2 = dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1];
                if (d2 > 0.0) {
                    d = this.ABNEG2 * Math.pow(d2, this.BNEG1) / (this.a * Math.pow(d2, this.b) + 1.0);
                    d3 = d * dArray4[0];
                    dArray3[0] = (d3 > 4.0 ? 4.0 : (d3 < -4.0 ? -4.0 : d3)) * this.alpha;
                    d3 = d * dArray4[1];
                    dArray3[1] = (d3 > 4.0 ? 4.0 : (d3 < -4.0 ? -4.0 : d3)) * this.alpha;
                    dArray[0] = dArray[0] + dArray3[0];
                    dArray[1] = dArray[1] + dArray3[1];
                    if (this.move_other) {
                        dArray2[0] = dArray2[0] - dArray3[0];
                        dArray2[1] = dArray2[1] - dArray3[1];
                        this.tail_embedding[n4][0] = dArray2[0];
                        this.tail_embedding[n4][1] = dArray2[1];
                    }
                } else {
                    dArray3[0] = 0.0;
                    dArray3[1] = 0.0;
                }
                int n5 = j;
                this.epoch_of_next_sample[n5] = this.epoch_of_next_sample[n5] + this.epochs_per_sample[j];
                n2 = (int)Math.floor(((double)i - this.epoch_of_next_negative_sample[j]) / this.epochs_per_negative_sample[j]);
                for (int k = 0; k < n2; ++k) {
                    if (list == null) {
                        n4 = this.r.nextInt(this.n_vertices);
                    } else {
                        if (n >= list.size()) {
                            n = 0;
                        }
                        n4 = list.get(n++);
                    }
                    if (n3 == n4) continue;
                    dArray2[0] = this.tail_embedding[n4][0];
                    dArray2[1] = this.tail_embedding[n4][1];
                    dArray4[0] = dArray[0] - dArray2[0];
                    dArray4[1] = dArray[1] - dArray2[1];
                    d2 = dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1];
                    if (d2 > 0.0) {
                        d = this.BG2S / (0.001 + d2) / (this.a * Math.pow(d2, this.b) + 1.0);
                        d3 = d * dArray4[0];
                        dArray3[0] = (d3 > 4.0 ? 4.0 : (d3 < -4.0 ? -4.0 : d3)) * this.alpha;
                        d3 = d * dArray4[1];
                        dArray3[1] = (d3 > 4.0 ? 4.0 : (d3 < -4.0 ? -4.0 : d3)) * this.alpha;
                    } else {
                        dArray3[0] = 4.0;
                        dArray3[1] = 4.0;
                    }
                    dArray[0] = dArray[0] + dArray3[0];
                    dArray[1] = dArray[1] + dArray3[1];
                }
                this.head_embedding[n3][0] = dArray[0];
                this.head_embedding[n3][1] = dArray[1];
                int n6 = j;
                this.epoch_of_next_negative_sample[n6] = this.epoch_of_next_negative_sample[n6] + (double)n2 * this.epochs_per_negative_sample[j];
                DEBUG_PRINT = false;
            }
            this.alpha = this.initial_alpha * (1.0 - (double)i / (double)this.n_epochs);
            if (Math.floor((double)i % this.nTh) != 0.0) continue;
            this.n_epoch = i + 1;
            return this.n_epoch >= this.n_epochs;
        }
        return true;
    }

    public double[][] getEmbedding() {
        return this.head_embedding;
    }

    public boolean isFinished() {
        return this.n_epoch >= this.n_epochs;
    }

    public static final int EPOCH_REPORTS() {
        return 20;
    }

    public static double[][] Copy(double[][] dArray) {
        int n = dArray.length;
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < n; ++i) {
            int n2 = dArray[i].length;
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArrayArray[i][j] = dArray[i][j];
            }
        }
        return dArrayArray;
    }

    public static double[][] optimize_layout(double[][] dArray, double[][] dArray2, int[] nArray, int[] nArray2, int n, int n2, double[] dArray3, double d, double d2, double d3, double d4, int n3, Object object, List<Integer> list) {
        boolean bl;
        JProgressBar jProgressBar;
        JLabel jLabel;
        Object var18_14 = null;
        Object var19_15 = null;
        ArrayList arrayList = new ArrayList();
        int n4 = 0;
        boolean bl2 = false;
        if (object instanceof JLabel) {
            jLabel = (JLabel)object;
            jProgressBar = null;
            bl = true;
        } else if (object instanceof JProgressBar) {
            jLabel = null;
            jProgressBar = (JProgressBar)object;
            jProgressBar.setMaximum(n + 1);
            bl = true;
        } else {
            jLabel = null;
            jProgressBar = null;
            bl = object instanceof Boolean ? (Boolean)object : false;
        }
        if (bl) {
            Umap.report(jLabel, jProgressBar, 1.0, "\t0/" + n + " epochs done");
        }
        boolean bl3 = dArray.length == dArray2.length;
        double d5 = d4;
        double d6 = 2.0 * d3 * d2;
        double d7 = -2.0 * d * d2;
        double d8 = d2 - 1.0;
        Random random = new Random(503L);
        int n5 = dArray3.length;
        double[] dArray4 = new double[dArray3.length];
        for (int i = 0; i < n5; ++i) {
            dArray4[i] = dArray3[i] / (double)n3;
        }
        double[] dArray5 = Arrays.copyOf(dArray4, n5);
        double[] dArray6 = Arrays.copyOf(dArray3, n5);
        double[] dArray7 = new double[]{0.0, 0.0};
        double[] dArray8 = new double[]{0.0, 0.0};
        double[] dArray9 = new double[]{0.0, 0.0};
        double[] dArray10 = new double[]{0.0, 0.0};
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = (double)n / (double)Umap.EPOCH_REPORTS();
        int n6 = 0;
        int n7 = 0;
        for (int i = 1; i <= n; ++i) {
            double d13;
            double d14;
            for (int j = 0; j < n5; ++j) {
                if (dArray6[j] > (double)i) continue;
                n6 = nArray[j] - 1;
                n7 = nArray2[j] - 1;
                dArray7[0] = dArray[n6][0];
                dArray7[1] = dArray[n6][1];
                dArray8[0] = dArray2[n7][0];
                dArray8[1] = dArray2[n7][1];
                dArray10[0] = dArray7[0] - dArray8[0];
                dArray10[1] = dArray7[1] - dArray8[1];
                d10 = dArray10[0] * dArray10[0] + dArray10[1] * dArray10[1];
                if (d10 > 0.0) {
                    d9 = d7 * Math.pow(d10, d8) / (d * Math.pow(d10, d2) + 1.0);
                    d11 = d9 * dArray10[0];
                    dArray9[0] = (d11 > 4.0 ? 4.0 : (d11 < -4.0 ? -4.0 : d11)) * d5;
                    d11 = d9 * dArray10[1];
                    dArray9[1] = (d11 > 4.0 ? 4.0 : (d11 < -4.0 ? -4.0 : d11)) * d5;
                    dArray7[0] = dArray7[0] + dArray9[0];
                    dArray7[1] = dArray7[1] + dArray9[1];
                    if (bl3) {
                        dArray8[0] = dArray8[0] - dArray9[0];
                        dArray8[1] = dArray8[1] - dArray9[1];
                        dArray2[n7][0] = dArray8[0];
                        dArray2[n7][1] = dArray8[1];
                    }
                } else {
                    dArray9[0] = 0.0;
                    dArray9[1] = 0.0;
                }
                int n8 = j;
                dArray6[n8] = dArray6[n8] + dArray3[j];
                n4 = (int)Math.floor(((double)i - dArray5[j]) / dArray4[j]);
                for (int k = 0; k < n4; ++k) {
                    n7 = random.nextInt(n2);
                    if (n6 == n7) continue;
                    dArray8[0] = dArray2[n7][0];
                    dArray8[1] = dArray2[n7][1];
                    dArray10[0] = dArray7[0] - dArray8[0];
                    dArray10[1] = dArray7[1] - dArray8[1];
                    d10 = dArray10[0] * dArray10[0] + dArray10[1] * dArray10[1];
                    if (d10 > 0.0) {
                        d9 = d6 / (0.001 + d10) / (d * Math.pow(d10, d2) + 1.0);
                        d11 = d9 * dArray10[0];
                        dArray9[0] = (d11 > 4.0 ? 4.0 : (d11 < -4.0 ? -4.0 : d11)) * d5;
                        d11 = d9 * dArray10[1];
                        dArray9[1] = (d11 > 4.0 ? 4.0 : (d11 < -4.0 ? -4.0 : d11)) * d5;
                    } else {
                        dArray9[0] = 4.0;
                        dArray9[1] = 4.0;
                    }
                    dArray7[0] = dArray7[0] + dArray9[0];
                    dArray7[1] = dArray7[1] + dArray9[1];
                }
                dArray[n6][0] = dArray7[0];
                dArray[n6][1] = dArray7[1];
                int n9 = j;
                dArray5[n9] = dArray5[n9] + (double)n4 * dArray4[j];
                DEBUG_PRINT = false;
            }
            d5 = d4 * (1.0 - (double)i / (double)n);
            if (!bl || Math.floor(d14 = (double)i % d12) != 0.0 || Umap.report(jLabel, jProgressBar, (d13 = (double)i / d12) * d12, i + "/" + n + " epochs done")) continue;
            return null;
        }
        return dArray;
    }

    private int findMisMatch(double[][] dArray) {
        int n = 0;
        for (int i = 0; i < this.head_embedding.length; ++i) {
            for (int j = 0; j < this.head_embedding[0].length; ++j) {
                double d = dArray[i][j];
                double d2 = this.head_embedding[i][j];
                if (d == d2) continue;
                System.out.println("Yeeeouch!! row=" + i + ", col=" + j);
                ++n;
            }
        }
        return n;
    }

    static boolean report(final JLabel jLabel, final JProgressBar jProgressBar, final double d, final String string) {
        boolean bl = true;
        if (jProgressBar != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            jProgressBar.setValue((int)d);
                            jProgressBar.setString(string);
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                System.out.print("Event dispatch ");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jProgressBar.setValue((int)d);
                        jProgressBar.setString(string);
                    }
                });
            }
        } else if (jLabel != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                System.out.print("NOT Event dispatch ");
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            jLabel.setText(string);
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                System.out.print("Event dispatch ");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jLabel.setText(string);
                    }
                });
            }
        }
        System.out.println("\t" + string);
        return bl;
    }
}

