/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.transform;

import edu.stanford.facs.transform.Transform;
import edu.stanford.facs.transform.TransformParameterException;

public class Arcsinh
extends Transform {
    public final double T;
    public final double M;
    public final double A;
    public final double a;
    public final double b;
    public final double c;

    public Arcsinh(double d, double d2, double d3, int n) {
        if (d <= 0.0) {
            throw new TransformParameterException("T is not positive");
        }
        if (d2 <= 0.0) {
            throw new TransformParameterException("M is not positive");
        }
        if (d3 < 0.0) {
            throw new TransformParameterException("A is negative");
        }
        if (d3 > d2) {
            throw new TransformParameterException("A is greater than M");
        }
        this.T = d;
        this.M = d2;
        this.A = d3;
        this.b = (d2 + d3) * LN_10;
        this.c = d3 * LN_10;
        this.a = d / Math.sinh(this.b - this.c);
    }

    public Arcsinh(double d, double d2, double d3) {
        this(d, d2, d3, 0);
    }

    @Override
    public double scale(double d) {
        boolean bl;
        double d2 = d / this.a;
        boolean bl2 = bl = d2 < 0.0;
        if (bl) {
            d2 = -d2;
        }
        double d3 = Math.log(d2 + Math.sqrt(d2 * d2 + 1.0));
        if (bl) {
            return (this.c - d3) / this.b;
        }
        return (d3 + this.c) / this.b;
    }

    @Override
    public double inverse(double d) {
        return this.a * Math.sinh(this.b * d - this.c);
    }

    @Override
    protected double slope(double d) {
        return this.a * this.b * Math.cosh(this.b * d - this.c);
    }

    @Override
    public double[] axisLabels() {
        int n;
        int n2;
        double d = Math.ceil(Math.log(this.T) / LN_10 - this.M);
        double d2 = Math.exp(LN_10 * d);
        if (d2 > this.T) {
            d2 = this.T;
            n2 = 1;
        } else {
            n2 = (int)Math.floor(Math.log(this.T) / LN_10 - d) + 1;
        }
        double d3 = this.inverse(0.0);
        int n3 = d2 > -d3 ? 0 : (d2 == this.T ? 1 : (int)Math.floor(Math.log(-d3) / LN_10 - d) + 1);
        double[] dArray = new double[n3 + n2 + 1];
        dArray[n3] = 0.0;
        for (n = 1; n <= n3; ++n) {
            dArray[n3 - n] = -d2;
            dArray[n3 + n] = d2;
            d2 *= 10.0;
        }
        for (n = n3 + 1; n <= n2; ++n) {
            dArray[n3 + n] = d2;
            d2 *= 10.0;
        }
        return dArray;
    }
}

