/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.transform;

import edu.stanford.facs.transform.Transform;
import edu.stanford.facs.transform.TransformParameterException;

public class Hyperlog
extends Transform {
    public final double T;
    public final double W;
    public final double M;
    public final double A;
    public final double a;
    public final double b;
    public final double c;
    public final double f;
    public final double w;
    public final double x0;
    public final double x1;
    public final double x2;
    protected final double xTaylor;
    protected final double[] taylor;
    private final double inverse_x0;

    public Hyperlog(double d, double d2, double d3, double d4, int n) {
        double d5;
        if (d <= 0.0) {
            throw new TransformParameterException("T is not positive");
        }
        if (d2 < 0.0) {
            throw new TransformParameterException("W is negative");
        }
        if (d3 <= 0.0) {
            throw new TransformParameterException("M is not positive");
        }
        if (d2 <= 0.0) {
            throw new TransformParameterException("W is not positive");
        }
        if (2.0 * d2 > d3) {
            throw new TransformParameterException("W is too large");
        }
        if (-d4 > d2 || d4 + d2 > d3 - d2) {
            throw new TransformParameterException("A is too large");
        }
        if (n > 0) {
            d5 = (d2 + d4) / (d3 + d4);
            d5 = Math.rint(d5 * (double)n) / (double)n;
            d4 = (d3 * d5 - d2) / (1.0 - d5);
        }
        this.T = d;
        this.M = d3;
        this.W = d2;
        this.A = d4;
        this.w = d2 / (d3 + d4);
        this.x2 = d4 / (d3 + d4);
        this.x1 = this.x2 + this.w;
        this.x0 = this.x2 + 2.0 * this.w;
        this.b = (d3 + d4) * LN_10;
        d5 = Math.exp(this.b * this.x0);
        double d6 = d5 / this.w;
        double d7 = Math.exp(this.b * this.x1) + d6 * this.x1;
        this.a = d / (Math.exp(this.b) + d6 - d7);
        this.c = d6 * this.a;
        this.f = d7 * this.a;
        this.xTaylor = this.x1 + this.w / 4.0;
        double d8 = this.a * Math.exp(this.b * this.x1);
        this.taylor = new double[16];
        for (int i = 0; i < this.taylor.length; ++i) {
            this.taylor[i] = d8 *= this.b / (double)(i + 1);
        }
        this.taylor[0] = this.taylor[0] + this.c;
        this.inverse_x0 = this.inverse(this.x0);
    }

    public Hyperlog(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, 0);
    }

    public Hyperlog(double d, double d2, double d3) {
        this(d, d2, d3, 0.0);
    }

    public Hyperlog(double d, double d2) {
        this(d, d2, 4.5, 0.0);
    }

    protected double taylorSeries(double d) {
        double d2 = d - this.x1;
        double d3 = this.taylor[this.taylor.length - 1] * d2;
        for (int i = this.taylor.length - 2; i >= 0; --i) {
            d3 = (d3 + this.taylor[i]) * d2;
        }
        return d3;
    }

    @Override
    public double scale(double d) {
        boolean bl;
        if (d == 0.0) {
            return this.x1;
        }
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d2 = d < this.inverse_x0 ? this.x1 + d * this.w / this.inverse_x0 : Math.log(d / this.a) / this.b;
        double d3 = 3.0 * Math.ulp(1.0);
        if (d2 > 1.0) {
            d3 = 3.0 * Math.ulp(d2);
        }
        for (int i = 0; i < 10; ++i) {
            double d4 = this.a * Math.exp(this.b * d2);
            double d5 = d2 < this.xTaylor ? this.taylorSeries(d2) - d : d4 + this.c * d2 - (this.f + d);
            double d6 = this.b * d4;
            double d7 = d6 + this.c;
            double d8 = this.b * d6;
            double d9 = d5 / (d7 * (1.0 - d5 * d8 / (2.0 * d7 * d7)));
            d2 -= d9;
            if (!(Math.abs(d9) < d3)) continue;
            if (bl) {
                return 2.0 * this.x1 - d2;
            }
            return d2;
        }
        throw new IllegalStateException("scale() didn't converge");
    }

    @Override
    public double inverse(double d) {
        boolean bl;
        boolean bl2 = bl = d < this.x1;
        if (bl) {
            d = 2.0 * this.x1 - d;
        }
        double d2 = d < this.xTaylor ? this.taylorSeries(d) : this.a * Math.exp(this.b * d) + this.c * d - this.f;
        if (bl) {
            return -d2;
        }
        return d2;
    }

    @Override
    protected double slope(double d) {
        if (d < this.x1) {
            d = 2.0 * this.x1 - d;
        }
        return this.a * this.b * Math.exp(this.b * d) + this.c;
    }

    @Override
    public double[] axisLabels() {
        int n;
        int n2;
        double d = this.M - 2.0 * this.W;
        double d2 = Math.ceil(Math.log(this.T) / LN_10 - d);
        double d3 = Math.exp(LN_10 * d2);
        if (d3 > this.T) {
            d3 = this.T;
            n2 = 1;
        } else {
            n2 = (int)Math.floor(Math.log(this.T) / LN_10 - d2) + 1;
        }
        double d4 = this.inverse(0.0);
        int n3 = d3 > -d4 ? 0 : (d3 == this.T ? 1 : (int)Math.floor(Math.log(-d4) / LN_10 - d2) + 1);
        double[] dArray = new double[n3 + n2 + 1];
        dArray[n3] = 0.0;
        for (n = 1; n <= n3; ++n) {
            dArray[n3 - n] = -d3;
            dArray[n3 + n] = d3;
            d3 *= 10.0;
        }
        for (n = n3 + 1; n <= n2; ++n) {
            dArray[n3 + n] = d3;
            d3 *= 10.0;
        }
        return dArray;
    }
}

