/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.transform;

import edu.stanford.facs.transform.Transform;
import edu.stanford.facs.transform.TransformParameterException;

public class Linear
extends Transform {
    public final double T;
    public final double A;
    public final double a;
    public final double b;
    public final double range;

    public Linear(double d, double d2, int n) {
        if (d <= 0.0) {
            throw new TransformParameterException("T is not positive");
        }
        if (d < d2) {
            throw new TransformParameterException("T is less than A");
        }
        this.T = d;
        this.A = d2;
        this.a = d + d2;
        this.b = -d2;
        this.range = d - d2;
    }

    public Linear(double d, double d2) {
        this(d, d2, 0);
    }

    public Linear(double d) {
        this(d, 0.0, 0);
    }

    @Override
    public double scale(double d) {
        return (d - this.A) / this.range;
    }

    @Override
    public double inverse(double d) {
        return this.range * d + this.A;
    }

    @Override
    protected double slope(double d) {
        return this.a;
    }

    @Override
    public double[] axisLabels() {
        int n;
        double d = this.T - this.A;
        double d2 = Math.floor(Math.log(d) / LN_10);
        double d3 = Math.exp(d2 * LN_10);
        double d4 = d / d3;
        if (d4 <= 1.2) {
            d3 /= 5.0;
        } else if (d4 <= 1.5) {
            d3 /= 4.0;
        } else if (d4 <= 3.0) {
            d3 /= 2.0;
        } else if (d4 >= 7.0) {
            d3 *= 2.0;
        }
        int n2 = (int)Math.floor(this.T / d3);
        int n3 = (int)Math.floor(this.A / d3);
        double[] dArray = new double[n3 + n2 + 1];
        dArray[n3] = 0.0;
        for (n = 1; n <= n3; ++n) {
            dArray[n3 - n] = -d3 * (double)n;
            dArray[n3 + n] = d3 * (double)n;
        }
        for (n = n3 + 1; n <= n2; ++n) {
            dArray[n3 + n] = d3 * (double)n;
        }
        return dArray;
    }
}

