/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.transform;

import edu.stanford.facs.transform.Transform;
import edu.stanford.facs.transform.TransformParameterException;

public class Logarithmic
extends Transform {
    public final double T;
    public final double M;
    public final double a;
    public final double b;

    public Logarithmic(double d, double d2, int n) {
        if (d <= 0.0) {
            throw new TransformParameterException("T is not positive");
        }
        if (d2 <= 0.0) {
            throw new TransformParameterException("M is not positive");
        }
        this.T = d;
        this.M = d2;
        this.b = d2 * LN_10;
        this.a = d / Math.exp(this.b);
    }

    public Logarithmic(double d, double d2) {
        this(d, d2, 0);
    }

    public Logarithmic(double d) {
        this(d, 4.5, 0);
    }

    @Override
    public double scale(double d) {
        return Math.log(d / this.a) / this.b;
    }

    @Override
    public double inverse(double d) {
        return this.a * Math.exp(this.b * d);
    }

    @Override
    protected double slope(double d) {
        return this.a * this.b * Math.exp(this.b * d);
    }

    @Override
    public double[] axisLabels() {
        int n;
        double d = Math.ceil(Math.log(this.T) / LN_10 - this.M);
        double d2 = Math.exp(LN_10 * d);
        if (d2 > this.T) {
            d2 = this.T;
            n = 0;
        } else {
            n = (int)Math.floor(Math.log(this.T) / LN_10 - d);
        }
        double[] dArray = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray[i] = d2;
            d2 *= 10.0;
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        Logarithmic logarithmic = new Logarithmic(262144.0, 5.41853992);
        logarithmic.scale(100000.0);
    }
}

