/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class GIFReader
extends FormatReader {
    public static final String GIF_MAGIC_STRING = "GIF";
    private static final int MAX_STACK_SIZE = 4096;
    private static final int IMAGE_SEPARATOR = 44;
    private static final int EXTENSION = 33;
    private static final int END = 59;
    private static final int GRAPHICS = 249;
    private int[] gct;
    private int[] act;
    private boolean interlace;
    private int ix;
    private int iy;
    private int iw;
    private int ih;
    private byte[] dBlock = new byte[256];
    private int blockSize = 0;
    private int dispose = 0;
    private int lastDispose = 0;
    private boolean transparency = false;
    private int transIndex;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] pixels;
    private Vector<byte[]> images;
    private Vector<int[]> colorTables;
    private transient Set<Integer> planesRead = new HashSet<Integer>();

    public GIFReader() {
        super("Graphics Interchange Format", "gif");
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = GIF_MAGIC_STRING.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).startsWith(GIF_MAGIC_STRING);
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[][] table = new byte[3][this.act.length];
        for (int i = 0; i < this.act.length; ++i) {
            table[0][i] = (byte)(this.act[i] >> 16 & 0xFF);
            table[1][i] = (byte)(this.act[i] >> 8 & 0xFF);
            table[2][i] = (byte)(this.act[i] & 0xFF);
        }
        return table;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.act = this.colorTables.get(no);
        byte[] b = this.images.get(no);
        if (no > 0 && this.transparency && !this.planesRead.contains(no)) {
            byte[] prev = this.planesRead.contains(no - 1) ? this.images.get(no - 1) : this.openBytes(no - 1);
            int idx = this.transIndex;
            if (idx >= 127) {
                idx = 0;
            }
            for (int i = 0; i < b.length; ++i) {
                if ((this.act[b[i] & 0xFF] & 0xFFFFFF) != idx) continue;
                b[i] = prev[i];
            }
            this.images.setElementAt(b, no);
        }
        this.planesRead.add(no);
        for (int row = 0; row < h; ++row) {
            System.arraycopy(b, (row + y) * this.getSizeX() + x, buf, row * w, w);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.transparency = false;
            this.interlace = false;
            this.blockSize = 0;
            this.ih = 0;
            this.iw = 0;
            this.iy = 0;
            this.ix = 0;
            this.transIndex = 0;
            this.lastDispose = 0;
            this.dispose = 0;
            this.gct = this.act;
            this.prefix = null;
            this.pixels = null;
            this.pixelStack = null;
            this.suffix = null;
            this.images = null;
            this.colorTables = null;
            Arrays.fill(this.dBlock, (byte)0);
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        LOGGER.info("Verifying GIF format");
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        this.images = new Vector();
        this.colorTables = new Vector();
        String ident = this.in.readString(6);
        if (!ident.startsWith(GIF_MAGIC_STRING)) {
            throw new FormatException("Not a valid GIF file.");
        }
        LOGGER.info("Reading dimensions");
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.sizeX = this.in.readShort();
        m.sizeY = this.in.readShort();
        int packed = this.in.read() & 0xFF;
        boolean gctFlag = (packed & 0x80) != 0;
        int gctSize = 2 << (packed & 7);
        this.in.skipBytes(2);
        this.addGlobalMeta("Global lookup table size", gctSize);
        if (gctFlag) {
            this.gct = this.readLut(gctSize);
        }
        LOGGER.info("Reading data blocks");
        boolean done = false;
        while (!done) {
            int code = this.in.read() & 0xFF;
            block0 : switch (code) {
                case 44: {
                    this.readImageBlock();
                    break;
                }
                case 33: {
                    code = this.in.read() & 0xFF;
                    switch (code) {
                        case 249: {
                            this.in.skipBytes(1);
                            packed = this.in.read() & 0xFF;
                            this.dispose = (packed & 0x1C) >> 1;
                            this.transparency = (packed & 1) != 0;
                            this.in.skipBytes(2);
                            this.transIndex = this.in.read() & 0xFF;
                            this.in.skipBytes(1);
                            break block0;
                        }
                    }
                    if (this.readBlock() == -1) {
                        done = true;
                        break;
                    }
                    this.skipBlocks();
                    break;
                }
                case 59: {
                    done = true;
                }
            }
        }
        this.act = this.colorTables.get(0);
        LOGGER.info("Populating metadata");
        this.addGlobalMeta("Use transparency", this.transparency);
        this.addGlobalMeta("Transparency index", this.transIndex);
        this.addGlobalMeta("Interlace", this.interlace);
        this.addGlobalMeta("Block size", this.blockSize);
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = this.getImageCount();
        m.dimensionOrder = "XYCTZ";
        m.rgb = false;
        m.littleEndian = true;
        m.interleaved = true;
        m.metadataComplete = true;
        m.indexed = true;
        m.falseColor = false;
        m.pixelType = 1;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private int readBlock() throws IOException {
        int n;
        if (this.in.getFilePointer() == this.in.length()) {
            return -1;
        }
        this.blockSize = this.in.read() & 0xFF;
        if (this.blockSize > 0) {
            try {
                int count;
                for (n = 0; n < this.blockSize && (count = this.in.read(this.dBlock, n, this.blockSize - n)) != -1; n += count) {
                }
            }
            catch (IOException e) {
                LOGGER.trace("Truncated block", e);
            }
        }
        return n;
    }

    private void decodeImageData() throws IOException {
        int nullCode = -1;
        int npix = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < npix) {
            this.pixels = new byte[npix];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int dataSize = this.in.read() & 0xFF;
        int clear = 1 << dataSize;
        int eoi = clear + 1;
        int available = clear + 2;
        int oldCode = nullCode;
        int codeSize = dataSize + 1;
        int codeMask = (1 << codeSize) - 1;
        int code = 0;
        int inCode = 0;
        for (code = 0; code < clear; ++code) {
            this.prefix[code] = 0;
            this.suffix[code] = (byte)code;
        }
        int datum = 0;
        int first = 0;
        int top = 0;
        int pi = 0;
        int bi = 0;
        int bits = 0;
        int count = 0;
        int i = 0;
        i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < codeSize) {
                    if (count == 0) {
                        count = this.readBlock();
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (this.dBlock[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                code = datum & codeMask;
                datum >>= codeSize;
                bits -= codeSize;
                if (code > available || code == eoi) break;
                if (code == clear) {
                    codeSize = dataSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    available = clear + 2;
                    oldCode = nullCode;
                    continue;
                }
                if (oldCode == nullCode) {
                    this.pixelStack[top++] = this.suffix[code];
                    oldCode = code;
                    first = code;
                    continue;
                }
                inCode = code;
                if (code == available) {
                    this.pixelStack[top++] = (byte)first;
                    code = oldCode;
                }
                while (code > clear) {
                    this.pixelStack[top++] = this.suffix[code];
                    code = this.prefix[code];
                }
                first = this.suffix[code] & 0xFF;
                if (available >= 4096) break;
                this.pixelStack[top++] = (byte)first;
                this.prefix[available] = (short)oldCode;
                this.suffix[available] = (byte)first;
                if ((++available & codeMask) == 0 && available < 4096) {
                    ++codeSize;
                    codeMask += available;
                }
                oldCode = inCode;
            }
            this.pixels[pi++] = this.pixelStack[--top];
            ++i;
        }
        for (i = pi; i < npix; ++i) {
            this.pixels[i] = 0;
        }
        this.setPixels();
    }

    private void setPixels() {
        byte[] dest = new byte[this.getSizeX() * this.getSizeY()];
        int lastImage = -1;
        if (this.lastDispose > 0) {
            int n;
            if (this.lastDispose == 3 && (n = this.getImageCount() - 2) > 0) {
                lastImage = n - 1;
            }
            if (lastImage != -1) {
                byte[] prev = this.images.get(lastImage);
                System.arraycopy(prev, 0, dest, 0, this.getSizeX() * this.getSizeY());
            }
        }
        int pass = 1;
        int inc = 8;
        int iline = 0;
        for (int i = 0; i < this.ih; ++i) {
            int line = i;
            if (this.interlace) {
                if (iline >= this.ih) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += this.iy) >= this.getSizeY()) continue;
            int k = line * this.getSizeX();
            int dx = k + this.ix;
            int dlim = dx + this.iw;
            if (k + this.getSizeX() < dlim) {
                dlim = k + this.getSizeX();
            }
            int sx = i * this.iw;
            while (dx < dlim) {
                int index = this.pixels[sx++] & 0xFF;
                dest[dx++] = (byte)index;
            }
        }
        this.colorTables.add(this.act);
        this.images.add(dest);
    }

    private void skipBlocks() throws IOException {
        int check = 0;
        do {
            check = this.readBlock();
        } while (this.blockSize > 0 && check != -1);
    }

    private void readImageBlock() throws FormatException, IOException {
        this.ix = this.in.readShort();
        this.iy = this.in.readShort();
        this.iw = this.in.readShort();
        this.ih = this.in.readShort();
        int packed = this.in.read();
        boolean lctFlag = (packed & 0x80) != 0;
        this.interlace = (packed & 0x40) != 0;
        int lctSize = 2 << (packed & 7);
        this.act = lctFlag ? this.readLut(lctSize) : this.gct;
        int save = 0;
        if (this.transparency) {
            save = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            throw new FormatException("Color table not found.");
        }
        this.decodeImageData();
        this.skipBlocks();
        ++((CoreMetadata)this.core.get((int)0)).imageCount;
        if (this.transparency) {
            this.act[this.transIndex] = save;
        }
        this.lastDispose = this.dispose;
    }

    private int[] readLut(int size) throws FormatException {
        int nbytes = 3 * size;
        byte[] c = new byte[nbytes];
        int n = 0;
        try {
            n = this.in.read(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n < nbytes) {
            throw new FormatException("Color table not found");
        }
        int[] lut = new int[256];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            int r = c[j++] & 0xFF;
            int g = c[j++] & 0xFF;
            int b = c[j++] & 0xFF;
            lut[i] = 0xFF000000 | r << 16 | g << 8 | b;
        }
        return lut;
    }
}

