/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class L2DReader
extends FormatReader {
    public static final String DATE_FORMAT = "yyyy, m, d";
    private static final String LICOR_MAGIC_STRING = "LI-COR LI2D";
    private String[][] tiffs;
    private List<String>[] metadataFiles;
    private MinimalTiffReader reader;
    private int[] tileWidth;
    private int[] tileHeight;

    public L2DReader() {
        super("Li-Cor L2D", new String[]{"l2d", "scn", "tif"});
        this.domains = new String[]{"Gel/Blot Imaging"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
        this.datasetDescription = "One .l2d file with one or more directories containing .tif/.tiff files";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        boolean hasScan;
        if (L2DReader.checkSuffix(name, "l2d") || L2DReader.checkSuffix(name, "scn")) {
            return super.isThisType(name, open);
        }
        if (!open) {
            return false;
        }
        Location location = new Location(name);
        if (!location.exists()) {
            return false;
        }
        Location parent = location.getAbsoluteFile().getParentFile();
        String scanName = location.getName();
        if (scanName.indexOf(95) >= 0) {
            scanName = scanName.substring(0, scanName.lastIndexOf("_"));
        }
        return (hasScan = new Location(parent, scanName + ".scn").exists()) && new Location(parent, scanName).exists();
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = (int)Math.min(512L, stream.length());
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        String check = stream.readString(blockLen);
        return check.indexOf(LICOR_MAGIC_STRING) >= 0;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.reader.setId(this.tiffs[this.getSeries()][no]);
        return this.reader.openBytes(0, buf, x, y, w, h);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        if (this.metadataFiles != null && this.getSeries() < this.metadataFiles.length) {
            files.addAll(this.metadataFiles[this.getSeries()]);
        }
        if (!noPixels) {
            for (String tiff : this.tiffs[this.getSeries()]) {
                files.add(tiff);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.reader != null) {
            this.reader.close(fileOnly);
        }
        if (!fileOnly) {
            this.tiffs = null;
            this.reader = null;
            this.metadataFiles = null;
            this.tileWidth = null;
            this.tileHeight = null;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tileWidth[this.getSeries()];
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tileHeight[this.getSeries()];
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (!L2DReader.checkSuffix(id, "l2d") && this.isGroupFiles()) {
            String[] list;
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            parent = parent.getParentFile();
            for (String file2 : list = parent.list()) {
                if (!L2DReader.checkSuffix(file2, "l2d")) continue;
                this.initFile(new Location(parent, file2).getAbsolutePath());
                return;
            }
            throw new FormatException("Could not find .l2d file");
        }
        if (!this.isGroupFiles()) {
            super.initFile(id);
            this.tiffs = new String[][]{{id}};
            TiffReader r = new TiffReader();
            r.setMetadataStore(this.getMetadataStore());
            r.setId(id);
            this.core = new ArrayList<CoreMetadata>(r.getCoreMetadataList());
            this.metadataStore = r.getMetadataStore();
            Hashtable<String, Object> globalMetadata = r.getGlobalMetadata();
            for (Map.Entry entry : globalMetadata.entrySet()) {
                this.addGlobalMeta((String)entry.getKey(), entry.getValue());
            }
            r.close();
            this.reader = new MinimalTiffReader();
            return;
        }
        super.initFile(id);
        String[] scans = this.getScanNames();
        Location parent = new Location(id).getAbsoluteFile().getParentFile();
        ArrayList<String> validScans = new ArrayList<String>();
        for (String s : scans) {
            Location scanDir = new Location(parent, s);
            if (!scanDir.exists() || !scanDir.isDirectory()) continue;
            validScans.add(s);
        }
        scans = validScans.toArray(new String[validScans.size()]);
        this.tiffs = new String[scans.length][];
        this.metadataFiles = new List[scans.length];
        this.core = new ArrayList(scans.length);
        String[] comments = new String[scans.length];
        String[] wavelengths = new String[scans.length];
        String[] dates = new String[scans.length];
        String model = null;
        this.tileWidth = new int[scans.length];
        this.tileHeight = new int[scans.length];
        this.core.clear();
        for (int i2 = 0; i2 < scans.length; ++i2) {
            String[] lines;
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            this.setSeries(i2);
            this.metadataFiles[i2] = new ArrayList<String>();
            String scanName = scans[i2] + ".scn";
            Location scanDir = new Location(parent, scans[i2]);
            String scanPath = new Location(scanDir, scanName).getAbsolutePath();
            this.addDirectory(scanDir.getAbsolutePath(), i2);
            String scanData = DataTools.readFile(scanPath);
            for (String line : lines = scanData.split("\n")) {
                if (line.startsWith("#")) continue;
                String key = line.substring(0, line.indexOf(61));
                String value = line.substring(line.indexOf(61) + 1);
                this.addSeriesMeta(key, value);
                if (key.equals("ExperimentNames")) continue;
                if (key.equals("ImageNames")) {
                    this.tiffs[i2] = value.split(",");
                    for (int t = 0; t < this.tiffs[i2].length; ++t) {
                        this.tiffs[i2][t] = new Location(scanDir, this.tiffs[i2][t].trim()).getAbsolutePath();
                    }
                    continue;
                }
                if (key.equals("Comments")) {
                    comments[i2] = value;
                    continue;
                }
                if (key.equals("ScanDate")) {
                    dates[i2] = value;
                    continue;
                }
                if (key.equals("ScannerName")) {
                    model = value;
                    continue;
                }
                if (!key.equals("ScanChannels")) continue;
                wavelengths[i2] = value;
            }
        }
        this.setSeries(0);
        this.reader = new MinimalTiffReader();
        MetadataStore store = this.makeFilterMetadata();
        for (i = 0; i < this.getSeriesCount(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.imageCount = this.tiffs[i].length;
            ms.sizeC = this.tiffs[i].length;
            ms.sizeT = 1;
            ms.sizeZ = 1;
            ms.dimensionOrder = "XYCZT";
            this.reader.setId(this.tiffs[i][0]);
            ms.sizeX = this.reader.getSizeX();
            ms.sizeY = this.reader.getSizeY();
            ms.sizeC *= this.reader.getSizeC();
            ms.rgb = this.reader.isRGB();
            ms.indexed = this.reader.isIndexed();
            ms.littleEndian = this.reader.isLittleEndian();
            ms.pixelType = this.reader.getPixelType();
            this.tileWidth[i] = this.reader.getOptimalTileWidth();
            this.tileHeight[i] = this.reader.getOptimalTileHeight();
        }
        MetadataTools.populatePixels(store, this);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName(scans[i], i);
            if (dates[i] == null) continue;
            dates[i] = DateTools.formatDate(dates[i], DATE_FORMAT);
            if (dates[i] == null) continue;
            store.setImageAcquisitionDate(new Timestamp(dates[i]), i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            for (int i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                store.setImageInstrumentRef(instrumentID, i3);
                store.setImageDescription(comments[i3], i3);
                if (wavelengths[i3] == null) continue;
                String[] waves = wavelengths[i3].split("[, ]");
                if (waves.length < this.getEffectiveSizeC()) {
                    LOGGER.debug("Expected {} wavelengths; got {} wavelengths.", (Object)this.getEffectiveSizeC(), (Object)waves.length);
                }
                for (int q = 0; q < waves.length; ++q) {
                    String laser = MetadataTools.createLSID("LightSource", 0, q);
                    store.setLaserID(laser, 0, q);
                    Double wave = new Double(waves[q].trim());
                    Length wavelength = FormatTools.getWavelength(wave);
                    if (wavelength != null) {
                        store.setLaserWavelength(wavelength, 0, q);
                    }
                    store.setLaserType(MetadataTools.getLaserType("Other"), 0, q);
                    store.setLaserLaserMedium(MetadataTools.getLaserMedium("Other"), 0, q);
                    store.setChannelLightSourceSettingsID(laser, i3, q);
                }
            }
            store.setMicroscopeModel(model, 0);
            store.setMicroscopeType(MetadataTools.getMicroscopeType("Other"), 0);
        }
    }

    private void addDirectory(String path, int series) {
        Location dir = new Location(path);
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        for (String f : files) {
            Location file2 = new Location(path, f);
            if (file2.isDirectory()) {
                this.addDirectory(file2.getAbsolutePath(), series);
                continue;
            }
            if (!L2DReader.checkSuffix(f, "scn")) continue;
            this.metadataFiles[series].add(file2.getAbsolutePath());
        }
    }

    private String[] getScanNames() throws IOException {
        String[] lines;
        String[] scans = null;
        String data = DataTools.readFile(this.currentId);
        for (String line : lines = data.split("\n")) {
            if (line.startsWith("#")) continue;
            String key = line.substring(0, line.indexOf(61)).trim();
            String value = line.substring(line.indexOf(61) + 1).trim();
            this.addGlobalMeta(key, value);
            if (!key.equals("ScanNames")) continue;
            scans = value.split(",");
            for (int i = 0; i < scans.length; ++i) {
                scans[i] = scans[i].trim();
            }
        }
        return scans;
    }
}

