/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.math.BigInteger;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;

public class MRCReader
extends FormatReader {
    private static final String[] TYPES = new String[]{"mono", "tilt", "tilts", "lina", "lins"};
    private static final String[] MRC_SUFFIXES = new String[]{"mrc", "st", "ali", "map", "rec", "mrcs"};
    private static final int HEADER_SIZE = 1024;
    private static final int GRIDSIZE_OFFSET = 28;
    private static final int ENDIANNESS_OFFSET = 212;
    private static final int IMODSTAMP_OFFSET = 152;
    private int extHeaderSize = 0;

    public MRCReader() {
        super("Medical Research Council", MRC_SUFFIXES);
        this.domains = new String[]{"Medical Imaging", "Light Microscopy"};
        this.suffixSufficient = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, 1024, false)) {
            return false;
        }
        this.setLittleEndian(stream);
        stream.seek(0L);
        int x = stream.readInt();
        if (!(x > 0 && (long)x < stream.length() || DataTools.swap(x) > 0 && (long)DataTools.swap(x) < stream.length())) {
            return false;
        }
        int y = stream.readInt();
        if (!(y > 0 && (long)y < stream.length() || DataTools.swap(y) > 0 && (long)DataTools.swap(y) < stream.length())) {
            return false;
        }
        int z = stream.readInt();
        return z > 0 && (long)z < stream.length() || DataTools.swap(z) > 0 && (long)DataTools.swap(z) < stream.length();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        long planeSize = FormatTools.getPlaneSize(this);
        long offset = (long)(1024 + this.extHeaderSize) + (long)no * planeSize;
        if (offset + planeSize <= this.in.length() && offset >= 0L) {
            this.in.seek(offset);
            this.readPlane(this.in, x, this.getSizeY() - h - y, w, h, buf);
            byte[] tmp = new byte[w * FormatTools.getBytesPerPixel(this.getPixelType())];
            for (int row = 0; row < h / 2; ++row) {
                int src = row * tmp.length;
                int dest = (h - row - 1) * tmp.length;
                System.arraycopy(buf, src, tmp, 0, tmp.length);
                System.arraycopy(buf, dest, buf, src, tmp.length);
                System.arraycopy(tmp, 0, buf, dest, tmp.length);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.extHeaderSize = 0;
        }
    }

    @Override
    public void initFile(String id) throws FormatException, IOException {
        double pixelTypeMax;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        LOGGER.info("Reading header");
        this.setLittleEndian(this.in);
        m.littleEndian = this.in.isLittleEndian();
        this.in.seek(0L);
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        m.sizeZ = this.in.readInt();
        BigInteger v = BigInteger.valueOf(this.getSizeX());
        v = v.multiply(BigInteger.valueOf(this.getSizeY()));
        v = v.multiply(BigInteger.valueOf(this.getSizeZ()));
        if (this.getSizeX() < 0 || this.getSizeY() < 0 || this.getSizeZ() < 0 || v.compareTo(BigInteger.valueOf(this.in.length())) > 0) {
            LOGGER.debug("Detected endianness is wrong, swapping");
            m.littleEndian = !this.isLittleEndian();
            this.in.seek(0L);
            this.in.order(this.isLittleEndian());
            m.sizeX = this.in.readInt();
            m.sizeY = this.in.readInt();
            m.sizeZ = this.in.readInt();
        }
        m.sizeC = 1;
        m.rgb = false;
        int mode = this.in.readInt();
        switch (mode) {
            case 0: {
                this.in.seek(152L);
                if (this.in.readInt() == 1146047817) {
                    m.pixelType = 0;
                    break;
                }
                m.pixelType = 1;
                break;
            }
            case 1: {
                m.pixelType = 2;
                break;
            }
            case 6: {
                m.pixelType = 3;
                break;
            }
            case 2: {
                m.pixelType = 6;
                break;
            }
            case 3: {
                m.pixelType = 5;
                break;
            }
            case 4: {
                m.pixelType = 7;
                break;
            }
            case 16: {
                m.sizeC = 3;
                m.pixelType = 1;
                m.rgb = true;
            }
        }
        this.in.seek(28L);
        double xSize = 0.0;
        double ySize = 0.0;
        double zSize = 0.0;
        if (level != MetadataLevel.MINIMUM) {
            int mx = this.in.readInt();
            int my = this.in.readInt();
            int mz = this.in.readInt();
            float xlen = this.in.readFloat();
            float ylen = this.in.readFloat();
            float zlen = this.in.readFloat();
            xSize = xlen / (float)mx;
            ySize = ylen / (float)my;
            zSize = zlen / (float)mz;
            this.addGlobalMeta("Grid size (X)", mx);
            this.addGlobalMeta("Grid size (Y)", my);
            this.addGlobalMeta("Grid size (Z)", mz);
            this.addGlobalMeta("Cell size (X)", xlen);
            this.addGlobalMeta("Cell size (Y)", ylen);
            this.addGlobalMeta("Cell size (Z)", zlen);
            this.addGlobalMeta("Alpha angle", this.in.readFloat());
            this.addGlobalMeta("Beta angle", this.in.readFloat());
            this.addGlobalMeta("Gamma angle", this.in.readFloat());
            this.in.skipBytes(12);
        } else {
            this.in.skipBytes(48);
        }
        double minValue = this.in.readFloat();
        double maxValue = this.in.readFloat();
        this.addGlobalMeta("Minimum pixel value", minValue);
        this.addGlobalMeta("Maximum pixel value", maxValue);
        this.addGlobalMeta("Mean pixel value", this.in.readFloat());
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        double range = Math.pow(2.0, bytes * 8) - 1.0;
        double pixelTypeMin = 0.0;
        boolean signed = FormatTools.isSigned(this.getPixelType());
        if (signed) {
            pixelTypeMin -= range / 2.0;
        }
        if ((pixelTypeMax = pixelTypeMin + range) < maxValue || pixelTypeMin > minValue && signed) {
            switch (this.getPixelType()) {
                case 2: {
                    m.pixelType = 3;
                    break;
                }
                case 4: {
                    m.pixelType = 5;
                }
            }
        }
        int ispg = this.in.readInt();
        this.addGlobalMeta("ISPG", ispg);
        this.addGlobalMeta("Is data cube", ispg == 1);
        this.extHeaderSize = this.in.readInt();
        this.in.skipBytes(8);
        String extType = this.in.readString(4);
        this.addGlobalMeta("Extended header type", extType);
        if (level != MetadataLevel.MINIMUM) {
            int i;
            this.in.skipBytes(52);
            short idtype = this.in.readShort();
            String type = "unknown";
            if (idtype >= 0 && idtype < TYPES.length) {
                type = TYPES[idtype];
            }
            this.addGlobalMeta("Series type", type);
            this.addGlobalMeta("Lens", this.in.readShort());
            this.addGlobalMeta("ND1", this.in.readShort());
            this.addGlobalMeta("ND2", this.in.readShort());
            this.addGlobalMeta("VD1", this.in.readShort());
            this.addGlobalMeta("VD2", this.in.readShort());
            for (i = 0; i < 6; ++i) {
                this.addGlobalMetaList("Angle", Float.valueOf(this.in.readFloat()));
            }
            this.in.skipBytes(24);
            this.addGlobalMeta("Number of useful labels", this.in.readInt());
            for (i = 0; i < 10; ++i) {
                this.addGlobalMetaList("Label", this.in.readString(80));
            }
            LOGGER.info("Skipping extended header of type '{}' and size {}", (Object)extType, (Object)this.extHeaderSize);
        }
        LOGGER.info("Populating metadata");
        m.sizeT = 1;
        m.dimensionOrder = this.isRGB() ? "XYCZT" : "XYZTC";
        m.imageCount = this.getSizeZ() * (this.isRGB() ? 1 : this.getSizeC());
        m.interleaved = true;
        m.indexed = false;
        m.falseColor = false;
        m.metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (level != MetadataLevel.MINIMUM) {
            Unit<Length> sizeUnit = UNITS.ANGSTROM;
            if (extType.equals("AGAR")) {
                sizeUnit = UNITS.MICROMETER;
            }
            Length sizeX = FormatTools.getPhysicalSizeX((Double)xSize, sizeUnit);
            Length sizeY = FormatTools.getPhysicalSizeY((Double)ySize, sizeUnit);
            Length sizeZ = FormatTools.getPhysicalSizeZ((Double)zSize, sizeUnit);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
        }
    }

    private void setLittleEndian(RandomAccessInputStream s) throws IOException {
        boolean big;
        s.seek(212L);
        int check = s.read();
        boolean little = check == 68;
        boolean bl = big = check == 17;
        if (little == big) {
            little = true;
        }
        s.order(little);
    }
}

