/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.formats.CoreMetadata;
import loci.formats.DelegateReader;
import loci.formats.FormatException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.in.TiffJAIReader;
import loci.formats.in.TiffReader;

public class TiffDelegateReader
extends DelegateReader {
    public TiffDelegateReader() {
        super("Tagged Image File Format", TiffReader.TIFF_SUFFIXES);
        this.nativeReader = new TiffReader();
        this.legacyReader = new TiffJAIReader();
        this.nativeReaderInitialized = false;
        this.legacyReaderInitialized = false;
        this.suffixNecessary = false;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (!this.isLegacy()) {
            try {
                return this.nativeReader.openBytes(no, buf, x, y, w, h);
            }
            catch (UnsupportedCompressionException e) {
                LOGGER.debug("Could not open plane with native reader", e);
                if (!this.legacyReaderInitialized) {
                    this.legacyReader.setId(this.getCurrentFile());
                    this.legacyReaderInitialized = true;
                    this.nativeReader.close();
                    this.nativeReaderInitialized = false;
                }
                return this.legacyReader.openBytes(no, buf, x, y, w, h);
            }
        }
        return super.openBytes(no, buf, x, y, w, h);
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        if (this.isLegacy()) {
            super.setId(id);
        }
        this.nativeReader.setId(id);
        this.nativeReaderInitialized = true;
        this.currentId = this.nativeReader.getCurrentFile();
        this.core = new ArrayList<CoreMetadata>(this.nativeReader.getCoreMetadataList());
        this.metadata = this.nativeReader.getGlobalMetadata();
        this.metadataStore = this.nativeReader.getMetadataStore();
    }
}

