/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.LZOCodec;
import loci.formats.meta.MetadataStore;

public class VolocityClippingReader
extends FormatReader {
    private static final String CLIPPING_MAGIC_STRING = "FFCA";
    private static final int AISF = 1179863361;
    private long pixelOffset;

    public VolocityClippingReader() {
        super("Volocity Library Clipping", "acff");
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        if ((long)(FormatTools.getPlaneSize(this) * 2) + this.in.getFilePointer() < this.in.length()) {
            this.readPlane(this.in, x, y, w, h, buf);
            return buf;
        }
        byte[] b = new LZOCodec().decompress(this.in, null);
        try (RandomAccessInputStream s = new RandomAccessInputStream(b);){
            s.seek(0L);
            this.readPlane(s, x, y, w, h, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = this.in.read() == 73;
        this.in.order(this.isLittleEndian());
        this.in.skipBytes(4);
        String magicString = this.in.readString(4);
        if (!magicString.equals(CLIPPING_MAGIC_STRING)) {
            throw new FormatException("Found invalid magic string: " + magicString);
        }
        int check = this.in.readInt();
        while (check != 520 && check != 1179863361) {
            this.in.seek(this.in.getFilePointer() - 3L);
            check = this.in.readInt();
        }
        if (check == 1179863361) {
            m.littleEndian = false;
            this.in.order(this.isLittleEndian());
            this.in.skipBytes(28);
        }
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        m.sizeZ = this.in.readInt();
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = this.getSizeZ() * this.getSizeT();
        m.dimensionOrder = "XYCZT";
        m.pixelType = 1;
        this.pixelOffset = this.in.getFilePointer() + 65L;
        if ((long)(this.getSizeX() * this.getSizeY() * 100) >= this.in.length()) {
            while (this.in.getFilePointer() < this.in.length()) {
                try {
                    byte[] b = new LZOCodec().decompress(this.in, null);
                    if (b.length > 0 && b.length % (this.getSizeX() * this.getSizeY()) == 0) {
                        int bytes = b.length / (this.getSizeX() * this.getSizeY());
                        m.pixelType = FormatTools.pixelTypeFromBytes(bytes, false, false);
                        break;
                    }
                }
                catch (EOFException b) {
                    // empty catch block
                }
                ++this.pixelOffset;
                this.in.seek(this.pixelOffset);
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

