/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import loci.common.services.AbstractService;
import loci.common.services.ServiceException;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.Modulo;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.meta.ModuloAnnotation;
import loci.formats.meta.OriginalMetadataAnnotation;
import loci.formats.ome.OMEPyramidStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.units.quantity.Length;
import ome.xml.meta.MetadataConverter;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Annotation;
import ome.xml.model.BinData;
import ome.xml.model.Channel;
import ome.xml.model.Image;
import ome.xml.model.MetadataOnly;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TiffData;
import ome.xml.model.XMLAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OMEXMLServiceImpl
extends AbstractService
implements OMEXMLService {
    public static final String LATEST_VERSION = "2016-06";
    public static final String NO_OME_XML_MSG = "ome-xml.jar is required to read OME-TIFF files.  Please download it from " + FormatTools.URL_BIO_FORMATS_LIBRARIES;
    private static final Logger LOGGER = LoggerFactory.getLogger(OMEXMLService.class);
    private static final String XSLT_PATH = "/transforms/";
    private static final String XSLT_2003FC = "/transforms/2003-FC-to-2008-09.xsl";
    private static final String XSLT_200706 = "/transforms/2007-06-to-2008-09.xsl";
    private static final String XSLT_200802 = "/transforms/2008-02-to-2008-09.xsl";
    private static final String XSLT_200809 = "/transforms/2008-09-to-2009-09.xsl";
    private static final String XSLT_200909 = "/transforms/2009-09-to-2010-04.xsl";
    private static final String XSLT_201004 = "/transforms/2010-04-to-2010-06.xsl";
    private static final String XSLT_201006 = "/transforms/2010-06-to-2011-06.xsl";
    private static final String XSLT_201106 = "/transforms/2011-06-to-2012-06.xsl";
    private static final String XSLT_201206 = "/transforms/2012-06-to-2013-06.xsl";
    private static final String XSLT_201306 = "/transforms/2013-06-to-2015-01.xsl";
    private static final String XSLT_201501 = "/transforms/2015-01-to-2016-06.xsl";
    private static Templates reorderXSLT;
    private static Templates update2003FC;
    private static Templates update200706;
    private static Templates update200802;
    private static Templates update200809;
    private static Templates update200909;
    private static Templates update201004;
    private static Templates update201006;
    private static Templates update201106;
    private static Templates update201206;
    private static Templates update201306;
    private static Templates update201501;
    private static final String SCHEMA_PATH = "http://www.openmicroscopy.org/Schemas/OME/";
    private static final Pattern SCHEMA_URL_PATTERN;
    private static final XMLTools.SchemaReader SCHEMA_CLASSPATH_READER;

    public OMEXMLServiceImpl() {
        this.checkClassDependency(OMEModelObject.class);
    }

    @Override
    public String getLatestVersion() {
        return LATEST_VERSION;
    }

    @Override
    public String transformToLatestVersion(String xml) throws ServiceException {
        String version = this.getOMEXMLVersion(xml);
        if (null == version) {
            throw new ServiceException("Could not get OME-XML version");
        }
        if (version.equals(this.getLatestVersion())) {
            return xml;
        }
        LOGGER.debug("Attempting to update XML with version: {}", (Object)version);
        LOGGER.trace("Initial dump: {}", (Object)xml);
        String transformed = null;
        try {
            if (version.equals("2003-FC")) {
                xml = this.verifyOMENamespace(xml);
                LOGGER.debug("Running UPDATE_2003FC stylesheet.");
                if (update2003FC == null) {
                    update2003FC = XMLTools.getStylesheet(XSLT_2003FC, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(xml, update2003FC);
            } else if (version.equals("2007-06")) {
                xml = this.verifyOMENamespace(xml);
                LOGGER.debug("Running UPDATE_200706 stylesheet.");
                if (update200706 == null) {
                    update200706 = XMLTools.getStylesheet(XSLT_200706, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(xml, update200706);
            } else if (version.equals("2008-02")) {
                xml = this.verifyOMENamespace(xml);
                LOGGER.debug("Running UPDATE_200802 stylesheet.");
                if (update200802 == null) {
                    update200802 = XMLTools.getStylesheet(XSLT_200802, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(xml, update200802);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2008-09");
            LOGGER.trace("At least 2008-09 dump: {}", (Object)transformed);
            if (version.compareTo("2009-09") < 0) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_200809 stylesheet.");
                if (update200809 == null) {
                    update200809 = XMLTools.getStylesheet(XSLT_200809, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update200809);
            }
            LOGGER.debug("XML updated to at least 2009-09");
            LOGGER.trace("At least 2009-09 dump: {}", (Object)transformed);
            if (version.compareTo("2010-04") < 0) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_200909 stylesheet.");
                if (update200909 == null) {
                    update200909 = XMLTools.getStylesheet(XSLT_200909, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update200909);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2010-04");
            LOGGER.trace("At least 2010-04 dump: {}", (Object)transformed);
            if (version.compareTo("2010-06") < 0) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_201004 stylesheet.");
                if (update201004 == null) {
                    update201004 = XMLTools.getStylesheet(XSLT_201004, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update201004);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2010-06");
            if (version.compareTo("2011-06") < 0) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_201006 stylesheet.");
                if (update201006 == null) {
                    update201006 = XMLTools.getStylesheet(XSLT_201006, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update201006);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2011-06");
            if (version.compareTo("2012-06") < 0) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_201106 stylesheet.");
                if (update201106 == null) {
                    update201106 = XMLTools.getStylesheet(XSLT_201106, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update201106);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2012-06");
            if (version.compareTo("2013-06") < 0) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_201206 stylesheet.");
                if (update201206 == null) {
                    update201206 = XMLTools.getStylesheet(XSLT_201206, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update201206);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2013-06");
            if (version.compareTo("2015-01") < 0) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_201306 stylesheet.");
                if (update201306 == null) {
                    update201306 = XMLTools.getStylesheet(XSLT_201306, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update201306);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2015-01");
            if (version.compareTo(LATEST_VERSION) < 0) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_201501 stylesheet.");
                if (update201501 == null) {
                    update201501 = XMLTools.getStylesheet(XSLT_201501, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update201501);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2016-06");
            transformed = transformed.replaceAll("<ns.*?:", "<");
            transformed = transformed.replaceAll("xmlns:ns.*?=", "xmlns:OME=");
            transformed = transformed.replaceAll("</ns.*?:", "</");
            LOGGER.trace("Transformed XML dump: {}", (Object)transformed);
            return transformed;
        }
        catch (IOException e) {
            LOGGER.warn("Could not transform version " + version + " OME-XML.");
            return null;
        }
    }

    @Override
    public OMEXMLMetadata createOMEXMLMetadata() throws ServiceException {
        return this.createOMEXMLMetadata(null);
    }

    @Override
    public OMEXMLMetadata createOMEXMLMetadata(String xml) throws ServiceException {
        return this.createOMEXMLMetadata(xml, null);
    }

    @Override
    public OMEXMLMetadata createOMEXMLMetadata(String xml, String version) throws ServiceException {
        if (xml != null) {
            xml = XMLTools.sanitizeXML(xml);
        }
        OMEXMLMetadataRoot ome = xml == null ? null : this.createRoot(this.transformToLatestVersion(xml));
        OMEPyramidStore meta = new OMEPyramidStore();
        if (ome != null) {
            meta.setRoot(ome);
        }
        return meta;
    }

    @Override
    public OMEModelObject createOMEXMLRoot(String xml) throws ServiceException {
        return this.createRoot(this.transformToLatestVersion(xml));
    }

    @Override
    public boolean isOMEXMLMetadata(Object o) {
        return o instanceof OMEXMLMetadata;
    }

    @Override
    public boolean isOMEXMLRoot(Object o) {
        return o instanceof OMEModelObject;
    }

    private OMEXMLMetadataRoot createRoot(String xml) throws ServiceException {
        try {
            OMEModelImpl model = new OMEModelImpl();
            OMEXMLMetadataRoot ome = new OMEXMLMetadataRoot(XMLTools.parseDOM(xml).getDocumentElement(), model);
            model.resolveReferences();
            return ome;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public String getOMEXMLVersion(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof OMEXMLMetadata || o instanceof OMEModelObject) {
            return LATEST_VERSION;
        }
        if (o instanceof String) {
            String xml = (String)o;
            try {
                Element e = XMLTools.parseDOM(xml).getDocumentElement();
                String namespace = e.getAttribute("xmlns");
                if (namespace == null || namespace.equals("")) {
                    namespace = e.getAttribute("xmlns:ome");
                }
                if (namespace == null || namespace.equals("")) {
                    namespace = e.getAttribute("xmlns:OME");
                }
                return namespace.endsWith("ome.xsd") ? "2003-FC" : namespace.substring(namespace.lastIndexOf("/") + 1);
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public OMEXMLMetadata getOMEMetadata(MetadataRetrieve src) throws ServiceException {
        if (src instanceof OMEXMLMetadata) {
            return (OMEXMLMetadata)src;
        }
        OMEXMLMetadata omexmlMeta = this.createOMEXMLMetadata();
        this.convertMetadata(src, (MetadataStore)omexmlMeta);
        return omexmlMeta;
    }

    @Override
    public String getOMEXML(MetadataRetrieve src) throws ServiceException {
        OMEXMLMetadata omexmlMeta = this.getOMEMetadata(src);
        String xml = omexmlMeta.dumpXML();
        Document doc = null;
        Exception exception = null;
        try {
            doc = XMLTools.parseDOM(xml);
        }
        catch (ParserConfigurationException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        catch (IOException exc) {
            exception = exc;
        }
        if (exception != null) {
            LOGGER.info("Malformed OME-XML", exception);
            return null;
        }
        Element root = doc.getDocumentElement();
        root.setAttribute("xmlns", SCHEMA_PATH + this.getLatestVersion());
        try {
            xml = XMLTools.getXML(doc);
        }
        catch (TransformerConfigurationException exc) {
            exception = exc;
        }
        catch (TransformerException exc) {
            exception = exc;
        }
        if (exception != null) {
            LOGGER.info("Internal XML conversion error", exception);
            return null;
        }
        return xml;
    }

    @Override
    public boolean validateOMEXML(String xml) {
        return this.validateOMEXML(xml, false);
    }

    @Override
    public boolean validateOMEXML(String xml, boolean pixelsHack) {
        if (pixelsHack) {
            Document doc = null;
            Exception exception = null;
            try {
                doc = XMLTools.parseDOM(xml);
            }
            catch (ParserConfigurationException exc) {
                exception = exc;
            }
            catch (SAXException exc) {
                exception = exc;
            }
            catch (IOException exc) {
                exception = exc;
            }
            if (exception != null) {
                LOGGER.info("Malformed OME-XML", exception);
                return false;
            }
            NodeList list = doc.getElementsByTagName("Pixels");
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                NodeList children = node.getChildNodes();
                boolean needsTiffData = true;
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    String name = child.getLocalName();
                    if (!"TiffData".equals(name) && !"BinData".equals(name)) continue;
                    needsTiffData = false;
                    break;
                }
                if (!needsTiffData) continue;
                Element tiffData = doc.createElement("TiffData");
                node.insertBefore(tiffData, node.getFirstChild());
            }
            try {
                xml = XMLTools.getXML(doc);
            }
            catch (TransformerConfigurationException exc) {
                exception = exc;
            }
            catch (TransformerException exc) {
                exception = exc;
            }
            if (exception != null) {
                LOGGER.info("Internal XML conversion error", exception);
                return false;
            }
        }
        try {
            OMEXMLMetadata omexml = this.createOMEXMLMetadata(xml);
            OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omexml.getRoot();
            for (int image = 0; image < root.sizeOfImageList(); ++image) {
                Image img = root.getImage(image);
                for (int i = 0; i < img.sizeOfLinkedAnnotationList(); ++i) {
                    Annotation annotation = img.getLinkedAnnotation(i);
                    if (!(annotation instanceof XMLAnnotation)) continue;
                    String annotationXML = ((XMLAnnotation)annotation).getValue();
                    Document annotationRoot = XMLTools.parseDOM(annotationXML);
                    NodeList nodes = annotationRoot.getElementsByTagName("ModuloAlongZ");
                    if (nodes.getLength() > 0) {
                        ((XMLAnnotation)annotation).setValue("");
                    }
                    if ((nodes = annotationRoot.getElementsByTagName("ModuloAlongC")).getLength() > 0) {
                        ((XMLAnnotation)annotation).setValue("");
                    }
                    if ((nodes = annotationRoot.getElementsByTagName("ModuloAlongT")).getLength() <= 0) continue;
                    ((XMLAnnotation)annotation).setValue("");
                }
            }
            omexml.setRoot(root);
            xml = this.getOMEXML(omexml);
        }
        catch (IOException | ParserConfigurationException | ServiceException | SAXException e) {
            LOGGER.warn("Could not remove Modulo annotations", e);
        }
        return XMLTools.validateXML(xml, "OME-XML", SCHEMA_CLASSPATH_READER);
    }

    @Override
    public Modulo getModuloAlongZ(OMEXMLMetadata omexml, int image) {
        return this.getModuloAlong(omexml, "ModuloAlongZ", image);
    }

    @Override
    public Modulo getModuloAlongC(OMEXMLMetadata omexml, int image) {
        return this.getModuloAlong(omexml, "ModuloAlongC", image);
    }

    @Override
    public Modulo getModuloAlongT(OMEXMLMetadata omexml, int image) {
        return this.getModuloAlong(omexml, "ModuloAlongT", image);
    }

    private Modulo getModuloAlong(OMEXMLMetadata omexml, String tag, int image) {
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omexml.getRoot();
        Image img = root.getImage(image);
        if (img == null) {
            return null;
        }
        for (int i = 0; i < img.sizeOfLinkedAnnotationList(); ++i) {
            Annotation annotation = img.getLinkedAnnotation(i);
            if (!(annotation instanceof XMLAnnotation)) continue;
            String xml = ((XMLAnnotation)annotation).getValue();
            try {
                NodeList labels;
                Document annotationRoot = XMLTools.parseDOM(xml);
                NodeList nodes = annotationRoot.getElementsByTagName(tag);
                if (nodes.getLength() <= 0) continue;
                Element modulo = (Element)nodes.item(0);
                NamedNodeMap attrs = modulo.getAttributes();
                Modulo m = new Modulo(tag.substring(tag.length() - 1));
                Node start = attrs.getNamedItem("Start");
                Node end = attrs.getNamedItem("End");
                Node step = attrs.getNamedItem("Step");
                Node type = attrs.getNamedItem("Type");
                Node typeDescription = attrs.getNamedItem("TypeDescription");
                Node unit = attrs.getNamedItem("Unit");
                if (start != null) {
                    m.start = Double.parseDouble(start.getNodeValue());
                }
                if (end != null) {
                    m.end = Double.parseDouble(end.getNodeValue());
                }
                if (step != null) {
                    m.step = Double.parseDouble(step.getNodeValue());
                }
                if (type != null) {
                    m.type = type.getNodeValue();
                }
                if (typeDescription != null) {
                    m.typeDescription = typeDescription.getNodeValue();
                }
                if (unit != null) {
                    m.unit = unit.getNodeValue();
                }
                if ((labels = modulo.getElementsByTagName("Label")) != null && labels.getLength() > 0) {
                    m.labels = new String[labels.getLength()];
                    for (int q = 0; q < labels.getLength(); ++q) {
                        m.labels[q] = labels.item(q).getTextContent();
                    }
                }
                return m;
            }
            catch (ParserConfigurationException e) {
                LOGGER.debug("Failed to parse ModuloAlong", e);
                continue;
            }
            catch (SAXException e) {
                LOGGER.debug("Failed to parse ModuloAlong", e);
                continue;
            }
            catch (IOException e) {
                LOGGER.debug("Failed to parse ModuloAlong", e);
            }
        }
        return null;
    }

    @Override
    public Hashtable getOriginalMetadata(OMEXMLMetadata omexmlMeta) {
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omexmlMeta.getRoot();
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        if (annotations == null) {
            return null;
        }
        Hashtable<String, String> metadata = new Hashtable<String, String>();
        for (int i = 0; i < annotations.sizeOfXMLAnnotationList(); ++i) {
            XMLAnnotation annotation = annotations.getXMLAnnotation(i);
            if (annotation instanceof OriginalMetadataAnnotation) {
                OriginalMetadataAnnotation original = (OriginalMetadataAnnotation)annotation;
                metadata.put(original.getKey(), original.getValueForKey());
                continue;
            }
            String xml = annotation.getValue();
            try {
                int meta;
                Document annotationRoot = XMLTools.parseDOM(xml);
                NodeList metadataNodes = annotationRoot.getElementsByTagName("OriginalMetadata");
                for (meta = 0; meta < metadataNodes.getLength(); ++meta) {
                    Element metadataNode = (Element)metadataNodes.item(meta);
                    NodeList keys = metadataNode.getElementsByTagName("Key");
                    NodeList values = metadataNode.getElementsByTagName("Value");
                    for (int q = 0; q < keys.getLength(); ++q) {
                        Node key = keys.item(q);
                        Node value = values.item(q);
                        metadata.put(key.getTextContent(), value.getTextContent());
                    }
                }
                if (metadataNodes.getLength() != 0) continue;
                metadataNodes = annotationRoot.getDocumentElement().getChildNodes();
                for (meta = 0; meta < metadataNodes.getLength(); ++meta) {
                    if (!(metadataNodes.item(meta) instanceof Element)) continue;
                    Element node = (Element)metadataNodes.item(meta);
                    String name = node.getNodeName();
                    NamedNodeMap attrs = node.getAttributes();
                    Node value = attrs.getNamedItem("Value");
                    if (value == null) continue;
                    metadata.put(name, value.getNodeValue());
                }
                continue;
            }
            catch (ParserConfigurationException e) {
                LOGGER.debug("Failed to parse OriginalMetadata", e);
                continue;
            }
            catch (SAXException e) {
                LOGGER.debug("Failed to parse OriginalMetadata", e);
                continue;
            }
            catch (IOException e) {
                LOGGER.debug("Failed to parse OriginalMetadata", e);
            }
        }
        return metadata;
    }

    @Override
    public void populateOriginalMetadata(OMEXMLMetadata omexmlMeta, Hashtable<String, Object> metadata) {
        int annotationIndex;
        omexmlMeta.resolveReferences();
        if (metadata.size() == 0) {
            return;
        }
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omexmlMeta.getRoot();
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        if (annotations == null) {
            annotations = new StructuredAnnotations();
        }
        if ((annotationIndex = annotations.sizeOfXMLAnnotationList()) > 0) {
            String lastAnnotationID = omexmlMeta.getXMLAnnotationID(annotationIndex - 1);
            String lastIndex = lastAnnotationID.substring(lastAnnotationID.lastIndexOf(":") + 1);
            try {
                int index = Integer.parseInt(lastIndex);
                while (index >= annotationIndex) {
                    ++annotationIndex;
                }
            }
            catch (NumberFormatException index) {
                // empty catch block
            }
        }
        for (String key : metadata.keySet()) {
            OriginalMetadataAnnotation annotation = new OriginalMetadataAnnotation();
            annotation.setID(MetadataTools.createLSID("Annotation", annotationIndex++));
            annotation.setKeyValue(key, metadata.get(key).toString());
            annotations.addXMLAnnotation(annotation);
        }
        root.setStructuredAnnotations(annotations);
        omexmlMeta.setRoot(root);
    }

    @Override
    public void populateOriginalMetadata(OMEXMLMetadata omexmlMeta, String key, String value) {
        int annotationIndex;
        omexmlMeta.resolveReferences();
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omexmlMeta.getRoot();
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        if (annotations == null) {
            annotations = new StructuredAnnotations();
        }
        if ((annotationIndex = annotations.sizeOfXMLAnnotationList()) > 0) {
            String lastAnnotationID = omexmlMeta.getXMLAnnotationID(annotationIndex - 1);
            String lastIndex = lastAnnotationID.substring(lastAnnotationID.lastIndexOf(":") + 1);
            try {
                int index = Integer.parseInt(lastIndex);
                while (index >= annotationIndex) {
                    ++annotationIndex;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        OriginalMetadataAnnotation annotation = new OriginalMetadataAnnotation();
        annotation.setID(MetadataTools.createLSID("Annotation", annotationIndex));
        annotation.setKeyValue(key, value);
        annotations.addXMLAnnotation(annotation);
        root.setStructuredAnnotations(annotations);
        omexmlMeta.setRoot(root);
    }

    @Override
    public void convertMetadata(String xml, MetadataStore dest) throws ServiceException {
        String storeVersion;
        OMEXMLMetadataRoot ome = this.createRoot(this.transformToLatestVersion(xml));
        String rootVersion = this.getOMEXMLVersion(ome);
        if (rootVersion.equals(storeVersion = this.getOMEXMLVersion(dest))) {
            if (!(dest instanceof OMEXMLMetadata)) {
                throw new IllegalArgumentException("Expecting OMEXMLMetadata instance.");
            }
            dest.setRoot(ome);
        } else {
            OMEXMLMetadata src = this.createOMEXMLMetadata(xml);
            this.convertMetadata(src, dest);
            for (int image = 0; image < src.getImageCount(); ++image) {
                Length physicalSizeZ;
                Length physicalSizeY;
                Length physicalSizeX = src.getPixelsPhysicalSizeX(image);
                if (physicalSizeX != null && physicalSizeX.value() != null) {
                    physicalSizeX = FormatTools.getPhysicalSize(physicalSizeX.value().doubleValue(), physicalSizeX.unit().getSymbol());
                    dest.setPixelsPhysicalSizeX(physicalSizeX, image);
                }
                if ((physicalSizeY = src.getPixelsPhysicalSizeY(image)) != null && physicalSizeY.value() != null) {
                    physicalSizeY = FormatTools.getPhysicalSize(physicalSizeY.value().doubleValue(), physicalSizeY.unit().getSymbol());
                    dest.setPixelsPhysicalSizeY(physicalSizeY, image);
                }
                if ((physicalSizeZ = src.getPixelsPhysicalSizeZ(image)) == null || physicalSizeZ.value() == null) continue;
                physicalSizeZ = FormatTools.getPhysicalSize(physicalSizeZ.value().doubleValue(), physicalSizeZ.unit().getSymbol());
                dest.setPixelsPhysicalSizeZ(physicalSizeZ, image);
            }
        }
    }

    @Override
    public void convertMetadata(MetadataRetrieve src, MetadataStore dest) {
        MetadataConverter.convertMetadata(src, dest);
    }

    @Override
    public void removeBinData(OMEXMLMetadata omexmlMeta) {
        omexmlMeta.resolveReferences();
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omexmlMeta.getRoot();
        List<Image> images = root.copyImageList();
        for (Image img : images) {
            Pixels pix = img.getPixels();
            List<BinData> binData = pix.copyBinDataList();
            for (BinData bin : binData) {
                pix.removeBinData(bin);
            }
            pix.setMetadataOnly(null);
        }
        omexmlMeta.setRoot(root);
    }

    @Override
    public void removeTiffData(OMEXMLMetadata omexmlMeta) {
        omexmlMeta.resolveReferences();
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omexmlMeta.getRoot();
        List<Image> images = root.copyImageList();
        for (Image img : images) {
            Pixels pix = img.getPixels();
            List<TiffData> tiffData = pix.copyTiffDataList();
            for (TiffData tiff : tiffData) {
                pix.removeTiffData(tiff);
            }
            pix.setMetadataOnly(null);
        }
        omexmlMeta.setRoot(root);
    }

    @Override
    public void removeChannels(OMEXMLMetadata omexmlMeta, int image, int sizeC) {
        omexmlMeta.resolveReferences();
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omexmlMeta.getRoot();
        Pixels img = root.getImage(image).getPixels();
        List<Channel> channels = img.copyChannelList();
        for (int c = 0; c < channels.size(); ++c) {
            Channel channel = channels.get(c);
            if (channel.getID() != null && c < sizeC) continue;
            img.removeChannel(channel);
        }
        omexmlMeta.setRoot(root);
    }

    @Override
    public void addMetadataOnly(OMEXMLMetadata omexmlMeta, int image) {
        this.addMetadataOnly(omexmlMeta, image, true);
    }

    @Override
    public void addMetadataOnly(OMEXMLMetadata omexmlMeta, int image, boolean resolve) {
        if (resolve) {
            omexmlMeta.resolveReferences();
        }
        MetadataOnly meta = new MetadataOnly();
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omexmlMeta.getRoot();
        Pixels pix = root.getImage(image).getPixels();
        pix.setMetadataOnly(meta);
    }

    @Override
    public boolean isEqual(OMEXMLMetadata src1, OMEXMLMetadata src2) {
        src1.resolveReferences();
        src2.resolveReferences();
        OMEXMLMetadataRoot omeRoot1 = (OMEXMLMetadataRoot)src1.getRoot();
        OMEXMLMetadataRoot omeRoot2 = (OMEXMLMetadataRoot)src2.getRoot();
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        Document doc1 = builder.newDocument();
        Document doc2 = builder.newDocument();
        Element root1 = omeRoot1.asXMLElement(doc1);
        Element root2 = omeRoot2.asXMLElement(doc2);
        return this.equals(root1, root2);
    }

    @Override
    public void addModuloAlong(OMEXMLMetadata meta, CoreMetadata core, int imageIdx) {
        Image image;
        meta.resolveReferences();
        if (core.moduloZ.length() == 1 && core.moduloC.length() == 1 && core.moduloT.length() == 1) {
            return;
        }
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)meta.getRoot();
        try {
            image = root.getImage(imageIdx);
        }
        catch (IndexOutOfBoundsException ieeb) {
            return;
        }
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        if (annotations == null) {
            annotations = new StructuredAnnotations();
        }
        int annotationIndex = annotations.sizeOfXMLAnnotationList();
        HashSet<String> knownModulos = new HashSet<String>();
        if (annotationIndex > 0) {
            for (int idx = 0; idx < annotationIndex; ++idx) {
                if (!ModuloAnnotation.MODULO_NS.equals(meta.getXMLAnnotationNamespace(idx))) continue;
                boolean ignore = true;
                String xmlID = meta.getXMLAnnotationID(idx);
                for (int link = 0; link < image.sizeOfLinkedAnnotationList(); ++link) {
                    if (!xmlID.equals(image.getLinkedAnnotation(link).getID())) continue;
                    ignore = false;
                    break;
                }
                if (ignore) continue;
                String value = meta.getXMLAnnotationValue(idx);
                try {
                    Document doc = XMLTools.parseDOM(value);
                    NodeList modulos = doc.getElementsByTagName("Modulo");
                    for (int m = 0; m < modulos.getLength(); ++m) {
                        Node modulo = modulos.item(m);
                        NodeList children = modulo.getChildNodes();
                        for (int c = 0; c < children.getLength(); ++c) {
                            Node child = children.item(c);
                            String name = child.getNodeName();
                            knownModulos.add(name);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Could not parse XML from annotation: {}", (Object)value, (Object)e);
                }
            }
            String lastAnnotationID = meta.getXMLAnnotationID(annotationIndex - 1);
            String lastIndex = lastAnnotationID.substring(lastAnnotationID.lastIndexOf(":") + 1);
            try {
                int index = Integer.parseInt(lastIndex);
                while (index >= annotationIndex) {
                    ++annotationIndex;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int imageAnnotation = 0;
        if (core.moduloZ.length() > 1 && !knownModulos.contains("ModuloAlongZ")) {
            this.createModulo(meta, core.moduloZ, annotations, image, imageIdx, annotationIndex, imageAnnotation);
            ++annotationIndex;
            ++imageAnnotation;
        }
        if (core.moduloC.length() > 1 && !knownModulos.contains("ModuloAlongC")) {
            this.createModulo(meta, core.moduloC, annotations, image, imageIdx, annotationIndex, imageAnnotation);
            ++annotationIndex;
            ++imageAnnotation;
        }
        if (core.moduloT.length() > 1 && !knownModulos.contains("ModuloAlongT")) {
            this.createModulo(meta, core.moduloT, annotations, image, imageIdx, annotationIndex, imageAnnotation);
            ++annotationIndex;
            ++imageAnnotation;
        }
        root.setStructuredAnnotations(annotations);
        meta.setRoot(root);
    }

    private void createModulo(OMEXMLMetadata meta, Modulo modulo, StructuredAnnotations annotations, Image image, int imageIdx, int annotationIndex, int imageAnnotation) {
        ModuloAnnotation annotation = new ModuloAnnotation();
        annotation.setModulo(meta, modulo);
        String id = MetadataTools.createLSID("Annotation", annotationIndex);
        annotation.setID(id);
        annotations.addXMLAnnotation(annotation);
        meta.setImageAnnotationRef(id, imageIdx, imageAnnotation);
        image.linkAnnotation(annotation);
    }

    @Override
    public MetadataStore asStore(MetadataRetrieve meta) {
        return meta instanceof MetadataStore ? (MetadataStore)((Object)meta) : null;
    }

    @Override
    public MetadataRetrieve asRetrieve(MetadataStore meta) {
        return meta instanceof MetadataRetrieve ? (MetadataRetrieve)((Object)meta) : null;
    }

    private String verifyOMENamespace(String xml) {
        try {
            Document doc = XMLTools.parseDOM(xml);
            Element e = doc.getDocumentElement();
            String omeNamespace = e.getAttribute("xmlns:ome");
            if (omeNamespace == null || omeNamespace.equals("")) {
                e.setAttribute("xmlns:ome", e.getAttribute("xmlns"));
            }
            return XMLTools.getXML(doc);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean equals(Node e1, Node e2) {
        String localName2;
        NodeList children1 = e1.getChildNodes();
        NodeList children2 = e2.getChildNodes();
        String localName1 = e1.getLocalName();
        if (localName1 == null) {
            localName1 = "";
        }
        if ((localName2 = e2.getLocalName()) == null) {
            localName2 = "";
        }
        if (!localName1.equals(localName2)) {
            return false;
        }
        if (localName1.equals("StructuredAnnotations")) {
            return true;
        }
        NamedNodeMap attributes1 = e1.getAttributes();
        NamedNodeMap attributes2 = e2.getAttributes();
        if (attributes1 == null || attributes2 == null) {
            if (attributes1 == null && attributes2 != null || attributes1 != null && attributes2 == null) {
                return false;
            }
        } else {
            if (attributes1.getLength() != attributes2.getLength()) {
                return false;
            }
            int nAttributes = attributes1.getLength();
            for (int i = 0; i < nAttributes; ++i) {
                Node n2;
                Node n1 = attributes1.item(i);
                String localName = n1.getNodeName();
                if (localName != null && !localName.equals("ID")) {
                    n2 = attributes2.getNamedItem(localName);
                    if (n2 == null) {
                        return false;
                    }
                    if (this.equals(n1, n2)) continue;
                    return false;
                }
                if (!"ID".equals(localName) || !localName1.endsWith("Settings")) continue;
                n2 = attributes2.getNamedItem(localName);
                Node realRoot1 = this.findRootNode(e1);
                Node realRoot2 = this.findRootNode(e2);
                String refName = localName1.replaceAll("Settings", "");
                Node ref1 = this.findChildWithID(realRoot1, refName, n1.getNodeValue());
                Node ref2 = this.findChildWithID(realRoot2, refName, n2.getNodeValue());
                if (ref1 == null && ref2 == null) {
                    return true;
                }
                if (!(ref1 == null && ref2 != null || ref1 != null && ref2 == null) && this.equals(ref1, ref2)) continue;
                return false;
            }
        }
        if (children1.getLength() != children2.getLength()) {
            return false;
        }
        String node1 = e1.getNodeValue();
        String node2 = e2.getNodeValue();
        if (node1 == null && node2 != null) {
            return false;
        }
        if (node1 != null && !node1.equals(node2) && !localName1.equals("")) {
            return false;
        }
        for (int i = 0; i < children1.getLength(); ++i) {
            if (this.equals(children1.item(i), children2.item(i))) continue;
            return false;
        }
        return true;
    }

    private Node findRootNode(Node child) {
        if (child.getParentNode() != null) {
            return this.findRootNode(child.getParentNode());
        }
        return child;
    }

    private Node findChildWithID(Node root, String name, String id) {
        Node idNode;
        NamedNodeMap attributes = root.getAttributes();
        if (attributes != null && (idNode = attributes.getNamedItem("ID")) != null && id.equals(idNode.getNodeValue()) && name.equals(root.getNodeName())) {
            return root;
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node result = this.findChildWithID(children.item(i), name, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static {
        SCHEMA_URL_PATTERN = Pattern.compile("http://www.openmicroscopy.org/Schemas/\\p{Alpha}+/(\\w+-\\w+)/(\\p{Alpha}+)\\.xsd");
        SCHEMA_CLASSPATH_READER = new XMLTools.SchemaReader(){

            @Override
            public InputStream getSchemaAsStream(String url) {
                Matcher matcher = SCHEMA_URL_PATTERN.matcher(url);
                if (matcher.matches()) {
                    return this.getClass().getResourceAsStream("/released-schema/" + matcher.group(1) + "/" + matcher.group(2) + ".xsd");
                }
                return null;
            }
        };
    }
}

