/*
 * Decompiled with CFR 0.152.
 */
package ome.specification;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.model.AffineTransform;
import ome.xml.model.Annotation;
import ome.xml.model.Arc;
import ome.xml.model.BinData;
import ome.xml.model.BinaryFile;
import ome.xml.model.BooleanAnnotation;
import ome.xml.model.Channel;
import ome.xml.model.CommentAnnotation;
import ome.xml.model.Dataset;
import ome.xml.model.Detector;
import ome.xml.model.DetectorSettings;
import ome.xml.model.Dichroic;
import ome.xml.model.DoubleAnnotation;
import ome.xml.model.Ellipse;
import ome.xml.model.Experiment;
import ome.xml.model.Experimenter;
import ome.xml.model.Filament;
import ome.xml.model.FileAnnotation;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.Image;
import ome.xml.model.ImagingEnvironment;
import ome.xml.model.Instrument;
import ome.xml.model.Laser;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightPath;
import ome.xml.model.LightSource;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.Line;
import ome.xml.model.LongAnnotation;
import ome.xml.model.MapAnnotation;
import ome.xml.model.Mask;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.Microscope;
import ome.xml.model.OME;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Objective;
import ome.xml.model.ObjectiveSettings;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.Plate;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.Point;
import ome.xml.model.Polyline;
import ome.xml.model.Project;
import ome.xml.model.ROI;
import ome.xml.model.Reagent;
import ome.xml.model.Rectangle;
import ome.xml.model.Screen;
import ome.xml.model.Shape;
import ome.xml.model.StageLabel;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TagAnnotation;
import ome.xml.model.TermAnnotation;
import ome.xml.model.TransmittanceRange;
import ome.xml.model.Union;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class XMLMockObjects {
    public static final Color DEFAULT_COLOR = new Color(100, 150, 200, 255);
    public static final Double LIGHTSOURCE_POWER = 200.0;
    public static final String COMPONENT_MODEL = "Model";
    public static final String COMPONENT_MANUFACTURER = "Manufacturer";
    public static final String COMPONENT_SERIAL_NUMBER = "0123456789";
    public static final String COMPONENT_LOT_NUMBER = "9876543210";
    public static final LaserType LASER_TYPE = LaserType.DYE;
    public static final ArcType ARC_TYPE = ArcType.HGXE;
    public static final FilamentType FILAMENT_TYPE = FilamentType.HALOGEN;
    public static final DetectorType DETECTOR_TYPE = DetectorType.CCD;
    public static final Correction CORRECTION = Correction.UV;
    public static final Immersion IMMERSION = Immersion.OIL;
    public static final FilterType FILTER_TYPE = FilterType.LONGPASS;
    public static final MicroscopeType MICROSCOPE_TYPE = MicroscopeType.UPRIGHT;
    public static final ExperimentType EXPERIMENT_TYPE = ExperimentType.FISH;
    public static final MicrobeamManipulationType MICROBEAM_MANIPULATION_TYPE = MicrobeamManipulationType.FLIP;
    public static final Binning BINNING = Binning.TWOBYTWO;
    public static final Medium MEDIUM = Medium.AIR;
    public static final LaserMedium LASER_MEDIUM = LaserMedium.ALEXANDRITE;
    public static final Integer SIZE_X = 24;
    public static final Integer SIZE_Y = 24;
    public static final Integer SIZE_Z = 1;
    public static final Integer SIZE_C = 1;
    public static final Integer SIZE_T = 1;
    public static final Integer BYTES_PER_PIXEL = 2;
    public static final int ROWS = 16;
    public static final int COLUMNS = 24;
    public static final int FIELDS = 3;
    public static final String[] LIGHT_SOURCES = new String[]{Laser.class.getName(), Arc.class.getName(), Filament.class.getName(), LightEmittingDiode.class.getName(), Laser.class.getName()};
    public static final String[] SHAPES = new String[]{Line.class.getName(), Point.class.getName(), Rectangle.class.getName(), Ellipse.class.getName(), Polyline.class.getName(), Mask.class.getName()};
    public static final String[] ANNOTATIONS = new String[]{BooleanAnnotation.class.getName(), CommentAnnotation.class.getName(), LongAnnotation.class.getName(), TermAnnotation.class.getName(), TagAnnotation.class.getName()};
    public static final NamingConvention ROW_NAMING_CONVENTION = NamingConvention.LETTER;
    public static final NamingConvention COLUMN_NAMING_CONVENTION = NamingConvention.NUMBER;
    public static final DimensionOrder DIMENSION_ORDER = DimensionOrder.XYZCT;
    public static final PixelType PIXEL_TYPE = PixelType.UINT16;
    public static final int NUMBER_OF_DECTECTORS = 1;
    public static final int NUMBER_OF_OBJECTIVES = 1;
    public static final int NUMBER_OF_FILTERS = 2;
    public static final int NUMBER_OF_DICHROICS = 1;
    public static final String POINTS = "0,0 10,10";
    public static final String TIME = "2006-05-04T18:13:51.0Z";
    public static final Double CUT_IN = 200.0;
    public static final Double CUT_OUT = 300.0;
    protected OME ome = new OME();
    protected Instrument instrument;

    private void populateInstrument() {
        if (this.instrument != null) {
            return;
        }
        this.instrument = this.createInstrument(true);
        this.ome.addInstrument(this.instrument);
    }

    public Detector createDetector(int index) {
        Detector detector = new Detector();
        detector.setID("Detector:" + index);
        detector.setModel(COMPONENT_MODEL);
        detector.setManufacturer(COMPONENT_MANUFACTURER);
        detector.setSerialNumber(COMPONENT_SERIAL_NUMBER);
        detector.setLotNumber(COMPONENT_LOT_NUMBER);
        detector.setAmplificationGain(0.0);
        detector.setGain(1.0);
        detector.setOffset(2.0);
        detector.setVoltage(new ElectricPotential(100, UNITS.VOLT));
        detector.setType(DETECTOR_TYPE);
        detector.setZoom(3.0);
        return detector;
    }

    public FilterSet createFilterSet(int index) {
        FilterSet set = new FilterSet();
        set.setID("FilterSet:" + index);
        set.setModel(COMPONENT_MODEL);
        set.setManufacturer(COMPONENT_MANUFACTURER);
        set.setSerialNumber(COMPONENT_SERIAL_NUMBER);
        set.setLotNumber(COMPONENT_LOT_NUMBER);
        return set;
    }

    public Microscope createMicroscope() {
        Microscope microscope = new Microscope();
        microscope.setManufacturer(COMPONENT_MANUFACTURER);
        microscope.setModel(COMPONENT_MODEL);
        microscope.setSerialNumber(COMPONENT_SERIAL_NUMBER);
        microscope.setLotNumber(COMPONENT_LOT_NUMBER);
        microscope.setType(MICROSCOPE_TYPE);
        return microscope;
    }

    public Dichroic createDichroic(int index) {
        Dichroic dichroic = new Dichroic();
        dichroic.setID("Dichroic:" + index);
        dichroic.setModel(COMPONENT_MODEL);
        dichroic.setManufacturer(COMPONENT_MANUFACTURER);
        dichroic.setLotNumber(COMPONENT_LOT_NUMBER);
        dichroic.setSerialNumber(COMPONENT_SERIAL_NUMBER);
        return dichroic;
    }

    public Objective createObjective(int index) {
        Objective objective = new Objective();
        objective.setID("Objective:" + index);
        objective.setModel(COMPONENT_MODEL);
        objective.setManufacturer(COMPONENT_MANUFACTURER);
        objective.setSerialNumber(COMPONENT_SERIAL_NUMBER);
        objective.setLotNumber(COMPONENT_LOT_NUMBER);
        objective.setCalibratedMagnification(1.0);
        objective.setCorrection(CORRECTION);
        objective.setImmersion(IMMERSION);
        objective.setIris(true);
        objective.setLensNA(0.5);
        objective.setNominalMagnification(1.5);
        objective.setWorkingDistance(new Length(1.0, UNITS.MICROMETER));
        return objective;
    }

    public Filter createFilter(int index, double cutIn, double cutOut) {
        Filter filter = new Filter();
        filter.setID("Filter:" + index);
        filter.setModel(COMPONENT_MODEL);
        filter.setManufacturer(COMPONENT_MANUFACTURER);
        filter.setLotNumber(COMPONENT_LOT_NUMBER);
        filter.setSerialNumber(COMPONENT_SERIAL_NUMBER);
        filter.setType(FILTER_TYPE);
        TransmittanceRange transmittance = new TransmittanceRange();
        transmittance.setCutIn(new Length(cutIn, UNITS.NANOMETRE));
        transmittance.setCutOut(new Length(cutOut, UNITS.NANOMETER));
        transmittance.setCutInTolerance(new Length(1.0, UNITS.NANOMETER));
        transmittance.setCutOutTolerance(new Length(1.0, UNITS.NANOMETER));
        transmittance.setTransmittance(new PercentFraction(Float.valueOf(0.5f)));
        filter.setTransmittanceRange(transmittance);
        return filter;
    }

    public LightSource createLightSource(String type, int index) {
        if (Laser.class.getName().equals(type)) {
            Laser laser = new Laser();
            laser.setID("LightSource:" + index);
            laser.setModel(COMPONENT_MODEL);
            laser.setManufacturer(COMPONENT_MANUFACTURER);
            laser.setSerialNumber(COMPONENT_SERIAL_NUMBER);
            laser.setLotNumber(COMPONENT_LOT_NUMBER);
            laser.setPower(new Power(LIGHTSOURCE_POWER, UNITS.MILLIWATT));
            laser.setType(LASER_TYPE);
            laser.setFrequencyMultiplication(new PositiveInteger(30));
            laser.setLaserMedium(LASER_MEDIUM);
            laser.setPockelCell(false);
            laser.setRepetitionRate(new Frequency(30.0, UNITS.ATTOHERTZ));
            laser.setTuneable(false);
            laser.setWavelength(new Length(200.0, UNITS.NANOMETER));
            return laser;
        }
        if (Arc.class.getName().equals(type)) {
            Arc arc = new Arc();
            arc.setID("LightSource:" + index);
            arc.setManufacturer(COMPONENT_MANUFACTURER);
            arc.setSerialNumber(COMPONENT_SERIAL_NUMBER);
            arc.setLotNumber(COMPONENT_LOT_NUMBER);
            arc.setModel(COMPONENT_MODEL);
            arc.setPower(new Power(LIGHTSOURCE_POWER, UNITS.MILLIWATT));
            arc.setType(ARC_TYPE);
            return arc;
        }
        if (Filament.class.getName().equals(type)) {
            Filament filament = new Filament();
            filament.setID("LightSource:" + index);
            filament.setManufacturer(COMPONENT_MANUFACTURER);
            filament.setSerialNumber(COMPONENT_SERIAL_NUMBER);
            filament.setLotNumber(COMPONENT_LOT_NUMBER);
            filament.setModel(COMPONENT_MODEL);
            filament.setPower(new Power(LIGHTSOURCE_POWER, UNITS.MILLIWATT));
            filament.setType(FILAMENT_TYPE);
            return filament;
        }
        if (LightEmittingDiode.class.getName().equals(type)) {
            LightEmittingDiode light = new LightEmittingDiode();
            light.setID("LightSource:" + index);
            light.setManufacturer(COMPONENT_MANUFACTURER);
            light.setSerialNumber(COMPONENT_SERIAL_NUMBER);
            light.setLotNumber(COMPONENT_LOT_NUMBER);
            light.setModel(COMPONENT_MODEL);
            light.setPower(new Power(LIGHTSOURCE_POWER, UNITS.MILLIWATT));
            return light;
        }
        return null;
    }

    public BinData createBinData(int sizeX, int sizeY, int bpp) {
        BinData data = new BinData();
        data.setBigEndian(false);
        data.setCompression(Compression.NONE);
        data.setLength(new NonNegativeLong(Long.valueOf(sizeX * sizeY * bpp)));
        return data;
    }

    public LightPath createLightPath() {
        LightPath lp = new LightPath();
        lp.linkDichroic(this.instrument.getDichroic(0));
        lp.linkEmissionFilter(this.instrument.getFilter(0));
        lp.linkExcitationFilter(this.instrument.getFilter(1));
        return lp;
    }

    public ImagingEnvironment createImageEnvironment() {
        ImagingEnvironment env = new ImagingEnvironment();
        env.setAirPressure(new Pressure(1.0, UNITS.MILLIBAR));
        env.setCO2Percent(new PercentFraction(Float.valueOf(1.0f)));
        env.setHumidity(new PercentFraction(Float.valueOf(1.0f)));
        env.setTemperature(new Temperature(1.0, UNITS.CELSIUS));
        return env;
    }

    public StageLabel createStageLabel() {
        StageLabel label = new StageLabel();
        label.setName("StageLabel");
        label.setX(new Length(1.0, UNITS.REFERENCEFRAME));
        label.setY(new Length(1.0, UNITS.REFERENCEFRAME));
        label.setZ(new Length(1.0, UNITS.REFERENCEFRAME));
        return label;
    }

    public LightSourceSettings createLightSourceSettings(int ref) {
        if (this.instrument == null) {
            this.populateInstrument();
        }
        LightSourceSettings settings = new LightSourceSettings();
        settings.setID("LightSource:" + ref);
        settings.setAttenuation(new PercentFraction(Float.valueOf(1.0f)));
        settings.setWavelength(new Length(200.2, UNITS.NANOMETRE));
        settings.setLightSource(this.instrument.copyLightSourceList().get(0));
        return settings;
    }

    public MicrobeamManipulation createMicrobeamManipulation(int index) {
        LightSourceSettings lss = this.createLightSourceSettings(4);
        MicrobeamManipulation mm = new MicrobeamManipulation();
        mm.setID("MicrobeamManipulation:" + index);
        mm.setType(MICROBEAM_MANIPULATION_TYPE);
        mm.setDescription("Manipulation #" + index);
        ROI roi = this.createROI(index, 0, 0, 0);
        this.ome.addROI(roi);
        mm.linkROI(roi);
        Experimenter experimenter = this.createExperimenter(index);
        this.ome.addExperimenter(experimenter);
        mm.linkExperimenter(experimenter);
        lss.setMicrobeamManipulation(mm);
        mm.addLightSourceSettings(lss);
        return mm;
    }

    public Experimenter createExperimenter(int index) {
        Experimenter experimenter = new Experimenter();
        experimenter.setID("Experimenter:" + index);
        return experimenter;
    }

    public Experiment createExperiment(int index) {
        Experiment exp = new Experiment();
        exp.setDescription("Experiment");
        exp.setType(ExperimentType.PHOTOBLEACHING);
        exp.setID("Experiment:" + index);
        return exp;
    }

    public Experiment createExperimentWithMicrobeam(int index) {
        Experiment exp = new Experiment();
        exp.setDescription("Experiment");
        exp.setType(ExperimentType.PHOTOBLEACHING);
        exp.setID("Experiment:" + index);
        MicrobeamManipulation mm = this.createMicrobeamManipulation(index);
        exp.addMicrobeamManipulation(mm);
        return exp;
    }

    public DetectorSettings createDetectorSettings(int ref) {
        DetectorSettings settings = new DetectorSettings();
        settings.setID("Detector:" + ref);
        settings.setBinning(BINNING);
        settings.setGain(1.0);
        settings.setOffset(1.0);
        settings.setReadOutRate(new Frequency(1.0, UNITS.HERTZ));
        settings.setVoltage(new ElectricPotential(1.0, UNITS.VOLT));
        settings.setIntegration(new PositiveInteger(20));
        settings.setZoom(3.0);
        return settings;
    }

    public ObjectiveSettings createObjectiveSettings(int ref) {
        ObjectiveSettings settings = new ObjectiveSettings();
        settings.setID("Objective:" + ref);
        settings.setMedium(MEDIUM);
        settings.setCorrectionCollar(1.0);
        settings.setRefractiveIndex(1.0);
        return settings;
    }

    public BinaryFile createBinaryFile() {
        BinaryFile bf = new BinaryFile();
        bf.setBinData(this.createBinData(SIZE_X, SIZE_Y, BYTES_PER_PIXEL));
        return bf;
    }

    public Shape createShape(int index, String type, int z, int c, int t) {
        Shape shape = null;
        if (Line.class.getName().equals(type)) {
            Line line = new Line();
            line.setX1(0.0);
            line.setY1(0.0);
            line.setX2(1.0);
            line.setY2(1.0);
            shape = line;
        } else if (Rectangle.class.getName().equals(type)) {
            Rectangle r = new Rectangle();
            r.setX(0.0);
            r.setY(0.0);
            r.setWidth(10.0);
            r.setHeight(10.0);
            shape = r;
        } else if (Ellipse.class.getName().equals(type)) {
            Ellipse e = new Ellipse();
            e.setRadiusX(1.0);
            e.setRadiusY(1.0);
            e.setY(2.0);
            e.setX(2.0);
            shape = e;
        } else if (Point.class.getName().equals(type)) {
            Point p = new Point();
            p.setY(2.0);
            p.setX(2.0);
            shape = p;
        } else if (Polyline.class.getName().equals(type)) {
            Polyline pl = new Polyline();
            pl.setPoints(POINTS);
            shape = pl;
        } else if (Mask.class.getName().equals(type)) {
            Mask m = new Mask();
            m.setX(0.0);
            m.setY(0.0);
            m.setWidth(new Double(SIZE_X.intValue()));
            m.setHeight(new Double(SIZE_Y.intValue()));
            m.setBinData(this.createBinData(SIZE_X, SIZE_Y, BYTES_PER_PIXEL));
            shape = m;
        }
        if (shape != null) {
            shape.setID("Shape:" + index);
            shape.setTheC(new NonNegativeInteger(c));
            shape.setTheZ(new NonNegativeInteger(z));
            shape.setTheT(new NonNegativeInteger(t));
            shape.setTransform(this.createTransform());
            shape.setFillColor(new ome.xml.model.primitives.Color(100));
            shape.setStrokeColor(new ome.xml.model.primitives.Color(100));
        }
        return shape;
    }

    private AffineTransform createTransform() {
        AffineTransform at = new AffineTransform();
        at.setA02(2.0);
        at.setA12(3.0);
        return at;
    }

    public ROI createROI(int index, int z, int c, int t) {
        ROI roi = new ROI();
        roi.setName("ROI name:" + index);
        roi.setID("ROI:" + index);
        int n = SHAPES.length;
        int j = index;
        if (index > 0) {
            j += n;
        }
        Union union = new Union();
        for (int i = 0; i < n; ++i) {
            Shape shape = this.createShape(j += i, SHAPES[i], z, c, t);
            shape.setID("Shape:" + index + ":" + j);
            union.addShape(shape);
        }
        roi.setUnion(union);
        return roi;
    }

    public OME getRoot() {
        return this.ome;
    }

    public Project createProject(int index) {
        Project project = new Project();
        project.setID("Project:" + index);
        project.setName("Project Name " + index);
        project.setDescription("Project Description " + index);
        return project;
    }

    public Dataset createDataset(int index) {
        Dataset dataset = new Dataset();
        dataset.setID("Dataset:" + index);
        dataset.setName("Dataset Name " + index);
        dataset.setDescription("Dataset Description " + index);
        return dataset;
    }

    public Screen createScreen(int index) {
        Screen screen = new Screen();
        screen.setID("Screen:" + index);
        screen.setName("Screen Name " + index);
        screen.setDescription("Screen Description " + index);
        return screen;
    }

    public Plate createBasicPlate(int index) {
        Plate plate = new Plate();
        plate.setID("Plate:" + index);
        plate.setName("Plate Name " + index);
        plate.setDescription("Plate Description " + index);
        return plate;
    }

    public Plate createPlate(int numberOfPlates, int index, int numberOfPlateAcquisition) {
        return this.createPlate(numberOfPlates, index, 16, 24, 3, numberOfPlateAcquisition);
    }

    public Plate createPlate(int numberOfPlates, int index, int rows, int columns, int fields, int numberOfPlateAcquisition) {
        return this.createPlate(numberOfPlates, index, rows, columns, fields, numberOfPlateAcquisition, true);
    }

    public Plate createPlate(int numberOfPlates, int index, int rows, int columns, int fields, int numberOfPlateAcquisition, boolean withMicrobeam) {
        return this.createPlate(1, 0, numberOfPlates, index, rows, columns, fields, numberOfPlateAcquisition, withMicrobeam);
    }

    public Plate createPlate(int numberOfScreens, int screenIndex, int numberOfPlates, int plateIndex, int rows, int columns, int fields, int numberOfPlateAcquisition) {
        return this.createPlate(numberOfScreens, screenIndex, numberOfPlates, plateIndex, rows, columns, fields, numberOfPlateAcquisition, true);
    }

    public Plate createPlate(int numberOfScreens, int screenIndex, int numberOfPlates, int plateIndex, int rows, int columns, int fields, int numberOfPlateAcquisition, boolean withMicrobeam) {
        int v;
        if (numberOfScreens == 0) {
            numberOfScreens = 1;
            screenIndex = 0;
        }
        int totalPlateIndex = numberOfPlates * screenIndex + plateIndex;
        Experiment exp = withMicrobeam ? this.createExperimentWithMicrobeam(totalPlateIndex) : this.createExperiment(totalPlateIndex);
        this.ome.addExperiment(exp);
        if (numberOfPlateAcquisition < 0) {
            numberOfPlateAcquisition = 0;
        }
        Plate plate = new Plate();
        plate.setID("Plate:" + totalPlateIndex);
        plate.setName("Plate Name " + totalPlateIndex);
        plate.setDescription(String.format("Plate %d of %d", plateIndex, numberOfPlates));
        plate.setExternalIdentifier("External Identifier");
        plate.setRows(new PositiveInteger(rows));
        plate.setColumns(new PositiveInteger(columns));
        plate.setRowNamingConvention(ROW_NAMING_CONVENTION);
        plate.setColumnNamingConvention(COLUMN_NAMING_CONVENTION);
        plate.setWellOriginX(new Length(0.0, UNITS.MICROMETER));
        plate.setWellOriginY(new Length(1.0, UNITS.MICROMETER));
        plate.setStatus("Plate status");
        PlateAcquisition pa = null;
        ArrayList<PlateAcquisition> pas = new ArrayList<PlateAcquisition>();
        if (numberOfPlateAcquisition > 0) {
            for (int i = 0; i < numberOfPlateAcquisition; ++i) {
                pa = new PlateAcquisition();
                v = i + totalPlateIndex * numberOfPlateAcquisition;
                pa.setID("PlateAcquisition:" + v);
                pa.setName("PlateAcquisition Name " + v);
                pa.setDescription(String.format("PlateAcquisition %d of %d", i, numberOfPlateAcquisition));
                pa.setEndTime(new Timestamp(TIME));
                pa.setStartTime(new Timestamp(TIME));
                plate.addPlateAcquisition(pa);
                pas.add(pa);
            }
        }
        int i = totalPlateIndex * rows * columns * fields * numberOfPlateAcquisition;
        int kk = 0;
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Image image;
                WellSample sample;
                int field;
                Well well = new Well();
                well.setID(String.format("Well:%d_%d_%d_%d", screenIndex, plateIndex, row, column));
                well.setRow(new NonNegativeInteger(row));
                well.setColumn(new NonNegativeInteger(column));
                well.setType("Transfection: done");
                well.setExternalDescription("External Description");
                well.setExternalIdentifier("External Identifier");
                well.setColor(new ome.xml.model.primitives.Color(255));
                if (pas.size() == 0) {
                    for (field = 0; field < fields; ++field) {
                        sample = new WellSample();
                        sample.setPositionX(new Length(0.0, UNITS.REFERENCEFRAME));
                        sample.setPositionY(new Length(1.0, UNITS.REFERENCEFRAME));
                        sample.setTimepoint(new Timestamp(TIME));
                        sample.setID(String.format("WellSample:%d_%d_%d_%d_%d", screenIndex, plateIndex, row, column, field));
                        sample.setIndex(new NonNegativeInteger(i));
                        image = this.createImageWithExperiment(i, true, exp);
                        this.ome.addImage(image);
                        sample.linkImage(image);
                        well.addWellSample(sample);
                        ++i;
                    }
                } else {
                    Iterator k = pas.iterator();
                    kk = 0;
                    while (k.hasNext()) {
                        pa = (PlateAcquisition)k.next();
                        for (field = 0; field < fields; ++field) {
                            v = kk + totalPlateIndex * numberOfPlates * numberOfScreens;
                            sample = new WellSample();
                            sample.setPositionX(new Length(0.0, UNITS.REFERENCEFRAME));
                            sample.setPositionY(new Length(1.0, UNITS.REFERENCEFRAME));
                            sample.setTimepoint(new Timestamp(TIME));
                            sample.setID(String.format("WellSample:%d_%d_%d_%d_%d_%d", screenIndex, plateIndex, row, column, field, v));
                            sample.setIndex(new NonNegativeInteger(i));
                            image = this.createImageWithExperiment(i, true, exp);
                            this.ome.addImage(image);
                            sample.linkImage(image);
                            pa.linkWellSample(sample);
                            well.addWellSample(sample);
                            ++i;
                        }
                        ++kk;
                    }
                }
                plate.addWell(well);
            }
        }
        return plate;
    }

    public Plane createPlane(int z, int c, int t) {
        Plane plane = new Plane();
        plane.setDeltaT(new Time(0.1, UNITS.SECOND));
        plane.setExposureTime(new Time(10.0, UNITS.SECOND));
        plane.setPositionX(new Length(1.0, UNITS.REFERENCEFRAME));
        plane.setPositionY(new Length(1.0, UNITS.REFERENCEFRAME));
        plane.setPositionZ(new Length(1.0, UNITS.REFERENCEFRAME));
        plane.setTheZ(new NonNegativeInteger(z));
        plane.setTheC(new NonNegativeInteger(c));
        plane.setTheT(new NonNegativeInteger(z));
        plane.setHashSHA1("1234567890ABCDEF1234567890ABCDEF12345678");
        return plane;
    }

    public Image createImage(int index, boolean metadata) {
        if (metadata && this.instrument == null) {
            this.populateInstrument();
        }
        Image image = new Image();
        image.setID("Image:" + index);
        image.setName("Image Name " + index);
        image.setDescription("Image Description " + index);
        if (metadata) {
            image.setImagingEnvironment(this.createImageEnvironment());
            image.setStageLabel(this.createStageLabel());
        }
        Pixels pixels = new Pixels();
        pixels.setID("Pixels:" + index);
        pixels.setSizeX(new PositiveInteger(SIZE_X));
        pixels.setSizeY(new PositiveInteger(SIZE_Y));
        pixels.setSizeZ(new PositiveInteger(SIZE_Z));
        pixels.setSizeC(new PositiveInteger(SIZE_C));
        pixels.setSizeT(new PositiveInteger(SIZE_T));
        pixels.setPhysicalSizeX(new Length(1, UNITS.MICROMETER));
        pixels.setPhysicalSizeY(new Length(1, UNITS.MICROMETER));
        pixels.setPhysicalSizeZ(new Length(1, UNITS.MICROMETER));
        pixels.setDimensionOrder(DIMENSION_ORDER);
        pixels.setType(PIXEL_TYPE);
        if (!metadata) {
            for (int i = 0; i < SIZE_Z * SIZE_C * SIZE_T; ++i) {
                BinData data = this.createBinData(SIZE_X, SIZE_Y, BYTES_PER_PIXEL);
                pixels.addBinData(data);
            }
        }
        for (int z = 0; z < SIZE_Z; ++z) {
            for (int t = 0; t < SIZE_T; ++t) {
                for (int c = 0; c < SIZE_C; ++c) {
                    pixels.addPlane(this.createPlane(z, c, t));
                }
            }
        }
        int j = 0;
        int n = LIGHT_SOURCES.length - 1;
        DetectorSettings ds = this.createDetectorSettings(0);
        for (int i = 0; i < SIZE_C; ++i) {
            Channel channel = this.createChannel(i);
            channel.setID("Channel:" + index + ":" + i);
            if (metadata) {
                if (j == n) {
                    j = 0;
                }
                channel.setLightSourceSettings(this.createLightSourceSettings(j));
                channel.setLightPath(this.createLightPath());
                channel.setDetectorSettings(ds);
                ++j;
            }
            pixels.addChannel(channel);
        }
        image.setPixels(pixels);
        return image;
    }

    public Channel createChannel(int index) {
        Channel channel = new Channel();
        channel.setID("Channel:" + index);
        channel.setAcquisitionMode(AcquisitionMode.FLUORESCENCELIFETIME);
        int argb = DEFAULT_COLOR.getRGB();
        int rgba = argb << 8 | argb >>> 24;
        channel.setColor(new ome.xml.model.primitives.Color(rgba));
        channel.setName("Name");
        channel.setIlluminationType(IlluminationType.OBLIQUE);
        channel.setPinholeSize(new Length(0.5, UNITS.MICROMETER));
        channel.setContrastMethod(ContrastMethod.BRIGHTFIELD);
        PositiveFloat emWave = new PositiveFloat(300.3);
        channel.setEmissionWavelength(new Length((Number)emWave.getValue(), UNITS.NANOMETER));
        PositiveFloat exWave = new PositiveFloat(400.3);
        channel.setExcitationWavelength(new Length((Number)exWave.getValue(), UNITS.NANOMETER));
        channel.setFluor("Fluor");
        channel.setNDFilter(1.0);
        channel.setPockelCellSetting(0);
        return channel;
    }

    public Image createImage(int index) {
        return this.createImage(index, false);
    }

    public Instrument createInstrument(boolean populate) {
        int index = 0;
        Instrument instrument = new Instrument();
        instrument.setID("Instrument:" + index);
        instrument.setMicroscope(this.createMicroscope());
        if (populate) {
            int i;
            for (i = 0; i < 1; ++i) {
                instrument.addObjective(this.createObjective(i));
            }
            for (i = 0; i < 1; ++i) {
                instrument.addDetector(this.createDetector(i));
            }
            instrument.addFilterSet(this.createFilterSet(index));
            for (i = 0; i < 2; ++i) {
                instrument.addFilter(this.createFilter(i, CUT_IN, CUT_OUT));
            }
            for (i = 0; i < 1; ++i) {
                instrument.addDichroic(this.createDichroic(i));
            }
            for (i = 0; i < LIGHT_SOURCES.length; ++i) {
                instrument.addLightSource(this.createLightSource(LIGHT_SOURCES[i], i));
            }
        }
        return instrument;
    }

    public Reagent createReagent(int index) {
        Reagent reagent = new Reagent();
        reagent.setID("Reagent:" + index);
        reagent.setDescription("Reagent Description");
        reagent.setName("Reagent Name");
        reagent.setReagentIdentifier("Reagent Identifier");
        return reagent;
    }

    public Annotation createAnnotation(String type, OMEModelObject object, int index) {
        Annotation annotation = null;
        if (object instanceof Image) {
            if (CommentAnnotation.class.getName().equals(type)) {
                CommentAnnotation c = new CommentAnnotation();
                c.setID("ImageCommentAnnotation:" + index);
                c.setValue("Image:" + index + " CommentAnnotation.");
                annotation = c;
            } else if (BooleanAnnotation.class.getName().equals(type)) {
                BooleanAnnotation b = new BooleanAnnotation();
                b.setID("ImageBooleanAnnotation:" + index);
                b.setValue(true);
                annotation = b;
            } else if (LongAnnotation.class.getName().equals(type)) {
                LongAnnotation l = new LongAnnotation();
                l.setID("ImageLongAnnotation:" + index);
                l.setValue(1L);
                annotation = l;
            } else if (TagAnnotation.class.getName().equals(type)) {
                TagAnnotation tag = new TagAnnotation();
                tag.setID("ImageTagAnnotation:" + index);
                tag.setValue("Image:" + index + " TagAnnotation.");
                annotation = tag;
            } else if (TermAnnotation.class.getName().equals(type)) {
                TermAnnotation term = new TermAnnotation();
                term.setID("ImageTermAnnotation:" + index);
                term.setValue("Image:" + index + " TermAnnotation.");
                annotation = term;
            } else if (FileAnnotation.class.getName().equals(type)) {
                FileAnnotation f = new FileAnnotation();
                f.setID("ImageFileAnnotation:" + index);
                f.setBinaryFile(this.createBinaryFile());
                annotation = f;
            }
            if (annotation != null) {
                ((Image)object).linkAnnotation(annotation);
            }
        } else if (object instanceof Plate) {
            if (CommentAnnotation.class.getName().equals(type)) {
                CommentAnnotation c = new CommentAnnotation();
                c.setID("PlateCommentAnnotation:" + index);
                c.setValue("Plate:" + index + " CommentAnnotation.");
                annotation = c;
            } else if (BooleanAnnotation.class.getName().equals(type)) {
                BooleanAnnotation b = new BooleanAnnotation();
                b.setID("PlateBooleanAnnotation:" + index);
                b.setValue(true);
                annotation = b;
            } else if (LongAnnotation.class.getName().equals(type)) {
                LongAnnotation l = new LongAnnotation();
                l.setID("PlateLongAnnotation:" + index);
                l.setValue(1L);
                annotation = l;
            } else if (TagAnnotation.class.getName().equals(type)) {
                TagAnnotation tag = new TagAnnotation();
                tag.setID("PlateTagAnnotation:" + index);
                tag.setValue("Plate:" + index + " TagAnnotation.");
                annotation = tag;
            } else if (TermAnnotation.class.getName().equals(type)) {
                TermAnnotation term = new TermAnnotation();
                term.setID("PlateTermAnnotation:" + index);
                term.setValue("Plate:" + index + " TermAnnotation.");
                annotation = term;
            } else if (FileAnnotation.class.getName().equals(type)) {
                FileAnnotation f = new FileAnnotation();
                f.setID("PlateFileAnnotation:" + index);
                f.setBinaryFile(this.createBinaryFile());
                annotation = f;
            }
            if (annotation != null) {
                ((Plate)object).linkAnnotation(annotation);
            }
        } else if (object instanceof Well) {
            if (CommentAnnotation.class.getName().equals(type)) {
                CommentAnnotation c = new CommentAnnotation();
                c.setID("WellCommentAnnotation:" + index);
                c.setValue("Well:" + index + " CommentAnnotation.");
                annotation = c;
            } else if (BooleanAnnotation.class.getName().equals(type)) {
                BooleanAnnotation b = new BooleanAnnotation();
                b.setID("WellBooleanAnnotation:" + index);
                b.setValue(true);
                annotation = b;
            } else if (LongAnnotation.class.getName().equals(type)) {
                LongAnnotation l = new LongAnnotation();
                l.setID("WellLongAnnotation:" + index);
                l.setValue(1L);
                annotation = l;
            } else if (TagAnnotation.class.getName().equals(type)) {
                TagAnnotation tag = new TagAnnotation();
                tag.setID("WellTagAnnotation:" + index);
                tag.setValue("Well:" + index + " TagAnnotation.");
                annotation = tag;
            } else if (TermAnnotation.class.getName().equals(type)) {
                TermAnnotation term = new TermAnnotation();
                term.setID("WellTermAnnotation:" + index);
                term.setValue("Well:" + index + " TermAnnotation.");
                annotation = term;
            } else if (FileAnnotation.class.getName().equals(type)) {
                FileAnnotation f = new FileAnnotation();
                f.setID("WellFileAnnotation:" + index);
                f.setBinaryFile(this.createBinaryFile());
                annotation = f;
            }
            if (annotation != null) {
                ((Well)object).linkAnnotation(annotation);
            }
        }
        return annotation;
    }

    public OME createImage() {
        this.ome.addImage(this.createImage(0));
        return this.ome;
    }

    public OME createImage(boolean metadata) {
        this.ome.addImage(this.createImage(0, metadata));
        return this.ome;
    }

    public OME createAnnotatedImage() {
        StructuredAnnotations annotations = new StructuredAnnotations();
        int index = 0;
        Image image = this.createImage(index);
        this.ome.addImage(image);
        annotations.addCommentAnnotation((CommentAnnotation)this.createAnnotation(CommentAnnotation.class.getName(), image, index));
        annotations.addBooleanAnnotation((BooleanAnnotation)this.createAnnotation(BooleanAnnotation.class.getName(), image, index));
        annotations.addLongAnnotation((LongAnnotation)this.createAnnotation(LongAnnotation.class.getName(), image, index));
        annotations.addTagAnnotation((TagAnnotation)this.createAnnotation(TagAnnotation.class.getName(), image, index));
        annotations.addTermAnnotation((TermAnnotation)this.createAnnotation(TermAnnotation.class.getName(), image, index));
        this.ome.setStructuredAnnotations(annotations);
        return this.ome;
    }

    public OME createImageWithAcquisitionData() {
        this.populateInstrument();
        Image image = this.createImage(0, true);
        ObjectiveSettings settings = this.createObjectiveSettings(0);
        image.setObjectiveSettings(settings);
        Experiment exp = this.createExperiment(0);
        this.ome.addExperiment(exp);
        MicrobeamManipulation mm = this.createMicrobeamManipulation(0);
        exp.addMicrobeamManipulation(mm);
        image.linkExperiment(exp);
        image.linkInstrument(this.instrument);
        image.linkMicrobeamManipulation(mm);
        this.ome.addImage(image);
        return this.ome;
    }

    public OME createImageWithAnnotatedAcquisitionData() {
        this.populateInstrument();
        this.instrument.setLinkedAnnotation(0, new TagAnnotation());
        List<Detector> detectors = this.instrument.copyDetectorList();
        Iterator<Detector> i = detectors.iterator();
        int index = 0;
        while (i.hasNext()) {
            i.next().setLinkedAnnotation(index, new BooleanAnnotation());
            ++index;
        }
        List<Dichroic> dichroics = this.instrument.copyDichroicList();
        index = 0;
        Iterator<Dichroic> j = dichroics.iterator();
        while (j.hasNext()) {
            j.next().setLinkedAnnotation(index, new LongAnnotation());
            ++index;
        }
        List<Filter> filters = this.instrument.copyFilterList();
        index = 0;
        Iterator<Filter> k = filters.iterator();
        while (k.hasNext()) {
            k.next().setLinkedAnnotation(index, new TermAnnotation());
            ++index;
        }
        List<LightSource> lights = this.instrument.copyLightSourceList();
        index = 0;
        Iterator<LightSource> l = lights.iterator();
        while (l.hasNext()) {
            l.next().setLinkedAnnotation(index, new DoubleAnnotation());
            ++index;
        }
        List<Objective> objectives = this.instrument.copyObjectiveList();
        index = 0;
        Iterator<Objective> m = objectives.iterator();
        while (m.hasNext()) {
            m.next().setLinkedAnnotation(index, new MapAnnotation());
            ++index;
        }
        Image image = this.createImage(0, true);
        ObjectiveSettings settings = this.createObjectiveSettings(0);
        image.setObjectiveSettings(settings);
        Experiment exp = this.createExperiment(0);
        this.ome.addExperiment(exp);
        image.linkExperiment(exp);
        image.linkInstrument(this.instrument);
        this.ome.addImage(image);
        return this.ome;
    }

    public Image createImageWithExperiment(int index, boolean metadata, Experiment exp) {
        Image image = this.createImage(index, metadata);
        image.linkExperiment(exp);
        return image;
    }

    public OME createImageWithROI() {
        int index = 0;
        Image image = this.createImage(index, false);
        this.ome.addImage(image);
        for (int i = 0; i < SIZE_C; ++i) {
            ROI roi = this.createROI(i, 0, i, 0);
            image.linkROI(roi);
            this.ome.addROI(roi);
        }
        return this.ome;
    }

    public OME createPopulatedPlate(int n) {
        this.populateInstrument();
        this.ome.addPlate(this.createPlate(1, 0, 1, 1, 1, n));
        return this.ome;
    }

    public OME createPopulatedPlate(int n, int fields) {
        if (fields < 1) {
            fields = 1;
        }
        this.populateInstrument();
        this.ome.addPlate(this.createPlate(1, 0, 1, 1, fields, n));
        return this.ome;
    }

    public OME createPopulatedPlate(int plates, int rows, int cols, int fields, int acqs) {
        return this.createPopulatedPlate(plates, rows, cols, fields, acqs, true);
    }

    public OME createPopulatedPlate(int plates, int rows, int cols, int fields, int acqs, boolean withMicrobeam) {
        for (int p = 0; p < plates; ++p) {
            Plate plate = this.createPlate(plates, p, rows, cols, fields, acqs, withMicrobeam);
            this.ome.addPlate(plate);
        }
        return this.ome;
    }

    public OME createPopulatedScreen(int screens, int plates, int rows, int cols, int fields, int acqs) {
        return this.createPopulatedScreen(screens, plates, rows, cols, fields, acqs, true);
    }

    public OME createPopulatedScreen(int screens, int plates, int rows, int cols, int fields, int acqs, boolean withMicrobeam) {
        for (int s = 0; s < screens; ++s) {
            Screen screen = this.createScreen(s);
            for (int p = 0; p < plates; ++p) {
                Plate plate = this.createPlate(screens, s, plates, p, rows, cols, fields, acqs, withMicrobeam);
                screen.linkPlate(plate);
                this.ome.addPlate(plate);
            }
            this.ome.addScreen(screen);
        }
        return this.ome;
    }

    public OME createPopulatedScreen(int plates, int rows, int cols, int fields, int acqs) {
        return this.createPopulatedScreen(1, plates, rows, cols, fields, acqs);
    }

    public OME createPopulatedScreen() {
        return this.createPopulatedScreen(1, 2, 2, 2, 2);
    }

    public OME createBasicPlateWithReagent() {
        this.populateInstrument();
        Plate plate = this.createPlate(1, 0, 1, 1, 1, 0);
        Reagent r = this.createReagent(0);
        plate.getWell(0).linkReagent(r);
        Screen screen = this.createScreen(0);
        screen.addReagent(r);
        screen.linkPlate(plate);
        this.ome.addPlate(plate);
        this.ome.addScreen(screen);
        return this.ome;
    }

    public OME createFullPopulatedPlate(int n) {
        this.populateInstrument();
        this.ome.addPlate(this.createPlate(1, 0, n));
        return this.ome;
    }
}

