/*
 * Decompiled with CFR 0.152.
 */
package ome.units.quantity;

import ome.units.quantity.Quantity;
import ome.units.unit.Unit;

public class Frequency
extends Quantity
implements Comparable<Frequency> {
    private static final int SEED1 = 34;
    private static final int SEED2 = 45;
    Number value;
    Unit<Frequency> unit;
    private int hashCodeValue;

    public Frequency(Number inValue, Unit<Frequency> inUnit) {
        if (inValue == null) {
            throw new NullPointerException("Frequency: Frequency cannot be constructed with a null value.");
        }
        this.value = inValue;
        this.unit = inUnit;
        this.hashCodeValue = 34;
        this.hashCodeValue = 45 * this.hashCodeValue + Float.floatToIntBits(this.value.floatValue());
        this.hashCodeValue = 45 * this.hashCodeValue + this.unit.getSymbol().hashCode();
    }

    @Override
    public Number value() {
        return this.value;
    }

    public Number value(Unit<Frequency> inUnit) {
        if (this.unit.equals(inUnit)) {
            return this.value;
        }
        if (this.unit.isConvertible(inUnit).booleanValue()) {
            return this.unit.convertValue(this.value, inUnit);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Frequency otherFrequency = (Frequency)other;
        if (this.unit.equals(otherFrequency.unit)) {
            return this.value.equals(otherFrequency.value);
        }
        if (this.unit.isConvertible(otherFrequency.unit).booleanValue()) {
            return this.unit.convertValue(this.value, otherFrequency.unit).equals(otherFrequency.value);
        }
        return false;
    }

    @Override
    public int compareTo(Frequency other) {
        if (this == other) {
            return 0;
        }
        return Double.compare(this.value.doubleValue(), other.value(this.unit).doubleValue());
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName());
        result.append(": ");
        result.append("value[");
        result.append(this.value);
        result.append("], unit[");
        result.append(this.unit.getSymbol());
        result.append("] stored as ");
        result.append(this.value.getClass().getName());
        return result.toString();
    }

    public Unit<Frequency> unit() {
        return this.unit;
    }
}

