/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.NumericAnnotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LongAnnotation
extends NumericAnnotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(LongAnnotation.class);
    private Long value;
    private StructuredAnnotations structuredAnnotations;

    public LongAnnotation() {
    }

    public LongAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public LongAnnotation(LongAnnotation orig) {
        super(orig);
        this.value = orig.value;
        this.structuredAnnotations = orig.structuredAnnotations;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        List<Element> Value_nodeList = LongAnnotation.getChildrenByTagName(element, "Value");
        if (Value_nodeList.size() > 1) {
            throw new RuntimeException(String.format("Value node list size %d != 1", Value_nodeList.size()));
        }
        if (Value_nodeList.size() != 0) {
            this.setValue(Long.valueOf(Value_nodeList.get(0).getTextContent()));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations_BackReference) {
        this.structuredAnnotations = structuredAnnotations_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element LongAnnotation_element) {
        if (LongAnnotation_element == null) {
            LongAnnotation_element = document.createElementNS(NAMESPACE, "LongAnnotation");
        }
        super.asXMLElement(document, LongAnnotation_element);
        if (this.value != null) {
            Element value_element = document.createElementNS(NAMESPACE, "Value");
            value_element.setTextContent(this.value.toString());
            LongAnnotation_element.appendChild(value_element);
        }
        if (this.structuredAnnotations != null) {
            // empty if block
        }
        return LongAnnotation_element;
    }
}

