/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.point.ProfileFeatureImpl;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationProfileCollectionImpl;
import ucar.nc2.ft.point.StationProfileFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.Station;

public class StandardStationProfileCollectionImpl
extends StationProfileCollectionImpl {
    private DateUnit timeUnit;
    private NestedTable ft;

    StandardStationProfileCollectionImpl(NestedTable ft, DateUnit timeUnit) throws IOException {
        super(ft.getName());
        this.ft = ft;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initStationHelper() {
        try {
            this.stationHelper = new StationHelper();
            StructureDataIterator siter = this.ft.getStationDataIterator(-1);
            try {
                while (siter.hasNext()) {
                    StructureData stationData = siter.next();
                    Station s = this.makeStation(stationData, siter.getCurrentRecno());
                    if (s == null) continue;
                    this.stationHelper.addStation(s);
                }
            }
            finally {
                siter.finish();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public Station makeStation(StructureData stationData, int recnum) {
        Station s = this.ft.makeStation(stationData);
        if (s == null) {
            return null;
        }
        return new StandardStationProfileFeature(s, stationData, recnum);
    }

    @Override
    public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new NestedPointFeatureCollectionIterator(){
            private Iterator iter;
            {
                this.iter = StandardStationProfileCollectionImpl.this.getStations().iterator();
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.iter.hasNext();
            }

            @Override
            public NestedPointFeatureCollection next() throws IOException {
                return (StandardStationProfileFeature)this.iter.next();
            }

            @Override
            public void finish() {
            }

            @Override
            public void setBufferSize(int bytes) {
            }
        };
    }

    private class StandardProfileFeatureIterator
    extends StandardPointFeatureIterator {
        StandardProfileFeatureIterator(NestedTable ft, DateUnit timeUnit, StructureDataIterator structIter, Cursor cursor) throws IOException {
            super(ft, timeUnit, structIter, cursor);
        }

        @Override
        protected boolean isMissing() throws IOException {
            if (super.isMissing()) {
                return true;
            }
            return this.ft.isAltMissing(this.cursor);
        }
    }

    private class StandardProfileFeature
    extends ProfileFeatureImpl {
        private Cursor cursor;

        StandardProfileFeature(Station s, double time, Cursor cursor) throws IOException {
            super(StandardStationProfileCollectionImpl.this.timeUnit.makeStandardDateString(time), s.getLatitude(), s.getLongitude(), time, -1);
            this.cursor = cursor;
            if (Double.isNaN(time)) {
                try {
                    PointFeatureIterator iter = this.getPointFeatureIterator(-1);
                    if (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        this.time = pf.getObservationTime();
                        this.name = StandardStationProfileCollectionImpl.this.timeUnit.makeStandardDateString(this.time);
                    } else {
                        this.name = "empty";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            Cursor cursorIter = this.cursor.copy();
            StructureDataIterator structIter = StandardStationProfileCollectionImpl.this.ft.getLeafFeatureDataIterator(cursorIter, bufferSize);
            StandardProfileFeatureIterator iter = new StandardProfileFeatureIterator(StandardStationProfileCollectionImpl.this.ft, StandardStationProfileCollectionImpl.this.timeUnit, structIter, cursorIter);
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }

        @Override
        public Date getTime() {
            return StandardStationProfileCollectionImpl.this.timeUnit.makeDate(this.time);
        }
    }

    private class StandardStationProfileFeature
    extends StationProfileFeatureImpl {
        Station s;
        StructureData stationData;
        int recnum;

        StandardStationProfileFeature(Station s, StructureData stationData, int recnum) {
            super(s, StandardStationProfileCollectionImpl.this.timeUnit, -1);
            this.s = s;
            this.stationData = stationData;
            this.recnum = recnum;
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
            Cursor cursor = new Cursor(StandardStationProfileCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[2] = this.recnum;
            cursor.tableData[2] = this.stationData;
            cursor.currentIndex = 2;
            StandardStationProfileCollectionImpl.this.ft.addParentJoin(cursor);
            return new TimeSeriesOfProfileFeatureIterator(cursor);
        }

        @Override
        public List<Date> getTimes() throws IOException {
            ArrayList<Date> result = new ArrayList<Date>();
            this.resetIteration();
            while (this.hasNext()) {
                ProfileFeature pf = this.next();
                result.add(pf.getTime());
            }
            return result;
        }

        @Override
        public ProfileFeature getProfileByDate(Date date) throws IOException {
            this.resetIteration();
            while (this.hasNext()) {
                ProfileFeature pf = this.next();
                if (!pf.getTime().equals(date)) continue;
                return pf;
            }
            return null;
        }

        private class TimeSeriesOfProfileFeatureIterator
        implements PointFeatureCollectionIterator {
            private Cursor cursor;
            private StructureDataIterator iter;
            private int count = 0;

            TimeSeriesOfProfileFeatureIterator(Cursor cursor) throws IOException {
                this.cursor = cursor;
                this.iter = StandardStationProfileCollectionImpl.this.ft.getMiddleFeatureDataIterator(cursor, -1);
            }

            @Override
            public boolean hasNext() throws IOException {
                do {
                    if (!this.iter.hasNext()) {
                        StandardStationProfileFeature.this.timeSeriesNpts = this.count;
                        return false;
                    }
                    this.cursor.tableData[1] = this.iter.next();
                    this.cursor.recnum[1] = this.iter.getCurrentRecno();
                    this.cursor.currentIndex = 1;
                    StandardStationProfileCollectionImpl.this.ft.addParentJoin(this.cursor);
                } while (StandardStationProfileCollectionImpl.this.ft.isMissing(this.cursor));
                return true;
            }

            @Override
            public PointFeatureCollection next() throws IOException {
                ++this.count;
                return new StandardProfileFeature(StandardStationProfileFeature.this.s, StandardStationProfileCollectionImpl.this.ft.getObsTime(this.cursor), this.cursor.copy());
            }

            @Override
            public void setBufferSize(int bytes) {
                this.iter.setBufferSize(bytes);
            }

            @Override
            public void finish() {
                this.iter.finish();
            }
        }
    }
}

