/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

public class GridTimeCoord
implements Comparable<GridTimeCoord> {
    private static Logger log = LoggerFactory.getLogger(GridTimeCoord.class);
    protected int seq = 0;
    protected String timeUdunit;
    protected int timeUnit;
    protected Date baseDate;
    protected boolean refDateDiffers = false;
    protected List<Date> times;
    protected List<TimeCoordWithInterval> timeIntvs;
    protected int constantInterval = -1;
    protected int[] coordData;

    protected GridTimeCoord(List<GridRecord> records, String where) {
        for (GridRecord record : records) {
            Date ref;
            if (this.baseDate == null) {
                this.baseDate = record.getReferenceTime();
                this.timeUdunit = record.getTimeUdunitName();
                this.timeUnit = record.getTimeUnit();
            }
            if (!this.baseDate.equals(ref = record.getReferenceTime())) {
                this.refDateDiffers = true;
                if (ref.before(this.baseDate)) {
                    this.baseDate = ref;
                }
            }
            if (record.getTimeUnit() == this.timeUnit) continue;
            log.warn("time units mismatch {} != {}", (Object)record.getTimeUnit(), (Object)this.timeUnit);
        }
        this.times = new ArrayList<Date>();
        for (GridRecord gr : records) {
            Date validTime = gr.getValidTime();
            if (validTime == null) {
                validTime = gr.getReferenceTime();
            }
            if (this.times.contains(validTime)) continue;
            this.times.add(validTime);
        }
        Collections.sort(this.times);
    }

    protected boolean matchTimes(List<GridRecord> records) {
        for (GridRecord record : records) {
            if (this.timeUdunit.equals(record.getTimeUdunitName())) continue;
            return false;
        }
        ArrayList<Date> timeList = new ArrayList<Date>(records.size());
        for (GridRecord record : records) {
            Date validTime = record.getValidTime();
            if (validTime == null) {
                validTime = record.getReferenceTime();
            }
            if (timeList.contains(validTime)) continue;
            timeList.add(validTime);
        }
        Collections.sort(timeList);
        return timeList.equals(this.times);
    }

    void setSequence(int seq) {
        this.seq = seq;
    }

    public String getName() {
        return this.seq == 0 ? "time" : "time" + this.seq;
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        ncfile.addDimension(g, new Dimension(this.getName(), this.getNTimes(), true));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        Variable v = new Variable(ncfile, g, null, this.getName());
        v.setDataType(DataType.INT);
        DateFormatter formatter = new DateFormatter();
        String refDate = formatter.toDateTimeStringISO(this.baseDate);
        String udunit = this.timeUdunit + " since " + refDate;
        DateUnit dateUnit = null;
        try {
            dateUnit = new DateUnit(udunit);
        }
        catch (Exception e) {
            log.error("TimeCoord not added, cant make DateUnit from String '" + udunit + "'", e);
            return;
        }
        Array coordArray = null;
        Array boundsArray = null;
        int ntimes = this.getNTimes();
        this.coordData = new int[ntimes];
        if (!this.isInterval()) {
            for (int i = 0; i < this.times.size(); ++i) {
                this.coordData[i] = (int)dateUnit.makeValue(this.times.get(i));
            }
            coordArray = Array.factory(DataType.INT, new int[]{ntimes}, (Object)this.coordData);
        } else {
            int[] boundsData = new int[ntimes * 2];
            for (int i = 0; i < this.timeIntvs.size(); ++i) {
                TimeCoordWithInterval tintv = this.timeIntvs.get(i);
                this.coordData[i] = tintv.start + tintv.interval;
                boundsData[2 * i + 1] = tintv.start + tintv.interval;
                boundsData[2 * i] = tintv.start;
            }
            coordArray = Array.factory(DataType.INT, new int[]{ntimes}, (Object)this.coordData);
            boundsArray = Array.factory(DataType.INT, new int[]{ntimes, 2}, (Object)boundsData);
        }
        v.setDimensions(v.getShortName());
        v.setCachedData(coordArray, false);
        if (!this.isInterval()) {
            v.addAttribute(new Attribute("long_name", "forecast time"));
            v.addAttribute(new Attribute("units", this.timeUdunit + " since " + refDate));
        } else {
            Formatter intervalName = new Formatter();
            if (this.constantInterval < 0) {
                intervalName.format("(mixed intervals)", new Object[0]);
            } else {
                intervalName.format("(%d %s intervals)", this.constantInterval, this.timeUdunit);
            }
            v.addAttribute(new Attribute("long_name", "forecast time for " + intervalName.toString()));
            v.addAttribute(new Attribute("units", this.timeUdunit + " since " + refDate));
            v.addAttribute(new Attribute("bounds", this.getName() + "_bounds"));
            if (g == null) {
                g = ncfile.getRootGroup();
            }
            Dimension bd = DatasetConstructor.getBoundsDimension(ncfile);
            Variable vb = new Variable(ncfile, g, null, this.getName() + "_bounds");
            vb.setDataType(DataType.INT);
            vb.setDimensions(this.getName() + " " + bd.getShortName());
            vb.addAttribute(new Attribute("long_name", "bounds for " + this.getName()));
            vb.addAttribute(new Attribute("units", this.timeUdunit + " since " + refDate));
            vb.setCachedData(boundsArray, false);
            ncfile.addVariable(g, vb);
        }
        ncfile.addVariable(g, v);
    }

    public int findIndex(GridRecord record) {
        Date validTime = record.getValidTime();
        return this.times.indexOf(validTime);
    }

    int getNTimes() {
        return this.isInterval() ? this.timeIntvs.size() : this.times.size();
    }

    int getConstantInterval() {
        return this.constantInterval;
    }

    String getTimeUnit() {
        return this.timeUdunit;
    }

    public boolean isInterval() {
        return this.timeIntvs != null;
    }

    public String getCoord(int i) {
        if (this.timeIntvs == null) {
            return this.coordData[i] + " ";
        }
        TimeCoordWithInterval ti = this.timeIntvs.get(i);
        return this.coordData[i] + "=" + ti.start + "/" + ti.interval;
    }

    @Override
    public int compareTo(GridTimeCoord o) {
        return o.getNTimes() - this.getNTimes();
    }

    protected class TimeCoordWithInterval
    implements Comparable<TimeCoordWithInterval> {
        public Date coord;
        public int start;
        public int interval;

        public TimeCoordWithInterval(Date coord, int start, int interval) {
            this.coord = coord;
            this.start = start;
            this.interval = interval;
        }

        @Override
        public int compareTo(TimeCoordWithInterval o) {
            int diff = this.coord.compareTo(o.coord);
            return diff == 0 ? o.interval - this.interval : diff;
        }

        public int hashCode() {
            return 17 * this.coord.hashCode() + this.interval;
        }

        public boolean equals(Object obj) {
            TimeCoordWithInterval o = (TimeCoordWithInterval)obj;
            return this.coord.equals(o.coord) && this.interval == o.interval;
        }

        public String toString() {
            return "start=" + this.start + ", interval=" + this.interval;
        }
    }
}

