/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.CpuInfo;
import edu.stanford.facs.swing.Html;
import edu.stanford.facs.swing.ImageIconColorer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Basics {
    public static Float widthFactor;
    public static Float heightFactor;
    public static Float toolBarFactor;
    static final String UTF8 = "UTF-8";
    private static final String[] entities;
    private static char[] symbols;

    public static String getUnique(Set<String> set, String string) {
        if (set.contains(string)) {
            int n = 2;
            while (set.contains(string + " #" + n)) {
                ++n;
            }
            return string + " #" + n;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(Properties properties, String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string));
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return true;
    }

    public static int debugProperties(Properties properties) {
        Basics.debug(properties.keySet().iterator());
        Basics.debug(properties.values().iterator());
        return 0;
    }

    public static int debug(Iterator iterator) {
        int n = 1;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            System.out.println("#" + n + " key=\"" + e.toString() + "\", class=" + e.getClass().getCanonicalName());
            ++n;
        }
        return n;
    }

    public static Map<Object, Object> SelfishMap(Collection<Object> collection, Map<Object, Object> map) {
        for (Object object : collection) {
            map.put(object, object);
        }
        return map;
    }

    public static Collection<String> Capitalize(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            if (string.length() <= 0) continue;
            String string2 = string.substring(0, 1).toUpperCase();
            if (string.length() > 1) {
                string2 = string2 + string.substring(1, string.length());
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static JDialog ShowMsgModeless(String string) {
        return Basics.ShowMsgModeless(string, "Note..", true);
    }

    public static JDialog ShowMsgModeless(String string, String string2, boolean bl) {
        JOptionPane jOptionPane = new JOptionPane(string);
        JDialog jDialog = jOptionPane.createDialog(string2);
        jDialog.setModal(false);
        if (bl) {
            jDialog.setVisible(true);
        }
        return jDialog;
    }

    public static boolean IsExpression(String string) {
        int n = string.length();
        block3: for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '!': 
                case '&': 
                case '(': 
                case ')': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '|': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static String getHomeNoDriveLetter() {
        String string = System.getProperty("user.home").indexOf(":") == 1 ? System.getProperty("user.home").substring(2) : System.getProperty("user.home");
        return string;
    }

    public Set getDupSet(Collection<String> collection, Map<String, List> map, String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        if (collection.size() >= 0) {
            Iterator<String> iterator = collection.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                List list = map.get(string2);
                if (list == null) {
                    treeSet.add(string2);
                    continue;
                }
                if (list.size() == 0) {
                    treeSet.add(string2);
                    continue;
                }
                if (string == null || !list.contains(string)) {
                    int n = list.size();
                    String string3 = string2 + " #" + (n + 1);
                    while (map.containsKey(string3)) {
                        n = n++;
                        string3 = string2 + " #" + (n + 1);
                    }
                    arrayList.add(string2);
                    arrayList2.add(string3);
                    treeSet2.add(string2);
                    continue;
                }
                treeSet.add(string2);
            }
        }
        return treeSet;
    }

    public static void savePng(ImageIcon imageIcon, String string, String string2) throws IOException {
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
    }

    public static JTextField GetTextField(JComboBox<Object> jComboBox, int n) {
        jComboBox.setSelectedIndex(-1);
        jComboBox.setEditable(true);
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        jTextField.setFocusable(true);
        jTextField.setText("");
        jTextField.setColumns(n);
        String string = new String(new char[n]).replace("\u0000", "F");
        jComboBox.setPrototypeDisplayValue(string);
        jTextField.setFocusable(true);
        jTextField.setText("");
        return jTextField;
    }

    public static int Scale(int n) {
        if ((double)toolBarFactor.floatValue() < 1.1) {
            return n;
        }
        return (int)((float)n * toolBarFactor.floatValue());
    }

    public static Object GetResizedImg(File file, float f, File file2) {
        String string = file.getAbsolutePath();
        if ((double)f > 0.0 && f != 1.0f && file.exists()) {
            File file3;
            String string2 = file.getName();
            int n = string2.lastIndexOf(".");
            if (n >= 0) {
                string2 = string2.substring(0, n) + "_" + f + ".png";
            }
            if (!(file3 = new File(file2, string2)).exists()) {
                ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
                int n2 = (int)((float)imageIcon.getIconWidth() * f);
                int n3 = (int)((float)imageIcon.getIconHeight() * f);
                Image image = Basics.Resize(imageIcon, n2, n3).getImage();
                BufferedImage bufferedImage = ImageIconColorer.ImageToBufferedImage(image, n2, n3);
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", file3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }
            string = file3.getAbsolutePath();
        }
        return string;
    }

    public static void HearEnterKey(final JList jList, final JButton jButton) {
        jList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray.length > 1) {
                    return;
                }
                if (keyEvent.getKeyCode() == 10) {
                    System.out.println("Sending ACTION_PERFORMED to ActionListener");
                    jButton.doClick();
                    keyEvent.consume();
                }
            }
        });
    }

    public static ImageIcon Resize(ImageIcon imageIcon, float f) {
        if (imageIcon == null) {
            return null;
        }
        int n = (int)((float)imageIcon.getIconWidth() * f);
        int n2 = (int)((float)imageIcon.getIconHeight() * f);
        return Basics.Resize(imageIcon, n, n2, 4);
    }

    public static ImageIcon Resize(ImageIcon imageIcon, int n, int n2) {
        return Basics.Resize(imageIcon, n, n2, 4);
    }

    public static ImageIcon Resize(ImageIcon imageIcon, int n, int n2, int n3) {
        return Basics.Resize(imageIcon.getImage(), n, n2, n3);
    }

    public static ImageIcon Resize(Image image, int n, int n2, int n3) {
        Image image2 = image.getScaledInstance(n, n2, n3);
        return new ImageIcon(image2);
    }

    public static void setResizingFactors(float f, float f2, float f3) {
        widthFactor = Float.valueOf(f);
        heightFactor = Float.valueOf(f2);
        toolBarFactor = Float.valueOf(f3);
    }

    public static ImageIcon ResizeIfNeeded(ImageIcon imageIcon) {
        if (toolBarFactor == null) {
            Basics.setResizing(2000, 2000, 12);
        }
        if (toolBarFactor.floatValue() != 1.0f) {
            return Basics.Resize(imageIcon, toolBarFactor.floatValue());
        }
        return imageIcon;
    }

    public static void setResizing(int n, int n2, int n3) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        widthFactor = Float.valueOf(1.0f);
        heightFactor = Float.valueOf(1.0f);
        toolBarFactor = Float.valueOf(1.0f);
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            if (rectangle == null || rectangle.height <= n && rectangle.width <= n2) continue;
            toolBarFactor = Float.valueOf((float)UIManager.getFont("Label.font").getSize() / (float)n3);
            heightFactor = Float.valueOf((float)rectangle.height / (float)n);
            widthFactor = Float.valueOf((float)rectangle.width / (float)n2);
        }
    }

    public static void setFontFace(String string) {
        String[] stringArray = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Font font = (Font)UIManager.get(string2);
            UIManager.put(string2, new Font(string, font.getStyle(), font.getSize()));
        }
    }

    public static synchronized ArrayList<Double> readMatrix(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(string)), UTF8));
            return Basics.readMatrix(bufferedReader, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ArrayList<Double> readMatrix(BufferedReader bufferedReader, boolean bl) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (bufferedReader != null) {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (bl) {
                        System.out.println("***" + string);
                    }
                    String[] stringArray = string.split(", *");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Double d = 0.0;
                        try {
                            d = Double.parseDouble(stringArray[i]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        arrayList.add(d);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                CpuInfo.closeWithoutThrowingUp(bufferedReader);
            }
        }
        return arrayList;
    }

    public static double[][] reshape2D(Collection<Double> collection) {
        int n = (int)Math.sqrt(collection.size());
        return Basics.reshape2D(collection, n, n);
    }

    public static double[][] reshape2D(Collection<Double> collection, int n, int n2) {
        double[][] dArrayArray = new double[n][];
        Iterator<Double> iterator = collection.iterator();
        int n3 = 0;
        int n4 = 0;
        double[] dArray = new double[n2];
        while (iterator.hasNext()) {
            dArray[n4] = iterator.next();
            if (++n4 != 256) continue;
            n4 = 0;
            dArray = new double[n2];
            dArrayArray[n3] = dArray;
            ++n3;
        }
        return dArrayArray;
    }

    public static double[] reshape1D(Collection<Double> collection) {
        double[] dArray = new double[collection.size()];
        Iterator<Double> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            dArray[n] = iterator.next();
            ++n;
        }
        return dArray;
    }

    public static String padRight(String string, int n) {
        return String.format("%-" + n + "s", string);
    }

    public static String padLeft(String string, int n) {
        return String.format("%" + n + "s", string);
    }

    public static PrintStream print(PrintStream printStream, String string, int[][] nArray) {
        return Basics.print(printStream, string, nArray, 12, "; ", "...");
    }

    public static PrintStream print(PrintStream printStream, String string, int[][] nArray, int n, String string2, String string3) {
        printStream.print(string);
        String string4 = Basics.padLeft(" ", string.length() + 1);
        printStream.print("[");
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            for (n2 = 0; n2 < nArray[i].length; ++n2) {
                printStream.print(nArray[i][n2]);
                if (n2 >= nArray[i].length - 1) continue;
                printStream.print(" ");
            }
            if (i >= nArray.length - 1) continue;
            printStream.print(string2);
            n2 = (i + 1) % n;
            if (n2 != 0) continue;
            printStream.println(string3);
            printStream.print(string4);
        }
        printStream.println("]");
        return printStream;
    }

    public static double mean(int[][] nArray, int n) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i][n];
        }
        return d / (double)nArray.length;
    }

    public static int[][] clockwise(int[][] nArray) {
        int[][] nArray2 = new int[nArray.length][2];
        double d = Basics.mean(nArray, 0);
        double d2 = Basics.mean(nArray, 1);
        Comparable[] comparableArray = new Double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            comparableArray[i] = Double.valueOf(Math.atan2((double)nArray[i][1] + d2, (double)nArray[i][0] + d));
        }
        int[] nArray3 = new IndirectSorter().sort(comparableArray, false);
        for (int i = 0; i < nArray3.length; ++i) {
            int n = nArray3[i];
            nArray2[i][0] = nArray[n][0];
            nArray2[i][1] = nArray[n][1];
        }
        return nArray2;
    }

    public static int[] reshape1DInt(Collection<Double> collection) {
        int[] nArray = new int[collection.size()];
        Iterator<Double> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            double d = iterator.next();
            nArray[n] = (int)d;
            ++n;
        }
        return nArray;
    }

    public static int[] toInt(Collection collection) {
        int[] nArray = new int[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n2 = 0;
            if (e instanceof Number) {
                n2 = ((Number)e).intValue();
            } else {
                try {
                    n2 = (int)Double.parseDouble(e.toString());
                }
                catch (Exception exception) {
                    System.out.println("Can't convert " + e);
                }
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public String ToFile() {
        return null;
    }

    public static Object EncodeFileUrl(String string) {
        return URLEncoder.encode(string).replaceAll("\\+", "%20");
    }

    public static Object EncodeFileUrl2(String string, String string2) {
        return URLEncoder.encode(new File(string, string2).getAbsolutePath()).replaceAll("\\+", "%20");
    }

    public static String firstWord(String string) {
        int n = string.indexOf(32);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String RemoveXml(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        int n = cArray.length;
        int n2 = entities.length;
        boolean bl = false;
        block5: for (int i = 0; i < n; ++i) {
            if (bl) {
                if (cArray[i] != '>') continue;
                bl = false;
                continue;
            }
            switch (cArray[i]) {
                case '<': {
                    bl = true;
                }
                case '*': 
                case '[': 
                case ']': 
                case '^': {
                    continue block5;
                }
                case '&': {
                    int n3;
                    for (n3 = i + 1; n3 < n && cArray[n3] != ';'; ++n3) {
                    }
                    if (n3 < n) {
                        int n4;
                        String string2 = string.substring(i, n3);
                        for (n4 = 0; n4 < n2; ++n4) {
                            if (!string2.equals(entities[n4])) continue;
                            stringBuilder.append(symbols[n4]);
                            break;
                        }
                        if (n4 == n2) {
                            stringBuilder.append(string2);
                            stringBuilder.append(';');
                        }
                    }
                    i = n3;
                    continue block5;
                }
                default: {
                    stringBuilder.append(cArray[i]);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object2 != null) {
            return object2.equals(object);
        }
        return object.equals(object2);
    }

    public static String getFileNameNoExtension(String string) {
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static Object Pluralize(String string, int n) {
        if (n > 1 || n == 0) {
            return string + "s";
        }
        return string;
    }

    public static Object Pluralize(String string, int n, String string2) {
        if (n > 1 || n == 0) {
            return string2;
        }
        return string;
    }

    public static Object Pluralize2(String string, int n) {
        if (n > 1 || n == 0) {
            return n + " " + string + "s";
        }
        return n + " " + string;
    }

    public static Object Pluralize2(String string, int n, String string2) {
        if (n > 1 || n == 0) {
            return n + " " + string2;
        }
        return n + " " + string;
    }

    public static void main(String[] stringArray) {
        Test.go(stringArray);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static List<String> tabToCsv(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(string.replaceAll(",", "").replaceAll("\t", ","));
        }
        return arrayList;
    }

    public static Object tabToCsv(String string) {
        return string.replaceAll(",", " ").replaceAll("\t", ",");
    }

    public static List<Integer> indexesOf(String string, String string2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = string.indexOf(string2);
        while (n >= 0) {
            arrayList.add(n);
            n = string.indexOf(string2, n + string2.length());
        }
        return arrayList;
    }

    public static void Shake(JComponent jComponent) {
        Basics.Shake(jComponent, 30, Color.red);
    }

    public static void Shake(JComponent jComponent, int n) {
        Basics.Shake(jComponent, n, Color.red);
    }

    public static void Shake(final JComponent jComponent, final int n, final Color color) {
        final Point point = jComponent.getLocation();
        final Color color2 = jComponent.getForeground();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < n; ++i) {
                    int n3;
                    int n2;
                    Color color3;
                    if ((i + 1) % 2 == 1) {
                        color3 = color2;
                        n2 = -3;
                        n3 = 3;
                    } else {
                        color3 = color;
                        n2 = 2;
                        n3 = 4;
                    }
                    try {
                        Basics.Relocate(jComponent, new Point(point.x + n3, point.y - n2), color3);
                        Thread.sleep(75L);
                        Basics.Relocate(jComponent, point, color3);
                        Thread.sleep(75L);
                        Basics.Relocate(jComponent, new Point(point.x - n3, point.y + n2), color3);
                        Thread.sleep(75L);
                        Basics.Relocate(jComponent, point, color3);
                        Thread.sleep(75L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                Basics.Relocate(jComponent, point, color2);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public static void Relocate(final JComponent jComponent, final Point point, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.setLocation(point);
                jComponent.setForeground(color);
            }
        });
    }

    public static Object[] StrDensity1D(double[][] dArray, String[] stringArray, String string, String string2) {
        int n = stringArray.length;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        StringBuilder stringBuilder = new StringBuilder(40 * n2);
        Object[] objectArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            int n4;
            stringBuilder.setLength(0);
            stringBuilder.append("<table><tr><td bgcolor='white'>");
            stringBuilder.append(string);
            double d = -99.0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (!(dArray[n4][i] > d)) continue;
                d = dArray[n4][i];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if (dArray[n4][i] < 1.0E-6) {
                    stringBuilder.append("<font color='#FFFFFF'");
                } else {
                    stringBuilder.append("<font ");
                    int n5 = (int)Math.ceil(dArray[n4][i] / d * (double)n) - 1;
                    stringBuilder.append(stringArray[n5]);
                    stringBuilder.append(" bg");
                    stringBuilder.append(stringArray[n5]);
                }
                stringBuilder.append(">&#10074;</font>");
            }
            stringBuilder.append(string2);
            stringBuilder.append("</td></tr></table>");
            objectArray[i] = stringBuilder.toString();
        }
        return objectArray;
    }

    public static Integer[] toIntegers(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public static ArrayList<String> containsPartialKey(Map<String, Object> map, String string) {
        return Basics.containsPartial(map.keySet(), string);
    }

    public static ArrayList<String> containsPartialKeyIgnoreCase(Map<String, Object> map, String string) {
        return Basics.containsPartialIgnoreCase(map.keySet(), string);
    }

    public static ArrayList<String> containsPartial(Collection<String> collection, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : collection) {
            if (!string2.contains(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static ArrayList<String> containsPartialIgnoreCase(Collection<String> collection, String string) {
        String string2 = string.toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : collection) {
            if (!string3.toLowerCase().contains(string2)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static String expandHome(String string) {
        if (string.contains("~")) {
            return string.replace("~", Basics.getHomeNoDriveLetter());
        }
        return string;
    }

    static {
        entities = new String[]{"&nbsp", "&amp", "&lt", "&gt", "&cent", "&pound", "&yen", "&euro", "&copy", "&reg"};
        symbols = new char[]{' ', '&', '<', '>', '\u00a2', '\u00a3', '\u00a5', '\u20ac', '\u00a9', '\u00ae'};
    }

    public static class IndirectSorter<T extends Comparable<T>> {
        public int[] sort(T[] TArray, boolean bl) {
            int n;
            Integer[] integerArray = new Integer[TArray.length];
            int[] nArray = new int[TArray.length];
            for (n = 0; n < integerArray.length; ++n) {
                integerArray[n] = new Integer(n);
            }
            Arrays.sort(integerArray, new IndirectCompareClass(this, TArray, bl));
            for (n = 0; n < integerArray.length; ++n) {
                nArray[n] = integerArray[n];
            }
            return nArray;
        }

        public String[] sortLetters(T[] TArray, boolean bl) {
            int n = TArray.length;
            String[] stringArray = new String[n];
            StringBuilder stringBuilder = new StringBuilder();
            int[] nArray = new IndirectSorter<T>().sort((Comparable[])TArray, bl);
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                stringBuilder.setLength(0);
                int n3 = i % 26;
                char c = 'A';
                c = (char)(c + n3);
                stringBuilder.append(c);
                if (i > 25) {
                    stringBuilder.append(i / 26);
                }
                stringArray[n2] = stringBuilder.toString();
            }
            return stringArray;
        }

        class IndirectCompareClass<T extends Comparable<T>>
        implements Comparator<Integer> {
            final T[] args;
            final boolean descending;
            final /* synthetic */ IndirectSorter this$0;

            /*
             * WARNING - Possible parameter corruption
             */
            public IndirectCompareClass(T[] TArray, boolean bl) {
                this.this$0 = (IndirectSorter)n;
                this.args = TArray;
                this.descending = bl;
            }

            @Override
            public int compare(Integer n, Integer n2) {
                if (this.descending) {
                    return this.args[n2].compareTo(this.args[n]);
                }
                return this.args[n].compareTo(this.args[n2]);
            }

            public boolean equals(Integer n, Integer n2) {
                if (this.descending) {
                    return this.args[n2].equals(this.args[n]);
                }
                return this.args[n].equals(this.args[n2]);
            }
        }
    }

    private static class Test {
        private Test() {
        }

        static void go(String[] stringArray) {
            Object object = (String)Basics.GetResizedImg(new File("/Users/swmeehan/Documents/eclipse/CytoGate/matlabsrc/tree.png"), 32.0f, new File("/Users/swmeehan/.autoGate"));
            object = Basics.GetResizedImg(new File("/Users/swmeehan/Documents/eclipse/AutooGate/matlabsrc/tree.png"), 32.0f, new File("/Users/swmeehan/.autoGate"));
            Object object2 = Basics.EncodeFileUrl("/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate/76.png");
            object2 = Basics.EncodeFileUrl2("/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", "76.png");
            object2 = Basics.EncodeFileUrl2("/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", "76.png");
            object2 = Html.ImgSized2("76.png", "/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", 1.0, 200, false);
            object2 = Html.ImgSized2("76.png", "/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", 1.0, 200, true);
            object2 = Html.ImgSized2("76.png", "/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", 0.5, 200, false);
            object2 = Html.ImgSized2("76.png", "/Users/swmeehan/Dropbox/AutoGate experiments/Denong/15-120915_Lisa/.autoGate", 0.75, 200, true);
            String string = Basics.RemoveXml("HI how are you");
            String string2 = Basics.RemoveXml("<html>I am good and &gt; you at making &cent; and &euro;nd &stuff; like that!!&aMp");
            String string3 = "/Users/swmeehan/Documents/workspace/CytoGate/matlabsrc/pointers.txt";
            if (stringArray.length > 0) {
                string3 = stringArray[0];
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("123.44");
            arrayList.add(45.2);
            arrayList.add(2);
            arrayList.add(Character.valueOf('h'));
            int[] nArray = Basics.toInt(arrayList);
            ArrayList<Double> arrayList2 = Basics.readMatrix(string3);
            double[][] dArray = Basics.reshape2D(arrayList2);
            double[] dArray2 = Basics.reshape1D(arrayList2);
            System.out.println(arrayList2);
        }
    }

    public static class Dups {
        final Set<String> unused = new TreeSet<String>();
        final Set<String> used = new TreeSet<String>();
        final List<String> dups = new ArrayList<String>();
        final List<String> dupAlts = new ArrayList<String>();
    }
}

