/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

public class ChangeQuantification {
    public static double quadraticForm(double d, double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, int[] nArray3) {
        double d2 = 0.0;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] - 1;
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[j] - 1;
                d2 += (1.0 - Math.sqrt((nArray2[i] - nArray2[j]) * (nArray2[i] - nArray2[j]) + (nArray3[i] - nArray3[j]) * (nArray3[i] - nArray3[j])) / d) * (dArray[n2] - dArray2[n2]) * (dArray[n3] - dArray2[n3]);
            }
        }
        return Math.sqrt(d2);
    }

    public static double quadraticForm2(float f, float[] fArray, float[] fArray2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            n = nArray[i] - 1;
            dArray[i] = fArray[n] - fArray2[n];
        }
        float f2 = 0.0f;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                f2 = (float)((double)f2 + (1.0 - Math.sqrt((nArray2[n] - nArray2[i]) * (nArray2[n] - nArray2[i]) + (nArray3[n] - nArray3[i]) * (nArray3[n] - nArray3[i])) / (double)f) * dArray[n] * dArray[i]);
            }
        }
        return Math.sqrt(f2);
    }

    public static double quadraticForm3(float f, float[] fArray, float[] fArray2, int[] nArray, float[] fArray3, float[] fArray4) {
        int n;
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            n = nArray[i] - 1;
            dArray[i] = fArray[n] - fArray2[n];
        }
        float f2 = 0.0f;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                f2 = (float)((double)f2 + (1.0 - Math.sqrt((fArray3[n] - fArray3[i]) * (fArray3[n] - fArray3[i]) + (fArray4[n] - fArray4[i]) * (fArray4[n] - fArray4[i])) / (double)f) * dArray[n] * dArray[i]);
            }
        }
        return Math.sqrt(f2);
    }

    public static double quadraticFormHiDSlow(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = dArray.length;
        double d = ChangeQuantification.maxDistSlow(dArray3);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                d2 += (1.0 - ChangeQuantification.dist(dArray3[i], dArray3[j]) / d) * (dArray[i] - dArray2[i]) * (dArray[j] - dArray2[j]);
            }
        }
        return Math.sqrt(d2);
    }

    public static double quadraticFormHiD(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = dArray.length;
        double d = ChangeQuantification.maxDist(dArray3);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = dArray3[i];
            for (int j = 0; j < n; ++j) {
                double[] dArray5 = dArray3[j];
                double d3 = 0.0;
                for (int k = 0; k < dArray4.length; ++k) {
                    double d4 = dArray5[k] - dArray4[k];
                    d3 += d4 * d4;
                }
                double d5 = Math.sqrt(d3);
                d2 += (1.0 - d5 / d) * (dArray[i] - dArray2[i]) * (dArray[j] - dArray2[j]);
            }
        }
        return Math.sqrt(d2);
    }

    public static double quadraticForm(double d, double[] dArray, double[] dArray2, double[][] dArray3) {
        return ChangeQuantification.quadraticForm(d, dArray, dArray2, dArray3[0], dArray3[1]);
    }

    public static double quadraticForm(double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray.length;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                f = (float)((double)f + (1.0 - Math.sqrt((dArray3[i] - dArray3[j]) * (dArray3[i] - dArray3[j]) + (dArray4[i] - dArray4[j]) * (dArray4[i] - dArray4[j])) / d) * (dArray[i] - dArray2[i]) * (dArray[j] - dArray2[j]));
            }
        }
        return Math.sqrt(f);
    }

    public static double quadraticForm(float f, float[] fArray, float[] fArray2, float[][] fArray3, int[] nArray) {
        return ChangeQuantification.quadraticForm(f, fArray, fArray2, fArray3[0], fArray3[1], nArray);
    }

    public static double maxDistSlow(double[][] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d2 = ChangeQuantification.dist(dArray[i], dArray[j]);
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public static double dist(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray2[i] - dArray[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double maxDist(double[][] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n; ++j) {
                double[] dArray3 = dArray[j];
                double d2 = 0.0;
                for (int k = 0; k < dArray2.length; ++k) {
                    double d3 = dArray3[k] - dArray2[k];
                    d2 += d3 * d3;
                }
                double d4 = Math.sqrt(d2);
                if (!(d4 > d)) continue;
                d = d4;
            }
        }
        return d;
    }

    public static double quadraticForm(float f, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int[] nArray) {
        int n = nArray.length;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] - 1;
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[j] - 1;
                f2 = (float)((double)f2 + (1.0 - Math.sqrt((fArray3[i] - fArray3[j]) * (fArray3[i] - fArray3[j]) + (fArray4[i] - fArray4[j]) * (fArray4[i] - fArray4[j])) / (double)f) * (double)(fArray[n2] - fArray2[n2]) * (double)(fArray[n3] - fArray2[n3]));
            }
        }
        return Math.sqrt(f2);
    }

    public static double quadraticFormGaussian(double d, double[] dArray, double[] dArray2, double[][] dArray3, int[] nArray) {
        return ChangeQuantification.quadraticFormGaussian(d, dArray, dArray2, dArray3[0], dArray3[1], nArray);
    }

    public static double quadraticFormGaussian(double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int[] nArray) {
        int n = nArray.length;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] - 1;
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[j] - 1;
                double d2 = Math.sqrt((dArray3[i] - dArray3[j]) * (dArray3[i] - dArray3[j]) + (dArray4[i] - dArray4[j]) * (dArray4[i] - dArray4[j]));
                f = (float)((double)f + Math.exp(-1.0 * (d2 / d * (d2 / d))) * (dArray[n2] - dArray2[n2]) * (dArray[n3] - dArray2[n3]));
            }
        }
        return Math.sqrt(f);
    }

    public static double chiSquare(double[] dArray, double[] dArray2, int[] nArray) {
        double d = 0.0;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] - 1;
            if (!(dArray[n2] + dArray2[n2] > 0.0)) continue;
            d += (dArray[n2] - dArray2[n2]) * (dArray[n2] - dArray2[n2]) / (dArray[n2] + dArray2[n2]);
        }
        return d;
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{15.0, 44.0, 33.0}, {100.0, 2.0, 4.0}};
        double[][] dArrayArray2 = new double[][]{{125.0, 4.0, 31.0}, {10.0, 22.0, 14.0}, {92.0, 88.0, 121.0}};
        for (int i = 0; i < dArrayArray.length; ++i) {
            for (int j = 0; j < dArrayArray2.length; ++j) {
                System.out.print(ChangeQuantification.dist(dArrayArray[i], dArrayArray2[j]));
                System.out.print('\t');
            }
            System.out.println();
        }
        double d = Math.exp(5.0);
        d = Math.exp(10.0);
        int[][] nArrayArray = new int[][]{{1, 4, 5}, {11, 44, 55}};
        int[] nArray = nArrayArray[0];
        int[] nArray2 = nArrayArray[1];
        int[] nArray3 = new int[]{1, 2, 4};
        double[] dArray = new double[]{0.5, 0.25, 0.0, 0.13, 0.0, 0.55, 0.66};
        double[] dArray2 = new double[]{0.0, 0.6, 0.19, 0.0, 0.04, 0.99, 0.4};
        double[][] dArrayArray3 = new double[][]{{15.0, 3.0}, {1.0, 4.0}, {100.0, 24.0}, {255.0, 155.0}, {15.0, 244.0}, {128.0, 128.0}, {173.0, 73.0}};
        double[] dArray3 = new double[dArrayArray3.length];
        double[] dArray4 = new double[dArray3.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArrayArray3[i][0];
            dArray4[i] = dArrayArray3[i][1];
        }
        double d2 = ChangeQuantification.maxDist(dArrayArray3);
        double d3 = ChangeQuantification.quadraticForm(d2, dArray, dArray2, dArray3, dArray4);
        double d4 = ChangeQuantification.quadraticFormHiD(dArray, dArray2, dArrayArray3);
        double d5 = ChangeQuantification.chiSquare(dArray, dArray2, nArray3);
        System.out.println("Qf ND=" + d4 + ", Qf 2D=" + d3 + ", chi square=" + d5);
    }
}

