/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;

public class CpuInfo {
    private static String[] summaries = new String[]{"<h3>Your computer meets the system's requirements nicely ....</h3>", "<h3>Your computer is fine but less than recommended</h3>", "<h2>Your computer has less power than required (too slow) <br><center>for the system!!</center></h2><center>Proceed, but know that the system will be slow.</center><br>", "<h1>Your computer has too little power (TOO slow)<br><center>for the system!!</center></h1><h3><center>If you proceed the system will be too slow for effective use.</center></h3>"};
    private static final DecimalFormat num = new DecimalFormat("#,###,###.###", CpuInfo.getDecimalFormatSymbols());
    private final Map<String, String> parsed = new HashMap<String, String>();
    private boolean isOScheckRequired = true;
    public String name;
    public String osType;
    public String osVersion;
    public int numProcessors;
    public int cpuCache;
    public String osWinVersion;
    public String osMacVersion;
    public double clock;
    public double memory;
    public static final List UNMODIFIABLE_EMPTY_LIST = Collections.unmodifiableList(Collections.EMPTY_LIST);
    public static final String UTF8 = "UTF-8";
    public static final DecimalFormat numFormat = new DecimalFormat("#,###,###.###", CpuInfo.getDecimalFormatSymbols());
    public static Exception lastReachableException = null;

    public static void setProblemSummaries(String string, String string2, String string3, String string4) {
        summaries = new String[]{string, string2, string3, string4};
    }

    public static String stripHtmlWord(String string) {
        if (string != null) {
            String string2 = string.toLowerCase();
            int n = string2.lastIndexOf("<html>");
            int n2 = string2.lastIndexOf("</html>");
            if (n2 >= 0 && n >= 0 && n2 > n) {
                return string.substring(n + 6, n2);
            }
        }
        return string;
    }

    public static String getSystemProperty(String string) {
        String string2;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = null;
            securityException.printStackTrace(System.err);
        }
        return string2;
    }

    public static boolean isMac() {
        return CpuInfo.getSystemProperty("os.name").indexOf("Mac OS") >= 0;
    }

    public static boolean isWindows() {
        return CpuInfo.getSystemProperty("os.name").indexOf("Windows") != -1;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        return decimalFormatSymbols;
    }

    public static void main(String[] stringArray) {
        Test.go();
    }

    public static CpuInfo detect() {
        CpuInfo cpuInfo = CpuInfo.isWindows() ? CpuInfo.detectForWindows() : CpuInfo.detectForMac();
        return cpuInfo;
    }

    private int getParsedInteger(String string) {
        int n = 0;
        if (this.parsed.containsKey(string)) {
            try {
                n = Integer.parseInt(this.parsed.get(string));
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return n;
    }

    private double getParsedDouble(String string) {
        double d = 0.0;
        if (this.parsed.containsKey(string)) {
            try {
                d = Double.parseDouble(this.parsed.get(string));
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return d;
    }

    private String getParsedValue(String string) {
        String string2 = null;
        if (this.parsed.containsKey(string)) {
            string2 = this.parsed.get(string);
        }
        return string2;
    }

    public static CpuInfo specify(double d, double d2, int n, int n2, String string, String string2) {
        CpuInfo cpuInfo = new CpuInfo();
        cpuInfo.memory = d;
        cpuInfo.clock = d2;
        cpuInfo.numProcessors = n;
        cpuInfo.cpuCache = n2;
        cpuInfo.osWinVersion = string;
        cpuInfo.osMacVersion = string2;
        return cpuInfo;
    }

    public static CpuInfo specify(double d, double d2, int n, int n2) {
        CpuInfo cpuInfo = new CpuInfo();
        cpuInfo.isOScheckRequired = false;
        cpuInfo.memory = d;
        cpuInfo.clock = d2;
        cpuInfo.numProcessors = n;
        cpuInfo.cpuCache = n2;
        return cpuInfo;
    }

    public static Report report(CpuInfo cpuInfo, CpuInfo cpuInfo2, CpuInfo cpuInfo3) {
        Report report = new Report();
        report.scrutinize(cpuInfo, report.required, true);
        report.scrutinize(cpuInfo2, report.recommended, true);
        report.scrutinize(cpuInfo3, report.tooLittle, false);
        report.summarize();
        report.start();
        report.appendRow(0);
        report.appendRow(2);
        report.sb.append("<tr><td><b>Computer resource</b></td><td><b>Detected</b></td><td><b>Recommended</b></td><td><b>Required</b></td><td><b>Minimum</b></td></tr>");
        report.appendRow(3, " GB");
        report.appendRow(5, " GHz");
        report.appendRow(6, " cores");
        report.appendRow(4, " KB");
        if (cpuInfo.isOScheckRequired) {
            report.appendRow(1);
        }
        report.end();
        return report;
    }

    public static Report reportSummary(CpuInfo cpuInfo, CpuInfo cpuInfo2, CpuInfo cpuInfo3) {
        Report report = new Report();
        report.scrutinize(cpuInfo, report.required, true);
        report.scrutinize(cpuInfo2, report.recommended, true);
        report.scrutinize(cpuInfo3, report.tooLittle, false);
        report.summarize();
        report.end();
        return report;
    }

    public static Report reportDetail(CpuInfo cpuInfo, CpuInfo cpuInfo2, CpuInfo cpuInfo3) {
        Report report = new Report();
        report.scrutinize(cpuInfo, report.required, true);
        report.scrutinize(cpuInfo2, report.recommended, true);
        report.scrutinize(cpuInfo3, report.tooLittle, false);
        report.start();
        report.sb.append("<tr><td><b>Computer resource</b></td><td><b>Detected</b></td><td><b>Recommended</b></td><td><b>Required</b></td><td><b>Too little</b></td></tr>");
        report.appendRow(3, " GB");
        report.appendRow(5, " GHz");
        report.appendRow(6, " cores");
        report.appendRow(4, " KB");
        if (cpuInfo.isOScheckRequired) {
            report.appendRow(1);
        }
        report.end();
        return report;
    }

    private static CpuInfo detectForWindows() {
        CpuInfo cpuInfo = new CpuInfo();
        cpuInfo.osType = "Windows";
        cpuInfo.callWMIC("cpu");
        cpuInfo.callWMIC("os");
        cpuInfo.name = cpuInfo.getParsedValue("Name");
        cpuInfo.numProcessors = cpuInfo.getParsedInteger("NumberOfCores");
        cpuInfo.clock = cpuInfo.getParsedDouble("MaxClockSpeed") / 1000.0;
        cpuInfo.cpuCache = cpuInfo.getParsedInteger("L2CacheSize");
        cpuInfo.memory = cpuInfo.getParsedDouble("TotalVisibleMemorySize") / 1000000.0;
        cpuInfo.osVersion = cpuInfo.getParsedValue("Caption");
        return cpuInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callWMIC(String string) {
        String string2 = "wmic " + string + " get /value";
        BufferedReader bufferedReader = null;
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(string2);
            InputStream inputStream = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string3 = bufferedReader.readLine()) != null) {
                int n = string3.indexOf("=");
                if (n < 0) continue;
                String string4 = string3.substring(0, n).trim();
                String string5 = string3.substring(n + 1).trim();
                this.parsed.put(string4, string5);
            }
            CpuInfo.closeWithoutThrowingUp(bufferedReader);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            CpuInfo.closeWithoutThrowingUp(bufferedReader);
        }
    }

    private static CpuInfo detectForMac() {
        CpuInfo cpuInfo = new CpuInfo();
        cpuInfo.osType = "Mac OS/X";
        cpuInfo.callSysCtrl("machdep.cpu");
        cpuInfo.callSysCtrl("hw");
        cpuInfo.name = cpuInfo.getParsedValue("brand_string");
        cpuInfo.numProcessors = cpuInfo.getParsedInteger("core_count");
        cpuInfo.clock = cpuInfo.getParsedDouble("cpufrequency_max") / 1.0E9;
        cpuInfo.cpuCache = cpuInfo.getParsedInteger("cache.size");
        cpuInfo.memory = cpuInfo.getParsedDouble("memsize") / 1.0E9;
        cpuInfo.osVersion = CpuInfo.getSystemProperty("os.version");
        return cpuInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callSysCtrl(String string) {
        String string2 = "sysctl -a " + string;
        int n = string.length() + 1;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(string2);
            InputStream inputStream = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string3 = bufferedReader.readLine()) != null) {
                int n2 = string3.indexOf(": ");
                if (n2 < 0) continue;
                String string4 = string3.substring(n, n2).trim();
                String string5 = string3.substring(n2 + 2).trim();
                this.parsed.put(string4, string5);
            }
            CpuInfo.closeWithoutThrowingUp(bufferedReader);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            CpuInfo.closeWithoutThrowingUp(bufferedReader);
        }
    }

    public static String getLoggedInUserName() {
        return System.getProperty("user.name");
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return "Unknown";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMACAddress() {
        String string;
        String string2 = "";
        String string3 = System.getProperty("os.name");
        if (string3 != null) {
            boolean bl = string3.startsWith("Windows");
            string = bl ? "cmd.exe /c ipconfig /all" : "ifconfig -a";
            BufferedReader bufferedReader = null;
            try {
                String string4;
                Process process;
                try {
                    process = Runtime.getRuntime().exec(string);
                }
                catch (IOException iOException) {
                    if (!bl) {
                        string = "/sbin/ifconfig -a";
                        process = Runtime.getRuntime().exec(string);
                    }
                    throw iOException;
                }
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string4 = bufferedReader.readLine()) != null) {
                    int n;
                    if (bl) {
                        if (string4.indexOf("Physical Address") <= 0) continue;
                        n = string4.indexOf(":");
                        string2 = string4.substring(n += 2);
                        break;
                    }
                    n = string4.indexOf("ether");
                    if (n >= 0) {
                        string2 = string4.substring(n += 5);
                        continue;
                    }
                    n = string4.indexOf("HWaddr");
                    if (n < 0) continue;
                    string2 = string4.substring(n += 6);
                }
                bufferedReader = null;
                CpuInfo.closeWithoutThrowingUp(bufferedReader);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            finally {
                CpuInfo.closeWithoutThrowingUp(bufferedReader);
            }
        }
        string = string2.trim();
        return string;
    }

    public static void registerEscape(RootPaneContainer rootPaneContainer, final AbstractButton abstractButton) {
        rootPaneContainer.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                abstractButton.doClick(150);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public static void registerW(RootPaneContainer rootPaneContainer, final AbstractButton abstractButton) {
        int n = CpuInfo.isMac() ? 4 : 2;
        rootPaneContainer.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                abstractButton.doClick(150);
            }
        }, KeyStroke.getKeyStroke(87, n), 2);
    }

    public static final ActionListener getCloseAction(final Window window) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CpuInfo.closeWindow(window);
            }
        };
    }

    public static void closeWindow(Window window) {
        window.dispatchEvent(new WindowEvent(window, 201));
    }

    public static void closeWithoutThrowingUp(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCrc32(String string) {
        block6: {
            long l;
            BufferedInputStream bufferedInputStream = null;
            FileInputStream fileInputStream = null;
            CheckedInputStream checkedInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                checkedInputStream = new CheckedInputStream(fileInputStream, new CRC32());
                bufferedInputStream = new BufferedInputStream(checkedInputStream);
                while (bufferedInputStream.read() != -1) {
                }
                l = checkedInputStream.getChecksum().getValue();
                CpuInfo.closeWithoutThrowingUp(bufferedInputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                break block6;
            }
            finally {
                CpuInfo.closeWithoutThrowingUp(bufferedInputStream);
                CpuInfo.closeWithoutThrowingUp(checkedInputStream);
                CpuInfo.closeWithoutThrowingUp(fileInputStream);
            }
            CpuInfo.closeWithoutThrowingUp(checkedInputStream);
            CpuInfo.closeWithoutThrowingUp(fileInputStream);
            return l;
        }
        return 0L;
    }

    public static String readTextFile(String string) {
        return CpuInfo.readTextFile(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveTextFile(String string, String string2) {
        boolean bl = false;
        try (PrintWriter printWriter = null;){
            printWriter = CpuInfo.getPrintWriterWithAppropriateEncoding(string, UTF8);
            printWriter.println(string2);
            bl = true;
        }
        return bl;
    }

    public static PrintWriter getPrintWriterWithAppropriateEncoding(String string, String string2) throws Exception {
        PrintWriter printWriter = null;
        printWriter = string2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2)) : new PrintWriter(new FileWriter(string));
        return printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) {
        String string = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            string = new String(cArray);
        }
        catch (IOException iOException) {
            try {
                iOException.printStackTrace(System.err);
            }
            catch (Throwable throwable) {
                CpuInfo.closeWithoutThrowingUp(fileReader);
                throw throwable;
            }
            CpuInfo.closeWithoutThrowingUp(fileReader);
        }
        CpuInfo.closeWithoutThrowingUp(fileReader);
        return string;
    }

    public static String encode(Number number) {
        return numFormat.format(number);
    }

    public static String encode(String string) {
        return numFormat.format(Double.parseDouble(string));
    }

    public static boolean needsHtmlEncoding(char[] cArray) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '>': {
                    return true;
                }
                case '<': {
                    return true;
                }
                case '&': {
                    return true;
                }
                case '\"': {
                    return true;
                }
            }
        }
        return false;
    }

    public static String encodeXmlOrHtml(Object object) {
        if (object != null) {
            String string = object.toString();
            char[] cArray = string.toCharArray();
            if (CpuInfo.needsHtmlEncoding(cArray)) {
                String string2 = null;
                int n = 0;
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = cArray.length;
                block6: for (int i = 0; i < n2; ++i) {
                    switch (cArray[i]) {
                        case '>': {
                            string2 = "&gt;";
                            break;
                        }
                        case '<': {
                            string2 = "&lt;";
                            break;
                        }
                        case '&': {
                            string2 = "&amp;";
                            break;
                        }
                        case '\"': {
                            string2 = "&quot;";
                            break;
                        }
                        default: {
                            continue block6;
                        }
                    }
                    if (i > n) {
                        stringBuilder.append(cArray, n, i - n);
                    }
                    n = i + 1;
                    stringBuilder.append(string2);
                }
                stringBuilder.append(cArray, n, n2 - n);
                string = stringBuilder.toString();
            }
            return string;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReachable(String string, int n, int n2) {
        lastReachableException = null;
        Socket socket = new Socket();
        boolean bl = true;
        if (n2 == 0) {
            n2 = 9000;
        }
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            socket.connect(inetSocketAddress, n2);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            bl = false;
            lastReachableException = socketTimeoutException;
            System.out.println(socketTimeoutException);
        }
        catch (IOException iOException) {
            bl = false;
            lastReachableException = iOException;
            System.out.println(iOException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            lastReachableException = runtimeException;
            System.out.println(runtimeException);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    public static class Report {
        public String html;
        public final Maps recommended = new Maps();
        public final Maps required = new Maps();
        public final Maps tooLittle = new Maps();
        public final CpuInfo detected;
        private final Map<String, String> computer = new TreeMap<String, String>();
        private final StringBuilder sb = new StringBuilder();
        private static final String[] FLDS = new String[]{"OS type", "OS version", "System name", "Memory", "CPU cache", "CPU speed", "Number of processors"};
        private static final int FLD_OS_TYPE = 0;
        private static final int FLD_OS_VER = 1;
        private static final int FLD_OS_SYSTEM_NAME = 2;
        private static final int FLD_MEMORY = 3;
        private static final int FLD_CPU_CACHE = 4;
        private static final int FLD_CPU_SPEED = 5;
        private static final int FLD_NUM_OF_PROCESSORS = 6;
        boolean winOsDetectionFailure = false;

        private Report() {
            this.detected = CpuInfo.detect();
            this.computer.put(FLDS[0], this.detected.osType);
            this.computer.put(FLDS[1], this.detected.osVersion);
            this.computer.put(FLDS[2], this.detected.name);
        }

        private static String stripWinOsEdition(String string) {
            StringTokenizer stringTokenizer;
            if (CpuInfo.isWindows() && (stringTokenizer = new StringTokenizer(string, " .")).countTokens() > 2) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.indexOf("Windows") == -1 && string2.indexOf("windows") == -1) continue;
                    return string2 + " " + stringTokenizer.nextToken();
                }
            }
            return string;
        }

        private static int getMacOsMinorVersion(String string) {
            if (CpuInfo.isMac()) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    StringTokenizer stringTokenizer2;
                    String string2 = stringTokenizer.nextToken();
                    if (string2.indexOf("10.") == -1 || (stringTokenizer2 = new StringTokenizer(string2, ".")).countTokens() <= 1) continue;
                    String string3 = stringTokenizer2.nextToken();
                    string3 = stringTokenizer2.nextToken();
                    return Integer.parseInt(string3);
                }
            }
            return -1;
        }

        private boolean scrtunizeOsVersions(String string, String string2, boolean bl) {
            if (CpuInfo.isWindows()) {
                int n;
                List<String> list = Arrays.asList("95", "98", "2000", "NT", "XP", "7", "8", "8.1", "10");
                List<String> list2 = Arrays.asList("Windows 95", "Windows 98", "Windows 2000", "Windows NT", "Windows XP", "Windows 7", "Windows 8", "Windows 8.1", "Windows 10");
                int n2 = list2.indexOf(Report.stripWinOsEdition(string));
                if (n2 == -1) {
                    n = 0;
                    for (String string3 : list) {
                        if (string.indexOf(string3) != -1) {
                            n2 = n;
                            break;
                        }
                        ++n;
                    }
                }
                if (n2 == -1) {
                    this.winOsDetectionFailure = true;
                }
                n = list2.indexOf(string2);
                if (bl) {
                    return n2 >= n;
                }
                return n2 > n;
            }
            if (CpuInfo.isMac()) {
                int n = Report.getMacOsMinorVersion(string);
                int n3 = Report.getMacOsMinorVersion(string2);
                if (bl) {
                    return n >= n3;
                }
                return n > n3;
            }
            return true;
        }

        private void scrutinize(int n, String string, String string2, Maps maps, boolean bl) {
            String string3 = FLDS[n];
            boolean bl2 = this.scrtunizeOsVersions(string, string2, bl);
            if (!bl2) {
                if (!this.winOsDetectionFailure) {
                    maps.bad.put(string3, string2);
                } else {
                    this.detected.osVersion = "Sorry, we are unable to determine the OS version. If you are on Windows Vista or above, please proceed";
                }
            } else {
                maps.good.put(string3, string2);
            }
            this.computer.put(string3, string);
        }

        private void scrutinize(int n, Number number, Number number2, Maps maps, boolean bl) {
            String string = FLDS[n];
            boolean bl2 = bl ? number.doubleValue() >= number2.doubleValue() : number.doubleValue() > number2.doubleValue();
            String string2 = num.format(number2.doubleValue());
            String string3 = num.format(number.doubleValue());
            if (!bl2) {
                if (number.doubleValue() == 0.0) {
                    maps.good.put(string, string2);
                } else {
                    maps.bad.put(string, string2);
                }
            } else {
                maps.good.put(string, string2);
            }
            if (number.doubleValue() == 0.0) {
                this.computer.put(string, "<font color=red'>'Cannot detect'</font>");
            } else {
                this.computer.put(string, string3);
            }
        }

        public int getProblemLevel() {
            int n = this.tooLittle.inadequateCount();
            if (n > 0) {
                return 3;
            }
            n = this.required.inadequateCount();
            if (n > 0) {
                return 2;
            }
            n = this.recommended.inadequateCount();
            if (n > 0) {
                return 1;
            }
            return 0;
        }

        private void summarize() {
            int n = this.getProblemLevel();
            this.sb.append("<font face='Arial'><table cellspacing='4' cellpadding='5'><tr><td>");
            this.sb.append(summaries[n]);
        }

        private void start() {
            this.sb.append("<center><table cellpadding='4' border='1'>");
        }

        private void end() {
            this.sb.append("</table></td></tr></table></font></center>");
            this.html = this.sb.toString();
        }

        private void scrutinize(CpuInfo cpuInfo, Maps maps, boolean bl) {
            this.scrutinize(3, this.detected.memory, cpuInfo.memory, maps, bl);
            this.scrutinize(6, this.detected.numProcessors, cpuInfo.numProcessors, maps, bl);
            this.scrutinize(4, this.detected.cpuCache, cpuInfo.cpuCache, maps, bl);
            this.scrutinize(5, this.detected.clock, cpuInfo.clock, maps, bl);
            if (cpuInfo.isOScheckRequired) {
                this.scrutinize(1, this.detected.osVersion, CpuInfo.isWindows() ? cpuInfo.osWinVersion : cpuInfo.osMacVersion, maps, bl);
            }
        }

        void appendRow(int n) {
            this.appendRow(n, "");
        }

        void appendRow(int n, String string) {
            String string2 = FLDS[n];
            if (!this.required.contains(string2)) {
                this.sb.append("<tr><td>");
                this.sb.append(string2);
                this.sb.append("</td><td colspan='4'>");
                this.sb.append(this.computer.get(string2));
                this.sb.append("</td>");
            } else {
                boolean bl = true;
                String string3 = null;
                if (!this.recommended.isAdequate(string2)) {
                    string3 = "<font color='#336600'>";
                    bl = false;
                }
                if (!this.required.isAdequate(string2)) {
                    string3 = "<font color='#9900FF' bgcolor='#CCFF66'>";
                    bl = false;
                }
                if (!this.tooLittle.isAdequate(string2)) {
                    string3 = "<font color='red' bgcolor='yellow'>";
                    bl = false;
                }
                if (bl) {
                    string3 = "<font>";
                }
                this.sb.append("<tr><td>");
                if (!bl) {
                    this.sb.append("<b>");
                }
                this.sb.append(string2);
                if (!bl) {
                    this.sb.append("</b>");
                }
                this.sb.append("</td>");
                this.sb.append("<td align='right'>");
                this.sb.append(string3);
                this.sb.append(this.computer.get(string2));
                this.sb.append(string);
                this.sb.append("</font></td>");
                this.recommended.append(this.sb, string2, string, 1);
                this.required.append(this.sb, string2, string, 2);
                this.tooLittle.append(this.sb, string2, string, 3);
            }
            this.sb.append("</tr>");
        }

        public static class Maps {
            public Map<String, String> bad = new TreeMap<String, String>();
            public Map<String, String> good = new TreeMap<String, String>();

            public int inadequateCount() {
                return this.bad.size();
            }

            public boolean isAdequate(String string) {
                return this.good.containsKey(string);
            }

            public boolean isAdequate() {
                return this.bad.size() == 0;
            }

            boolean contains(String string) {
                return this.bad.containsKey(string) || this.good.containsKey(string);
            }

            void append(StringBuilder stringBuilder, String string, String string2, int n) {
                String string3;
                String string4 = "";
                String string5 = "";
                if (this.bad.containsKey(string)) {
                    string3 = this.bad.get(string);
                    if (n == 1) {
                        string4 = "<font color='#DF3A01'><b>";
                        string5 = "</b></font>";
                    } else {
                        string4 = "<font color='red'><big>";
                        string5 = "</big></font>";
                    }
                } else {
                    assert (this.good.containsKey(string));
                    string3 = this.good.get(string);
                }
                stringBuilder.append("<td align='right'>");
                stringBuilder.append(string4);
                stringBuilder.append(string3);
                stringBuilder.append(string5);
                if (!string4.equals("")) {
                    stringBuilder.append("<b>");
                }
                stringBuilder.append(string2);
                if (!string4.equals("")) {
                    stringBuilder.append("</b>");
                }
                stringBuilder.append("</td>");
            }
        }
    }

    private static class Test {
        private Test() {
        }

        static void go() {
            CpuInfo cpuInfo = CpuInfo.detect();
            System.out.println("         OS type: " + cpuInfo.osType);
            System.out.println("      OS version: " + cpuInfo.osVersion);
            System.out.println("     System name: " + cpuInfo.name);
            System.out.println(" CPU clock speed: " + num.format(cpuInfo.clock) + " GHz");
            System.out.println("       CPU cache: " + cpuInfo.cpuCache + " KB");
            System.out.println("       CPU cores: " + cpuInfo.numProcessors + " cores");
            System.out.println("      RAM memory: " + num.format(cpuInfo.memory) + " GB");
            CpuInfo cpuInfo2 = CpuInfo.specify(8.0, 2.3, 2, 256, "Windows 8", "10.8");
            CpuInfo cpuInfo3 = CpuInfo.specify(6.0, 2.0, 2, 256, "Windows 7", "Windows 10.7");
            CpuInfo cpuInfo4 = CpuInfo.specify(4.0, 1.4, 1, 128, "Windows Vista", "10.6");
            Report report = CpuInfo.report(cpuInfo3, cpuInfo2, cpuInfo4);
            String string = "<html>\n" + report.html + "\n</html>";
            System.out.println(string);
        }
    }
}

