/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.CpuInfo;
import edu.stanford.facs.swing.DropRule;
import edu.stanford.facs.swing.ToolTipOnDemand;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DndTrees
extends AbstractButton {
    final List<File> missing = new ArrayList<File>();
    public String treeName = "";
    public String noDropZone = "<html><font color='red'>Drag over top of something valid...</font></html>";
    private List<String> prohibitedExportImports = new ArrayList<String>();
    private List<DropRule> dropRules = new ArrayList<DropRule>();
    public DropData lastDrop;
    public Transferable lastTransferable = null;
    public JTree lastDraggedTree;
    public JTree lastDroppedTree;
    public TreePath lastDraggedPath;
    public TreePath lastDroppedPath;
    public DefaultMutableTreeNode lastDraggedNode;
    public DefaultMutableTreeNode lastDroppedNode;
    public String lastDraggedUserObjectString;
    public String lastDroppedUserObjectString;
    public String lastDraggedText;
    public String lastDroppedText;

    public static void ToClipBoard(String string) {
        DndTrees.ToClipBoard(string, false);
    }

    public static void ToClipBoard(String string, boolean bl) {
        Object object;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        if (CpuInfo.isMac()) {
            object = new StringSelection("Java 7 clipboard copy works only for string");
            clipboard.setContents((Transferable)object, (ClipboardOwner)object);
        }
        if (bl) {
            try {
                object = "file://" + string;
                URL uRL = new URL((String)object);
                TransferableURL transferableURL = new TransferableURL(uRL);
                clipboard.setContents(transferableURL, transferableURL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            object = new ArrayList();
            File file = new File(string);
            boolean bl2 = file.exists();
            ((ArrayList)object).add(file);
            TransferableFile transferableFile = new TransferableFile((List<File>)object);
            clipboard.setContents(transferableFile, transferableFile);
        }
    }

    public static void reloadAll(JTree jTree) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        Enumeration<TreePath> enumeration = jTree.getExpandedDescendants(new TreePath(((DefaultMutableTreeNode)defaultTreeModel.getRoot()).getPath()));
        defaultTreeModel.reload();
        while (enumeration != null && enumeration.hasMoreElements()) {
            TreePath treePath = enumeration.nextElement();
            jTree.expandPath(treePath);
        }
    }

    public void manage(JTree jTree) {
        this.manage(jTree, null, 5, 5, 10, 10);
    }

    public void manage(JTree jTree, Image image, int n, int n2, int n3, int n4) {
        new Drag(jTree, 3, image, n, n2);
        new Drop(jTree, n3, n4);
    }

    public void rejectDragDrop(String string, String string2) {
        this.rejectDragDrop(string, string2, false);
    }

    public void rejectDragDrop(String string, String string2, boolean bl) {
        DropRule dropRule = new DropRule(string, string2, bl);
        this.dropRules.add(dropRule);
    }

    public void prohibitExportImport(String string) {
        this.prohibitedExportImports.add(string);
    }

    static DefaultMutableTreeNode toTreeNode(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)object;
        }
        return null;
    }

    static String toTreeNodeUserObject(TreeNode treeNode) {
        Object object;
        if (treeNode instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)treeNode).getUserObject()) != null) {
            return object.toString();
        }
        return null;
    }

    public void notifyDrop() {
        this.lastDrop = new DropData();
        this.lastDrop.lastTransferable = this.lastTransferable;
        try {
            this.lastDrop.lastTransferableData = this.lastTransferable.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            exception.printStackTrace();
        }
        this.lastDrop.lastDraggedNode = this.lastDraggedNode;
        this.lastDrop.lastDroppedNode = this.lastDroppedNode;
        this.lastDrop.lastDraggedTree = this.lastDraggedTree;
        this.lastDrop.lastDroppedTree = this.lastDroppedTree;
        this.lastDrop.lastDraggedPath = this.lastDraggedPath;
        this.lastDrop.lastDroppedPath = this.lastDroppedPath;
        this.lastDrop.lastDraggedUserObjectString = this.lastDraggedUserObjectString;
        this.lastDrop.lastDroppedUserObjectString = this.lastDroppedUserObjectString;
        System.out.println("lastDraggedNode=" + this.lastDraggedNode);
        this.lastDrop.key = "normal";
        ActionEvent actionEvent = new ActionEvent(this, 22, "normal");
        this.fireActionPerformed(actionEvent);
        this.missing.clear();
    }

    static class TransferableURL
    implements Transferable,
    ClipboardOwner {
        private final DataFlavor urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL", "Image URL");
        private final DataFlavor[] flavors = new DataFlavor[]{this.urlFlavor};
        private final URL url;

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }

        public TransferableURL(URL uRL) {
            this.url = uRL;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.getRepresentationClass() == URL.class;
        }

        @Override
        public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                return this.url;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    static class TransferableFile
    implements Transferable,
    ClipboardOwner {
        private final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor};
        private final List<File> files;

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }

        public TransferableFile(List<File> list) {
            this.files = list;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.getRepresentationClass() == List.class;
        }

        @Override
        public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                return this.files;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    class Drag
    implements DragSourceListener,
    DragGestureListener {
        private DragSource source;
        private Transferable transferable;
        private JTree sourceTree;
        private Image dragImage = null;
        private int dragOffSetX;
        private int dragOffSetY;

        Drag(JTree jTree, int n, Image image, int n2, int n3) {
            this.sourceTree = jTree;
            this.dragImage = image;
            this.dragOffSetX = n2;
            this.dragOffSetY = n3;
            this.source = new DragSource();
            this.source.createDefaultDragGestureRecognizer(this.sourceTree, n, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            TreePath treePath = this.sourceTree.getSelectionPath();
            if (treePath == null || treePath.getPathCount() <= 1) {
                return;
            }
            DndTrees.this.lastDraggedTree = this.sourceTree;
            DndTrees.this.lastDraggedPath = treePath;
            DndTrees.this.lastDraggedNode = DndTrees.toTreeNode(treePath);
            DndTrees.this.lastDraggedUserObjectString = DndTrees.toTreeNodeUserObject(DndTrees.this.lastDraggedNode);
            DndTrees.this.lastDroppedPath = null;
            DndTrees.this.lastDroppedTree = null;
            DndTrees.this.lastDroppedNode = null;
            DndTrees.this.lastDroppedUserObjectString = null;
            ArrayList<File> arrayList = new ArrayList<File>();
            TreePath[] treePathArray = this.sourceTree.getSelectionPaths();
            for (TreePath treePath2 : treePathArray) {
                this.addFile(treePath2, arrayList);
            }
            if (arrayList.size() > 0) {
                System.out.println("Dragging " + arrayList.size() + " files");
                this.transferable = new TransferableFile(arrayList);
            } else {
                this.transferable = new TransferableTreeNode(DndTrees.this.lastDraggedUserObjectString);
            }
            if (this.dragImage == null) {
                this.source.startDrag(dragGestureEvent, null, this.transferable, this);
            } else {
                this.source.startDrag(dragGestureEvent, null, this.dragImage, new Point(this.dragOffSetX, this.dragOffSetY), this.transferable, this);
            }
            DndTrees.this.missing.clear();
            for (File file : arrayList) {
                if (file.exists()) continue;
                DndTrees.this.missing.add(file);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            System.out.println("Action: " + dragSourceDragEvent.getDropAction());
            System.out.println("Target Action: " + dragSourceDragEvent.getTargetActions());
            System.out.println("User Action: " + dragSourceDragEvent.getUserAction());
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            System.out.println("Drop Action: " + dragSourceDropEvent.getDropAction());
            ToolTipOnDemand.getSingleton().close();
            if (DndTrees.this.missing.size() > 0) {
                DndTrees.this.lastDrop = new DropData();
                DndTrees.this.lastDrop.lastDraggedNode = DndTrees.this.lastDraggedNode;
                DndTrees.this.lastDrop.lastDroppedNode = DndTrees.this.lastDroppedNode;
                DndTrees.this.lastDrop.lastDraggedTree = DndTrees.this.lastDraggedTree;
                DndTrees.this.lastDrop.lastDroppedTree = DndTrees.this.lastDroppedTree;
                DndTrees.this.lastDrop.lastDraggedPath = DndTrees.this.lastDraggedPath;
                DndTrees.this.lastDrop.lastDroppedPath = DndTrees.this.lastDroppedPath;
                DndTrees.this.lastDrop.lastDraggedUserObjectString = DndTrees.this.lastDraggedUserObjectString;
                DndTrees.this.lastDrop.lastDroppedUserObjectString = DndTrees.this.lastDroppedUserObjectString;
                DndTrees.this.lastDrop.key = "Missing";
                ActionEvent actionEvent = new ActionEvent(this, 22, "missing " + DndTrees.this.missing.iterator().next().getAbsolutePath());
                DndTrees.this.fireActionPerformed(actionEvent);
            }
            DndTrees.this.lastDraggedNode = null;
        }

        boolean addFile(Object object, List<File> list) {
            boolean bl = false;
            String string = object instanceof String ? (String)object : DndTrees.toTreeNodeUserObject(DndTrees.toTreeNode((TreePath)object));
            if (string != null) {
                int n;
                int n2 = n = string == null ? -1 : string.lastIndexOf("file://");
                if (n >= 0) {
                    String string2 = string.substring(n + 7);
                    System.out.println(string2);
                    list.add(new File(string2));
                    bl = true;
                }
            }
            return bl;
        }
    }

    class Drop
    implements DropTargetListener {
        private int dropOffSetX;
        private int dropOffSetY;
        private final JTree targetTree;
        private TreeNode over;

        Drop(JTree jTree, int n, int n2) {
            this.targetTree = jTree;
            this.dropOffSetX = n;
            this.dropOffSetY = n2;
            new DropTarget(this.targetTree, this);
        }

        private String stripAndFormat(TreeNode treeNode) {
            int n;
            if (treeNode == null) {
                return "";
            }
            String string = treeNode.toString();
            int n2 = string.indexOf("<html>");
            if (n2 >= 0) {
                string = string.substring(n2).replaceAll("<html>", "").replaceAll("</html>", "");
                return string;
            }
            String string2 = treeNode.getClass().getName();
            int n3 = string.indexOf(string2);
            System.out.println("Class=" + string2);
            System.out.println("clIdx=" + n3 + ", toString()=" + string);
            if (n3 >= 0 && n3 <= string.length() - 2) {
                string = string.substring(n3 + string2.length() + 1);
            }
            int n4 = n = string == null ? -1 : string.lastIndexOf("file://");
            if (n > 1 && string.charAt(n - 1) != '\'') {
                string = string.substring(0, n);
            }
            return string;
        }

        private DefaultMutableTreeNode getNode(DropTargetDragEvent dropTargetDragEvent, boolean bl) {
            Point point = dropTargetDragEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getPathForLocation(point.x, point.y);
            DefaultMutableTreeNode defaultMutableTreeNode = treePath == null ? null : (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (bl && defaultMutableTreeNode != this.over) {
                String string;
                ToolTipOnDemand toolTipOnDemand = ToolTipOnDemand.getSingleton();
                if (defaultMutableTreeNode == null) {
                    string = DndTrees.this.noDropZone;
                } else if (defaultMutableTreeNode == DndTrees.this.lastDraggedNode) {
                    string = "<html><font color='red'>Can't drag & drop on self.</font></html>";
                } else {
                    String string2 = this.reject(defaultMutableTreeNode) ? "<font color='red'>You can't drop</font>" : "You can drop";
                    String string3 = jTree != DndTrees.this.lastDraggedTree ? " <i>(from different " + DndTrees.this.treeName + ")</i> " : "";
                    DndTrees.this.lastDroppedText = this.stripAndFormat(defaultMutableTreeNode);
                    DndTrees.this.lastDraggedText = this.stripAndFormat(DndTrees.this.lastDraggedNode);
                    String string4 = "<br>&nbsp;&nbsp;on to  \"<b>" + DndTrees.this.lastDroppedText + "</b>\"";
                    string = "<html>" + string2 + "  \"<b>" + DndTrees.this.lastDraggedText + "</b>\"" + string3 + string4 + "</html>";
                }
                toolTipOnDemand.close();
                toolTipOnDemand.show((JComponent)jTree, false, point.x + this.dropOffSetX, point.y + this.dropOffSetY, null, string);
                this.over = defaultMutableTreeNode;
            }
            return defaultMutableTreeNode;
        }

        boolean reject(DefaultMutableTreeNode defaultMutableTreeNode) {
            String string;
            if (DndTrees.this.dropRules.size() > 0 && DndTrees.this.lastDraggedUserObjectString != null && (string = DndTrees.toTreeNodeUserObject(defaultMutableTreeNode)) != null) {
                for (Object object : DndTrees.this.dropRules) {
                    if (!((DropRule)object).matches(DndTrees.this.lastDraggedUserObjectString, string)) continue;
                    return true;
                }
            }
            if (DndTrees.this.lastDraggedTree != this.targetTree && DndTrees.this.prohibitedExportImports.size() > 0) {
                string = DndTrees.toTreeNodeUserObject(defaultMutableTreeNode);
                for (Object object : DndTrees.this.prohibitedExportImports) {
                    if (DndTrees.this.lastDraggedNode == null) {
                        return true;
                    }
                    if (DndTrees.this.lastDraggedUserObjectString.startsWith((String)object)) {
                        return true;
                    }
                    if (!string.startsWith((String)object)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(dropTargetDragEvent, false);
            if (defaultMutableTreeNode == null || defaultMutableTreeNode == DndTrees.this.lastDraggedNode || this.reject(defaultMutableTreeNode)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(dropTargetDragEvent, true);
            if (defaultMutableTreeNode == null || defaultMutableTreeNode == DndTrees.this.lastDraggedNode || this.reject(defaultMutableTreeNode)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Point point = dropTargetDropEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == DndTrees.this.lastDraggedNode || this.reject(defaultMutableTreeNode)) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            if (defaultMutableTreeNode == null) {
                System.out.println("ParentPath is NULL >> but we were over ... " + this.over);
                if (this.over == null) {
                    return;
                }
            }
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!transferable.isDataFlavorSupported(dataFlavorArray[i])) continue;
                    DndTrees.this.lastTransferable = transferable;
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    DndTrees.this.lastDroppedPath = treePath;
                    DndTrees.this.lastDroppedTree = this.targetTree;
                    DndTrees.this.lastDroppedNode = defaultMutableTreeNode;
                    DndTrees.this.lastDroppedUserObjectString = DndTrees.toTreeNodeUserObject(DndTrees.this.lastDroppedNode);
                    DndTrees.this.notifyDrop();
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
                dropTargetDropEvent.rejectDrop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    public static class DropData {
        public String key;
        public Transferable lastTransferable;
        public Object lastTransferableData;
        public JTree lastDraggedTree;
        public JTree lastDroppedTree;
        public TreePath lastDraggedPath;
        public TreePath lastDroppedPath;
        public DefaultMutableTreeNode lastDraggedNode;
        public DefaultMutableTreeNode lastDroppedNode;
        public String lastDraggedUserObjectString;
        public String lastDroppedUserObjectString;
    }

    static class TransferableTreeNode
    implements Transferable {
        private static DataFlavor TREE_PATH_FLAVOR = new DataFlavor(String.class, "Tree Path");
        private DataFlavor[] flavors = new DataFlavor[]{TREE_PATH_FLAVOR};
        private String path;

        public TransferableTreeNode(String string) {
            this.path = string;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.getRepresentationClass() == String.class;
        }

        @Override
        public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                return this.path;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

