/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EppGatingML {
    String[] parameters;
    Document document;

    public EppGatingML() {
    }

    public EppGatingML(String[] stringArray) {
        this.parameters = stringArray;
    }

    public Element getRoot() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        this.document = documentBuilder.newDocument();
        Element element = this.document.createElementNS("http://www.isac-net.org/std/Gating-ML/v2.0/gating", "gating:Gating-ML");
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttribute("xmlns:transforms", "http://www.isac-net.org/std/Gating-ML/v2.0/transformations");
        element.setAttribute("xmlns:data-type", "http://www.isac-net.org/std/Gating-ML/v2.0/datatypes");
        this.document.appendChild(element);
        return element;
    }

    public Element addPolygon(Element element, String string, String string2, String string3, Map<Double, Double> map, Element element2) {
        Object object;
        Element element3 = this.document.createElementNS("http://www.isac-net.org/std/Gating-ML/v2.0/gating", "gating:PolygonGate");
        element3.setAttributeNS("http://www.isac-net.org/std/Gating-ML/v2.0/gating", "gating:id", string);
        if (element != element2 && element != null && element.getAttribute("id") != null) {
            object = element.getAttributeNodeNS("http://www.isac-net.org/std/Gating-ML/v2.0/gating", "id").getNodeValue();
            element3.setAttributeNS("http://www.isac-net.org/std/Gating-ML/v2.0/gating", "gating:parent_id", (String)object);
        }
        object = this.document.createElementNS("http://www.isac-net.org/std/Gating-ML/v2.0/gating", "gating:dimension");
        Element element4 = this.document.createElementNS("http://www.isac-net.org/std/Gating-ML/v2.0/datatypes", "data-type:fcs-dimension");
        Element element5 = this.document.createElementNS("http://www.isac-net.org/std/Gating-ML/v2.0/gating", "gating:dimension");
        Element element6 = this.document.createElementNS("http://www.isac-net.org/std/Gating-ML/v2.0/datatypes", "data-type:fcs-dimension");
        if (this.parameters != null && this.parameters.length > 0) {
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            if (this.parameters.length >= n) {
                element4.setAttributeNS("http://www.isac-net.org/std/Gating-ML/v2.0/datatypes", "data-type:name", this.parameters[n - 1]);
            } else {
                element4.setAttributeNS("http://www.isac-net.org/std/Gating-ML/v2.0/datatypes", "data-type:name", string2);
            }
            if (this.parameters.length >= n2) {
                element6.setAttributeNS("http://www.isac-net.org/std/Gating-ML/v2.0/datatypes", "data-type:name", this.parameters[n2 - 1]);
            } else {
                element6.setAttributeNS("http://www.isac-net.org/std/Gating-ML/v2.0/datatypes", "data-type:name", string3);
            }
        } else {
            element4.setAttributeNS("http://www.isac-net.org/std/Gating-ML/v2.0/datatypes", "data-type:name", string2);
            element6.setAttributeNS("http://www.isac-net.org/std/Gating-ML/v2.0/datatypes", "data-type:name", string3);
        }
        object.appendChild(element4);
        element5.appendChild(element6);
        element3.appendChild((Node)object);
        element3.appendChild(element5);
        for (Map.Entry<Double, Double> entry : map.entrySet()) {
            element3.appendChild(this.getVertex(entry.getKey(), entry.getValue()));
        }
        element2.appendChild(element3);
        return element3;
    }

    private Element getVertex(Double d, Double d2) {
        Element element = this.document.createElementNS("http://www.isac-net.org/std/Gating-ML/v2.0/gating", "gating:vertex");
        element.appendChild(this.getCoordinate(d));
        element.appendChild(this.getCoordinate(d2));
        return element;
    }

    private Element getCoordinate(Double d) {
        Element element = this.document.createElementNS("http://www.isac-net.org/std/Gating-ML/v2.0/gating", "gating:coordinate");
        element.setAttributeNS("http://www.isac-net.org/std/Gating-ML/v2.0/datatypes", "data-type:value", String.valueOf(d));
        return element;
    }

    public void createGatingMLfile(Element element, File file) {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(this.getGatingMLString(element));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeGatingML(Element element, File file) {
        Object var3_3 = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            transformer.transform(new DOMSource(element), new StreamResult(fileOutputStream));
            fileOutputStream.close();
        }
        catch (TransformerException transformerException) {
            System.err.println(transformerException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    public String getGatingMLString(Element element) {
        String string = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(element), new StreamResult(byteArrayOutputStream));
            string = new String(byteArrayOutputStream.toByteArray());
        }
        catch (TransformerException transformerException) {
            System.err.println(transformerException.getMessage());
        }
        return string;
    }
}

