/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.Epp;
import edu.stanford.facs.swing.EppGatingML;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class EppProps {
    private static final String BOOLEAN_GATE_SUFFIX = ".B";
    private static final String GATE_NAME_SUFFIX = ".name";
    private static Properties props = new Properties();
    List<Epp> epps = new ArrayList<Epp>();

    public EppProps(File file) {
        try {
            props.load(new FileReader(file));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static Element addEpp(EppGatingML eppGatingML, Element element, Epp epp, Element element2) {
        List<Double> list = epp.getCoordinates();
        TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
        if (list != null && list.size() > 0) {
            int n = list.size() / 2;
            for (int i = 0; i < n; ++i) {
                treeMap.put(list.get(i), list.get(n + i));
            }
        }
        return eppGatingML.addPolygon(element, epp.getName(), epp.getX(), epp.getY(), treeMap, element2);
    }

    private static void addEppGateHierarchy(EppGatingML eppGatingML, Element element, Epp epp, Element element2) {
        Element element3 = EppProps.addEpp(eppGatingML, element, epp, element2);
        for (Epp epp2 : epp.getChildren()) {
            EppProps.addEppGateHierarchy(eppGatingML, element3, epp2, element2);
        }
    }

    public void getGatingML(Epp epp, String[] stringArray, File file) {
        EppGatingML eppGatingML = new EppGatingML(stringArray);
        Element element = eppGatingML.getRoot();
        for (Epp epp2 : epp.getChildren()) {
            EppProps.addEppGateHierarchy(eppGatingML, element, epp2, element);
        }
        eppGatingML.writeGatingML(element, file);
    }

    public Epp getAutoGateRoot(List<Epp> list) {
        Iterator<Epp> iterator = list.iterator();
        Epp epp = null;
        while (iterator.hasNext()) {
            Epp epp2 = iterator.next();
            if (!epp2.getId().trim().equals("0")) continue;
            epp = epp2;
            iterator.remove();
            break;
        }
        this.sortEppObjects("01", epp, list);
        return epp;
    }

    /*
     * WARNING - void declaration
     */
    private void sortEppObjects(String string, Epp epp, List<Epp> list) {
        boolean bl = false;
        for (Epp object2 : list) {
            String string2 = object2.getId();
            if (string2.equalsIgnoreCase(string + BOOLEAN_GATE_SUFFIX)) {
                epp.addBooleanGate(object2);
                continue;
            }
            if (!string2.equals(string)) continue;
            bl = true;
            epp.addChild(object2);
        }
        if (bl) {
            void var6_8;
            int n = Integer.parseInt(String.valueOf(string.charAt(string.length() - 1)));
            String string3 = string.substring(0, string.length() - 1);
            this.sortEppObjects(string3 + (int)(++var6_8), epp, list);
        } else {
            for (Epp epp2 : epp.getChildren()) {
                this.sortEppObjects(epp2.getId() + "1", epp2, list);
            }
        }
    }

    private Epp getEppObject(String string) {
        if (!this.epps.isEmpty()) {
            for (Epp epp : this.epps) {
                if (!epp.getId().equals(string)) continue;
                return epp;
            }
        }
        return null;
    }

    public List<Epp> getEppObjectsOld() {
        HashMap<String[], String> hashMap = new HashMap<String[], String>();
        ArrayList<Epp> arrayList = new ArrayList<Epp>();
        for (Map.Entry<Object, Object> object : props.entrySet()) {
            try {
                String[] stringArray;
                String string;
                String l;
                Object l2;
                String[] stringArray2;
                Epp exception = new Epp();
                boolean bl = false;
                String string2 = (String)object.getKey();
                try {
                    long exception2 = Long.parseLong(string2);
                }
                catch (Exception exception3) {
                    if (string2.endsWith(GATE_NAME_SUFFIX)) {
                        stringArray2 = string2.substring(0, string2.indexOf(GATE_NAME_SUFFIX));
                        l2 = this.getEppObject((String)stringArray2);
                        if (l2 != null) {
                            ((Epp)l2).setName((String)object.getValue());
                        } else {
                            hashMap.put(stringArray2, (String)object.getValue());
                        }
                    }
                    if (!string2.endsWith(BOOLEAN_GATE_SUFFIX)) continue;
                    stringArray2 = string2.substring(0, string2.indexOf("."));
                    try {
                        long exception2 = Long.parseLong((String)stringArray2);
                        bl = true;
                    }
                    catch (Exception exception4) {
                        continue;
                    }
                }
                exception.setId(string2);
                if (hashMap.containsKey(string2)) {
                    exception.setName((String)hashMap.get(string2));
                }
                if ((stringArray2 = (l = (String)object.getValue()).split(":")).length != 2) continue;
                l2 = stringArray2[0];
                String[] stringArray3 = ((String)l2).split("/");
                if (stringArray3.length == 2) {
                    string = stringArray3[0];
                    stringArray = stringArray3[1];
                    exception.setX(string);
                    exception.setY((String)stringArray);
                }
                if ((stringArray = (string = stringArray2[1]).split(" ")) != null && stringArray.length > 0) {
                    for (String string3 : stringArray) {
                        if (string3.trim().equals("")) continue;
                        exception.addCoordinate(Double.parseDouble(string3));
                    }
                }
                arrayList.add(exception);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n = 1;
        for (Epp exception : arrayList) {
            if (exception.getName() != null && !exception.getName().trim().equals("")) continue;
            exception.setName("ID" + n++);
        }
        return arrayList;
    }

    public List<Epp> getEppObjects() {
        HashMap<String[], String> hashMap = new HashMap<String[], String>();
        ArrayList<Epp> arrayList = new ArrayList<Epp>();
        for (Map.Entry<Object, Object> object2 : props.entrySet()) {
            try {
                String[] stringArray;
                String string;
                Object object;
                Epp epp = new Epp();
                String string2 = (String)object2.getKey();
                try {
                    long l = Long.parseLong(string2);
                }
                catch (Exception exception) {
                    if (string2.endsWith(GATE_NAME_SUFFIX)) {
                        object = string2.substring(0, string2.indexOf(GATE_NAME_SUFFIX));
                        hashMap.put((String[])object, (String)object2.getValue());
                    }
                    if (!string2.endsWith(BOOLEAN_GATE_SUFFIX)) continue;
                    object = string2.substring(0, string2.indexOf("."));
                    try {
                        long l = Long.parseLong((String)object);
                    }
                    catch (Exception exception2) {
                        continue;
                    }
                }
                epp.setId(string2);
                String string3 = (String)object2.getValue();
                object = string3.split(":");
                if (((String[])object).length != 2) continue;
                String string4 = object[0];
                String[] stringArray2 = string4.split("/");
                if (stringArray2.length == 2) {
                    string = stringArray2[0];
                    stringArray = stringArray2[1];
                    epp.setX(string);
                    epp.setY((String)stringArray);
                }
                if ((stringArray = (string = object[1]).split(" ")) != null && stringArray.length > 0) {
                    for (String string5 : stringArray) {
                        if (string5.trim().equals("")) continue;
                        epp.addCoordinate(Double.parseDouble(string5));
                    }
                }
                arrayList.add(epp);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (Epp epp : arrayList) {
            String string = (String)hashMap.get(epp.getId());
            if (string != null) {
                epp.setName(string);
                continue;
            }
            System.out.println("WARNING: No name for " + epp.getId());
        }
        int n = 1;
        for (Epp epp : arrayList) {
            if (epp.getName() != null && !epp.getName().trim().equals("")) continue;
            System.out.println("WARNING: SETTING RANDOM ID For " + epp.getId());
            epp.setName("ID" + n++);
        }
        return arrayList;
    }

    private void minimizeAndTransform(File file) throws FileNotFoundException {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String string = (String)entry.getKey();
            try {
                long l = Long.parseLong(string);
            }
            catch (Exception exception) {
                props.remove(string);
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(new File(System.getProperty("user.home"), "minimizedEpp.properties"));
        props.save(fileOutputStream, "");
    }

    public static void createGatingML(String string, String string2, String string3) {
        if (string3 != null) {
            EppProps.createGatingML(string, string2, string3.split(","));
        } else {
            EppProps.createGatingML(string, string2, string3);
        }
    }

    public static void createGatingML(String string, String string2, String[] stringArray) {
        File file = new File(string);
        if (file.exists()) {
            EppProps eppProps = new EppProps(file);
            List<Epp> list = eppProps.getEppObjects();
            Epp epp = eppProps.getAutoGateRoot(list);
            if (stringArray != null) {
                eppProps.getGatingML(epp, stringArray, new File(string2));
            } else {
                String[] stringArray2 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
                eppProps.getGatingML(epp, stringArray2, new File(string2));
            }
        }
    }

    private void createGatingMLfile(File file, String string) {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        URL uRL = EppProps.class.getResource("./eppNew.properties");
        if (uRL != null) {
            File file = new File(uRL.toURI());
            EppProps eppProps = new EppProps(file);
            String[] stringArray2 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
            List<Epp> list = eppProps.getEppObjects();
            Epp epp = eppProps.getAutoGateRoot(list);
            EppProps.printEppGateHierarchy(0, epp);
            File file2 = new File(System.getProperty("user.home"), "Epp-gatingml.xml");
            eppProps.getGatingML(epp, stringArray2, file2);
        }
    }

    private static void printEpp(int n, Epp epp) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(epp.getId()).append(",").append(epp.getX()).append(",").append(epp.getY()).append(",").append(epp.getCoordinates());
        System.out.println(stringBuilder.toString());
    }

    private static void printEppGateHierarchy(int n, Epp epp) {
        EppProps.printEpp(n++, epp);
        for (Epp epp2 : epp.getChildren()) {
            EppProps.printEppGateHierarchy(n, epp2);
        }
    }
}

