/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.Basics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FlowJoWsp {
    public final Properties props;
    public final Properties propsGui;
    public static final String SAMPLE = "Sample";
    public static final String FOCI = "gating:foci";
    public static final String EDGE = "gating:edge";
    public static final String VERTEX = "gating:vertex";
    public static final String COORD = "gating:coordinate";
    public static final String TYPE_ROOT = "root";
    public static final String TYPE_FOLDER = "folder";
    public static final String TYPE_SAMPLE = "sample";
    public static final String TYPE_GATE = "gate";
    public static final String ROOT_ID = "root:0";
    public static final String ROOT_CHILDREN = "root:0.children";
    public static final String[] ELLIPSE_FOCI = new String[]{"gating:foci", "gating:vertex", "gating:coordinate"};
    public static final String[] ELLIPSE_EDGE = new String[]{"gating:edge", "gating:vertex", "gating:coordinate"};
    public final DeferredDocumentImpl doc;
    public final String version;
    public final String flowJoVersion;
    public DeepNodeListImpl sampleNodes;
    public int nSamples;
    public final Map<String, ElementImpl> idMap = new TreeMap<String, ElementImpl>();
    private static final ElementImpl[] emptyEle = new ElementImpl[0];
    private static final String[] subPop = new String[]{"Subpopulations"};
    private static final String[] graph = new String[]{"Graph"};
    private static final String[] axis = new String[]{"Graph", "Axis"};
    public Boolean hasNotProps = null;
    public static final String[] SUBPOPS = new String[]{"Subpopulations", "Population"};
    public static final String[] SUBNOTS = new String[]{"Subpopulations", "NotNode"};
    public static String[] GATE = new String[]{"Gate", "gating:*"};
    public boolean rootIdsInSync = false;
    public static final String[] Coords = new String[]{"gating:vertex", "gating:coordinate"};
    public static final String[] Dims = new String[]{"gating:dimension"};
    public static final String[] MinMax = new String[]{"gating:min", "gating:max"};
    public static final String[] EllipseCoords = new String[]{"gating:edge", "gating:vertex", "gating:coordinate"};
    public static final String[] FcsDims = new String[]{"gating:dimension", "data-type:fcs-dimension"};
    static final String[] derivied = new String[]{"DerivedParameters", "DerivedParameter"};

    public boolean IsGateId(String string) {
        return string.startsWith("gate:");
    }

    public boolean IsSampleId(String string) {
        return string.startsWith("sample:");
    }

    public boolean IsFolderId(String string) {
        return string.startsWith("folder:");
    }

    public boolean IsRootId(String string) {
        return string.startsWith("root:");
    }

    public void removeChild(String string, String string2) {
        String string3 = string + ".children";
        String string4 = this.props.getProperty(string3);
        if (!Basics.isEmpty(string4)) {
            this.props.setProperty(string3, string4.replace(string2 + " ", ""));
        }
    }

    public void addChild(String string, String string2) {
        String string3 = string + ".children";
        String string4 = this.props.getProperty(string3);
        if (string4 == null) {
            string4 = "";
        }
        this.props.setProperty(string3, string4 + string2 + " ");
    }

    public void setParent(Object object, String string) {
        String string2 = object instanceof Integer ? (String)this.getSampleIdByNum(((Double)object).intValue()) : (object instanceof Integer ? (String)this.getSampleIdByNum((Integer)object) : (String)object);
        String string3 = string2 + ".parent";
        String string4 = this.props.getProperty(string3);
        if (!Basics.isEmpty(string4)) {
            this.removeChild(string4, string2);
        }
        this.addChild(string, string2);
        this.props.setProperty(string3, string);
        this.rootIdsInSync = false;
    }

    public Object getSampleIdByNum(int n) {
        return "sample:" + this.getSampleNode(n).getAttribute("sampleID");
    }

    public static Object[] parseIdTypeNumb(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return new String[]{string, "?", string};
        }
        String string2 = string.substring(0, n);
        Object[] objectArray = (string = string.substring(n + 1)).startsWith("ID") ? new Object[]{string, string2, string.substring(2)} : new Object[]{string, string2, string};
        return objectArray;
    }

    public static Object parseId(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public void refreshSampleNodes() {
        this.sampleNodes = (DeepNodeListImpl)this.doc.getElementsByTagName(SAMPLE);
        this.nSamples = this.sampleNodes.getLength();
    }

    public ElementImpl getSampleNode(int n) {
        return FlowJoWsp.GetFirstNode((ElementImpl)this.sampleNodes.item(n - 1), "SampleNode");
    }

    public int getSampleNumById(String string) {
        Object object = FlowJoWsp.parseId(string);
        for (int i = 1; i <= this.nSamples; ++i) {
            if (!this.getSampleNode(i).getAttribute("sampleID").equals(object)) continue;
            return i;
        }
        return 0;
    }

    public Object get(Object object, String[] stringArray, boolean bl) {
        ElementImpl elementImpl = object instanceof Integer ? (ElementImpl)this.sampleNodes.item((Integer)object - 1) : (object instanceof Double ? (ElementImpl)this.sampleNodes.item(((Double)object).intValue() - 1) : (ElementImpl)object);
        if (bl) {
            return FlowJoWsp.GetAllWild(elementImpl, stringArray);
        }
        return FlowJoWsp.GetFirst(elementImpl, stringArray, 1);
    }

    public FlowJoWsp(DeferredDocumentImpl deferredDocumentImpl, Properties properties, Properties properties2) {
        this.doc = deferredDocumentImpl;
        this.props = properties;
        this.propsGui = properties2;
        ElementImpl elementImpl = (ElementImpl)deferredDocumentImpl.item(0);
        this.version = elementImpl.getAttribute("version");
        this.flowJoVersion = elementImpl.getAttribute("flowJoVersion");
        this.refreshSampleNodes();
    }

    public static ElementImpl GetFirstNode(ElementImpl elementImpl, String string) {
        int n = elementImpl.getLength();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(elementImpl.item(i).getNodeName())) continue;
            return (ElementImpl)elementImpl.item(i);
        }
        return null;
    }

    public static ElementImpl GetFirst(ElementImpl elementImpl, String[] stringArray, int n) {
        String string = stringArray[n - 1];
        int n2 = elementImpl.getLength();
        for (int i = 0; i < n2; ++i) {
            if (!string.equals(elementImpl.item(i).getNodeName())) continue;
            if (n == stringArray.length) {
                return (ElementImpl)elementImpl.item(i);
            }
            return FlowJoWsp.GetFirst((ElementImpl)elementImpl.item(i), stringArray, n + 1);
        }
        return null;
    }

    public static Collection<ElementImpl> GetList(ElementImpl elementImpl, String[] stringArray) {
        ArrayList<ElementImpl> arrayList = new ArrayList<ElementImpl>();
        FlowJoWsp.GetAll(arrayList, elementImpl, stringArray, 1);
        return arrayList;
    }

    public static ElementImpl[] GetAll(ElementImpl elementImpl, String[] stringArray) {
        return FlowJoWsp.GetList(elementImpl, stringArray).toArray(emptyEle);
    }

    public static Collection<ElementImpl> GetAll(Collection<ElementImpl> collection, ElementImpl elementImpl, String[] stringArray, int n) {
        String string = stringArray[n - 1];
        int n2 = elementImpl.getLength();
        for (int i = 0; i < n2; ++i) {
            if (!string.equals(elementImpl.item(i).getNodeName())) continue;
            if (n == stringArray.length) {
                collection.add((ElementImpl)elementImpl.item(i));
                continue;
            }
            FlowJoWsp.GetAll(collection, (ElementImpl)elementImpl.item(i), stringArray, n + 1);
        }
        return collection;
    }

    public static ElementImpl GetFirstWild(ElementImpl elementImpl, String[] stringArray, int n) {
        String string = stringArray[n - 1];
        int n2 = string.length();
        int n3 = elementImpl.getLength();
        if (n2 > 1 && string.endsWith("*")) {
            string = string.substring(0, n2 - 1);
            for (int i = 0; i < n3; ++i) {
                if (!elementImpl.item(i).getNodeName().startsWith(string)) continue;
                if (n == stringArray.length) {
                    return (ElementImpl)elementImpl.item(i);
                }
                return FlowJoWsp.GetFirstWild((ElementImpl)elementImpl.item(i), stringArray, n + 1);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (!string.equals(elementImpl.item(i).getNodeName())) continue;
                if (n == stringArray.length) {
                    return (ElementImpl)elementImpl.item(i);
                }
                return FlowJoWsp.GetFirstWild((ElementImpl)elementImpl.item(i), stringArray, n + 1);
            }
        }
        return null;
    }

    public Element getSubPopNode(ElementImpl elementImpl) {
        ElementImpl[] elementImplArray = FlowJoWsp.GetAll(elementImpl, subPop);
        if (elementImplArray != null && elementImplArray.length > 0) {
            return elementImplArray[0];
        }
        Element element = this.doc.createElement(subPop[0]);
        elementImpl.appendChild((Node)element);
        return element;
    }

    public void addParentGraph(ElementImpl elementImpl, ElementImpl elementImpl2, String[] stringArray) {
        ElementImpl[] elementImplArray = FlowJoWsp.GetAll(elementImpl, graph);
        if (elementImplArray != null && elementImplArray.length > 0) {
            ElementImpl elementImpl3 = elementImplArray[0];
            ElementImpl[] elementImplArray2 = FlowJoWsp.GetAll(elementImpl, axis);
            if (elementImplArray2 == null || elementImplArray2.length != 2) {
                for (int i = 0; i < 2; ++i) {
                    Element element = this.doc.createElement("Axis");
                    elementImpl3.appendChild((Node)element);
                    element.setAttribute("auto", "x");
                    element.setAttribute("label", "");
                    element.setAttribute("name", stringArray[i]);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    elementImplArray2[i].setAttribute("name", stringArray[i]);
                }
            }
            elementImpl2.appendChild(elementImplArray[0].cloneNode(true));
        }
    }

    public static void setIds(Element element, String string, String string2, boolean bl) {
        if (!bl) {
            element.setAttribute("gating:parent_id", string);
        }
        element.setAttribute("gating:id", string2);
    }

    public ElementImpl setDim(ElementImpl elementImpl, String string) {
        if (elementImpl == null) {
            System.out.print("gatingNode is null");
            return null;
        }
        ElementImpl elementImpl2 = (ElementImpl)this.doc.createElement("gating:dimension");
        elementImpl.appendChild((Node)elementImpl2);
        ElementImpl elementImpl3 = (ElementImpl)this.doc.createElement("data-type:fcs-dimension");
        elementImpl3.setAttribute("data-type:name", string);
        elementImpl2.appendChild((Node)elementImpl3);
        return elementImpl2;
    }

    public static void debugMatrix(double[][] dArray) {
        System.out.println("rows x cols ... " + dArray.length + "x" + dArray[0].length);
    }

    public Object[] createPolygonSubGate(ElementImpl elementImpl, String string, String string2, double[][] dArray, String string3, int n, String[] stringArray) {
        Object[] objectArray = new Object[3];
        objectArray[0] = "gate:" + string2;
        ElementImpl elementImpl2 = (ElementImpl)this.doc.createElement("Population");
        objectArray[1] = elementImpl2;
        elementImpl2.setAttribute("name", string3);
        elementImpl2.setAttribute("count", Integer.toString(n));
        elementImpl2.setAttribute("annotation", "");
        elementImpl2.setAttribute("owningGroup", "");
        elementImpl2.setAttribute("expanded", "0");
        elementImpl2.setAttribute("sortPriority", "10");
        this.getSubPopNode(elementImpl).appendChild((Node)elementImpl2);
        this.addParentGraph(elementImpl, elementImpl2, stringArray);
        ElementImpl elementImpl3 = (ElementImpl)this.doc.createElement("Gate");
        objectArray[2] = elementImpl3;
        boolean bl = elementImpl.getNodeName().equals("SampleNode");
        String string4 = (String)FlowJoWsp.parseId(string);
        this.idMap.put((String)objectArray[0], elementImpl2);
        FlowJoWsp.setIds((Element)elementImpl3, string4, string2, bl);
        elementImpl2.appendChild((Node)elementImpl3);
        ElementImpl elementImpl4 = (ElementImpl)this.doc.createElement("gating:PolygonGate");
        elementImpl4.setAttribute("isTinted", "0");
        elementImpl4.setAttribute("eventsInside", "1");
        elementImpl4.setAttribute("lineWeight", "Normal");
        elementImpl4.setAttribute("tint", "#000000");
        elementImpl4.setAttribute("userDefined", "1");
        FlowJoWsp.setIds((Element)elementImpl4, string4, string2, bl);
        this.setDim(elementImpl4, stringArray[0]);
        this.setDim(elementImpl4, stringArray[1]);
        elementImpl3.appendChild((Node)elementImpl4);
        elementImpl4.setAttribute("quadId", "-1");
        elementImpl4.setAttribute("gateResolution", "256");
        for (int i = 0; i < dArray.length; ++i) {
            ElementImpl elementImpl5 = (ElementImpl)this.doc.createElement(VERTEX);
            elementImpl4.appendChild((Node)elementImpl5);
            for (int j = 0; j < dArray[0].length; ++j) {
                ElementImpl elementImpl6 = (ElementImpl)this.doc.createElement(COORD);
                elementImpl6.setAttribute("data-type:value", Double.toString(dArray[i][j]));
                elementImpl5.appendChild((Node)elementImpl6);
            }
        }
        return objectArray;
    }

    public Object[] createPolygonSubGate(int n, String string, String string2, double[][] dArray, String string3, int n2, String[] stringArray) {
        return this.createPolygonSubGate(this.getSampleNode(n), string, string2, dArray, string3, n2, stringArray);
    }

    public static List<ElementImpl> GetWildList(ElementImpl elementImpl, String[] stringArray) {
        ArrayList<ElementImpl> arrayList = new ArrayList<ElementImpl>();
        FlowJoWsp.GetAllWild(arrayList, elementImpl, stringArray, 1);
        return arrayList;
    }

    public static ElementImpl[] GetAllWild(Object object, String[] stringArray) {
        if (!(object instanceof ElementImpl)) {
            return null;
        }
        return FlowJoWsp.GetWildList((ElementImpl)object, stringArray).toArray(emptyEle);
    }

    static Collection<ElementImpl> GetAllWild(Collection<ElementImpl> collection, ElementImpl elementImpl, String[] stringArray, int n) {
        String string = stringArray[n - 1];
        int n2 = string.length();
        int n3 = elementImpl.getLength();
        if (n2 > 1 && string.endsWith("*")) {
            string = string.substring(0, n2 - 1);
            for (int i = 0; i < n3; ++i) {
                if (!elementImpl.item(i).getNodeName().startsWith(string)) continue;
                if (n == stringArray.length) {
                    collection.add((ElementImpl)elementImpl.item(i));
                    continue;
                }
                FlowJoWsp.GetAllWild(collection, (ElementImpl)elementImpl.item(i), stringArray, n + 1);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (!string.equals(elementImpl.item(i).getNodeName())) continue;
                if (n == stringArray.length) {
                    collection.add((ElementImpl)elementImpl.item(i));
                    continue;
                }
                FlowJoWsp.GetAllWild(collection, (ElementImpl)elementImpl.item(i), stringArray, n + 1);
            }
        }
        return collection;
    }

    public static boolean IsNotGate(ElementImpl elementImpl) {
        return elementImpl != null && elementImpl.getNodeName().equals("NotNode");
    }

    public Collection<ElementImpl> getSubPopulationList(ElementImpl elementImpl) {
        Collection<ElementImpl> collection = FlowJoWsp.GetList(elementImpl, SUBPOPS);
        if (this.hasNotProps == null) {
            this.hasNotProps = this.doc.getElementsByTagName("NotNode").getLength() > 0;
        }
        if (this.hasNotProps.booleanValue()) {
            collection.addAll(FlowJoWsp.GetList(elementImpl, SUBNOTS));
        }
        return collection;
    }

    public ElementImpl[] getSubPopulations(ElementImpl elementImpl) {
        return this.getSubPopulationList(elementImpl).toArray(emptyEle);
    }

    public String ensureUniquePopulationName(ElementImpl elementImpl, String string) {
        Collection<ElementImpl> collection = this.getSubPopulationList(elementImpl);
        for (ElementImpl elementImpl2 : collection) {
            if (!elementImpl2.getAttribute("name").equals(string)) continue;
            int n = 2;
            while (true) {
                boolean bl = false;
                String string2 = string + "#" + n;
                for (ElementImpl elementImpl3 : collection) {
                    if (!elementImpl3.getAttribute("name").equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return string2;
                }
                ++n;
            }
        }
        return string;
    }

    public ElementImpl findPopulation(ElementImpl elementImpl, String[] stringArray, int n) {
        Collection<ElementImpl> collection = this.getSubPopulationList(elementImpl);
        String string = stringArray[n - 1];
        if (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1);
            for (ElementImpl elementImpl2 : collection) {
                if (!elementImpl2.getAttribute("name").startsWith(string)) continue;
                if (n == stringArray.length) {
                    return elementImpl2;
                }
                return this.findPopulation(elementImpl2, stringArray, n + 1);
            }
        } else {
            for (ElementImpl elementImpl3 : collection) {
                if (!elementImpl3.getAttribute("name").equals(string)) continue;
                if (n == stringArray.length) {
                    return elementImpl3;
                }
                return this.findPopulation(elementImpl3, stringArray, n + 1);
            }
        }
        return null;
    }

    public ElementImpl getPopulationById(String string) {
        Object[] objectArray = FlowJoWsp.parseIdTypeNumb(string);
        DeepNodeListImpl deepNodeListImpl = (DeepNodeListImpl)this.doc.getElementsByTagName("Gate");
        int n = deepNodeListImpl.getLength();
        for (int i = 0; i < n; ++i) {
            ElementImpl elementImpl = (ElementImpl)deepNodeListImpl.item(i);
            String string2 = elementImpl.getAttribute("gating:id");
            ElementImpl elementImpl2 = (ElementImpl)elementImpl.getParentNode();
            if (objectArray[0].equals(string2)) {
                return elementImpl2;
            }
            this.idMap.put(objectArray[1] + ":" + string2, elementImpl2);
        }
        return null;
    }

    public ElementImpl getNodeById(String string) {
        ElementImpl elementImpl = this.idMap.get(string);
        if (elementImpl == null) {
            if (this.IsSampleId(string)) {
                elementImpl = this.getSampleNode(this.getSampleNumById(string));
            } else if (this.IsGateId(string)) {
                elementImpl = this.getPopulationById(string);
            }
            if (elementImpl != null) {
                this.idMap.put(string, elementImpl);
            }
        }
        return elementImpl;
    }

    public Object[] getNodeAndTypeById(String string) {
        ElementImpl elementImpl = this.getNodeById(string);
        return new Object[]{elementImpl, this.getGateType(elementImpl)};
    }

    public Object getId(ElementImpl elementImpl) {
        if (elementImpl.getNodeName().equals("SampleNode")) {
            return "sample:" + elementImpl.getAttribute("sampleID");
        }
        return this.getGateId(elementImpl);
    }

    public Object getParentId(String string) {
        String string2 = this.props.getProperty(string + ".parent");
        if (Basics.isEmpty(string2) && !this.IsSampleId(string) && !this.IsFolderId(string)) {
            ElementImpl elementImpl = this.getNodeById(string);
            if (elementImpl == null) {
                return "";
            }
            string2 = (String)this.getId((ElementImpl)elementImpl.getParentNode());
            while (Basics.isEmpty(string2) && (elementImpl = (ElementImpl)elementImpl.getParentNode()) != null) {
                string2 = (String)this.getId(elementImpl);
            }
            this.props.setProperty(string + ".parent", string2);
        }
        return string2;
    }

    boolean addGateOrSampleId(ElementImpl elementImpl, Collection<String> collection, boolean bl) {
        boolean bl2 = "SampleNode".equals(elementImpl.getNodeName());
        if (bl2) {
            if (bl) {
                collection.add("sample:" + elementImpl.getAttribute("sampleID"));
            }
        } else {
            String string = (String)this.getGateId(elementImpl);
            if (!Basics.isEmpty(string)) {
                collection.add(string);
            }
        }
        return bl2;
    }

    public ArrayList<String> getParentIds(ElementImpl elementImpl, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl3 = this.addGateOrSampleId(elementImpl, arrayList, bl);
        if (arrayList.size() > 0) {
            String string = arrayList.get(0);
            if (this.props.containsKey(string + ".parent")) {
                string = (String)this.getParentId(string);
                while (!(Basics.isEmpty(string) || this.IsRootId(string) || (this.IsSampleId(string) ? !bl : this.IsFolderId(string) && !bl2))) {
                    arrayList.add(string);
                    string = (String)this.getParentId(string);
                }
            } else {
                while (!bl3 && (elementImpl = (ElementImpl)elementImpl.getParentNode()) != null) {
                    bl3 = this.addGateOrSampleId(elementImpl, arrayList, bl);
                }
                if (bl3 && bl && bl2) {
                    string = (String)this.getParentId(arrayList.get(arrayList.size() - 1));
                    while (!Basics.isEmpty(string) && !ROOT_ID.equals(string)) {
                        arrayList.add(string);
                        string = (String)this.getParentId(arrayList.get(arrayList.size() - 1));
                    }
                    int n = arrayList.size();
                    for (int i = 1; i < n; ++i) {
                        this.props.setProperty(arrayList.get(i - 1) + ".parent", arrayList.get(i));
                    }
                }
            }
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    public String getGateType(ElementImpl elementImpl) {
        if (elementImpl == null) {
            return null;
        }
        ElementImpl elementImpl2 = FlowJoWsp.GetFirstWild(elementImpl, GATE, 1);
        if (elementImpl2 == null) {
            return null;
        }
        return elementImpl2.getNodeName().substring(7);
    }

    public Object[] getGateIdAndNodeAndType(Object object) {
        if (!(object instanceof ElementImpl)) {
            return new Object[]{"", null, "?"};
        }
        ElementImpl elementImpl = FlowJoWsp.GetFirstWild((ElementImpl)object, GATE, 1);
        if (elementImpl == null) {
            return new Object[]{"", null, "?"};
        }
        String string = elementImpl.getAttribute("gating:id");
        if (Basics.isEmpty(string)) {
            string = ((ElementImpl)elementImpl.getParentNode()).getAttribute("gating:id");
        }
        return new Object[]{"gate:" + string, elementImpl, elementImpl.getNodeName().substring(7)};
    }

    public Object getGateId(ElementImpl elementImpl) {
        ElementImpl elementImpl2 = FlowJoWsp.GetFirstNode(elementImpl, "Gate");
        if (elementImpl2 == null) {
            return null;
        }
        return "gate:" + elementImpl2.getAttribute("gating:id");
    }

    public Object getName(Object object) {
        ElementImpl elementImpl = object instanceof String ? this.getNodeById((String)object) : (ElementImpl)object;
        if (elementImpl == null) {
            return null;
        }
        return elementImpl.getAttribute("name");
    }

    public boolean hasAnyChildren(String string) {
        String string2 = string + ".children";
        if (!this.props.containsKey(string2)) {
            this.getChildIdsString(string);
        }
        return !Basics.isEmpty(this.props.getProperty(string2));
    }

    public Object getChildIdsString(String string) {
        String string2;
        boolean bl;
        String string3 = string + ".children";
        boolean bl2 = bl = this.IsRootId(string) && !this.rootIdsInSync;
        if (!this.props.containsKey(string3) || bl) {
            this.props.setProperty(string3, "");
            if (this.IsSampleId(string) || this.IsGateId(string)) {
                string2 = this.getNodeById(string);
                if (string2 == null) {
                    return "";
                }
                Collection<ElementImpl> collection = this.getSubPopulationList((ElementImpl)string2);
                for (ElementImpl elementImpl : collection) {
                    this.setParent(this.getGateId(elementImpl), string);
                }
            } else if (bl) {
                this.syncRootIds();
            }
        }
        if (Basics.isEmpty(string2 = this.props.getProperty(string3))) {
            return "";
        }
        return string2.trim();
    }

    public ArrayList<String> getSampleIdsInProperties() {
        return this.getSampleIdsInProperties(new ArrayList<String>(), ROOT_ID);
    }

    public ArrayList<String> getSampleIdsInProperties(ArrayList<String> arrayList, String string) {
        String string2;
        String string3 = string + ".children";
        if (this.props.containsKey(string3) && !Basics.isEmpty(string2 = this.props.getProperty(string3))) {
            String[] stringArray;
            for (String string4 : stringArray = string2.split(" ")) {
                if (this.IsSampleId(string4)) {
                    int n = this.getSampleNumById(string4);
                    if (n < 1) {
                        this.removeChild(string, string4);
                        continue;
                    }
                    arrayList.add(string4);
                    continue;
                }
                this.getSampleIdsInProperties(arrayList, string4);
            }
        }
        return arrayList;
    }

    public void syncRootIds() {
        ArrayList<String> arrayList = this.getSampleIdsInProperties();
        for (int i = 1; i <= this.nSamples; ++i) {
            String string = (String)this.getSampleIdByNum(i);
            if (arrayList.contains(string)) continue;
            this.setParent(string, ROOT_ID);
        }
        this.rootIdsInSync = true;
    }

    public Object getExpandableIds(Collection<String> collection) {
        String string2;
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : collection) {
            String string3 = (String)this.getParentId(string2);
            if (hashSet.contains(string3)) continue;
            arrayList.add(string2);
            hashSet.add(string3);
        }
        Iterator<String> iterator = arrayList.iterator();
        block1: while (iterator.hasNext()) {
            string2 = iterator.next();
            for (String string4 : arrayList) {
                if (string2.equals(string4) || !this.descendsFromAncestorOrItsSibling(string4, string2)) continue;
                iterator.remove();
                continue block1;
            }
        }
        string2 = ((Object)arrayList).toString();
        string2 = string2.substring(1, string2.length() - 1);
        return string2.replace(", ", " ");
    }

    public boolean descendsFromAncestorOrItsSibling(String string, String string2) {
        String string3 = (String)this.getParentId(string);
        while (!Basics.isEmpty(string3)) {
            if (!this.hasChild(string3 = (String)this.getParentId(string3), string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChild(String string, String string2) {
        if (Basics.isEmpty(string)) {
            return false;
        }
        String string3 = this.props.getProperty(string + ".children");
        if (string3 == null) {
            this.getChildIdsString(string);
            string3 = this.props.getProperty(string + ".children");
        }
        return string3.contains(string2 + " ");
    }

    public static double[][] Reshape1to2(double[] dArray) {
        return FlowJoWsp.Reshape1to2(dArray, null);
    }

    public static double[][] Reshape1to2(double[] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = n / 2;
        if (dArray2 == null) {
            dArray2 = new double[n2][2];
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            dArray2[i][0] = dArray[n3++];
            dArray2[i][1] = dArray[n3++];
        }
        return dArray2;
    }

    public static double[][] GetPolygonCoords(Object object) {
        double[][] dArray;
        double[] dArray2 = FlowJoWsp.GetValueVector(object, Coords);
        if (dArray2 == null) {
            return null;
        }
        int n = dArray2.length;
        int n2 = n / 2;
        if (dArray2[0] != dArray2[n - 2] || dArray2[1] != dArray2[n - 1]) {
            dArray = FlowJoWsp.Reshape1to2(dArray2, new double[n2 + 1][2]);
            FlowJoWsp.Reshape1to2(dArray2, dArray);
            dArray[n2][0] = dArray[0][0];
            dArray[n2][1] = dArray[0][1];
        } else {
            dArray = FlowJoWsp.Reshape1to2(dArray2);
        }
        return dArray;
    }

    public static double[] GetRectCoords(Object object) {
        if (!(object instanceof ElementImpl)) {
            return null;
        }
        ElementImpl elementImpl = (ElementImpl)object;
        List<ElementImpl> list = FlowJoWsp.GetWildList(elementImpl, Dims);
        if (list.size() != 2) {
            return null;
        }
        double[] dArray = new double[4];
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                Double d;
                elementImpl = list.get(j);
                try {
                    d = Double.valueOf(elementImpl.getAttribute(MinMax[i]));
                }
                catch (Exception exception) {
                    d = null;
                }
                if (d == null) {
                    d = Double.NaN;
                    bl = true;
                }
                dArray[n] = d;
                ++n;
            }
        }
        if (!bl) {
            dArray[2] = dArray[2] - dArray[0];
            dArray[3] = dArray[3] - dArray[1];
        }
        return dArray;
    }

    public static double[] GetEllipseCoords(Object object) {
        return FlowJoWsp.GetValueVector(object, EllipseCoords);
    }

    public static double[] GetValueVector(Object object, String[] stringArray) {
        return FlowJoWsp.GetAttributeVector(object, stringArray, "data-type:value");
    }

    public static double[] GetAttributeVector(Object object, String[] stringArray, String string) {
        if (!(object instanceof ElementImpl)) {
            return null;
        }
        ElementImpl elementImpl = (ElementImpl)object;
        List<ElementImpl> list = FlowJoWsp.GetWildList(elementImpl, stringArray);
        try {
            int n = list.size();
            double[] dArray = new double[n];
            Iterator iterator = list.iterator();
            for (int i = 0; i < n; ++i) {
                elementImpl = (ElementImpl)iterator.next();
                dArray[i] = Double.valueOf(elementImpl.getAttribute(string));
            }
            return dArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ElementImpl[] GetFcsDims(Object object) {
        if (!(object instanceof ElementImpl)) {
            return null;
        }
        ElementImpl elementImpl = (ElementImpl)object;
        return FlowJoWsp.GetWildList(elementImpl, FcsDims).toArray(emptyEle);
    }

    public Object getSampleDerived(Object object) {
        return this.getSampleItems(object, derivied, true);
    }

    public Object getSampleItems(Object object, String[] stringArray, boolean bl) {
        ElementImpl elementImpl;
        if (object instanceof Integer) {
            elementImpl = (ElementImpl)this.sampleNodes.item((Integer)object - 1);
        } else if (object instanceof Double) {
            elementImpl = (ElementImpl)this.sampleNodes.item(((Double)object).intValue() - 1);
        } else if (object instanceof ElementImpl) {
            elementImpl = (ElementImpl)object;
        } else {
            return null;
        }
        if (bl) {
            return FlowJoWsp.GetList(elementImpl, stringArray);
        }
        return FlowJoWsp.GetFirst(elementImpl, stringArray, 1);
    }

    public int getSampleNumByName(String string) {
        return this.getSampleNumByName(string, 0);
    }

    public int getSampleNumByName(String string, int n) {
        if (string.endsWith("*")) {
            String string2 = string.substring(0, string.length() - 1);
            for (int i = 1; i <= this.nSamples; ++i) {
                if (!this.getSampleNode(i).getAttribute("name").startsWith(string2)) continue;
                return i;
            }
        } else {
            for (int i = 1; i <= this.nSamples; ++i) {
                if (!this.getSampleNode(i).getAttribute("name").equals(string)) continue;
                return i;
            }
        }
        return n;
    }
}

