/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class FolderWatch {
    private boolean alive = true;
    private final boolean logToStdOut;
    public final String folder;
    WatchKey key = null;

    public boolean isAlive() {
        return this.alive;
    }

    public void close() {
        this.alive = false;
        if (this.key != null) {
            try {
                if (this.logToStdOut) {
                    System.out.println("Closed ALL watches on \"" + this.folder + "\"");
                }
                this.key.cancel();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    public FolderWatch(String string, boolean bl) {
        this.folder = string;
        this.logToStdOut = bl;
    }

    public FolderWatch(String string, final boolean bl, final boolean bl2, final boolean bl3, final JButton jButton, boolean bl4, final String string2) {
        this(string, bl4);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                FolderWatch.this.watch(jButton, bl, bl2, bl3, string2);
            }
        });
        thread.start();
    }

    public void watch(JButton jButton, boolean bl, boolean bl2, boolean bl3, String string) {
        Object object;
        Path path = new File(this.folder).toPath();
        try {
            object = (Boolean)Files.getAttribute(path, "basic:isDirectory", LinkOption.NOFOLLOW_LINKS);
            if (!((Boolean)object).booleanValue()) {
                throw new IllegalArgumentException("Path: " + path + " is not a folder");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.logToStdOut) {
            System.out.print("Watching path: " + path + " with ");
        }
        object = path.getFileSystem();
        try (WatchService watchService = ((FileSystem)object).newWatchService();){
            SensitivityWatchEventModifier sensitivityWatchEventModifier;
            if (string.equalsIgnoreCase("low")) {
                sensitivityWatchEventModifier = SensitivityWatchEventModifier.LOW;
                if (this.logToStdOut) {
                    System.out.print("low");
                }
            } else if (string.equals("medium")) {
                sensitivityWatchEventModifier = SensitivityWatchEventModifier.MEDIUM;
                if (this.logToStdOut) {
                    System.out.print("medium");
                }
            } else {
                sensitivityWatchEventModifier = SensitivityWatchEventModifier.HIGH;
                if (this.logToStdOut) {
                    System.out.print("high");
                }
            }
            if (this.logToStdOut) {
                System.out.println(" priority (" + sensitivityWatchEventModifier.sensitivityValueInSeconds() + " second sensitity )");
            }
            ArrayList<WatchEvent.Kind<Path>> arrayList = new ArrayList<WatchEvent.Kind<Path>>(3);
            if (bl3) {
                arrayList.add(StandardWatchEventKinds.ENTRY_DELETE);
            }
            if (bl) {
                arrayList.add(StandardWatchEventKinds.ENTRY_CREATE);
            }
            if (bl2) {
                arrayList.add(StandardWatchEventKinds.ENTRY_MODIFY);
            }
            WatchEvent.Kind[] kindArray = arrayList.toArray(new WatchEvent.Kind[arrayList.size()]);
            path.register(watchService, kindArray, sensitivityWatchEventModifier);
            String string2 = null;
            Path path2 = null;
            while (this.alive) {
                this.key = watchService.take();
                WatchEvent.Kind<?> kind = null;
                for (WatchEvent<?> watchEvent : this.key.pollEvents()) {
                    if (!this.alive) {
                        System.out.println("Watch has been closed!!!");
                        break;
                    }
                    kind = watchEvent.kind();
                    if (StandardWatchEventKinds.OVERFLOW == kind) continue;
                    if (StandardWatchEventKinds.ENTRY_DELETE == kind) {
                        path2 = (Path)watchEvent.context();
                        string2 = "Deleted";
                    } else if (StandardWatchEventKinds.ENTRY_CREATE == kind) {
                        path2 = (Path)watchEvent.context();
                        string2 = "Created";
                    } else if (StandardWatchEventKinds.ENTRY_MODIFY == kind) {
                        path2 = (Path)watchEvent.context();
                        string2 = "Modified";
                    }
                    String string3 = string2 + ": " + path2;
                    if (jButton != null) {
                        FolderWatch.notify(jButton, string3, this.logToStdOut);
                        continue;
                    }
                    if (this.logToStdOut) {
                        System.out.println(string3);
                        continue;
                    }
                    System.err.println(string3);
                }
                if (!this.key.reset()) {
                } else if (this.alive) continue;
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (this.logToStdOut) {
            System.out.println("Exiting watch on \"" + this.folder + "\"");
        }
    }

    static void notify(final JButton jButton, final String string, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jButton.setActionCommand(string);
                jButton.doClick();
                if (bl) {
                    System.out.println("Clicked button labeled \"" + jButton.getText() + ", with action \"" + string + "\"");
                }
            }
        });
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        final JButton jButton = new JButton();
        final FolderWatch folderWatch = new FolderWatch("/Users/swmeehan/Downloads", true, true, true, jButton, false, "medium");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jButton.getActionCommand();
                System.out.println("test button actionPerformed(): \"" + string + "\"");
                if (string.equals("Deleted: duh.txt")) {
                    System.out.println("STOPPING folder watch");
                    folderWatch.close();
                }
            }
        });
    }
}

