/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;

public class GridClusterEdge {
    private final int M;
    public boolean[] edge = null;
    public int[] edgeBins;
    public double[] x;
    public double[] y;
    static final int CLUE_EDGE_ANY = 0;
    static final int CLUE_EDGE_OFF_GRID_EDGE = -1;
    static final int CLUE_EDGE_ON_NON_CLUE = 1;

    public GridClusterEdge(int n) {
        this.M = n;
    }

    public void computeAll(int[] nArray, double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        boolean[] blArray = new boolean[this.M * this.M + 2];
        int n4 = nArray.length;
        for (int i = 0; i < n4; ++i) {
            blArray[nArray[i]] = true;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n4);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n4);
        boolean[][] blArray2 = new boolean[this.M + 1][this.M + 1];
        block1: for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            n2 = (n5 - 1) % this.M + 1;
            int n6 = (n5 - 1) / this.M + 1;
            for (n = -1; n < 2; ++n) {
                int n7 = n2 + n;
                boolean bl = false;
                if (n7 < 1) {
                    n7 = 1;
                    bl = true;
                } else if (n7 > this.M) {
                    n7 = this.M;
                    bl = true;
                }
                for (int i = -1; i < 2; ++i) {
                    int n8 = n6 + i;
                    boolean bl2 = bl;
                    if (!bl2) {
                        if (n8 < 1) {
                            n8 = 1;
                            bl2 = true;
                        } else if (n8 > this.M) {
                            n8 = this.M;
                            bl2 = true;
                        }
                    }
                    if (!bl2 && blArray[(n8 - 1) * this.M + n7]) continue;
                    blArray2[n2][n6] = true;
                    arrayList.add(n2);
                    arrayList2.add(n6);
                    break;
                }
                if (blArray2[n2][n6]) continue block1;
            }
        }
        n3 = arrayList.size();
        this.x = new double[n3];
        this.y = new double[n3];
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (n2 = 0; n2 < n3; ++n2) {
            treeSet.add(((Integer)arrayList2.get(n2) - 1) * this.M + (Integer)arrayList.get(n2));
        }
        this.edgeBins = new int[treeSet.size()];
        n2 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.edgeBins[n2] = n = ((Integer)iterator.next()).intValue();
            this.x[n2] = dArray[0] + (double)((n - 1) % this.M) * dArray2[0];
            this.y[n2] = dArray[1] + (double)((n - 1) / this.M) * dArray2[1];
            ++n2;
        }
    }

    public void computeAllFast(int[] nArray, double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        boolean[] blArray = new boolean[this.M * this.M + 2];
        int n4 = nArray.length;
        for (int i = 0; i < n4; ++i) {
            blArray[nArray[i]] = true;
        }
        boolean[] blArray2 = new boolean[n4];
        int n5 = 0;
        block1: for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            n = (n2 - 1) % this.M + 1;
            int n6 = (n2 - 1) / this.M + 1;
            for (int i = -1; i < 2; ++i) {
                int n7 = n + i;
                boolean bl = false;
                if (n7 < 1) {
                    n7 = 1;
                    bl = true;
                } else if (n7 > this.M) {
                    n7 = this.M;
                    bl = true;
                }
                for (int j = -1; j < 2; ++j) {
                    int n8 = n6 + j;
                    boolean bl2 = bl;
                    if (!bl2) {
                        if (n8 < 1) {
                            n8 = 1;
                            bl2 = true;
                        } else if (n8 > this.M) {
                            n8 = this.M;
                            bl2 = true;
                        }
                    }
                    if (!bl2 && blArray[(n8 - 1) * this.M + n7]) continue;
                    blArray2[n3] = true;
                    break;
                }
                if (!blArray2[n3]) continue;
                ++n5;
                continue block1;
            }
        }
        this.edgeBins = new int[n5];
        this.x = new double[n5];
        this.y = new double[n5];
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (!blArray2[n2]) continue;
            this.edgeBins[n3] = n = nArray[n2];
            this.x[n3] = dArray[0] + (double)((n - 1) % this.M) * dArray2[0];
            this.y[n3] = dArray[1] + (double)((n - 1) / this.M) * dArray2[1];
            ++n3;
        }
    }

    public void compute(int[] nArray, boolean bl, double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean[] blArray = new boolean[this.M * this.M + 2];
        int n7 = nArray.length;
        for (int i = 0; i < n7; ++i) {
            blArray[nArray[i]] = true;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        boolean[][] blArray2 = new boolean[this.M + 1][this.M + 1];
        block1: for (int i = 0; i < n7; ++i) {
            int n8 = nArray[i];
            int n9 = (n8 - 1) % this.M + 1;
            n6 = (n8 - 1) / this.M + 1;
            for (n5 = -1; n5 < 2; ++n5) {
                int n10 = n9 + n5;
                n4 = 0;
                if (n10 < 1) {
                    n10 = 1;
                    n4 = 1;
                } else if (n10 > this.M) {
                    n10 = this.M;
                    n4 = 1;
                }
                for (n3 = -1; n3 < 2; ++n3) {
                    n2 = n6 + n3;
                    n = n4;
                    if (n == 0) {
                        if (n2 < 1) {
                            n2 = 1;
                            n = 1;
                        } else if (n2 > this.M) {
                            n2 = this.M;
                            n = 1;
                        }
                    }
                    if (n == 0 && blArray[(n2 - 1) * this.M + n10]) continue;
                    blArray2[n9][n6] = true;
                    treeSet.add(n9);
                    treeSet2.add(n6);
                    break;
                }
                if (blArray2[n9][n6]) continue block1;
            }
        }
        boolean[][] blArray3 = new boolean[this.M + 1][this.M + 1];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n7);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n7);
        n6 = (Integer)treeSet2.first();
        n5 = (Integer)treeSet2.last();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            n4 = (Integer)iterator.next();
            n3 = 0;
            n2 = 0;
            for (n = n6; n <= n5; ++n) {
                if (!blArray2[n4][n]) continue;
                if (n3 == 0) {
                    n3 = n;
                    blArray3[n4][n] = true;
                }
                n2 = n;
            }
            if (n3 <= 0) continue;
            arrayList.add(n4);
            arrayList2.add(n3);
            if (n2 <= n3) continue;
            arrayList.add(n4);
            arrayList2.add(n2);
            blArray3[n4][n2] = true;
        }
        n6 = (Integer)treeSet.first();
        n5 = (Integer)treeSet.last();
        iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            n4 = (Integer)iterator.next();
            n3 = 0;
            n2 = 0;
            for (n = n6; n <= n5; ++n) {
                if (!blArray2[n][n4]) continue;
                if (n3 == 0) {
                    n3 = n;
                }
                n2 = n;
            }
            if (n3 <= 0) continue;
            if (!blArray3[n3][n4]) {
                arrayList2.add(n4);
                arrayList.add(n3);
            }
            if (blArray3[n2][n4] || n2 <= n3) continue;
            arrayList2.add(n4);
            arrayList.add(n2);
        }
        int n11 = arrayList.size();
        this.x = new double[n11];
        this.y = new double[n11];
        if (bl) {
            TreeSet<Integer> treeSet3 = new TreeSet<Integer>();
            for (n3 = 0; n3 < n11; ++n3) {
                treeSet3.add(((Integer)arrayList2.get(n3) - 1) * this.M + (Integer)arrayList.get(n3));
            }
            this.edgeBins = new int[treeSet3.size()];
            n3 = 0;
            Iterator iterator2 = treeSet3.iterator();
            while (iterator2.hasNext()) {
                this.edgeBins[n3] = n = ((Integer)iterator2.next()).intValue();
                this.x[n3] = dArray[0] + (double)((n - 1) % this.M) * dArray2[0];
                this.y[n3] = dArray[1] + (double)((n - 1) / this.M) * dArray2[1];
                ++n3;
            }
        } else {
            this.edgeBins = new int[0];
            if (dArray == null || dArray2 == null) {
                for (n4 = 0; n4 < n11; ++n4) {
                    this.x[n4] = ((Integer)arrayList.get(n4)).intValue();
                    this.y[n4] = ((Integer)arrayList2.get(n4)).intValue();
                }
            } else {
                for (n4 = 0; n4 < n11; ++n4) {
                    this.x[n4] = dArray[0] + (double)((Integer)arrayList.get(n4) - 1) * dArray2[0];
                    this.y[n4] = dArray[1] + (double)((Integer)arrayList2.get(n4) - 1) * dArray2[1];
                }
            }
        }
    }

    public static int[] find(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray2.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block0: for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (nArray[n] != nArray2[i]) continue;
                arrayList.add(n + 1);
                continue block0;
            }
        }
        n = arrayList.size();
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = (Integer)arrayList.get(i);
        }
        return nArray3;
    }

    public static int[] GetUsingClues(int n, int[] nArray, int[] nArray2) {
        assert (n * n == nArray.length);
        return GridClusterEdge.GetUsingClueInds(n, GridClusterEdge.find(nArray, nArray2), 1);
    }

    public static int[] GetUsingClues(int n, int[] nArray, int[] nArray2, int n2) {
        assert (n * n == nArray.length);
        return GridClusterEdge.GetUsingClueInds(n, GridClusterEdge.find(nArray, nArray2), n2);
    }

    public static int[] GetUsingClueInds(int n, int[] nArray, int n2) {
        int n3;
        int n4;
        boolean[] blArray = new boolean[n * n + 2];
        int n5 = nArray.length;
        for (int i = 0; i < n5; ++i) {
            blArray[nArray[i]] = true;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        boolean[][] blArray2 = new boolean[n + 1][n + 1];
        boolean[][] blArray3 = new boolean[n + 1][n + 1];
        boolean[][] blArray4 = new boolean[n + 1][n + 1];
        for (n4 = 0; n4 < n5; ++n4) {
            int n6 = nArray[n4];
            if (n6 == 24) {
                System.out.print("");
            }
            n3 = (n6 - 1) % n + 1;
            int n7 = (n6 - 1) / n + 1;
            for (int i = -1; i < 2; ++i) {
                int n8 = n3 + i;
                boolean bl = false;
                if (n8 < 1) {
                    n8 = 1;
                    bl = true;
                } else if (n8 > n) {
                    n8 = n;
                    bl = true;
                }
                for (int j = -1; j < 2; ++j) {
                    int n9 = n7 + j;
                    boolean bl2 = bl;
                    if (!bl2) {
                        if (n9 < 1) {
                            n9 = 1;
                            bl2 = true;
                        } else if (n9 > n) {
                            n9 = n;
                            bl2 = true;
                        }
                    }
                    if (n2 == 0) {
                        if (!bl2 && blArray[(n9 - 1) * n + n8]) continue;
                        blArray2[n3][n7] = true;
                        arrayList.add(n3);
                        arrayList2.add(n7);
                        break;
                    }
                    if (bl2) {
                        blArray3[n3][n7] = true;
                        continue;
                    }
                    if (blArray[(n9 - 1) * n + n8]) continue;
                    blArray4[n3][n7] = true;
                }
                if (n2 == 0 && blArray2[n3][n7]) break;
            }
            if (n2 == 0 || !blArray4[n3][n7]) continue;
            if (n2 == -1) {
                if (blArray3[n3][n7]) continue;
                arrayList.add(n3);
                arrayList2.add(n7);
                continue;
            }
            if (n2 != 1) continue;
            arrayList.add(n3);
            arrayList2.add(n7);
        }
        n4 = arrayList.size();
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray2[n3] = ((Integer)arrayList2.get(n3) - 1) * n + (Integer)arrayList.get(n3);
        }
        return nArray2;
    }

    public static void main(String[] stringArray) {
        int[][] nArrayArray = new int[][]{{3, 3, 3, 3, 3, 3}, {3, 1, 1, 3, 3, 3}, {1, 1, 1, 3, 3, 3}, {1, 1, 1, 2, 2, 2}, {1, 1, 1, 2, 2, 2}, {2, 2, 2, 2, 2, 2}};
        int n = nArrayArray.length;
        int[] nArray = new int[n * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[n2++] = nArrayArray[i][j];
            }
        }
        GridClusterEdge.test(n, nArray, new int[]{2});
        int[] nArray2 = new int[]{2, 3};
        int[] nArray3 = GridClusterEdge.find(nArray, nArray2);
        System.out.println(Arrays.toString(GridClusterEdge.GetUsingClues(n, nArray, nArray2, 0)));
        System.out.println(Arrays.toString(GridClusterEdge.GetUsingClues(n, nArray, nArray2, -1)));
        System.out.println(Arrays.toString(GridClusterEdge.GetUsingClues(n, nArray, nArray2, 1)));
        nArray2 = new int[]{2};
        nArray3 = GridClusterEdge.find(nArray, nArray2);
        System.out.println(Arrays.toString(nArray3));
        System.out.println(Arrays.toString(GridClusterEdge.GetUsingClueInds(n, nArray3, 1)));
        System.out.println(Arrays.toString(GridClusterEdge.GetUsingClues(n, nArray, nArray2, 0)));
        nArray2 = new int[]{2, 3};
        nArray3 = GridClusterEdge.find(nArray, nArray2);
        System.out.println(Arrays.toString(nArray3));
        int[] nArray4 = GridClusterEdge.GetUsingClueInds(n, nArray3, 1);
        System.out.println(Arrays.toString(nArray4));
        System.out.println(Arrays.toString(GridClusterEdge.GetUsingClues(n, nArray, nArray2, -1)));
    }

    static void test(int n, int[] nArray, int[] nArray2) {
        System.out.println(Arrays.toString(GridClusterEdge.GetUsingClues(n, nArray, nArray2, 0)));
        System.out.println(Arrays.toString(GridClusterEdge.GetUsingClues(n, nArray, nArray2, -1)));
        System.out.println(Arrays.toString(GridClusterEdge.GetUsingClues(n, nArray, nArray2, 1)));
    }
}

