/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JList;
import javax.swing.ListModel;

public class Mover {
    private static boolean contains(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private static int[] duplicate(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    public static int[] move(int[] nArray, Direction direction, int n) {
        int[] nArray2 = Mover.duplicate(nArray);
        Arrays.sort(nArray2);
        return Mover._move(nArray2, direction, n);
    }

    private static int[] _move(int[] nArray, Direction direction, int n) {
        int[] nArray2;
        switch (direction) {
            case TOP: {
                nArray2 = Mover.moveTop(nArray, 0);
                break;
            }
            case BOTTOM: {
                nArray2 = Mover.moveBottom(nArray, n);
                break;
            }
            case UP: {
                nArray2 = Mover.moveUp(nArray, 0);
                break;
            }
            default: {
                nArray2 = Mover.moveDown(nArray, n);
            }
        }
        return nArray2;
    }

    public static Object[] move(Object[] objectArray, int[] nArray, Direction direction) {
        int[] nArray2 = Mover.duplicate(nArray);
        Arrays.sort(nArray2);
        int[] nArray3 = Mover._move(nArray2, direction, objectArray.length - 1);
        Object[] objectArray2 = Mover.move(objectArray, nArray2, nArray3);
        return objectArray2;
    }

    private static int[] moveUp(int[] nArray, int n) {
        int n2;
        int[] nArray2 = Mover.duplicate(nArray);
        int n3 = n;
        for (n2 = 0; n2 < nArray2.length && nArray2[n2] == n3; ++n3, ++n2) {
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            if (nArray2[n2] <= n3) continue;
            int n4 = n2;
            nArray2[n4] = nArray2[n4] - 1;
        }
        return nArray2;
    }

    private static int[] moveDown(int[] nArray, int n) {
        int n2;
        int[] nArray2 = Mover.duplicate(nArray);
        int n3 = n;
        for (n2 = nArray2.length - 1; n2 >= 0 && nArray2[n2] == n3; --n3, --n2) {
        }
        for (n2 = nArray2.length - 1; n2 >= 0; --n2) {
            if (nArray2[n2] >= n3) continue;
            int n4 = n2;
            nArray2[n4] = nArray2[n4] + 1;
        }
        return nArray2;
    }

    private static int[] moveBottom(int[] nArray, int n) {
        int[] nArray2 = Mover.duplicate(nArray);
        int n2 = 0;
        for (int i = nArray2.length - 1; i >= 0; --i) {
            nArray2[i] = n - n2;
            ++n2;
        }
        return nArray2;
    }

    private static int[] moveTop(int[] nArray, int n) {
        int[] nArray2 = Mover.duplicate(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = n + i;
        }
        return nArray2;
    }

    static Object[] move(Object[] objectArray, int[] nArray, int[] nArray2) {
        int n;
        Object[] objectArray2 = new Object[objectArray.length];
        for (n = 0; n < nArray.length; ++n) {
            objectArray2[nArray2[n]] = objectArray[nArray[n]];
        }
        n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (Mover.contains(nArray, i)) continue;
            while (objectArray2[n] != null) {
                ++n;
            }
            objectArray2[n] = objectArray[i];
        }
        return objectArray2;
    }

    public static Object[] getDataList(JList jList) {
        ListModel listModel = jList.getModel();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < listModel.getSize(); ++i) {
            arrayList.add(listModel.getElementAt(i));
        }
        return arrayList.toArray();
    }

    public static void move(JList jList, Direction direction) {
        Object[] objectArray = Mover.getDataList(jList);
        int[] nArray = jList.getSelectedIndices();
        Object[] objectArray2 = Mover.move(objectArray, nArray, direction);
        int[] nArray2 = Mover.move(nArray, direction, objectArray.length - 1);
        jList.clearSelection();
        jList.setListData(objectArray2);
        for (int n : nArray2) {
            jList.addSelectionInterval(n, n);
        }
        if (direction == Direction.UP || direction == Direction.TOP) {
            jList.ensureIndexIsVisible(nArray2[0]);
        } else {
            jList.ensureIndexIsVisible(nArray2[nArray2.length - 1]);
        }
    }

    public static enum Direction {
        TOP,
        UP,
        DOWN,
        BOTTOM;

    }
}

